/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.WebRequest;

@Controller
public class ErrorHandlerController
implements ErrorController {
    private ErrorAttributes errorAttributes;
    private static final String ERROR_PATH = "/login/error";

    public ErrorHandlerController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    @RequestMapping(value={"/login/error"})
    public String getErrorPath(HttpServletRequest request, WebRequest webRequest, Model model) {
        Map errorAttributes = this.errorAttributes.getErrorAttributes(webRequest, ErrorAttributeOptions.defaults());
        model.addAttribute("msg", (Object)errorAttributes);
        model.addAttribute("status", (Object)this.getStatus(request));
        model.addAttribute("home", (Object)"/login/open/home");
        model.addAttribute("style", (Object)"/login/open/css/style.css");
        return "error";
    }

    @RequestMapping(value={"/error"})
    public String baseError(HttpServletRequest request, WebRequest webRequest, Model model) {
        Map errorAttributes = this.errorAttributes.getErrorAttributes(webRequest, ErrorAttributeOptions.defaults());
        model.addAttribute("msg", (Object)errorAttributes);
        model.addAttribute("status", (Object)this.getStatus(request));
        model.addAttribute("home", (Object)"/login/open/home");
        model.addAttribute("style", (Object)"/login/open/css/style.css");
        return "error";
    }

    private boolean getTraceParameter(HttpServletRequest request) {
        String parameter = request.getParameter("trace");
        if (parameter == null) {
            return false;
        }
        return !"false".equals(parameter.toLowerCase());
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode != null) {
            try {
                return HttpStatus.valueOf((int)statusCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

