/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.dto.DockerStatsDto;
import at.letto.setupservice.service.AnalyzeService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class DockerStatsService
implements Runnable {
    private AnalyzeService analyzeService;
    private ConcurrentHashMap<String, DockerStatsDto> dockerStats = new ConcurrentHashMap();
    public long lastStatsTimeMillis = 0L;
    public Thread thread;

    public DockerStatsService(AnalyzeService analyzeService) {
        this.analyzeService = analyzeService;
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    private void runDockerStats() {
        ProcessBuilder pb = new ProcessBuilder("docker", "stats", "--all", "--no-trunc");
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            String line;
            process = pb.start();
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            int[] pos = null;
            while ((line = reader.readLine()) != null) {
                if (Thread.interrupted()) {
                    process.destroyForcibly();
                }
                if ((line = line.trim()).contains("CONTAINER ID") && line.contains("NAME")) {
                    int p = line.indexOf("CONTAINER");
                    line = line.substring(p).trim();
                }
                if (line.startsWith("CONTAINER ID")) {
                    try {
                        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                            try {
                                if (dockerStatsDto.isOk()) continue;
                                this.dockerStats.remove(dockerStatsDto.getName());
                            }
                            catch (Exception exception) {}
                        }
                        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                            dockerStatsDto.setOk(false);
                        }
                        pos = new int[]{0, line.indexOf("NAME"), line.indexOf("CPU %"), line.indexOf("MEM USAGE"), line.indexOf("MEM %"), line.indexOf("NET I/O"), line.indexOf("BLOCK I/O"), line.indexOf("PIDS")};
                        this.lastStatsTimeMillis = System.currentTimeMillis();
                    }
                    catch (Exception p) {}
                    continue;
                }
                if (pos == null) continue;
                String id = line.substring((int)pos[0], (int)pos[1]).trim();
                String name = line.substring((int)pos[1], (int)pos[2]).trim();
                String cpu = line.substring(pos[2], pos[3]).trim();
                String mem = line.substring(pos[3], pos[4]).trim();
                String memP = line.substring(pos[4], pos[5]).trim();
                String net = line.substring(pos[5], pos[6]).trim();
                String block = line.substring(pos[6], pos[7]).trim();
                String pids = line.substring(pos[7]).trim();
                DockerStatsDto dockerStatsDto = null;
                if (this.dockerStats.containsKey(name)) {
                    dockerStatsDto = (DockerStatsDto)this.dockerStats.get(name);
                    dockerStatsDto.setId(id);
                } else {
                    dockerStatsDto = new DockerStatsDto(id, name);
                    this.dockerStats.put(name, dockerStatsDto);
                }
                dockerStatsDto.setOk(true);
                dockerStatsDto.setPids(pids);
                try {
                    dockerStatsDto.setCpu(Double.parseDouble(cpu.trim().substring(0, cpu.trim().length() - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setMemoryUsage(mem.split("\\s*\\/\\s*")[0].trim());
                    dockerStatsDto.setMemoryLimit(mem.split("\\s*\\/\\s*")[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setMemory(Double.parseDouble(memP.trim().substring(0, memP.trim().length() - 1)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setNetInput(net.split("\\s*\\/\\s*")[0].trim());
                    dockerStatsDto.setNetOutput(net.split("\\s*\\/\\s*")[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dockerStatsDto.setBlockInput(block.split("\\s*\\/\\s*")[0].trim());
                    dockerStatsDto.setBlockOutput(block.split("\\s*\\/\\s*")[1].trim());
                }
                catch (Exception exception) {}
            }
            int exitCode = 0;
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Prozess beendet mit Exit-Code: " + exitCode);
            reader.close();
            inputStreamReader.close();
            inputStream.close();
            process.destroyForcibly();
        }
        catch (Exception e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            this.runDockerStats();
        }
    }

    public double cpuUsage() {
        double sum = 0.0;
        boolean ct = false;
        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
            try {
                sum += dockerStatsDto.getCpu();
            }
            catch (Exception exception) {}
        }
        return sum;
    }

    public double cpuUsagePercent() {
        return this.cpuUsage() / (double)this.analyzeService.getCPUanzahl();
    }

    public double cpuUsageAvg() {
        double sum = 0.0;
        boolean ct = false;
        for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
            try {
                sum += dockerStatsDto.getCpuAvg();
            }
            catch (Exception exception) {}
        }
        return sum;
    }

    public double cpuUsageAvgPercent() {
        return this.cpuUsage() / (double)this.analyzeService.getCPUanzahl();
    }

    public DockerStatsDto getContainerByName(String name) {
        if (this.dockerStats.contains(name = name.trim())) {
            return (DockerStatsDto)this.dockerStats.get(name);
        }
        return null;
    }

    public DockerStatsDto getContainerById(String id) {
        id = id.trim();
        try {
            for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                if (!dockerStatsDto.getId().equals(id)) continue;
                return dockerStatsDto;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<DockerStatsDto> getContainers() {
        ArrayList<DockerStatsDto> ret = new ArrayList<DockerStatsDto>();
        try {
            for (DockerStatsDto dockerStatsDto : this.dockerStats.values()) {
                ret.add(dockerStatsDto);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

