/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.model.properties;

import at.letto.setupservice.model.properties.LettoProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class LettoProperty {
    private PropertyMode propertyMode = PropertyMode.UNDEFINED;
    private String name = "";
    private String property = "";
    private String help = "";

    private LettoProperty(PropertyMode propertyMode, String name, String property, String help) {
        if (name.contains("=")) {
            throw new RuntimeException("property-name " + name + " contains = poperty: " + property);
        }
        this.propertyMode = propertyMode == null ? PropertyMode.UNDEFINED : propertyMode;
        this.name = name == null ? "" : name.replaceAll("[\\s\\r\\n]", "").trim();
        this.property = property == null ? "" : property.replaceAll("[\\r\\n]", "").trim();
        String string = this.help = help == null ? "" : help.replaceAll("[\\r\\n]", "").trim();
        if (this.propertyMode == PropertyMode.PROPERTY && name.length() == 0) {
            throw new RuntimeException("property-name is not defined");
        }
    }

    public static LettoProperty newProperty(String name, String property, String help) {
        return new LettoProperty(PropertyMode.PROPERTY, name, property, help);
    }

    public static LettoProperty newProperty(String name, String property) {
        return new LettoProperty(PropertyMode.PROPERTY, name, property, "");
    }

    public static LettoProperty newLine() {
        return new LettoProperty(PropertyMode.NEWLINE, "", "", "");
    }

    public static LettoProperty newComment(String comment) {
        return new LettoProperty(PropertyMode.COMMENT, "", "", comment);
    }

    public static LettoProperty newUndefined(String name) {
        return new LettoProperty(PropertyMode.UNDEFINED, name, "", "");
    }

    public static LettoProperty newPropertyFromFile(String line) {
        line = line.trim();
        try {
            if (line.length() == 0) {
                return LettoProperty.newLine();
            }
            if (line.startsWith("#")) {
                return LettoProperty.newComment((String)line.substring(1).trim());
            }
            Matcher m = Pattern.compile("^([^=]*)=(.*)$").matcher(line);
            if (m.find()) {
                String name = m.group(1).trim();
                String prop = m.group(2).trim();
                return LettoProperty.newProperty((String)name, (String)prop);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LettoProperty.newUndefined((String)line);
    }

    public String toString() {
        switch (1.$SwitchMap$at$letto$setupservice$model$properties$LettoProperty$PropertyMode[this.propertyMode.ordinal()]) {
            default: {
                return this.name;
            }
            case 2: {
                return "";
            }
            case 3: {
                return "# " + this.help;
            }
            case 4: 
        }
        Object ret = "";
        if (this.help.length() > 0) {
            ret = "# " + this.help + "\n";
        }
        ret = (String)ret + this.name + " = " + this.property;
        return ret;
    }

    public PropertyMode getPropertyMode() {
        return this.propertyMode;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty() {
        return this.property;
    }

    public String getHelp() {
        return this.help;
    }

    public LettoProperty() {
    }
}

