/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.dto;

import at.letto.setupservice.dto.DockerContainerStatusDto;
import at.letto.tools.Datum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemStatusDto
implements Cloneable {
    private long time = 0L;
    private double cpuLoad = 0.0;
    private int memoryTotalMB = 0;
    private int memoryFreeMB = 0;
    private int memoryUsedMB = 0;
    private int memorySwapTotalMB = 0;
    private int memorySwapFreeMB = 0;
    private int memorySwapUsedMB = 0;
    private int memoryBufferMB = 0;
    private int memoryAvailableMB = 0;
    private int memoryJavaUsedMB = 0;
    private int memoryJavaMaxMB = 0;
    private int totalDiskSpaceMB = 0;
    private int freeDiskSpaceMB = 0;
    private int useableDiskSpaceMB = 0;
    private List<DockerContainerStatusDto> dockerContainers = new ArrayList();

    private String getTimeString() {
        return Datum.formatDateTime((Date)new Date(this.time));
    }

    public String toString() {
        long t = (this.time + 500L) / 1000L;
        String ret = Datum.formatDateTime((Date)new Date(t * 1000L)) + ";" + t + ";" + this.cpuLoad + ";" + this.memoryTotalMB + ";" + this.memoryFreeMB + ";" + this.memoryUsedMB + ";" + this.memorySwapTotalMB + ";" + this.memorySwapFreeMB + ";" + this.memorySwapUsedMB + ";" + this.memoryBufferMB + ";" + this.memoryAvailableMB + ";" + this.memoryJavaUsedMB + ";" + this.memoryJavaMaxMB + ";" + this.totalDiskSpaceMB + ";" + this.freeDiskSpaceMB + ";" + this.useableDiskSpaceMB;
        for (DockerContainerStatusDto c : this.dockerContainers) {
            ret = ret + ";" + c;
        }
        return ret;
    }

    public static SystemStatusDto parse(String s) {
        SystemStatusDto dto = new SystemStatusDto();
        try {
            Pattern p = Pattern.compile("^([^;]+);([^;]*);([^;]*);([^;]*);([^;]*);([^;]*);([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);([^;]+);(.*)$");
            Matcher m = p.matcher(s);
            if (m.find()) {
                dto.time = Long.parseLong(m.group(2).trim()) * 1000L;
                dto.cpuLoad = Double.parseDouble(m.group(3).trim());
                dto.memoryTotalMB = Integer.parseInt(m.group(4).trim());
                dto.memoryFreeMB = Integer.parseInt(m.group(5).trim());
                dto.memoryUsedMB = Integer.parseInt(m.group(6).trim());
                dto.memorySwapTotalMB = Integer.parseInt(m.group(7).trim());
                dto.memorySwapFreeMB = Integer.parseInt(m.group(8).trim());
                dto.memorySwapUsedMB = Integer.parseInt(m.group(9).trim());
                dto.memoryBufferMB = Integer.parseInt(m.group(10).trim());
                dto.memoryAvailableMB = Integer.parseInt(m.group(11).trim());
                dto.memoryJavaUsedMB = Integer.parseInt(m.group(12).trim());
                dto.memoryJavaMaxMB = Integer.parseInt(m.group(13).trim());
                dto.totalDiskSpaceMB = Integer.parseInt(m.group(14).trim());
                dto.freeDiskSpaceMB = Integer.parseInt(m.group(15).trim());
                dto.useableDiskSpaceMB = Integer.parseInt(m.group(16).trim());
                s = m.group(17).trim();
                m = Pattern.compile("docker\\([^\\)]+\\)").matcher(s);
                while (m.find()) {
                    DockerContainerStatusDto dcs = DockerContainerStatusDto.parse((String)m.group(0));
                    if (dcs == null) continue;
                    dto.getDockerContainers().add(dcs);
                }
            }
            return dto;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getTime() {
        return this.time;
    }

    public double getCpuLoad() {
        return this.cpuLoad;
    }

    public int getMemoryTotalMB() {
        return this.memoryTotalMB;
    }

    public int getMemoryFreeMB() {
        return this.memoryFreeMB;
    }

    public int getMemoryUsedMB() {
        return this.memoryUsedMB;
    }

    public int getMemorySwapTotalMB() {
        return this.memorySwapTotalMB;
    }

    public int getMemorySwapFreeMB() {
        return this.memorySwapFreeMB;
    }

    public int getMemorySwapUsedMB() {
        return this.memorySwapUsedMB;
    }

    public int getMemoryBufferMB() {
        return this.memoryBufferMB;
    }

    public int getMemoryAvailableMB() {
        return this.memoryAvailableMB;
    }

    public int getMemoryJavaUsedMB() {
        return this.memoryJavaUsedMB;
    }

    public int getMemoryJavaMaxMB() {
        return this.memoryJavaMaxMB;
    }

    public int getTotalDiskSpaceMB() {
        return this.totalDiskSpaceMB;
    }

    public int getFreeDiskSpaceMB() {
        return this.freeDiskSpaceMB;
    }

    public int getUseableDiskSpaceMB() {
        return this.useableDiskSpaceMB;
    }

    public List<DockerContainerStatusDto> getDockerContainers() {
        return this.dockerContainers;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setCpuLoad(double cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    public void setMemoryTotalMB(int memoryTotalMB) {
        this.memoryTotalMB = memoryTotalMB;
    }

    public void setMemoryFreeMB(int memoryFreeMB) {
        this.memoryFreeMB = memoryFreeMB;
    }

    public void setMemoryUsedMB(int memoryUsedMB) {
        this.memoryUsedMB = memoryUsedMB;
    }

    public void setMemorySwapTotalMB(int memorySwapTotalMB) {
        this.memorySwapTotalMB = memorySwapTotalMB;
    }

    public void setMemorySwapFreeMB(int memorySwapFreeMB) {
        this.memorySwapFreeMB = memorySwapFreeMB;
    }

    public void setMemorySwapUsedMB(int memorySwapUsedMB) {
        this.memorySwapUsedMB = memorySwapUsedMB;
    }

    public void setMemoryBufferMB(int memoryBufferMB) {
        this.memoryBufferMB = memoryBufferMB;
    }

    public void setMemoryAvailableMB(int memoryAvailableMB) {
        this.memoryAvailableMB = memoryAvailableMB;
    }

    public void setMemoryJavaUsedMB(int memoryJavaUsedMB) {
        this.memoryJavaUsedMB = memoryJavaUsedMB;
    }

    public void setMemoryJavaMaxMB(int memoryJavaMaxMB) {
        this.memoryJavaMaxMB = memoryJavaMaxMB;
    }

    public void setTotalDiskSpaceMB(int totalDiskSpaceMB) {
        this.totalDiskSpaceMB = totalDiskSpaceMB;
    }

    public void setFreeDiskSpaceMB(int freeDiskSpaceMB) {
        this.freeDiskSpaceMB = freeDiskSpaceMB;
    }

    public void setUseableDiskSpaceMB(int useableDiskSpaceMB) {
        this.useableDiskSpaceMB = useableDiskSpaceMB;
    }

    public void setDockerContainers(List<DockerContainerStatusDto> dockerContainers) {
        this.dockerContainers = dockerContainers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemStatusDto)) {
            return false;
        }
        SystemStatusDto other = (SystemStatusDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (Double.compare(this.getCpuLoad(), other.getCpuLoad()) != 0) {
            return false;
        }
        if (this.getMemoryTotalMB() != other.getMemoryTotalMB()) {
            return false;
        }
        if (this.getMemoryFreeMB() != other.getMemoryFreeMB()) {
            return false;
        }
        if (this.getMemoryUsedMB() != other.getMemoryUsedMB()) {
            return false;
        }
        if (this.getMemorySwapTotalMB() != other.getMemorySwapTotalMB()) {
            return false;
        }
        if (this.getMemorySwapFreeMB() != other.getMemorySwapFreeMB()) {
            return false;
        }
        if (this.getMemorySwapUsedMB() != other.getMemorySwapUsedMB()) {
            return false;
        }
        if (this.getMemoryBufferMB() != other.getMemoryBufferMB()) {
            return false;
        }
        if (this.getMemoryAvailableMB() != other.getMemoryAvailableMB()) {
            return false;
        }
        if (this.getMemoryJavaUsedMB() != other.getMemoryJavaUsedMB()) {
            return false;
        }
        if (this.getMemoryJavaMaxMB() != other.getMemoryJavaMaxMB()) {
            return false;
        }
        if (this.getTotalDiskSpaceMB() != other.getTotalDiskSpaceMB()) {
            return false;
        }
        if (this.getFreeDiskSpaceMB() != other.getFreeDiskSpaceMB()) {
            return false;
        }
        if (this.getUseableDiskSpaceMB() != other.getUseableDiskSpaceMB()) {
            return false;
        }
        List this$dockerContainers = this.getDockerContainers();
        List other$dockerContainers = other.getDockerContainers();
        return !(this$dockerContainers == null ? other$dockerContainers != null : !((Object)this$dockerContainers).equals(other$dockerContainers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemStatusDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $cpuLoad = Double.doubleToLongBits(this.getCpuLoad());
        result = result * 59 + (int)($cpuLoad >>> 32 ^ $cpuLoad);
        result = result * 59 + this.getMemoryTotalMB();
        result = result * 59 + this.getMemoryFreeMB();
        result = result * 59 + this.getMemoryUsedMB();
        result = result * 59 + this.getMemorySwapTotalMB();
        result = result * 59 + this.getMemorySwapFreeMB();
        result = result * 59 + this.getMemorySwapUsedMB();
        result = result * 59 + this.getMemoryBufferMB();
        result = result * 59 + this.getMemoryAvailableMB();
        result = result * 59 + this.getMemoryJavaUsedMB();
        result = result * 59 + this.getMemoryJavaMaxMB();
        result = result * 59 + this.getTotalDiskSpaceMB();
        result = result * 59 + this.getFreeDiskSpaceMB();
        result = result * 59 + this.getUseableDiskSpaceMB();
        List $dockerContainers = this.getDockerContainers();
        result = result * 59 + ($dockerContainers == null ? 43 : ((Object)$dockerContainers).hashCode());
        return result;
    }

    public SystemStatusDto() {
    }

    public SystemStatusDto(long time, double cpuLoad, int memoryTotalMB, int memoryFreeMB, int memoryUsedMB, int memorySwapTotalMB, int memorySwapFreeMB, int memorySwapUsedMB, int memoryBufferMB, int memoryAvailableMB, int memoryJavaUsedMB, int memoryJavaMaxMB, int totalDiskSpaceMB, int freeDiskSpaceMB, int useableDiskSpaceMB, List<DockerContainerStatusDto> dockerContainers) {
        this.time = time;
        this.cpuLoad = cpuLoad;
        this.memoryTotalMB = memoryTotalMB;
        this.memoryFreeMB = memoryFreeMB;
        this.memoryUsedMB = memoryUsedMB;
        this.memorySwapTotalMB = memorySwapTotalMB;
        this.memorySwapFreeMB = memorySwapFreeMB;
        this.memorySwapUsedMB = memorySwapUsedMB;
        this.memoryBufferMB = memoryBufferMB;
        this.memoryAvailableMB = memoryAvailableMB;
        this.memoryJavaUsedMB = memoryJavaUsedMB;
        this.memoryJavaMaxMB = memoryJavaMaxMB;
        this.totalDiskSpaceMB = totalDiskSpaceMB;
        this.freeDiskSpaceMB = freeDiskSpaceMB;
        this.useableDiskSpaceMB = useableDiskSpaceMB;
        this.dockerContainers = dockerContainers;
    }
}

