/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.dto;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerStatsDto {
    private String id = "";
    private String name = "";
    private String memoryUsage = "";
    private int memoryMB = 0;
    private String memoryLimit = "";
    private int memoryLimitMB = 0;
    private double memory = 0.0;
    private String netInput = "";
    private int netInputMB = 0;
    private String netOutput = "";
    private int netOutputMB = 0;
    private String blockInput = "";
    private int blockInputMB = 0;
    private String blockOutput = "";
    private int blockOutputMB = 0;
    private String pids = "";
    private boolean ok = false;
    private double cpu = 0.0;
    private double[] cpuTrend = new double[60];
    private int cpuTrendCounter = 0;
    private boolean cpuTrendFull = false;
    private double cpuAvg = 0.0;

    public DockerStatsDto(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public void setCpu(double cpu) {
        this.cpu = cpu;
        this.cpuTrend[this.cpuTrendCounter] = cpu;
        this.cpuTrendCounter = (this.cpuTrendCounter + 1) % 60;
        if (this.cpuTrendCounter == 59) {
            this.cpuTrendFull = true;
        }
        double sum = 0.0;
        int max = this.cpuTrendFull ? 60 : this.cpuTrendCounter;
        for (int i = 0; i < max; ++i) {
            sum += this.cpuTrend[i];
        }
        this.cpuAvg = sum / (double)max;
    }

    private Double parseMB(String s) {
        Matcher m = Pattern.compile("^([0-9\\.]+)([^0-9\\.]*)$").matcher(s.trim());
        if (m.find()) {
            try {
                double w = Double.parseDouble(m.group(1));
                String e = m.group(2);
                if (e.startsWith("k")) {
                    return w / 1024.0;
                }
                if (e.startsWith("M")) {
                    return w;
                }
                if (e.startsWith("G")) {
                    return w * 1024.0;
                }
                if (e.startsWith("T")) {
                    return w * 1024.0 * 1024.0;
                }
                if (e.startsWith("B")) {
                    return 0.0;
                }
                if (e.startsWith("iB")) {
                    return 0.0;
                }
                if (e.length() == 0) {
                    return 0.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setMemoryUsage(String memoryUsage) {
        this.memoryUsage = memoryUsage;
        Double w = this.parseMB(memoryUsage);
        if (w != null) {
            this.memoryMB = (int)(w + 0.5);
        }
    }

    public void setMemoryLimit(String memoryLimit) {
        this.memoryLimit = memoryLimit;
        Double w = this.parseMB(memoryLimit);
        if (w != null) {
            this.memoryLimitMB = (int)(w + 0.5);
        }
    }

    public void setNetInput(String netInput) {
        this.netInput = netInput;
        Double w = this.parseMB(netInput);
        if (w != null) {
            this.netInputMB = (int)(w + 0.5);
        }
    }

    public void setNetOutput(String netOutput) {
        this.netOutput = netOutput;
        Double w = this.parseMB(netOutput);
        if (w != null) {
            this.netOutputMB = (int)(w + 0.5);
        }
    }

    public void setBlockInput(String blockInput) {
        this.blockInput = blockInput;
        Double w = this.parseMB(this.netOutput);
        if (w != null) {
            this.netOutputMB = (int)(w + 0.5);
        }
    }

    public void setBlockOutput(String blockOutput) {
        this.blockOutput = blockOutput;
        Double w = this.parseMB(this.netOutput);
        if (w != null) {
            this.netOutputMB = (int)(w + 0.5);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMemoryUsage() {
        return this.memoryUsage;
    }

    public int getMemoryMB() {
        return this.memoryMB;
    }

    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    public int getMemoryLimitMB() {
        return this.memoryLimitMB;
    }

    public double getMemory() {
        return this.memory;
    }

    public String getNetInput() {
        return this.netInput;
    }

    public int getNetInputMB() {
        return this.netInputMB;
    }

    public String getNetOutput() {
        return this.netOutput;
    }

    public int getNetOutputMB() {
        return this.netOutputMB;
    }

    public String getBlockInput() {
        return this.blockInput;
    }

    public int getBlockInputMB() {
        return this.blockInputMB;
    }

    public String getBlockOutput() {
        return this.blockOutput;
    }

    public int getBlockOutputMB() {
        return this.blockOutputMB;
    }

    public String getPids() {
        return this.pids;
    }

    public boolean isOk() {
        return this.ok;
    }

    public double getCpu() {
        return this.cpu;
    }

    public double[] getCpuTrend() {
        return this.cpuTrend;
    }

    public int getCpuTrendCounter() {
        return this.cpuTrendCounter;
    }

    public boolean isCpuTrendFull() {
        return this.cpuTrendFull;
    }

    public double getCpuAvg() {
        return this.cpuAvg;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMemory(double memory) {
        this.memory = memory;
    }

    public void setPids(String pids) {
        this.pids = pids;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }
}

