/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.service.DockerService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.WebRequest;

@Controller
public class ErrorHandlerController
implements ErrorController {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private DockerService dockerService;
    private ErrorAttributes errorAttributes;

    public ErrorHandlerController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    public String getErrorPath() {
        if (this.microServiceConfiguration.isSetupDocker()) {
            return "/config/error";
        }
        return "/setup/error";
    }

    @RequestMapping(value={"/config/error"})
    public String getErrorPath(HttpServletRequest request, WebRequest webRequest, Model model) {
        Map errorAttributes = this.errorAttributes.getErrorAttributes(webRequest, ErrorAttributeOptions.defaults());
        model.addAttribute("msg", (Object)errorAttributes);
        model.addAttribute("status", (Object)this.getStatus(request));
        model.addAttribute("welcome", (Object)this.dockerService.welcomeEP());
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "error";
    }

    @RequestMapping(value={"/setup/error"})
    public String getErrorPathLocal(HttpServletRequest request, WebRequest webRequest, Model model) {
        Map errorAttributes = this.errorAttributes.getErrorAttributes(webRequest, ErrorAttributeOptions.defaults());
        model.addAttribute("msg", (Object)errorAttributes);
        model.addAttribute("status", (Object)this.getStatus(request));
        model.addAttribute("welcome", (Object)this.dockerService.welcomeEP());
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "error";
    }

    private boolean getTraceParameter(HttpServletRequest request) {
        String parameter = request.getParameter("trace");
        if (parameter == null) {
            return false;
        }
        return !"false".equals(parameter.toLowerCase());
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode != null) {
            try {
                return HttpStatus.valueOf((int)statusCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

