/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.model.LettoSetupConfigFile;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.SetupUserDetailsService;
import at.letto.tools.Cmd;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SetupConfiguration {
    private AnalyzeService analyzeService;
    private DockerConfiguration dockerConfiguration;
    private LettoService lettoService;
    protected LettoSetupConfigFile conf = null;
    private MicroServiceConfiguration microServiceConfiguration;
    private SetupUserDetailsService userDetailsService;
    private boolean autostartLettoLocal = false;
    private boolean autostartLettoDocker = false;
    private boolean autostartLtiLocal = false;

    private void setPropDef(String prop, String def) {
        if (def != null && def.trim().length() > 0) {
            this.conf.setProperty(prop, def);
        }
    }

    public SetupConfiguration(AnalyzeService analyzeService, DockerConfiguration dockerConfiguration, LettoService lettoService) {
        this.analyzeService = analyzeService;
        this.dockerConfiguration = dockerConfiguration;
        this.lettoService = lettoService;
    }

    public void erstConfiguration() {
        this.conf.setSetupInit(true);
        this.conf.setSetupLettoDocker(false);
        this.conf.setSetupLettoLocal(false);
        System.out.println("Erstkonfiguration");
        this.setPropDef("letto_tomee_mysql_server", this.analyzeService.getLocal_tomee_mysql_server());
        this.setPropDef("letto_tomee_mysql_database", this.analyzeService.getLocal_tomee_mysql_database());
        this.setPropDef("letto_tomee_mysql_user", this.analyzeService.getLocal_tomee_mysql_user());
        this.setPropDef("letto_tomee_mysql_password", this.analyzeService.getLocal_tomee_mysql_password());
        this.setPropDef("letto_lti_mysql_server", this.analyzeService.getLocal_lti_mysql_server());
        this.setPropDef("letto_lti_mysql_database", this.analyzeService.getLocal_lti_mysql_database());
        this.setPropDef("letto_lti_mysql_user", this.analyzeService.getLocal_lti_mysql_user());
        this.setPropDef("letto_lti_mysql_password", this.analyzeService.getLocal_lti_mysql_password());
        this.setPropDef("letto_mysql_sicherungsuser", this.analyzeService.getLocal_sicherung_user());
        this.setPropDef("letto_mysql_sicherungspasswort", this.analyzeService.getLocal_sicherung_password());
        this.setPropDef("letto_dns_name", this.analyzeService.getLocal_dns_name());
        this.setPropDef("letto_admin_email", this.analyzeService.getLocal_admin_email());
        this.setPropDef("letto_memory", this.analyzeService.getLocal_letto_memory());
        this.setPropDef("letto_local_maxima", this.analyzeService.searchMaximaPath());
        this.setPropDef("letto_local_tex", this.analyzeService.searchTexPath());
        this.setPropDef("letto_local_inkscape", this.analyzeService.searchInkscapePath());
        if (this.analyzeService.isLocalInstallationFound()) {
            this.conf.setSetupLettoLocal(true);
        }
        if (this.analyzeService.isSetupConfigurationPresent()) {
            this.conf.setSetupLettoDocker(true);
        }
        this.conf.save();
    }

    public void searchPrograms() {
        String p = this.analyzeService.searchMaximaPath();
        if (p != null && p.length() > 0) {
            this.setPropDef("letto_local_maxima", p);
        }
        if ((p = this.analyzeService.searchTexPath()) != null && p.length() > 0) {
            this.setPropDef("letto_local_tex", p);
        }
        if ((p = this.analyzeService.searchInkscapePath()) != null && p.length() > 0) {
            this.setPropDef("letto_local_inkscape", p);
        }
        this.conf.save();
        this.analyzeService.analyze();
    }

    public void startLeTTo() {
        if (this.autostartLettoLocal && !this.isRunningLettoLocal()) {
            this.startLettoLocal();
        }
        System.out.println("Starte LeTTo");
    }

    public boolean isRunningLettoLocal() {
        return false;
    }

    public void startLettoLocal() {
        if (this.analyzeService.isLinux()) {
            Cmd.systemcall((String)"/opt/letto/start.sh");
        }
    }

    public void reload() {
        this.conf = new LettoSetupConfigFile(this.analyzeService.getRootPath() + "/letto.conf");
        this.analyzeService.analyze();
    }

    public AnalyzeService getAnalyzeService() {
        return this.analyzeService;
    }

    public DockerConfiguration getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public LettoService getLettoService() {
        return this.lettoService;
    }

    public LettoSetupConfigFile getConf() {
        return this.conf;
    }

    public MicroServiceConfiguration getMicroServiceConfiguration() {
        return this.microServiceConfiguration;
    }

    public SetupUserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public boolean isAutostartLettoLocal() {
        return this.autostartLettoLocal;
    }

    public boolean isAutostartLettoDocker() {
        return this.autostartLettoDocker;
    }

    public boolean isAutostartLtiLocal() {
        return this.autostartLtiLocal;
    }
}

