/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice;

import at.letto.setupservice.model.properties.LettoProperties;
import at.letto.tools.Cmd;
import at.letto.tools.ServerStatus;
import java.io.File;
import java.security.CodeSource;
import java.util.Map;
import java.util.jar.Manifest;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication(scanBasePackages={"at.letto.setupservice", "at.letto.basespringboot.security", "at.letto.basespringboot.config", "at.letto.basespringboot.controller"})
public class SetupserviceApplication {
    public static ConfigurableApplicationContext context;
    public static Manifest manifest;

    public static String getRootPath(Class mainClass) {
        try {
            CodeSource codeSource = mainClass.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            String jarDir = jarFile.getParentFile().getPath();
            return jarDir;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static boolean isDocker() {
        Map<String, String> env = System.getenv();
        return env.containsKey("SETUP_DOCKER") && env.get("SETUP_DOCKER").equalsIgnoreCase("true");
    }

    public static void main(String[] args) {
        context = SpringApplication.run(SetupserviceApplication.class, (String[])args);
        try {
            manifest = new Manifest(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/MANIFEST.MF"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void restart() {
        ApplicationArguments args = (ApplicationArguments)context.getBean(ApplicationArguments.class);
        Thread thread = new Thread(() -> {
            System.out.println("lettosetup soll neu gestartet werden!");
            if (ServerStatus.isLinux()) {
                try {
                    File restartfile = new File(LettoProperties.ROOT_PATH + "/restart.setup");
                    restartfile.createNewFile();
                    System.out.println("lettosetup wird gestoppt.");
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ServerStatus.isWindows()) {
                context.close();
                Cmd.systemcall((String)(LettoProperties.ROOT_PATH + "/startlettosetup.bat"));
                System.out.println("startlettosetup.bat wurde gestartet! Setup wird beendet!");
                System.exit(0);
            }
            System.out.println("lettosetup kann nicht neu gestartet werden!");
        });
        thread.setDaemon(false);
        thread.start();
    }
}

