/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.xml;

import at.letto.export.dto.ImportExportDto;
import at.letto.exportservice.dto.ImportParams;
import at.letto.exportservice.xml.XMLconfig;
import at.letto.exportservice.xml.XMLfileLTO;
import at.letto.exportservice.xml.XMLfileMoodle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class XMLfile {
    public static final Vector<XMLfile> XMLformats = XMLfile.registerXMLfiles();

    public abstract boolean checkRootElementName(String var1);

    public abstract ImportExportDto parseXMLnode(Element var1, XMLconfig var2, ImportParams var3);

    public void readContentPrepare(Vector<String> inhalt) {
    }

    protected String getElementName(String element) {
        Matcher m = Pattern.compile("^([^\\s]+)\\s.*").matcher(element);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static Vector<XMLfile> registerXMLfiles() {
        Vector<XMLfile> ret = new Vector<XMLfile>();
        ret.add((XMLfile)new XMLfileLTO());
        ret.add((XMLfile)new XMLfileMoodle());
        return ret;
    }

    private static String getRootElementString(Vector<String> inhalt) {
        Object line = "";
        for (String s : inhalt) {
            line = (String)line + s.trim();
            ((String)line).replaceAll("\\<\\?.*\\?\\>", "");
            ((String)line).replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
            ((String)line).trim();
            Matcher m = Pattern.compile("\\<([^\\?\\!\\s\\>]+[^\\s\\>]*)(\\s[^\\>]*)?\\>").matcher((CharSequence)line);
            if (!m.find()) continue;
            String p = m.group(1);
            return p;
        }
        return null;
    }

    public static ImportExportDto loadXML(File file, XMLconfig conf, ImportParams importParams) {
        if (file.exists() && file.canRead() && !file.isDirectory()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                return XMLfile.loadXML((BufferedReader)reader, (XMLconfig)conf, (ImportParams)importParams);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Datei kann nicht gelesen werden!");
    }

    public static ImportExportDto loadXML(String filename, XMLconfig conf, ImportParams importParams) {
        if (filename == null || filename.length() == 0) {
            throw new RuntimeException("Dateiname leer!");
        }
        File file = new File(filename);
        return XMLfile.loadXML((File)file, (XMLconfig)conf, (ImportParams)importParams);
    }

    public static ImportExportDto loadXML(BufferedReader reader, XMLconfig conf, ImportParams importParams) {
        try {
            DOMParser parser = new DOMParser();
            Element root = null;
            XMLfile xmlfile = null;
            try {
                String sl;
                parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
                Vector<String> inhalt = new Vector<String>();
                while ((sl = reader.readLine()) != null) {
                    StringBuilder sb = new StringBuilder();
                    for (Object c : (Object)sl.toCharArray()) {
                        if (c <= 8) continue;
                        sb.append((char)c);
                    }
                    sl = sb.toString();
                    inhalt.add(sl);
                }
                String rootElementString = XMLfile.getRootElementString(inhalt);
                for (XMLfile f : XMLformats) {
                    if (xmlfile != null || !f.checkRootElementName(rootElementString)) continue;
                    xmlfile = f;
                }
                if (xmlfile != null) {
                    xmlfile.readContentPrepare(inhalt);
                    StringBuffer inhaltAsString = new StringBuffer();
                    for (String s : inhalt) {
                        inhaltAsString.append(s + "\n");
                    }
                    parser.parse(new InputSource(new StringReader(inhaltAsString.toString())));
                    Document d = parser.getDocument();
                    root = d.getDocumentElement();
                }
            }
            catch (SAXException e) {
                reader.close();
                throw new RuntimeException("Ein XML-Parser-Fehler ist aufgetreten: " + e);
            }
            reader.close();
            if (root == null || xmlfile == null) {
                throw new RuntimeException("Die Datei hat ein ung\u00fcltiges Format!");
            }
            return xmlfile.parseXMLnode(root, conf, importParams);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Datei kann nicht gelesen werden!");
        }
    }
}

