/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.service.threads;

import at.letto.export.dto.FileTransferDto;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.export.dto.questions.ExportAnswerV1;
import at.letto.export.dto.questions.ExportDatasetDefinitionV1;
import at.letto.export.dto.questions.ExportLettoFileV1;
import at.letto.export.dto.questions.ExportLettoTextV1;
import at.letto.export.dto.questions.ExportQuestionCommentV1;
import at.letto.export.dto.questions.ExportQuestionV1;
import at.letto.export.dto.questions.ExportSubQuestionV1;
import at.letto.exportservice.dto.ImportParams;
import at.letto.exportservice.service.ExportImportService;
import at.letto.exportservice.xml.XMLconfig;
import at.letto.service.base.BaseImageService;
import at.letto.tools.enums.AntwortenMischen;
import at.letto.tools.enums.Breite;
import at.letto.tools.enums.IconType;
import at.letto.tools.enums.LueckentextMode;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.enums.SQMODE;
import at.letto.tools.enums.Schwierigkeit;
import at.letto.tools.html.HTMLtool;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlImport {
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public static String getStringNode(Node n) {
        NodeList c = n.getChildNodes();
        for (int k = 0; k < c.getLength(); ++k) {
            if (c.item(k).getNodeType() != 3) continue;
            return HTMLtool.XMLToString((String)c.item(k).getNodeValue());
        }
        return "";
    }

    public static String getCDataNode(Node n) {
        NodeList c1 = n.getChildNodes();
        for (int k = 0; k < c1.getLength(); ++k) {
            if (c1.item(k).getNodeType() != 4) continue;
            return HTMLtool.XMLToString((String)c1.item(k).getNodeValue());
        }
        return "";
    }

    public static int getBooleanNodeInt(Node n) {
        if (XmlImport.getStringNode((Node)n).equals("true")) {
            return 1;
        }
        if (XmlImport.getStringNode((Node)n).equals("1")) {
            return 1;
        }
        return 0;
    }

    public static boolean getBooleanNode(Node n) {
        if (XmlImport.getStringNode((Node)n).equals("true")) {
            return true;
        }
        return XmlImport.getStringNode((Node)n).equals("1");
    }

    public static Date getDateNode(Node n) {
        NodeList c = n.getChildNodes();
        for (int k = 0; k < c.getLength(); ++k) {
            if (c.item(k).getNodeType() != 3) continue;
            String dat = HTMLtool.XMLToString((String)c.item(k).getNodeValue());
            try {
                return dateFormat.parse(dat);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static int getIntNode(Node n) {
        int ret = 0;
        String s = "";
        try {
            s = XmlImport.getStringNode((Node)n);
            ret = Integer.parseInt(XmlImport.getStringNode((Node)n));
        }
        catch (NumberFormatException e) {
            System.out.println("Integer Importfehler:" + s + " E:" + e);
        }
        return ret;
    }

    public static Long getLongNode(Node n) {
        long ret = 0L;
        String s = "";
        try {
            s = XmlImport.getStringNode((Node)n);
            ret = Long.parseLong(XmlImport.getStringNode((Node)n));
        }
        catch (NumberFormatException e) {
            System.out.println("Long Importfehler:" + s + " E:" + e);
        }
        return ret;
    }

    public static double getDoubleNode(Node n) {
        double ret = 0.0;
        String s = "";
        try {
            s = XmlImport.getStringNode((Node)n);
            ret = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            System.out.println("Double Importfehler:" + s + " E:" + e);
        }
        return ret;
    }

    public static String NodeImportTagText(String inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            NodeList c1 = n.getChildNodes();
            for (int j = 0; j < c1.getLength(); ++j) {
                if (!c1.item(j).getNodeName().equals("text") || c1.item(j).getNodeType() != 1) continue;
                String in = XmlImport.getCDataNode((Node)c1.item(j));
                if (in.length() == 0) {
                    in = XmlImport.getStringNode((Node)c1.item(j));
                }
                return in;
            }
        }
        return inhalt;
    }

    public static double NodeImportDouble(double inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            return XmlImport.getDoubleNode((Node)n);
        }
        return inhalt;
    }

    public static int NodeImportInt(int inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            return XmlImport.getIntNode((Node)n);
        }
        return inhalt;
    }

    public static long NodeImportLong(long inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            return XmlImport.getLongNode((Node)n);
        }
        return inhalt;
    }

    public static int NodeImportBoolean(int inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            return XmlImport.getBooleanNodeInt((Node)n);
        }
        return inhalt;
    }

    public static boolean NodeImportBoolean(boolean inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            return XmlImport.getBooleanNode((Node)n);
        }
        return inhalt;
    }

    public static String NodeImportString(String inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            return XmlImport.getStringNode((Node)n);
        }
        return inhalt;
    }

    public static String NodeImportText(String inhalt, Node n) {
        if (n.getNodeName().equals("text") && n.getNodeType() == 1 && (inhalt = XmlImport.getCDataNode((Node)n)).length() == 0) {
            inhalt = XmlImport.getStringNode((Node)n);
        }
        return inhalt;
    }

    public static String NodeImportCData(String inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1 && (inhalt = XmlImport.getCDataNode((Node)n)).length() == 0) {
            inhalt = XmlImport.getStringNode((Node)n);
        }
        return inhalt;
    }

    public static String LettoImportCData(String inhalt, Node n, String tagName) {
        if (n.getNodeName().equals(tagName) && n.getNodeType() == 1) {
            int k;
            NodeList c = n.getChildNodes();
            for (k = 0; k < c.getLength(); ++k) {
                if (c.item(k).getNodeType() != 4) continue;
                return c.item(k).getNodeValue();
            }
            for (k = 0; k < c.getLength(); ++k) {
                if (c.item(k).getNodeType() != 3) continue;
                return c.item(k).getNodeValue();
            }
        }
        return inhalt;
    }

    public static String NodeImportAttribut(String inhalt, Node n, String attrName) {
        if (n.getNodeType() == 2 && n.getNodeName().equals(attrName)) {
            return n.getNodeValue();
        }
        return inhalt;
    }

    public static boolean existQuestion(ExportCategoryV1 category, String name) {
        for (ExportQuestionV1 q : category.getQuestions()) {
            if (!q.getName().trim().equals(name.trim())) continue;
            return true;
        }
        return false;
    }

    public static ExportQuestionV1 addQuestion(ExportCategoryV1 parent, ExportQuestionV1 question) {
        for (ExportQuestionV1 q : parent.getQuestions()) {
            if (!q.toString().equals(question.toString())) continue;
            return q;
        }
        while (XmlImport.existQuestion((ExportCategoryV1)parent, (String)question.getName())) {
            Matcher m = Pattern.compile("^(.*\\-)(\\d+)$").matcher(question.getName());
            if (m.find()) {
                MatchResult result = m.toMatchResult();
                int n = Integer.parseInt(result.group(2));
                question.setName(result.group(1) + (n + 1));
                continue;
            }
            question.setName(question.getName() + "-1");
        }
        question.setId(0);
        question.setCategory(parent);
        parent.getQuestions().add(question);
        return question;
    }

    public static ExportCategoryV1 addCategory(ExportCategoryV1 parent, ExportCategoryV1 category) {
        for (ExportCategoryV1 c : parent.getCategories()) {
            if (!c.getName().equals(category.getName())) continue;
            for (ExportCategoryV1 sc : category.getCategories()) {
                XmlImport.addCategory((ExportCategoryV1)c, (ExportCategoryV1)sc);
            }
            for (ExportQuestionV1 sq : category.getQuestions()) {
                XmlImport.addQuestion((ExportCategoryV1)c, (ExportQuestionV1)sq);
            }
            return c;
        }
        parent.getCategories().add(category);
        category.setParent(parent);
        return category;
    }

    public static ExportCategoryV1 parseCategory(ExportCategoryV1 parent, Node n, XMLconfig conf, ImportParams importParams) {
        ExportCategoryV1 result = new ExportCategoryV1();
        result.setParent(parent);
        NodeList c = n.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            Node node = c.item(i);
            if (node.getNodeType() == 1) {
                switch (node.getNodeName()) {
                    case "category": {
                        ExportCategoryV1 category = XmlImport.parseCategory((ExportCategoryV1)result, (Node)node, (XMLconfig)conf, (ImportParams)importParams);
                        XmlImport.addCategory((ExportCategoryV1)result, (ExportCategoryV1)category);
                        break;
                    }
                    case "question": {
                        ExportQuestionV1 question = XmlImport.parseQuestion((ExportCategoryV1)result, (Node)node, (ImportParams)importParams);
                        XmlImport.addQuestion((ExportCategoryV1)result, (ExportQuestionV1)question);
                    }
                }
            }
            result.setName(XmlImport.NodeImportCData((String)result.getName(), (Node)node, (String)"name"));
        }
        return result;
    }

    public static ExportQuestionV1 parseQuestion(ExportCategoryV1 parent, Node n, ImportParams importParams) {
        ExportQuestionV1 result = new ExportQuestionV1();
        result.setCategory(parent);
        NodeList c = n.getChildNodes();
        if (result.getSingle() == null) {
            result.setSingle(LueckentextMode.Texteingabe.toString());
        }
        block84: for (int i = 0; i < c.getLength(); ++i) {
            Node sn = c.item(i);
            String nodename = sn.getNodeName();
            if (nodename == null || sn.getNodeType() != 1) continue;
            switch (nodename) {
                case "id": {
                    result.setId(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "idUser": {
                    result.setIdUser(XmlImport.getLongNode((Node)sn).longValue());
                    continue block84;
                }
                case "questionType": {
                    String questionType = XmlImport.getStringNode((Node)sn);
                    if (questionType == null) continue block84;
                    if (questionType.matches("^\\d+$")) {
                        result.setQuestionType(QuestionType.getType((int)XmlImport.getIntNode((Node)sn)).toString());
                        continue block84;
                    }
                    result.setQuestionType(questionType);
                    continue block84;
                }
                case "single": {
                    String single = XmlImport.getStringNode((Node)sn);
                    if (single == null) continue block84;
                    if (single.matches("^\\d+$")) {
                        result.setSingle(LueckentextMode.getType((int)XmlImport.getIntNode((Node)sn)).toString());
                        continue block84;
                    }
                    result.setSingle(single);
                    continue block84;
                }
                case "shuffleAnswers": {
                    String sA = XmlImport.getStringNode((Node)sn);
                    if (sA == null) continue block84;
                    if (sA.matches("^\\d+$")) {
                        result.setShuffleAnswers(AntwortenMischen.getType((int)XmlImport.getIntNode((Node)sn)).toString());
                        continue block84;
                    }
                    result.setShuffleAnswers(sA);
                    continue block84;
                }
                case "name": {
                    result.setName(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "punkte": {
                    result.setPunkte(XmlImport.getDoubleNode((Node)sn));
                    continue block84;
                }
                case "abzug": {
                    result.setAbzug(XmlImport.getStringNode((Node)sn));
                    continue block84;
                }
                case "hidden": {
                    result.setHidden(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "tag": {
                    result.setTag(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "noAutoCorrect": {
                    result.setNoAutoCorrect(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "usecase": {
                    result.setUsecase(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "synchronize": {
                    result.setSynchronize(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "answerNumbering": {
                    result.setAnswerNumbering(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "unitGradingType": {
                    result.setUnitGradingType(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "unitPenalty": {
                    result.setUnitPenalty(XmlImport.getDoubleNode((Node)sn));
                    continue block84;
                }
                case "showUnits": {
                    result.setShowUnits(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "unitsLeft": {
                    result.setUnitsLeft(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "maxima": {
                    result.setMaxima(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "maximaAngabe": {
                    result.setMaximaAngabe(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "responseFormat": {
                    result.setResponseFormat(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "responseFieldLines": {
                    result.setResponseFieldLines(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "attachments": {
                    result.setAttachments(XmlImport.getIntNode((Node)sn));
                    continue block84;
                }
                case "md5": {
                    result.setMd5(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "units": {
                    result.setUnits(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "plugins": {
                    result.setPlugins(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "sendToParser": {
                    result.setSendToParser(XmlImport.getBooleanNode((Node)sn));
                    continue block84;
                }
                case "preCalc": {
                    result.setPreCalc(XmlImport.getBooleanNode((Node)sn));
                    continue block84;
                }
                case "useSymbolicMode": {
                    result.setUseSymbolicMode(XmlImport.getBooleanNode((Node)sn));
                    continue block84;
                }
                case "info": {
                    result.setQuestionInfo(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "licenceKey": {
                    result.setLicenceKey(XmlImport.getCDataNode((Node)sn));
                    continue block84;
                }
                case "streng": {
                    result.setStreng(XmlImport.getBooleanNode((Node)sn));
                    continue block84;
                }
                case "konstanteMitProzent": {
                    result.setKonstanteMitProzent(XmlImport.getBooleanNode((Node)sn));
                    continue block84;
                }
                case "addDocumentsPossible": {
                    result.setAddDocumentsPossible(XmlImport.getBooleanNode((Node)sn));
                    continue block84;
                }
                case "randomDataset": {
                    result.setRandomDataset(XmlImport.getBooleanNode((Node)sn));
                    continue block84;
                }
                case "questionCommentMsg": {
                    String msg = XmlImport.getCDataNode((Node)sn);
                    if (msg == null) continue block84;
                    if (result.getQuestionComment() == null) {
                        result.setQuestionComment(new ExportQuestionCommentV1(0, result.getId(), msg, IconType.PROCESSING.toString()));
                        continue block84;
                    }
                    result.getQuestionComment().setMessage(msg);
                    continue block84;
                }
                case "questionCommentIcon": {
                    String icon = XmlImport.getStringNode((Node)sn);
                    if (icon == null || icon.length() <= 0) continue block84;
                    if (result.getQuestionComment() == null) {
                        result.setQuestionComment(new ExportQuestionCommentV1(0, result.getId(), "", icon));
                        continue block84;
                    }
                    result.getQuestionComment().setIcon(icon);
                    continue block84;
                }
                case "text": {
                    result.getLettoTexte().add(XmlImport.parseLettoText((Node)sn, (ImportParams)importParams));
                    continue block84;
                }
                case "subquestion": {
                    result.getSubQuestions().add(XmlImport.parseSubQuestion((Node)sn, (ImportParams)importParams));
                    continue block84;
                }
                case "dataset": {
                    result.getDatasetDefinitions().add(XmlImport.parseDatasetDefinition((Node)sn, (ImportParams)importParams));
                }
            }
        }
        return result;
    }

    public static ExportLettoTextV1 parseLettoText(Node n, ImportParams importParams) {
        ExportLettoTextV1 result = new ExportLettoTextV1();
        NamedNodeMap attr_list = n.getAttributes();
        block20: for (int i = 0; i < attr_list.getLength(); ++i) {
            if (attr_list.item(i).getNodeType() != 2) continue;
            String name = attr_list.item(i).getNodeName();
            String value = attr_list.item(i).getNodeValue();
            switch (name) {
                case "art": {
                    continue block20;
                }
                case "id": {
                    try {
                        result.setId(Long.parseLong(value));
                    }
                    catch (Exception exception) {}
                    continue block20;
                }
                case "format": {
                    result.setFormat(value);
                    continue block20;
                }
            }
        }
        NodeList c = n.getChildNodes();
        block21: for (int i = 0; i < c.getLength(); ++i) {
            Node sn = c.item(i);
            String nodename = sn.getNodeName();
            if (nodename == null || sn.getNodeType() != 1) continue;
            switch (nodename) {
                case "inhalt": {
                    result.setText(XmlImport.getCDataNode((Node)sn));
                    continue block21;
                }
                case "file": {
                    ExportLettoFileV1 file = XmlImport.parseLettoFile((Node)sn, (ImportParams)importParams);
                    if (file == null) continue block21;
                    result.getFiles().add(file);
                }
            }
        }
        return result;
    }

    public static ExportSubQuestionV1 parseSubQuestion(Node n, ImportParams importParams) {
        ExportSubQuestionV1 result = new ExportSubQuestionV1();
        NodeList c = n.getChildNodes();
        String einheit = "";
        block24: for (int i = 0; i < c.getLength(); ++i) {
            Node sn = c.item(i);
            String nodename = sn.getNodeName();
            if (nodename == null || sn.getNodeType() != 1) continue;
            switch (nodename) {
                case "id": {
                    result.setId(XmlImport.getLongNode((Node)sn).longValue());
                    continue block24;
                }
                case "grade": {
                    result.setGrade(XmlImport.getDoubleNode((Node)sn));
                    continue block24;
                }
                case "mode": {
                    String sqmode = XmlImport.getStringNode((Node)sn);
                    if (sqmode == null) continue block24;
                    if (sqmode.matches("^\\d+$")) {
                        result.setMode(SQMODE.parse((int)XmlImport.getIntNode((Node)sn)).toString());
                        continue block24;
                    }
                    result.setMode(sqmode);
                    continue block24;
                }
                case "name": {
                    result.setName(XmlImport.getCDataNode((Node)sn));
                    continue block24;
                }
                case "maxima": {
                    result.setMaxima(XmlImport.getCDataNode((Node)sn));
                    continue block24;
                }
                case "plugininfo": {
                    result.setPluginInfo(XmlImport.getCDataNode((Node)sn));
                    continue block24;
                }
                case "einheit": {
                    einheit = XmlImport.getCDataNode((Node)sn);
                    continue block24;
                }
                case "shuffleanswers": {
                    String shuffleanswers = XmlImport.getStringNode((Node)sn);
                    if (shuffleanswers == null) continue block24;
                    if (shuffleanswers.matches("^\\d+$")) {
                        result.setShuffleAnswers(AntwortenMischen.getType((int)XmlImport.getIntNode((Node)sn)).toString());
                        continue block24;
                    }
                    result.setShuffleAnswers(shuffleanswers);
                    continue block24;
                }
                case "schwierigkeit": {
                    String schwierigkeit = XmlImport.getStringNode((Node)sn);
                    if (schwierigkeit == null) continue block24;
                    if (schwierigkeit.matches("^\\d+$")) {
                        result.setSchwierigkeit(Schwierigkeit.getType((int)XmlImport.getIntNode((Node)sn)).toString());
                        continue block24;
                    }
                    result.setSchwierigkeit(schwierigkeit);
                    continue block24;
                }
                case "answer": {
                    ExportAnswerV1 answer = XmlImport.parseAnswer((Node)sn, (ImportParams)importParams);
                    if (answer == null) continue block24;
                    if (answer.getEinheit().length() == 0) {
                        answer.setEinheit(einheit);
                    }
                    result.getAnswers().add(answer);
                }
            }
        }
        return result;
    }

    public static ExportAnswerV1 parseAnswer(Node n, ImportParams importParams) {
        ExportAnswerV1 result = new ExportAnswerV1();
        NodeList c = n.getChildNodes();
        block26: for (int i = 0; i < c.getLength(); ++i) {
            Node sn = c.item(i);
            String nodename = sn.getNodeName();
            if (nodename == null || sn.getNodeType() != 1) continue;
            switch (nodename) {
                case "id": {
                    result.setId(XmlImport.getIntNode((Node)sn));
                    continue block26;
                }
                case "fraction": {
                    result.setFraction(XmlImport.getDoubleNode((Node)sn));
                    continue block26;
                }
                case "format": {
                    result.setFormat(XmlImport.getCDataNode((Node)sn));
                    continue block26;
                }
                case "text": {
                    result.setText(XmlImport.getCDataNode((Node)sn));
                    continue block26;
                }
                case "feedback": {
                    result.setFeedback(XmlImport.getCDataNode((Node)sn));
                    continue block26;
                }
                case "tolerance": {
                    result.setTolerance(XmlImport.getCDataNode((Node)sn));
                    continue block26;
                }
                case "correctAnswerFormat": {
                    result.setCorrectAnswerFormat(XmlImport.getIntNode((Node)sn));
                    continue block26;
                }
                case "correctAnswerLength": {
                    result.setCorrectAnswerLength(XmlImport.getIntNode((Node)sn));
                    continue block26;
                }
                case "maxima": {
                    result.setMaxima(XmlImport.getCDataNode((Node)sn));
                    continue block26;
                }
                case "answer": {
                    result.setAnswer(XmlImport.getCDataNode((Node)sn));
                    continue block26;
                }
                case "einheit": {
                    result.setEinheit(XmlImport.getCDataNode((Node)sn));
                }
            }
        }
        return result;
    }

    public static ExportDatasetDefinitionV1 parseDatasetDefinition(Node n, ImportParams importParams) {
        ExportDatasetDefinitionV1 result = new ExportDatasetDefinitionV1();
        NodeList c = n.getChildNodes();
        block28: for (int i = 0; i < c.getLength(); ++i) {
            Node sn = c.item(i);
            String nodename = sn.getNodeName();
            if (nodename == null || sn.getNodeType() != 1) continue;
            switch (nodename) {
                case "id": {
                    result.setId((long)XmlImport.getIntNode((Node)sn));
                    continue block28;
                }
                case "name": {
                    result.setName(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "type": {
                    result.setType(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "distribution": {
                    result.setDistribution(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "minimum": {
                    result.setMinimum(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "maximum": {
                    result.setMaximum(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "decimals": {
                    result.setDecimals(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "itemcount": {
                    result.setItemcount(XmlImport.getIntNode((Node)sn));
                    continue block28;
                }
                case "zahlenbereich": {
                    result.setZahlenbereich(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "ziffern": {
                    result.setZiffern(XmlImport.getIntNode((Node)sn));
                    continue block28;
                }
                case "einheit": {
                    result.setEinheit(XmlImport.getCDataNode((Node)sn));
                    continue block28;
                }
                case "items": {
                    result.setItems(XmlImport.getCDataNode((Node)sn));
                }
            }
        }
        return result;
    }

    public static ExportLettoFileV1 parseLettoFile(Node n, ImportParams importParams) {
        ExportLettoFileV1 result = new ExportLettoFileV1();
        NamedNodeMap attr_list = n.getAttributes();
        block34: for (int i = 0; i < attr_list.getLength(); ++i) {
            if (attr_list.item(i).getNodeType() != 2) continue;
            String name = attr_list.item(i).getNodeName();
            String value = attr_list.item(i).getNodeValue().trim();
            switch (name) {
                case "filename": {
                    result.setFilename(value);
                    continue block34;
                }
                case "id": {
                    try {
                        result.setId(Long.parseLong(value));
                    }
                    catch (Exception exception) {}
                    continue block34;
                }
                case "width": {
                    try {
                        if (value.endsWith("px")) {
                            result.setTagWidth((int)Double.parseDouble(value.substring(0, value.length() - 2).trim()));
                            result.setBreite(Breite.Pixel.toString());
                            continue block34;
                        }
                        if (value.endsWith("%")) {
                            result.setTagWidth((int)Double.parseDouble(value.substring(0, value.length() - 1).trim()));
                            result.setBreite(Breite.Prozent.toString());
                            continue block34;
                        }
                        result.setTagWidth((int)Double.parseDouble(value));
                        if (result.getTagWidth() > 105) {
                            result.setBreite(Breite.Pixel.toString());
                            continue block34;
                        }
                        result.setBreite(Breite.Prozent.toString());
                    }
                    catch (Exception exception) {}
                    continue block34;
                }
                case "height": {
                    try {
                        if (value.endsWith("px")) {
                            result.setTagHeight((int)Double.parseDouble(value.substring(0, value.length() - 2).trim()));
                            continue block34;
                        }
                        if (value.endsWith("%")) {
                            result.setTagHeight((int)Double.parseDouble(value.substring(0, value.length() - 1).trim()));
                            continue block34;
                        }
                        result.setTagHeight((int)Double.parseDouble(value));
                    }
                    catch (Exception exception) {}
                    continue block34;
                }
                case "title": {
                    result.setTagTitle(value);
                    continue block34;
                }
                case "alt": {
                    result.setTagAlt(value);
                    continue block34;
                }
                case "style": {
                    result.setTagStyle(value);
                    continue block34;
                }
            }
        }
        BaseImageService imageService = null;
        try {
            imageService = importParams.getExportImportService().imageService.images();
        }
        catch (Exception name) {
            // empty catch block
        }
        if (imageService == null) {
            importParams.getExportImportService();
            ExportImportService.LOGGER.error("Imageservice kann nicht geladen werden! Kein Bildimport m\u00f6glich!");
            return null;
        }
        NodeList c = n.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            Node sn = c.item(i);
            String nodename = sn.getNodeName();
            if (nodename == null || sn.getNodeType() != 1) continue;
            FileTransferDto file = new FileTransferDto();
            switch (nodename) {
                case "webPath": {
                    String webPath = XmlImport.getCDataNode((Node)sn);
                    if (webPath.isEmpty()) break;
                    String[] x = webPath.split("/");
                    if (x.length < 2) {
                        return result;
                    }
                    String md5 = x[x.length - 1].replace("\\.[^\\.]+$", "");
                    String fname = x[x.length - 1];
                    result.setExtension(imageService.getExtension(fname));
                    if (imageService.existImage(fname)) {
                        file = FileTransferDto.generate((File)imageService.getLocalFile(fname));
                        break;
                    }
                    fname = imageService.saveURLImage(webPath);
                    if (fname == null || fname.length() <= 0) break;
                    file = FileTransferDto.generate((File)imageService.getLocalFile(fname));
                    break;
                }
                case "base64": {
                    String fname;
                    String b64 = XmlImport.getCDataNode((Node)sn);
                    String extension = imageService.getExtension(result.getFilename());
                    result.setExtension(extension);
                    if (b64 == null || b64.length() <= 0 || (fname = imageService.saveBase64Image(b64, extension)) == null || fname.length() <= 0) break;
                    file = FileTransferDto.generate((File)imageService.getLocalFile(fname));
                }
            }
            if (file.getFile() == null) continue;
            String filename = file.getFile().getName();
            file.setUrl(imageService.getAbsURL(filename));
            if (importParams.isBase64()) {
                file.setBase64Content(imageService.loadImageBase64(filename));
            }
            result.setFile(file);
            return result;
        }
        if (result.getFile() == null) {
            return null;
        }
        return result;
    }
}

