/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.service.threads;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.export.dto.FileTransferDto;
import at.letto.export.dto.ImportExportDto;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.export.dto.questions.ExportLettoFileV1;
import at.letto.export.dto.questions.ExportLettoTextV1;
import at.letto.export.dto.questions.ExportQuestionV1;
import at.letto.exportservice.dto.ExportParams;
import at.letto.exportservice.dto.ExportStatusAndResult;
import at.letto.exportservice.service.CmdService;
import at.letto.exportservice.service.ExportImportService;
import at.letto.tools.Datum;
import at.letto.tools.ImageMethods;
import at.letto.tools.JSON;
import at.letto.tools.WebGet;
import at.letto.tools.rest.DtoAndMsg;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.web.client.RestTemplate;

public class ExportServiceThread
extends CmdThread {
    static final Logger LOGGER = LoggerFactory.getLogger(ExportServiceThread.class);
    public final ImportExportDto exportDto;
    public final String transferID;
    public final HashMap<String, String> params;
    public final ExportImportService exportImportService;
    public final CmdService cmdService;
    public final ExportStatusAndResult result;
    private String errormsg = "";
    private boolean haserror = false;
    private boolean filesBase64 = false;
    private String target;
    private String version;
    private String backlink;
    private String[] imageloading;
    private String resultTarget;
    private String validString;
    private ExportParams exportParams = new ExportParams();
    private String files;
    private long valid = 3600L;
    private int filenumber = 1;
    private String exportDirectoryName = null;
    private File exportDirectory = null;
    private int ctCategory = 0;
    private int ctQuestion = 0;
    private String servername = "";

    public ExportServiceThread(ExportImportService exportImportService, ImportExportDto exportDto, String transferID, HashMap<String, String> params) {
        super(exportImportService.cmdService.getRootPath(), exportImportService.cmdService.getCmdCharset(), CmdThread.CmdMode.BASH, new String[0]);
        this.exportDto = exportDto;
        this.transferID = transferID;
        this.params = params;
        this.cmdService = exportImportService.cmdService;
        this.exportImportService = exportImportService;
        this.result = new ExportStatusAndResult(transferID, this);
        exportImportService.exportStatusAndResultHashMap.put(transferID, this.result);
        this.exportParams.setExportImportService(exportImportService);
        this.saveData();
    }

    public void error(String msg) {
        this.errormsg = msg;
        this.haserror = true;
        throw new RuntimeException(msg);
    }

    public void task() {
        LOGGER.info("Start Export THREAD " + this.transferID);
        try {
            this.exportDirectoryName = "/opt/letto/docker/storage/export/export/" + this.transferID;
            this.exportDirectory = new File(this.exportDirectoryName);
            this.exportDirectory.mkdirs();
            this.doExport();
        }
        catch (RuntimeException ex) {
            if (!this.haserror) {
                this.haserror = true;
                this.errormsg = "RuntimeException " + ex.getMessage();
            }
        }
        catch (Exception ex) {
            this.haserror = true;
            this.errormsg = ex.getClass().getName() + " " + ex.getMessage();
        }
        catch (Error er) {
            this.haserror = true;
            this.errormsg = er.getClass().getName() + " " + er.getMessage();
        }
        if (this.haserror) {
            this.htmlErr(this.errormsg);
            this.result.getExportResultDto().setResult("ERROR");
            this.result.getExportResultDto().setMsg(this.errormsg);
            LOGGER.error("Export(" + this.transferID + ") error : " + this.errormsg);
        }
        this.result.getExportResultDto().setValidToLong(Datum.nowDateInteger() + this.valid);
        this.result.finish();
        this.saveData();
        if (this.backlink.length() > 0 && this.result.isBacklinkActive()) {
            RestTemplate restTemplate = new RestTemplate();
            HttpEntity request = new HttpEntity((Object)this.transferID);
            String response = null;
            try {
                response = (String)restTemplate.postForObject(this.backlink, (Object)request, String.class, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.error("Backlink " + this.backlink + " not reachable!");
            }
        }
        this.result.setBacklinkActive(false);
    }

    private void saveData() {
        this.exportImportService.saveExportData(this.transferID, this.result, this);
    }

    private String getParam(String param) {
        String result = "";
        if (this.params.containsKey(param)) {
            result = (String)this.params.get(param);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    private void doExport() {
        this.target = this.getParam("target").trim().toLowerCase();
        this.version = this.getParam("version").trim();
        this.backlink = this.getParam("backlink").trim();
        this.servername = this.getParam("server").trim();
        String imageloadingString = this.getParam("imageloading").trim().toLowerCase();
        if (imageloadingString.length() == 0) {
            imageloadingString = "default";
        }
        imageloadingString.replaceAll("default", "path.url.base64.request");
        this.imageloading = imageloadingString.trim().split("\\.");
        this.resultTarget = this.getParam("result").trim();
        this.validString = this.getParam("valid").trim();
        this.exportParams.setKey(this.getParam("key").trim());
        this.files = this.getParam("files").trim();
        if (this.files.equalsIgnoreCase("embedded") || this.files.equalsIgnoreCase("base64")) {
            this.filesBase64 = true;
        }
        this.valid = ExportImportService.parseValidString((long)this.valid, (String)this.validString);
        this.result.getExportResultDto().setValidToLong(Datum.nowDateInteger() + this.valid);
        this.result.getExportResultDto().setMsg("loading");
        String dataServiceUrl = this.getParam("dataserviceurl").trim();
        if (dataServiceUrl.length() > 0) {
            int idSchule = 0;
            try {
                idSchule = Integer.parseInt(this.getParam("dataserviceIdSchule").trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String school = this.getParam("dataserviceSchool").trim();
            String user = this.getParam("dataserviceUser").trim();
            String password = this.getParam("dataservicePassword").trim();
            RestLettoDataService dataService = null;
            dataService = new RestLettoDataService(dataServiceUrl, user, password, idSchule, school);
            if (dataService == null) {
                this.error("Dataservice kann nicht verbunden werden!!");
            }
            this.loadDataFromDatabase(dataService, this.exportDto);
        }
        if (this.loadImages(this.exportDto)) {
            return;
        }
        switch (this.target) {
            case "testquick": {
                this.testquick();
                break;
            }
            case "testdelay": {
                this.testdelay();
                break;
            }
            case "lto": {
                this.lto();
                break;
            }
            case "moodlexml": {
                this.moodlexml();
                break;
            }
            case "tex": {
                this.tex();
                break;
            }
            case "pdf": {
                this.pdf();
                break;
            }
            case "json": {
                this.json();
                break;
            }
            default: {
                this.error("target " + this.target + " not defined!");
            }
        }
    }

    private void testquick() {
        this.result.getExportResultDto().setResult("OK");
        this.result.getExportResultDto().setMsg("Test-Quick OK");
        LOGGER.info("Test Quick " + this.transferID);
        this.htmlOut("Test Quick " + this.transferID);
    }

    private void testdelay() {
        long delaytime = 0L;
        try {
            delaytime = Long.parseLong(this.getParam("delaytime").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (delaytime == 0L) {
            delaytime = 60L;
        }
        LOGGER.info("Test Delay " + this.transferID + " with " + delaytime + "s");
        this.htmlOut("Test Delay " + this.transferID + " with " + delaytime + "s");
        long t = 0L;
        while (t < delaytime) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.result.getExportResultDto().setMsg(++t + "/" + delaytime + " seconds -> " + (int)((double)t / (double)delaytime * 100.0) + "%");
            if (!Thread.interrupted()) continue;
            this.error("Thread interrupted");
        }
        this.result.getExportResultDto().setResult("OK");
        this.result.getExportResultDto().setMsg("Test-Delay OK");
        LOGGER.info("Test Delay " + this.transferID + " finished!");
        this.htmlOut("Test Delay " + this.transferID + " finished!");
    }

    private String newFileName(String extension) {
        if (!((String)(extension = ((String)extension).trim())).startsWith(".")) {
            extension = "." + (String)extension;
        }
        return "file" + this.filenumber++ + (String)extension;
    }

    private boolean loadImages(ImportExportDto dto) {
        if (dto instanceof ExportCategoryV1) {
            return this.loadImages((ExportCategoryV1)dto);
        }
        if (dto instanceof ExportQuestionV1) {
            return this.loadImages((ExportQuestionV1)dto);
        }
        return false;
    }

    private boolean loadImages(ExportCategoryV1 category) {
        boolean request = false;
        for (ExportCategoryV1 cat : category.getCategories()) {
            request |= this.loadImages(cat);
        }
        for (ExportQuestionV1 que : category.getQuestions()) {
            request |= this.loadImages(que);
        }
        return request;
    }

    private boolean loadImages(ExportQuestionV1 category) {
        boolean request = false;
        for (ExportLettoTextV1 lettoText : category.getLettoTexte()) {
            request |= this.loadImages(lettoText);
        }
        return request;
    }

    private boolean loadImages(ExportLettoTextV1 lettoText) {
        boolean request = false;
        for (ExportLettoFileV1 lettoFile : lettoText.getFiles()) {
            request |= this.loadImages(lettoFile);
        }
        return request;
    }

    private boolean loadImages(ExportLettoFileV1 lettoFile) {
        return this.loadImages(lettoFile.getFile(), lettoFile.getExtension());
    }

    private boolean loadImages(FileTransferDto dto, String extension) {
        Object source = "";
        File inFile = null;
        File outFile = null;
        block22: for (String load : this.imageloading) {
            switch (load = load.toLowerCase().trim()) {
                case "path": {
                    String path = dto.getFilePath().trim();
                    if (path == null || path.length() <= 0) continue block22;
                    source = (String)source + (((String)source).length() > 0 ? "," : "") + path;
                    inFile = new File("/opt/letto/docker/storage/" + path);
                    if (!inFile.exists() || !inFile.isFile()) continue block22;
                    outFile = new File(this.exportDirectoryName + "/" + this.newFileName(extension));
                    try {
                        Files.copy(inFile.toPath(), outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        dto.setFile(outFile);
                        dto.setUrl("https://" + this.servername + dto.getFilePath());
                        return false;
                    }
                    catch (Exception ex) {
                        LOGGER.error("cannot read File from Location " + path);
                        continue block22;
                    }
                }
                case "url": {
                    String url = dto.getUrl().trim();
                    if (url == null || url.length() <= 0) continue block22;
                    source = (String)source + (((String)source).length() > 0 ? "," : "") + url;
                    outFile = new File(this.exportDirectoryName + "/" + this.newFileName(extension));
                    if (!WebGet.readFileFromURL((String)url, (File)outFile)) {
                        LOGGER.error("cannot read File from url " + url);
                        --this.filenumber;
                        continue block22;
                    }
                    dto.setFile(outFile);
                    return false;
                }
                case "base64": {
                    String base64 = dto.getBase64Content();
                    source = (String)source + (((String)source).length() > 0 ? "," : "") + "BASE64";
                    if (base64 == null || base64.length() <= 0) continue block22;
                    outFile = new File(this.exportDirectoryName + "/" + this.newFileName(extension));
                    if (!ImageMethods.saveBase64Image((String)base64, (File)outFile)) {
                        LOGGER.error("cannot save Base64-Image");
                        --this.filenumber;
                        continue block22;
                    }
                    dto.setFile(outFile);
                    return false;
                }
                case "text": {
                    String content = dto.getContent();
                    source = (String)source + (((String)source).length() > 0 ? "," : "") + "CONTENT";
                    if (content == null || content.length() <= 0) continue block22;
                    outFile = new File(this.exportDirectoryName + "/" + this.newFileName(extension));
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(content);
                    try {
                        Files.write(outFile.toPath(), data, new OpenOption[0]);
                        dto.setFile(outFile);
                        return false;
                    }
                    catch (Exception ex) {
                        LOGGER.error("cannot write File from content");
                        continue block22;
                    }
                }
                case "ignore": {
                    dto.setFile(null);
                    return false;
                }
                case "request": {
                    String path = dto.getFilePath().trim();
                    String url = dto.getUrl().trim();
                    dto.setFile(null);
                    if (path != null && path.length() > 0) {
                        this.result.getExportResultDto().getFiles().add(path);
                        return true;
                    }
                    if (url == null || url.length() <= 0) continue block22;
                    this.result.getExportResultDto().getFiles().add(url);
                    return true;
                }
                case "": {
                    continue block22;
                }
                default: {
                    LOGGER.error("Bild Lademodi " + load + " nicht definiert!");
                }
            }
        }
        LOGGER.error("Bild kann nicht geladen werden von " + (String)source + "!");
        dto.setFile(null);
        return false;
    }

    private void loadMsg() {
        this.result.getExportResultDto().setMsg("loading " + this.ctCategory + " categories, " + this.ctQuestion + " questions");
    }

    private void loadDataFromDatabase(RestLettoDataService dataService, ImportExportDto exportDto) {
        ++this.ctCategory;
        if (exportDto instanceof ExportCategoryV1) {
            ExportCategoryV1 cat = (ExportCategoryV1)exportDto;
            this.ctQuestion += cat.getQuestions().size();
            this.loadMsg();
            DtoAndMsg dto = dataService.export.loadCategoryQuestions(Integer.valueOf(cat.getId()));
            if (dto.checkOk()) {
                ExportCategoryV1 lc = (ExportCategoryV1)dto.getData();
                for (ExportQuestionV1 q : lc.getQuestions()) {
                    boolean found = false;
                    for (ExportQuestionV1 qx : cat.getQuestions()) {
                        if (qx.getId() != q.getId()) continue;
                        found = true;
                    }
                    if (found) continue;
                    cat.getQuestions().add(q);
                    ++this.ctQuestion;
                    this.loadMsg();
                }
            }
            for (ExportCategoryV1 c : cat.getCategories()) {
                this.loadDataFromDatabase(dataService, (ImportExportDto)c);
            }
        }
    }

    private void lto() {
        this.result.getExportResultDto().setResult("OK");
    }

    private void moodlexml() {
        this.result.getExportResultDto().setResult("OK");
    }

    private void tex() {
        this.result.getExportResultDto().setResult("OK");
    }

    private void pdf() {
        this.result.getExportResultDto().setResult("OK");
    }

    private void json() {
        File output = new File("/opt/letto/docker/storage/export/export/" + this.transferID + "/data.json");
        try {
            JSON.objToJson((Object)this.exportDto, (File)output);
        }
        catch (Exception ex) {
            this.error("JSON-Zieldatei kann nicht geschrieben werden!");
        }
        this.result.getExportResultDto().setGeneratedFile(FileTransferDto.generate((File)output));
        this.result.getExportResultDto().setMsg("Data exported in " + output.getAbsolutePath());
        this.result.getExportResultDto().setResult("OK");
    }
}

