/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.export.dto.ExportResultDto;
import at.letto.export.dto.ImportDto;
import at.letto.export.dto.ImportExportDto;
import at.letto.export.dto.ImportResultDto;
import at.letto.export.dto.api.InfoResultDto;
import at.letto.export.restclient.ExportService;
import at.letto.export.restclient.RestExportService;
import at.letto.exportservice.dto.ExportStatusAndResult;
import at.letto.exportservice.dto.ImportStatusAndResult;
import at.letto.exportservice.service.CmdService;
import at.letto.exportservice.service.LocalImageService;
import at.letto.exportservice.service.threads.ExportServiceThread;
import at.letto.exportservice.service.threads.ImportServiceThread;
import at.letto.tools.Cmd;
import at.letto.tools.Datum;
import at.letto.tools.JSON;
import at.letto.tools.ServerStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportImportService
implements ExportService {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExportImportService.class);
    public static final String EXPORT_FILE_PATH = "/opt/letto/docker/storage/export/export";
    public static final String IMPORT_FILE_PATH = "/opt/letto/docker/storage/export/import";
    public static final String STORAGE_PATH = "/opt/letto/docker/storage";
    @Autowired
    public CmdService cmdService;
    @Autowired
    public LocalImageService imageService;
    public static final long WAIT_TIME_MS = 1000L;
    public ConcurrentHashMap<String, ExportStatusAndResult> exportStatusAndResultHashMap = new ConcurrentHashMap();
    public ConcurrentHashMap<String, ImportStatusAndResult> importStatusAndResultHashMap = new ConcurrentHashMap();

    private ExportResultDto startExportThread(ImportExportDto exportDto, String transferID, HashMap<String, String> params) {
        ExportServiceThread thread = new ExportServiceThread(this, exportDto, transferID, params);
        thread.start();
        this.cmdService.addThread((CmdThread)thread, 1000L);
        ExportStatusAndResult result = (ExportStatusAndResult)this.exportStatusAndResultHashMap.get(transferID);
        if (result.getFinishTimeMillis() == 0L) {
            result.setBacklinkActive(true);
        }
        return result.getExportResultDto();
    }

    private ImportResultDto startImportThread(ImportDto importDto, String transferID, HashMap<String, String> params, List<String> importClasses) {
        ImportServiceThread thread = new ImportServiceThread(this, importDto, transferID, params, importClasses);
        thread.start();
        this.cmdService.addThread((CmdThread)thread, 1000L);
        ImportStatusAndResult result = (ImportStatusAndResult)this.importStatusAndResultHashMap.get(transferID);
        if (result.getFinishTimeMillis() == 0L) {
            result.setBacklinkActive(true);
        }
        return result.getImportResultDto();
    }

    public ExportResultDto exportData(ImportExportDto exportDto, String transferID, HashMap<String, String> params) {
        String cmd = params.get("cmd").toLowerCase();
        if (cmd == null || cmd.length() == 0) {
            cmd = "default";
        }
        LOGGER.info("Export(" + cmd + ", transferID=" + transferID + ")");
        switch (cmd) {
            case "new": {
                if (this.exportStatusAndResultHashMap.containsKey(transferID)) {
                    this.deleteExportData(transferID);
                }
                return this.startExportThread(exportDto, transferID, params);
            }
            case "get": {
                if (this.exportStatusAndResultHashMap.containsKey(transferID)) {
                    ExportStatusAndResult result = (ExportStatusAndResult)this.exportStatusAndResultHashMap.get(transferID);
                    return result.getExportResultDto();
                }
                ExportResultDto result = new ExportResultDto();
                result.setResult("NOTFOUND");
                return result;
            }
            case "delete": {
                if (this.exportStatusAndResultHashMap.containsKey(transferID)) {
                    this.deleteExportData(transferID);
                    return new ExportResultDto("DELETED");
                }
                ExportResultDto result = new ExportResultDto();
                result.setResult("NOTFOUND");
                return result;
            }
            case "default": {
                if (this.exportStatusAndResultHashMap.containsKey(transferID)) {
                    ExportStatusAndResult result = (ExportStatusAndResult)this.exportStatusAndResultHashMap.get(transferID);
                    return result.getExportResultDto();
                }
                return this.startExportThread(exportDto, transferID, params);
            }
        }
        return new ExportResultDto("ERROR", "Command cmd=" + cmd + " not found!");
    }

    public ImportResultDto importData(ImportDto importDto, String transferID, HashMap<String, String> params, List<String> importClasses) {
        String cmd = params.get("cmd").toLowerCase();
        if (cmd == null || cmd.length() == 0) {
            cmd = "default";
        }
        LOGGER.info("Export(" + cmd + ", transferID=" + transferID + ")");
        switch (cmd) {
            case "new": {
                if (this.importStatusAndResultHashMap.containsKey(transferID)) {
                    this.deleteImportData(transferID);
                }
                return this.startImportThread(importDto, transferID, params, importClasses);
            }
            case "get": {
                if (this.importStatusAndResultHashMap.containsKey(transferID)) {
                    ImportStatusAndResult result = (ImportStatusAndResult)this.importStatusAndResultHashMap.get(transferID);
                    return result.getImportResultDto();
                }
                ImportResultDto result = new ImportResultDto();
                result.setResult("NOTFOUND");
                return result;
            }
            case "delete": {
                if (this.importStatusAndResultHashMap.containsKey(transferID)) {
                    this.deleteImportData(transferID);
                    return new ImportResultDto("DELETED");
                }
                ImportResultDto result = new ImportResultDto();
                result.setResult("NOTFOUND");
                return result;
            }
            case "default": {
                if (this.importStatusAndResultHashMap.containsKey(transferID)) {
                    ImportStatusAndResult result = (ImportStatusAndResult)this.importStatusAndResultHashMap.get(transferID);
                    return result.getImportResultDto();
                }
                return this.startImportThread(importDto, transferID, params, importClasses);
            }
        }
        return new ImportResultDto("ERROR", "Command cmd=" + cmd + " not found!");
    }

    public InfoResultDto infoData() {
        HashMap info = new HashMap();
        ArrayList<String> exportClasses = new ArrayList<String>();
        ArrayList<String> importClasses = new ArrayList<String>();
        for (Class c : RestExportService.classes) {
            exportClasses.add(c.getName());
            importClasses.add(c.getName());
        }
        InfoResultDto infoResultDto = new InfoResultDto(ServerStatus.getRevision(), "1.0", exportClasses, importClasses, info);
        return infoResultDto;
    }

    public void deleteExportData(String transferID) {
        ExportStatusAndResult exportStatusAndResult = (ExportStatusAndResult)this.exportStatusAndResultHashMap.get(transferID);
        if (exportStatusAndResult != null) {
            ExportServiceThread t = exportStatusAndResult.getThread();
            if (t != null) {
                this.cmdService.removeThread((CmdThread)t);
            }
            try {
                this.cmdService.delete("/opt/letto/docker/storage/export/export/" + transferID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.exportStatusAndResultHashMap.remove(transferID);
        }
    }

    public void deleteImportData(String transferID) {
        ImportStatusAndResult importStatusAndResult = (ImportStatusAndResult)this.importStatusAndResultHashMap.get(transferID);
        if (importStatusAndResult != null) {
            ImportServiceThread t = importStatusAndResult.getThread();
            if (t != null) {
                this.cmdService.removeThread((CmdThread)t);
            }
            try {
                this.cmdService.delete("/opt/letto/docker/storage/export/import/" + transferID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.importStatusAndResultHashMap.remove(transferID);
        }
    }

    public void saveExportData(String transferID, ExportStatusAndResult result, ExportServiceThread t) {
        File dir = new File("/opt/letto/docker/storage/export/export/" + transferID);
        dir.mkdirs();
        Cmd.writefile((String)JSON.objToJson((Object)result), (String)("/opt/letto/docker/storage/export/export/" + transferID + "/status.json"));
        File threadInfoFile = new File("/opt/letto/docker/storage/export/export/" + transferID + "/threadinfo.html");
        Vector<String> data = new Vector<String>();
        data.add("<html><body>");
        data.add(t.getHtmlOutput());
        data.add("</body></html>");
        try {
            Files.write(threadInfoFile.toPath(), data, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveImportData(String transferID, ImportStatusAndResult result, ImportServiceThread t) {
        File dir = new File("/opt/letto/docker/storage/export/import/" + transferID);
        dir.mkdirs();
        Cmd.writefile((String)JSON.objToJson((Object)result), (String)("/opt/letto/docker/storage/export/import/" + transferID + "/status.json"));
        File threadInfoFile = new File("/opt/letto/docker/storage/export/import/" + transferID + "/threadinfo.html");
        Vector<String> data = new Vector<String>();
        data.add("<html><body>");
        data.add(t.getHtmlOutput());
        data.add("</body></html>");
        try {
            Files.write(threadInfoFile.toPath(), data, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long parseValidString(long oldvalid, String s) {
        long t = 0L;
        s = s.trim();
        try {
            Matcher m = Pattern.compile("^[0-9]+$").matcher(s);
            if (m.find()) {
                t = Long.parseLong(s);
            } else {
                String[] sa;
                for (String x : sa = s.replaceAll("(?<=[a-zA-Z])(?=[0-9])", ",").replaceAll("[^a-zA-Z0-9]+", ",").split(",")) {
                    x = x.trim().toLowerCase();
                    m = Pattern.compile("^[0-9]+$").matcher(x);
                    if (m.find()) {
                        t += Long.parseLong(x);
                        continue;
                    }
                    m = Pattern.compile("^([0-9]+)(m|min|minutes?)$").matcher(x);
                    if (m.find()) {
                        t += Long.parseLong(m.group(1)) * 60L;
                        continue;
                    }
                    m = Pattern.compile("^([0-9]+)(h|hours?)$").matcher(x);
                    if (m.find()) {
                        t += Long.parseLong(m.group(1)) * 3600L;
                        continue;
                    }
                    m = Pattern.compile("^([0-9]+)(d|days?)$").matcher(x);
                    if (m.find()) {
                        t += Long.parseLong(m.group(1)) * 3600L * 24L;
                        continue;
                    }
                    m = Pattern.compile("^([0-9]+)(s|sec|seconds?)$").matcher(x);
                    if (m.find()) {
                        t += Long.parseLong(m.group(1));
                        continue;
                    }
                    m = Pattern.compile("^([0-9]+)(y|years?)$").matcher(x);
                    if (!m.find()) continue;
                    t += Long.parseLong(m.group(1)) * 3600L * 24L * 365L;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t > 0L ? t : oldvalid;
    }

    public void deleteOutdatedData() {
        long valid;
        long time = Datum.nowDateInteger();
        Set keys = this.exportStatusAndResultHashMap.keySet();
        for (String transferID : keys) {
            ExportStatusAndResult exportStatusAndResult;
            if (!this.exportStatusAndResultHashMap.containsKey(transferID) || (exportStatusAndResult = (ExportStatusAndResult)this.exportStatusAndResultHashMap.get(transferID)) == null || time <= (valid = exportStatusAndResult.getExportResultDto().getValidToLong())) continue;
            this.deleteExportData(transferID);
        }
        keys = this.importStatusAndResultHashMap.keySet();
        for (String transferID : keys) {
            ImportStatusAndResult importStatusAndResult;
            if (!this.importStatusAndResultHashMap.containsKey(transferID) || (importStatusAndResult = (ImportStatusAndResult)this.importStatusAndResultHashMap.get(transferID)) == null || time <= (valid = importStatusAndResult.getImportResultDto().getValidToLong())) continue;
            this.deleteImportData(transferID);
        }
    }

    public void loadExportImportData() {
        File fileStatus;
        String name;
        File[] allContents;
        File f = new File(EXPORT_FILE_PATH);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.exists()) {
            LOGGER.error("cannot create Export-Directory /opt/letto/docker/storage/export/export");
        }
        if ((allContents = f.listFiles()) != null) {
            for (File file : allContents) {
                name = file.getName();
                if (name.equals(".") || name.equals("..") || !f.isDirectory()) continue;
                fileStatus = new File("/opt/letto/docker/storage/export/export/" + name + "/status.json");
                if (fileStatus.exists() && fileStatus.isFile()) {
                    ExportStatusAndResult exportStatusAndResult = (ExportStatusAndResult)JSON.jsonToObj((File)fileStatus, ExportStatusAndResult.class);
                    this.exportStatusAndResultHashMap.put(name, exportStatusAndResult);
                    continue;
                }
                this.cmdService.delete("/opt/letto/docker/storage/export/export/" + name);
            }
        }
        if (!(f = new File(IMPORT_FILE_PATH)).exists()) {
            f.mkdirs();
        }
        if (!f.exists()) {
            LOGGER.error("cannot create Import-Directory /opt/letto/docker/storage/export/import");
        }
        if ((allContents = f.listFiles()) != null) {
            for (File file : allContents) {
                name = file.getName();
                if (name.equals(".") || name.equals("..") || !f.isDirectory()) continue;
                fileStatus = new File("/opt/letto/docker/storage/export/import/" + name + "/status.json");
                if (fileStatus.exists() && fileStatus.isFile()) {
                    ImportStatusAndResult importStatusAndResult = (ImportStatusAndResult)JSON.jsonToObj((File)fileStatus, ImportStatusAndResult.class);
                    this.importStatusAndResultHashMap.put(name, importStatusAndResult);
                    continue;
                }
                this.cmdService.delete("/opt/letto/docker/storage/export/import/" + name);
            }
        }
    }

    public void deleteStoppedThreads() {
        ExportServiceThread t;
        Set keys = this.exportStatusAndResultHashMap.keySet();
        for (String transferID : keys) {
            ExportStatusAndResult exportStatusAndResult;
            if (!this.exportStatusAndResultHashMap.containsKey(transferID) || (exportStatusAndResult = (ExportStatusAndResult)this.exportStatusAndResultHashMap.get(transferID)) == null || (t = exportStatusAndResult.getThread()) == null || !t.isFinished()) continue;
            exportStatusAndResult.setThread(null);
            this.cmdService.removeThread((CmdThread)t);
        }
        keys = this.importStatusAndResultHashMap.keySet();
        for (String transferID : keys) {
            ImportStatusAndResult importStatusAndResult;
            if (!this.importStatusAndResultHashMap.containsKey(transferID) || (importStatusAndResult = (ImportStatusAndResult)this.importStatusAndResultHashMap.get(transferID)) == null || (t = importStatusAndResult.getThread()) == null || !t.isFinished()) continue;
            importStatusAndResult.setThread(null);
            this.cmdService.removeThread((CmdThread)t);
        }
    }
}

