/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.dto.question;

import at.letto.export.dto.questions.ExportLettoFileV1;
import at.letto.globalinterfaces.LettoFile;
import at.letto.tools.ImageMethods;
import java.io.File;

public class ExportLettoFile
extends ExportLettoFileV1
implements LettoFile {
    public ExportLettoFile(ExportLettoFileV1 fileV1) {
        super(fileV1.getId(), fileV1.getFile(), fileV1.getExtension(), fileV1.getTagWidth(), fileV1.getBreite(), fileV1.getTagHeight(), fileV1.getTagAlt(), fileV1.getTagTitle(), fileV1.getTagStyle(), fileV1.getFilename());
    }

    public String getImgSizeTex() {
        if (this.tagWidth == 0) {
            return "[width=100mm]";
        }
        double sz = (double)this.tagWidth / 100.0;
        Object w = sz > 0.99 ? "\\textwidth" : (sz < 0.01 ? "0.01\\textwidth" : sz + "\\textwidth");
        return "[width=" + (String)w + "]";
    }

    public String getTmpFile() {
        return "";
    }

    public String getImgTag() {
        Object ret = " ";
        if (this.tagWidth > 0) {
            ret = (String)ret + "width=\"" + this.tagWidth + "%\" ";
        }
        if (this.tagAlt.length() > 0) {
            ret = (String)ret + "alt=\"" + this.tagAlt + "\" ";
        }
        if (this.tagTitle.length() > 0) {
            ret = (String)ret + "title=\"" + this.tagTitle + "\" ";
        }
        if (this.tagStyle.length() > 0) {
            ret = (String)ret + "style=\"" + this.tagStyle + "\" ";
        }
        return ret;
    }

    public String getWebPath() {
        return this.file.getUrl();
    }

    public String getInhalt() {
        String base64 = this.file.getBase64Content();
        if (base64 == null || base64.length() == 0) {
            base64 = ImageMethods.loadFileAsBase64((File)this.file.getFile());
        }
        if (base64 == null) {
            base64 = "";
        }
        return base64;
    }

    public String getLinkWeb(int nr, String attribs) {
        String webPath = this.getWebPath();
        if (this.getExtension().contains("mp4") && !webPath.isEmpty()) {
            return " <video width='320' height='240' controls>  <source src='" + webPath + "' type='video/mp4'></video> ";
        }
        if (this.getExtension().contains("ogg") && !webPath.isEmpty()) {
            return " <video width='320' height='240' controls>  <source src='" + webPath + "' type='video/ogg'></video> ";
        }
        if (this.getExtension().contains("mp3") && !webPath.isEmpty()) {
            return " <audio controls src='" + webPath + "' type='audio/mp3' />";
        }
        if (this.getExtension().contains("m4a") && !webPath.isEmpty()) {
            return " <audio controls src='" + webPath + "' type='audio/mp4' />";
        }
        return webPath.isEmpty() ? "<a href=\"#\" onclick=\"openDocument(" + nr + ");\">" + attribs + "</a>" : "<a href=\"" + webPath + "\" target=\"_blank\" download=\"" + attribs + "\">" + attribs + "</a>";
    }

    public String getImageWeb(boolean dblClick) {
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportLettoFile)) {
            return false;
        }
        ExportLettoFile other = (ExportLettoFile)o;
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportLettoFile;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ExportLettoFile()";
    }

    public ExportLettoFile() {
    }
}

