/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.config;

import at.letto.exportservice.config.MicroServiceConfiguration;
import at.letto.exportservice.service.CmdService;
import at.letto.exportservice.service.ExportImportService;
import at.letto.exportservice.service.LocalImageService;
import at.letto.tools.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StartupConfiguration {
    private MicroServiceConfiguration microServiceConfiguration;
    private CmdService cmdService;
    private ExportImportService exportImportService;
    private LocalImageService imageService;
    public static String ROOT_PATH = ServerStatus.getRootPath(StartupConfiguration.class).replaceAll("\\\\", "/");
    protected static String cmdCharset = ServerStatus.getEncoding();
    static final Logger LOGGER = LoggerFactory.getLogger(StartupConfiguration.class);

    public StartupConfiguration(MicroServiceConfiguration microServiceConfiguration, CmdService cmdService, ExportImportService exportImportService, LocalImageService imageService) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.cmdService = cmdService;
        this.exportImportService = exportImportService;
        exportImportService.loadExportImportData();
        exportImportService.deleteOutdatedData();
        cmdService.init(false, ROOT_PATH, cmdCharset);
        imageService.init(microServiceConfiguration.getServername());
        LOGGER.info("Startup finished");
    }
}

