/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service.testservice;

import at.letto.data.dto.tests.FragenGruppierung;
import at.letto.data.dto.tests.TestBereichDto;
import at.letto.data.dto.tests.TestFrageDto;
import at.letto.data.dto.tests.TestGruppeDto;
import at.letto.data.dto.tests.TestInhaltDto;
import at.letto.lettoedit.service.testservice.TestsService;
import at.letto.security.LettoToken;
import at.letto.tools.Listen;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupingService {
    @Autowired
    private TestsService testsService;

    public TestInhaltDto groupingTestFragen(int idTest, List<Integer> idsTestfragen, int anzahl, LettoToken token) {
        if (idsTestfragen == null || idsTestfragen.size() == 0) {
            throw new MsgException("tf.err.noFragenSelected");
        }
        TestInhaltDto test = this.testsService.loadTestInhalt(idTest, token);
        for (TestGruppeDto g : test.getTestGruppen()) {
            for (TestBereichDto b : g.getBereiche()) {
                for (FragenGruppierung gr : b.getGruppierungen()) {
                    for (TestFrageDto tf : gr.getTestFragen()) {
                        int i;
                        if (tf.getId() != idsTestfragen.get(0).intValue()) continue;
                        int nr = b.getGruppierungen().size();
                        int idGroup = (Integer)DtoAndMsg.get((DtoAndMsg)this.testsService.data((LettoToken)token).tests.groupingTestFragen(idsTestfragen, anzahl, nr));
                        FragenGruppierung groupNew = new FragenGruppierung();
                        groupNew.setIdGruppierung(idGroup);
                        groupNew.setIdGruppe(b.getId());
                        groupNew.setAnz(anzahl);
                        groupNew.setPoints(tf.getPoints());
                        groupNew.setTestFragen(new Vector());
                        b.getGruppierungen().add(groupNew);
                        List testfragen = b.getGruppierungen().stream().map(grx -> grx.getTestFragen()).flatMap(Collection::stream).sorted(Comparator.comparing(TestFrageDto::getPosInGruppe)).collect(Collectors.toList());
                        int pos = Listen.indexOf(testfragen, (int)idsTestfragen.get(0));
                        for (i = 0; i < idsTestfragen.size(); ++i) {
                            int p = Listen.indexOf(testfragen, (int)idsTestfragen.get(i));
                            TestFrageDto x = (TestFrageDto)testfragen.remove(p);
                            groupNew.getTestFragen().add(x);
                            gr.getTestFragen().remove(x);
                            x.setAnzahlInGruppe(anzahl);
                            x.setGruppierung(idGroup);
                            testfragen.add(pos++, x);
                        }
                        DtoAndMsg.get((DtoAndMsg)this.testsService.data((LettoToken)token).tests.saveFragenOrder(testfragen));
                        for (i = 0; i < testfragen.size(); ++i) {
                            ((TestFrageDto)testfragen.get(i)).setPosInGruppe(Integer.valueOf(i));
                        }
                        return this.testsService.loadTestInhalt(idTest, token);
                    }
                }
            }
        }
        throw new MsgException("tf.err.noTestFragenFound");
    }

    public String changeGroupingAnzahl(int idTest, int idGruppierung, int anzahl, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.testsService.data((LettoToken)token).tests.updateGruppierungPoints(idGruppierung, anzahl));
        TestInhaltDto test = this.testsService.loadTestInhalt(idTest, token);
        test.getTestGruppen().stream().map(g -> g.getBereiche()).flatMap(Collection::stream).map(b -> b.getGruppierungen()).flatMap(Collection::stream).filter(gr -> gr.getIdGruppierung() == idGruppierung).findFirst().ifPresent(gr -> {
            gr.setAnz(anzahl);
            gr.getTestFragen().forEach(tf -> tf.setAnzahlInGruppe(anzahl));
        });
        return "";
    }

    public TestInhaltDto removeGruppierung(int idTest, int idGruppierung, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.testsService.data((LettoToken)token).tests.removeGruppierung(idGruppierung));
        TestInhaltDto test = this.testsService.loadTestInhalt(idTest, token);
        FragenGruppierung ziel = test.getTestGruppen().stream().map(g -> g.getBereiche()).flatMap(Collection::stream).map(b -> b.getGruppierungen()).flatMap(Collection::stream).filter(gr -> gr.getIdGruppierung() == 0).findFirst().get();
        if (ziel == null) {
            this.testsService.clearTestCache(idTest, token);
            return this.testsService.loadTestInhalt(idTest, token);
        }
        TestBereichDto b2 = test.getTestGruppen().stream().map(g -> g.getBereiche()).flatMap(Collection::stream).filter(be -> be.getGruppierungen().stream().anyMatch(gr -> gr.getIdGruppierung() == idGruppierung)).findFirst().get();
        if (b2 == null) {
            this.testsService.clearTestCache(idTest, token);
            return this.testsService.loadTestInhalt(idTest, token);
        }
        Iterator iter = b2.getGruppierungen().iterator();
        Object quelle = null;
        while (iter.hasNext()) {
            FragenGruppierung gr2 = (FragenGruppierung)iter.next();
            if (gr2.getIdGruppierung() != idGruppierung) continue;
            ziel = gr2;
            iter.remove();
        }
        if (quelle == null) {
            this.testsService.clearTestCache(idTest, token);
            return this.testsService.loadTestInhalt(idTest, token);
        }
        quelle.getTestFragen().forEach(tf -> tf.setGruppierung(0));
        ziel.getTestFragen().addAll(quelle.getTestFragen());
        quelle.getTestFragen().clear();
        return test;
    }

    public TestsService getTestsService() {
        return this.testsService;
    }

    public void setTestsService(TestsService testsService) {
        this.testsService = testsService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupingService)) {
            return false;
        }
        GroupingService other = (GroupingService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TestsService this$testsService = this.getTestsService();
        TestsService other$testsService = other.getTestsService();
        return !(this$testsService == null ? other$testsService != null : !this$testsService.equals(other$testsService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupingService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TestsService $testsService = this.getTestsService();
        result = result * 59 + ($testsService == null ? 43 : $testsService.hashCode());
        return result;
    }

    public String toString() {
        return "GroupingService(testsService=" + this.getTestsService() + ")";
    }
}

