/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service.beurteilung;

import at.letto.data.dto.ObjAndMsg;
import at.letto.data.dto.PairIntString;
import at.letto.data.dto.beurteilung.AlleBeurteilungenDTO;
import at.letto.data.dto.beurteilung.BeurteilungDTO;
import at.letto.data.dto.beurteilung.ErgebnisseNachLehrer;
import at.letto.data.dto.beurteilung.KlassenBeurteilungDTO;
import at.letto.data.dto.beurteilung.KlassenInfoDTO;
import at.letto.data.dto.beurteilung.KompetenzBeurteilungsDTO;
import at.letto.data.dto.beurteilung.LehrerInfoDTO;
import at.letto.data.dto.beurteilung.NoteDTO;
import at.letto.data.dto.beurteilung.StudentDto;
import at.letto.data.dto.beurteilung.SubBeurteilung;
import at.letto.data.dto.beurteilung.TestDTO;
import at.letto.data.dto.beurteilung.TestDtoDateComparator;
import at.letto.data.dto.beurteilung.TestPunkteDTO;
import at.letto.data.dto.beuteilungsschema.BeurteilungsartDTO;
import at.letto.data.dto.beuteilungsschema.BeurteilungsconfigDTO;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.data.restclient.data.FindBeurteilungsart;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.beurteilung.BeurtConfigCache;
import at.letto.lettoedit.service.beurteilung.BeurteilungService;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.security.LettoToken;
import at.letto.tools.Cmd;
import at.letto.tools.enums.Semestrierung;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import at.letto.tools.rest.MsgType;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BeurteilungService {
    private ConfigService configService;
    private MicroServiceConfiguration microServiceConfiguration;
    public BeurtConfigCache<BeurteilungsconfigDTO> beurtConfigCache;
    private Map<String, BeurteilungsconfigDTO> defaultSchemas = new ConcurrentHashMap();
    private static Pattern inpNote = Pattern.compile("^\\+?[1-5]((\\s*\\-\\s*[1-5])|(\\s*\\-))?$");
    private static Pattern inpProzent = Pattern.compile("^((\\d+)(\\.\\d+)?)%?$");
    private static DecimalFormat dec = new DecimalFormat("#.##");

    public BeurteilungService(ConfigService configService, MicroServiceConfiguration microServiceConfiguration) {
        this.configService = configService;
        this.microServiceConfiguration = microServiceConfiguration;
        this.beurtConfigCache = new BeurtConfigCache(500, microServiceConfiguration);
    }

    public BeurteilungsconfigDTO getDefaultSchema(LettoToken token) {
        if (!this.defaultSchemas.containsKey(token.getSchool())) {
            this.defaultSchemas.put(token.getSchool(), (BeurteilungsconfigDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurtConfig.loadDefaultSchema()));
        }
        return (BeurteilungsconfigDTO)this.defaultSchemas.get(token.getSchool());
    }

    public RestLettoDataService data(LettoToken token) {
        return this.microServiceConfiguration.getDataService(token);
    }

    public BeurteilungDTO save(BeurteilungDTO beurteilungDTO, int idSchema, LettoToken token) {
        BeurteilungsconfigDTO schema = (BeurteilungsconfigDTO)this.beurtConfigCache.loadData(idSchema, token);
        BeurteilungsartDTO baDTO = schema.getBeurteilungsart(beurteilungDTO);
        if (baDTO == null) {
            throw new MsgException("Angeforderte Beurteilungsart konnte nicht gefunden werden!");
        }
        beurteilungDTO.setIdBeurteilungsart(baDTO.getId());
        if (schema != null) {
            beurteilungDTO.mark(schema);
        }
        return (BeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.saveBeurteilung(beurteilungDTO));
    }

    public KlassenBeurteilungDTO save(KlassenBeurteilungDTO kbDTO, int idSchema, LettoToken token) {
        BeurteilungsconfigDTO schema = (BeurteilungsconfigDTO)this.beurtConfigCache.loadData(idSchema, token);
        BeurteilungsartDTO baDTO = schema.getBeurteilungsart(kbDTO);
        if (baDTO == null) {
            throw new MsgException("Angeforderte Beurteilungsart konnte nicht gefunden werden!");
        }
        kbDTO.setIdBeurteilungsart(baDTO.getId());
        return (KlassenBeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.saveKlassenBeurteilung(kbDTO));
    }

    public void setMissingBewertung(BeurteilungDTO b, BeurteilungsconfigDTO beurtConf, LettoToken token) {
        BeurteilungsartDTO ba;
        if (b.getSubBeurteilungen().size() > 0 && (ba = FindBeurteilungsart.get((BeurteilungsconfigDTO)beurtConf, (BeurteilungDTO)b)).getSubBeurteilungen() != null && !ba.getSubBeurteilungen().isEmpty()) {
            String[] subBew = ba.getSubBeurteilungen().split(",");
            int i = 0;
            for (String bew : subBew) {
                if ((bew.trim().startsWith("!") || bew.trim().endsWith("!")) && b.getSubBeurteilungen().size() > i) {
                    if (((BeurteilungDTO)b.getSubBeurteilungen().get(i)).getNote() == null) {
                        b.setFehlendeUnterbeurteilung(true);
                        break;
                    }
                    if (((BeurteilungDTO)b.getSubBeurteilungen().get(i)).getNote().startsWith("*")) {
                        b.setForced(true);
                        break;
                    }
                    if (((BeurteilungDTO)b.getSubBeurteilungen().get(i)).getProzent() < 50.0) {
                        b.setFehlendeUnterbeurteilung(true);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public BeurteilungDTO recalc(BeurteilungDTO b, BeurteilungsconfigDTO conf) {
        double sum = 0.0;
        double anz = 0.0;
        for (BeurteilungDTO sub : b.getSubBeurteilungen()) {
            String note = sub.getNote();
            if (note == null || note.startsWith("*") || note.isEmpty()) continue;
            anz += sub.getGewicht();
            sum += sub.getProzent() * sub.getGewicht();
        }
        if (anz > 0.0) {
            b.setProzent(Double.valueOf(sum / anz));
            BeurteilungsartDTO ba = FindBeurteilungsart.get((BeurteilungsconfigDTO)conf, (BeurteilungDTO)b);
            b.setNote(ba.getSymbol(b.getProzent()));
            b.setInput(String.format("%2.1f", b.getProzent()) + "%");
        } else if (b.getSubBeurteilungen().size() > 0) {
            b.setNote("");
            b.setProzent(Double.valueOf(-1.0));
        }
        return b;
    }

    public String validate(String inp, BeurteilungsartDTO ba) {
        ObjAndMsg ret = new ObjAndMsg(null, "", MsgType.ERROR);
        inp = inp.replaceAll(",", ".");
        BeurteilungsconfigDTO beurtConf = ba.getBeurteilungsConfig();
        Matcher m = inpNote.matcher(inp);
        if (m.matches()) {
            Double p = ba.getProz(inp);
            return p == null ? "Diese Noteneingabe konnte nicht korrekt aufgel\u00f6st werden!" : "";
        }
        m = inpProzent.matcher(inp);
        if (m.matches()) {
            Double proz = Double.parseDouble(m.group(1));
            String symb = ba.getSymbol(proz);
            return symb.equals("") ? "F\u00fcr diese Prozenteingabe konnte keine Note gefunden werden!" : "";
        }
        if (inp == null || inp.isEmpty()) {
            return "";
        }
        if (inp.startsWith("*")) {
            return "";
        }
        return "Falsche Noten- oder Prozenteingabe";
    }

    public ObjAndMsg<BeurteilungDTO> changeBeurt(BeurteilungDTO b, String inp, BeurteilungsartDTO ba) {
        ObjAndMsg ret = new ObjAndMsg((Object)b, "", MsgType.ERROR);
        inp = inp.replaceAll(",", ".");
        if (ba == null) {
            System.out.println("Error NullPointer");
        }
        BeurteilungsconfigDTO beurtConf = ba.getBeurteilungsConfig();
        Double p = ba.getProz(inp);
        if (p != null) {
            b.setNote(inp);
            b.setProzent(p);
            if (b.getParent() != null) {
                this.recalc(b.getParent(), beurtConf);
                return new ObjAndMsg((Object)b.getParent(), "", MsgType.OK);
            }
            return new ObjAndMsg((Object)b, "", MsgType.OK);
        }
        Matcher m = inpProzent.matcher(inp);
        if (m.matches()) {
            Double proz = Double.parseDouble(m.group(1));
            String symb = ba.getSymbol(proz);
            if (symb.equals("")) {
                return new ObjAndMsg(null, "F\u00fcr diese Prozenteingabe konnte keine Note gefunden werden!", MsgType.ERROR);
            }
            b.setNote(symb);
            b.setProzent(proz);
            if (b.getParent() != null) {
                this.recalc(b.getParent(), beurtConf);
                return new ObjAndMsg((Object)b.getParent(), "", MsgType.OK);
            }
            return new ObjAndMsg((Object)b, "", MsgType.OK);
        }
        if (inp == null || inp.isEmpty()) {
            b.setNote(null);
            b.setProzent(Double.valueOf(0.0));
            if (b.getParent() != null) {
                this.recalc(b.getParent(), beurtConf);
                return new ObjAndMsg((Object)b.getParent(), "", MsgType.OK);
            }
            return new ObjAndMsg((Object)b, "", MsgType.OK);
        }
        if (inp.startsWith("*")) {
            b.setNote("*");
            b.setProzent(Double.valueOf(0.0));
            if (b.getParent() != null) {
                this.recalc(b.getParent(), beurtConf);
                return new ObjAndMsg((Object)b.getParent(), "", MsgType.OK);
            }
            return new ObjAndMsg((Object)b, "", MsgType.OK);
        }
        return new ObjAndMsg(null, "Falsche Noten- oder Prozenteingabe", MsgType.ERROR);
    }

    public AlleBeurteilungenDTO loadBeurteilungenAll(HashMap<String, String> dto, LettoToken token) {
        int idLk = Integer.parseInt(dto.get("idLk"));
        boolean global = "true".equals(dto.get("global"));
        Semestrierung sem = Semestrierung.valueOf((String)dto.get("sem"));
        String anzeigeConf = dto.get("anzeigeConf");
        BeurteilungsconfigDTO schema = this.getSchema(idLk, token);
        KlassenInfoDTO klassenInfo = this.findKlassenInfo(idLk, token);
        return this.loadBeurteilungen(idLk, global, sem, anzeigeConf, schema, klassenInfo, token);
    }

    public StudentDto loadBeurteilungenStudent(HashMap<String, String> dto, LettoToken token) {
        int idUser = Integer.parseInt(dto.get("idUser"));
        AlleBeurteilungenDTO alleBeurteilungen = this.loadBeurteilungenAll(dto, token);
        alleBeurteilungen.recalcSum();
        return (StudentDto)alleBeurteilungen.getStudentsHash().get(idUser);
    }

    public AlleBeurteilungenDTO loadBeurteilungen(int idLk, boolean global, Semestrierung sem, String anzeigeConf, BeurteilungsconfigDTO schema, LettoToken token) {
        KlassenInfoDTO klassenInfo = this.findKlassenInfo(idLk, token);
        return this.loadBeurteilungen(idLk, global, sem, anzeigeConf, schema, klassenInfo, token);
    }

    public AlleBeurteilungenDTO loadBeurteilungen(int idLk, boolean global, Semestrierung sem, String anzeigeConf, BeurteilungsconfigDTO schema, KlassenInfoDTO klassenInfo, LettoToken token) {
        List showTestModes;
        String lkConf = (String)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadLehrerKlasseConfig(idLk));
        anzeigeConf = Cmd.isEmpty((String)lkConf) ? anzeigeConf : lkConf;
        AlleBeurteilungenDTO alleBeurteilungen = new AlleBeurteilungenDTO(klassenInfo, global, sem, schema, anzeigeConf);
        Integer lehrerId = (Integer)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadLehrerID(idLk));
        alleBeurteilungen.setSchema(schema);
        Map testPathes = this.getFolders(idLk, klassenInfo.getSemester(), sem, global, token);
        Semestrierung finalSem = sem;
        HashMap testMap = testPathes.isEmpty() ? new HashMap() : (Map)((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestsByAct(testPathes.keySet()))).stream().filter(t -> klassenInfo.fitsDate(t.getDatum(), finalSem)).collect(LinkedHashMap::new, (map, t) -> map.put(t.getIdTest(), t), Map::putAll);
        Set<String> testarten = testMap.values().stream().map(t -> t.getBeurteilungsart()).collect(Collectors.toSet());
        testarten.removeAll(schema.getBeurteilungsartHash().keySet());
        testarten.forEach(ta -> {
            BeurteilungsartDTO x = (BeurteilungsartDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurtConfig.loadGlobalBeurteilungsart(ta));
            if (x != null) {
                schema.getBeurteilungsartHash().put(ta, x);
                if (!schema.getBeurteilungsarten().contains(x)) {
                    schema.getBeurteilungsarten().add(x);
                }
            }
        });
        HashMap mainTests = new HashMap();
        testMap.values().stream().collect(Collectors.groupingBy(TestDTO::getIdGruppe, Collectors.mapping(TestDTO::getIdTest, Collectors.toList()))).values().stream().filter(l -> l.size() > 1).forEach(g -> {
            int mainTest = (Integer)g.get(0);
            for (int j = 1; j < g.size(); ++j) {
                mainTests.put((Integer)g.get(j), mainTest);
            }
        });
        if (!testPathes.isEmpty()) {
            Map<Integer, List<TestPunkteDTO>> mapTestPoints = ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestPoints(testPathes.keySet()))).stream().collect(Collectors.groupingBy(TestPunkteDTO::getIdTest));
            mapTestPoints.keySet().forEach(id -> {
                if (testMap.containsKey(id)) {
                    double points = ((List)mapTestPoints.get(id)).stream().collect(Collectors.summingDouble(dto -> dto.getIdFragengruppe() > 0 ? dto.getPoints() * (double)dto.getAnzFragenInGruppe() : dto.getSumPoints()));
                    ((TestDTO)testMap.get(id)).setPunkteSoll(Double.valueOf(points));
                }
            });
        }
        ArrayList testversuche = testPathes.isEmpty() ? new ArrayList() : (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestVersuche(testPathes.keySet()));
        testversuche.stream().filter(v -> testMap.containsKey(v.getIdTest())).forEach(v -> v.setIdLk(((TestDTO)testMap.get(v.getIdTest())).getIdLk()));
        List students = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadStudents(idLk));
        String grSel = alleBeurteilungen.getGroupSelection();
        Map<Integer, StudentDto> studentHashTemp = students.stream().collect(Collectors.toMap(s -> s.getId(), s -> s));
        List groupDtos = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadStudentGroups(idLk));
        groupDtos.forEach(g -> {
            if (studentHashTemp.containsKey(g.getIdUser())) {
                StudentDto gr = (StudentDto)studentHashTemp.get(g.getIdUser());
                gr.setGruppenName(g.getGruppenName());
                gr.setGruppenId(Integer.valueOf(g.getId()));
            }
        });
        String finalGrSel = grSel.replace("*", ".*");
        Map<Integer, StudentDto> studentHash = alleBeurteilungen.getAnzeigeConfig().contains("groups") && !Cmd.isEmpty((String)grSel) ? students.stream().filter(u -> !Cmd.isEmpty((String)u.getGruppenName()) && u.getGruppenName().matches(finalGrSel)).collect(Collectors.toMap(s -> s.getId(), s -> s)) : studentHashTemp;
        testversuche.forEach(v -> {
            if (studentHash.get(v.getIdUser()) != null) {
                StudentDto s = (StudentDto)studentHash.get(v.getIdUser());
                if (mainTests.containsKey(v.getIdTest())) {
                    v.setIdMainTest(((Integer)mainTests.get(v.getIdTest())).intValue());
                } else {
                    v.setIdMainTest(v.getIdTest());
                }
                TestDTO t = (TestDTO)testMap.get(v.getIdMainTest());
                if (t != null) {
                    v.setTest(t);
                }
                v.setNote(v.getNoteTestVersuch(schema));
                s.getTestErgebnisse().put(v.getIdMainTest(), v);
            }
        });
        testMap.values().forEach(t -> t.setParentFolder((String)testPathes.get(t.getIdTest())));
        String anz = anzeigeConf;
        if (anz == null) {
            anz = "";
        }
        Function<TestDTO, String> collectFunction = (showTestModes = Arrays.asList((anz = anz.replaceAll("^\\[", "").replaceAll("\\]$", "")).split(",")).stream().map(m -> m.trim()).collect(Collectors.toList())).contains("FolderSort") ? TestDTO::getParentFolder : TestDTO::getBeurteilungsart;
        Map<String, List<TestDTO>> angezeigteTests = testMap.values().stream().filter(t -> showTestModes.contains(t.getBeurteilungsart())).filter(t -> !mainTests.containsKey(t.getIdTest())).sorted((Comparator<TestDTO>)new TestDtoDateComparator()).collect(Collectors.groupingBy(collectFunction));
        if (showTestModes.contains("FolderSort")) {
            LinkedHashMap<String, List<TestDTO>> sortedTests = new LinkedHashMap<String, List<TestDTO>>();
            Map<String, List<TestDTO>> finalAngezeigteTests = angezeigteTests;
            ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadActivitiesInKlasse(idLk))).forEach(o -> {
                List x = (List)finalAngezeigteTests.remove(o);
                if (x != null && x.size() > 0) {
                    sortedTests.put(o.replaceAll(".*\\/([^\\/]*$)", "$1"), x);
                }
            });
            if (angezeigteTests.size() > 0) {
                sortedTests.put("main", angezeigteTests.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            }
            angezeigteTests = sortedTests;
        }
        alleBeurteilungen.setTests(angezeigteTests);
        alleBeurteilungen.setTestModes(testMap.values().stream().map(t -> t.getBeurteilungsart()).collect(Collectors.toSet()).stream().collect(Collectors.toList()));
        List beurteilungen = global ? (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadGlobalByLK(idLk)) : (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadByLK(idLk));
        beurteilungen.stream().filter(b -> b.getProzent() == null).forEach(b -> {
            ObjAndMsg ret;
            BeurteilungsartDTO ba;
            if (schema != null) {
                b.mark(schema);
            }
            if ((ba = schema.getBeurteilungsart(b)) != null && (ret = this.changeBeurt(b, b.getInput(), ba)).isOk()) {
                b.setNote(((BeurteilungDTO)ret.object).getNote());
                b.setProzent(((BeurteilungDTO)ret.object).getProzent());
            }
        });
        Map<Integer, BeurteilungDTO> ids = beurteilungen.stream().collect(Collectors.toMap(b -> b.getId(), b -> b));
        List subBeurteilungen = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadSubBeurteilungen(ids.keySet()));
        subBeurteilungen.stream().forEach(b -> {
            if (ids.get(b.getIdParent()) != null) {
                BeurteilungDTO parent = (BeurteilungDTO)ids.get(b.getIdParent());
                parent.getSubBeurteilungen().add(b);
                b.setParent(parent);
            }
        });
        this.setBeurteilungsMarkierungen(schema, ids);
        ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadFremdLehrer(ids.keySet()))).forEach(b -> {
            if (ids.containsKey(b.getIdBeurteilung())) {
                ((BeurteilungDTO)ids.get(b.getIdBeurteilung())).setFremdLehrer(b.getNachname() + " " + b.getVorname());
                ((BeurteilungDTO)ids.get(b.getIdBeurteilung())).setIdFremdLehrer(b.getIdUser());
            }
        });
        Map kompetenzen = ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadKompetenzen(ids.keySet()))).stream().collect(Collectors.groupingBy(k -> k.getIdBeurteilung(), Collectors.mapping(k -> k, Collectors.toList())));
        kompetenzen.keySet().forEach(k -> {
            if (ids.containsKey(k)) {
                ((BeurteilungDTO)ids.get(k)).setKompetenzen((List)kompetenzen.get(k));
            }
        });
        List kbs = global ? (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadGlobalKlassenBeurteilungen(idLk)) : (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadKlassenBeurteilungen(idLk));
        Map<Integer, KlassenBeurteilungDTO> klassenbeurteilungsMap = kbs.stream().collect(Collectors.toMap(s -> s.getId(), s -> s));
        if (klassenbeurteilungsMap.keySet().size() > 0) {
            ((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadSubKlassenBeurteilungen(klassenbeurteilungsMap.keySet()))).forEach(sub -> {
                KlassenBeurteilungDTO par = (KlassenBeurteilungDTO)klassenbeurteilungsMap.get(sub.getIdParent());
                if (par != null) {
                    sub.setParent(par);
                    par.getSubKlassenbeurteilungen().add(sub);
                }
            });
        }
        int maxAnzBeurt = 0;
        for (Object b2 : beurteilungen) {
            if (studentHash.get(b2.getIdUser()) == null) continue;
            StudentDto s2 = studentHash.get(b2.getIdUser());
            boolean dateOK = klassenInfo.fitsDate(b2.getDatum(), sem);
            b2.setDateOK(dateOK);
            if (b2.getIdKlassenbeurteilung() > 0) {
                KlassenBeurteilungDTO kb = klassenbeurteilungsMap.get(b2.getIdKlassenbeurteilung());
                b2.setKlassenbeurteilung(kb);
                if (!b2.getBeurteilungsart().equals(kb.getBeurteilungsart())) {
                    b2.setBeurteilungsart(kb.getBeurteilungsart());
                    b2.setBezeichnerBeurteilungsart(kb.getBezeichnerBeurteilungsart());
                    if (b2.getProzent() != null && b2.getProzent() >= 0.0) {
                        BeurteilungsartDTO ba2 = schema.getBeurteilungsart(b2);
                        b2.setNote(ba2.getSymbol(b2.getProzent()));
                    }
                }
                if (kb == null) continue;
                b2.setGewicht(kb.getGewichtung());
                s2.getKlassenBeurteilungen().put(kb.getId(), b2);
                kb.getBeurteilungen().add(b2);
                continue;
            }
            if (!dateOK) continue;
            b2.setGewicht(1.0);
            s2.getIndivBeurteilungen().add(b2);
            if (maxAnzBeurt >= s2.getIndivBeurteilungen().size()) continue;
            maxAnzBeurt = s2.getIndivBeurteilungen().size();
        }
        List noten = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadNoten(idLk));
        noten.forEach(n -> {
            if (studentHash.containsKey(n.getIdUser())) {
                StudentDto s = (StudentDto)studentHash.get(n.getIdUser());
                if (n.getSemestrierung() == Semestrierung.Wintersemester) {
                    s.setNoteWS(n);
                } else {
                    s.setNoteSS(n);
                }
            }
        });
        if (schema.isCalcNote()) {
            Object b2;
            b2 = schema.getBeurteilungsarten().stream().map(ba -> ba.getBeurtGruppe()).collect(Collectors.toSet()).stream().collect(Collectors.toList());
        }
        List testIds = testPathes.keySet().stream().collect(Collectors.toList());
        alleBeurteilungen.setStudentsHash(studentHash);
        alleBeurteilungen.setKlassenBeurteilungen(klassenbeurteilungsMap);
        alleBeurteilungen.loadKlassenBeurteilungsList();
        alleBeurteilungen.setIndividalSpalten(maxAnzBeurt < 3 ? 3 : maxAnzBeurt);
        if (schema.isCalcNote()) {
            alleBeurteilungen.recalcSum();
        }
        if (global && schema.isSummeLehrer()) {
            this.calcSummenModus(alleBeurteilungen);
        }
        if (schema.isGruppierung()) {
            alleBeurteilungen.sortByGroup();
        } else {
            alleBeurteilungen.sortByName();
        }
        return alleBeurteilungen;
    }

    public void changeLehrerGewicht(int idLk, double gewicht, AlleBeurteilungenDTO alleBeurteilungen, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).beurteilung.changeLehrerKlasseGewicht(idLk, gewicht));
        alleBeurteilungen.defineGewichtungLehrer(idLk, gewicht);
        alleBeurteilungen.recalcSum();
    }

    public void changeKlassenbeurteilungsGewicht(KlassenBeurteilungDTO kb, AlleBeurteilungenDTO alleBeurteilungen, boolean recalc, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).beurteilung.changeKlassenbeurteilungsGewicht(kb.getId(), kb.getGewichtung()));
        kb.setGewichtung(kb.getGewichtung());
        alleBeurteilungen.addKlassenbeurteilung(kb);
        if (recalc) {
            alleBeurteilungen.recalcSum();
        }
        if (kb.getBeurteilungsart().equals("Summe")) {
            this.changeLehrerGewicht(kb.getIdLk(), kb.getGewichtung(), alleBeurteilungen, token);
        }
    }

    public String setUserGruppe(StudentDto student, int idLk, String gruppe, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).beurteilung.setUserGruppe(student, idLk, gruppe));
        return "";
    }

    private void setBeurteilungsMarkierungen(BeurteilungsconfigDTO schema, Map<Integer, BeurteilungDTO> ids) {
        Map<String, List> x = schema.getBeurteilungsartHash().values().stream().filter(b -> b.getSubBeurteilungen() != null && b.getSubBeurteilungen().contains("!")).collect(Collectors.toMap(b -> b.getName(), b -> BeurteilungService.erzwungeneBeurteilung((String)b.getSubBeurteilungen())));
        ids.values().forEach(b -> b.mark(x));
    }

    private static List<String> erzwungeneBeurteilung(String subDefinition) {
        return Stream.of(subDefinition.split(",")).filter(s -> s.contains("!")).map(s -> s.replaceAll("[!\\*]", "").replaceAll("\\d*\\s*$", "")).collect(Collectors.toList());
    }

    public BeurteilungsconfigDTO getSchema(int idLk, LettoToken token) {
        return (BeurteilungsconfigDTO)this.beurtConfigCache.loadData(idLk, token);
    }

    public String getNote(double proz, String beurteilungsart, BeurteilungsconfigDTO schema) {
        try {
            BeurteilungsartDTO x = (BeurteilungsartDTO)schema.getBeurteilungsartHash().get(beurteilungsart);
            return x.getBewertung(proz).getSymbol();
        }
        catch (Exception e) {
            return "---XXX---";
        }
    }

    public Map<Integer, String> getFolders(int idLk, Date d, Semestrierung sem, boolean global, LettoToken token) {
        List x;
        if (global) {
            switch (1.$SwitchMap$at$letto$tools$enums$Semestrierung[sem.ordinal()]) {
                case 1: {
                    x = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestsGlobalFullPathWinterSemester(idLk, d));
                    break;
                }
                case 2: {
                    x = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestsGlobalFullPathSommerSemester(idLk, d));
                    break;
                }
                default: {
                    x = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestsGlobalWithFullPath(idLk));
                    break;
                }
            }
        } else {
            switch (1.$SwitchMap$at$letto$tools$enums$Semestrierung[sem.ordinal()]) {
                case 1: {
                    x = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestsFullPathWinterSemester(idLk, d));
                    break;
                }
                case 2: {
                    x = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestsFullPathSommerSemester(idLk, d));
                    break;
                }
                default: {
                    x = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadTestsWithFullPath(idLk));
                }
            }
        }
        Map<Integer, String> tests = x.stream().collect(Collectors.toMap(PairIntString::getVal1, p -> {
            String path = p.getVal2();
            if (path != null && path.contains("/")) {
                return path.replaceAll("/[^/]*$", "");
            }
            return path != null ? path : "";
        }));
        return tests;
    }

    public KlassenInfoDTO findKlassenInfo(int idLk, LettoToken token) {
        KlassenInfoDTO ki = (KlassenInfoDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadKlassenInfo(idLk));
        if (ki == null) {
            return null;
        }
        List l = (List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadLehrerInKlasse(idLk));
        for (int i = 0; i < l.size(); ++i) {
            ((LehrerInfoDTO)l.get(i)).setColorClass("col" + i);
        }
        ki.setUnterrichtendeLehrer(l);
        ki.setFremdLehrer((List)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadFremdLehrerInKlasse(idLk)));
        return ki;
    }

    public KlassenBeurteilungDTO findKlassenBeurteilung(int id, BeurteilungsconfigDTO schema, LettoToken token) {
        KlassenBeurteilungDTO kb = (KlassenBeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadKlassenbeurteilung(id));
        BeurteilungsartDTO ba = schema.getBeurteilungsart(kb);
        kb.setBeurteilungsart(ba);
        return kb;
    }

    public boolean checkRights(BeurteilungDTO b, int idKlassenlehrer, int idLehrer) {
        if (idLehrer == idKlassenlehrer) {
            return true;
        }
        if (b == null) {
            return true;
        }
        return b.getIdFremdLehrer() == idLehrer;
    }

    public String checkRightsDelete(KlassenBeurteilungDTO kb, int idKlassenlehrer, int idLehrer) {
        if (idLehrer == idKlassenlehrer) {
            return "";
        }
        if (kb == null) {
            return "Klassenbeuteilung leer!";
        }
        if (kb.getIdFremdlehrer() != idLehrer) {
            return "Sie d\u00fcrfen diese Klassenweise Beurteilung nicht l\u00f6schen: Sie wurde vom Hauptverantwortlichen Lehrer angelegt";
        }
        if (kb.getBeurteilungen().stream().anyMatch(b -> !this.checkRights(b, idKlassenlehrer, idLehrer))) {
            return "Sie d\u00fcrfen diese Klassenweise Beurteilung nicht l\u00f6schen, weil es Beurteilungen vom Hauptverantwortlichen Lehrer gibt.";
        }
        return "";
    }

    public KlassenBeurteilungDTO delOnlineTest(KlassenBeurteilungDTO kb, BeurteilungsconfigDTO schema, LettoToken token) {
        return (KlassenBeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.delOnlineTest(kb));
    }

    public NoteDTO saveNote(NoteDTO n, LettoToken token) {
        return (NoteDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.saveNote(n));
    }

    public void delKlassenBeurteilung(KlassenBeurteilungDTO kb, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).beurteilung.delKlassenBeurteilung(kb.getId()));
    }

    public void delBeurteilung(BeurteilungDTO b, LettoToken token) {
        DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.delBeurteilung(b.getId()));
    }

    public void delBeurteilungenTestversuch(int idTest, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).beurteilung.delBeurteilungenTestversuch(idTest));
    }

    public static Semestrierung adaptSemestrierung(Semestrierung sem, KlassenInfoDTO klassenInfoDTO) {
        switch (1.$SwitchMap$at$letto$tools$enums$Semestrierung[sem.ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                return Semestrierung.GanzesJahr;
            }
            case 2: {
                return Semestrierung.Sommersemester;
            }
            case 1: {
                return Semestrierung.Wintersemester;
            }
            case 6: {
                if (klassenInfoDTO.getSemestrierung() == Semestrierung.NichtSemestriert) {
                    return Semestrierung.GanzesJahr;
                }
                return new Date().after(klassenInfoDTO.getSemester()) ? Semestrierung.Sommersemester : Semestrierung.Wintersemester;
            }
        }
        return null;
    }

    public void deactivateSummenModus(AlleBeurteilungenDTO alleBeurteilungen) {
        alleBeurteilungen.loadKlassenBeurteilungsList();
        alleBeurteilungen.setSummeGlobal(false);
    }

    public void calcSummenModus(AlleBeurteilungenDTO alleBeurteilungen) {
        KlassenInfoDTO klassenInfo = alleBeurteilungen.getKlassenInfoDTO();
        Vector kbList = new Vector();
        klassenInfo.getUnterrichtendeLehrer().forEach(l -> {
            KlassenBeurteilungDTO kb = new KlassenBeurteilungDTO();
            kb.setIdLk(l.getIdLk());
            kb.setId(l.getIdLk());
            String name = "\u2211 " + l.getLehrer();
            if (!Cmd.isEmpty((String)l.getFachbez())) {
                name = name + "-" + l.getFachbez();
            }
            kb.setName(name);
            kb.setGewichtung(l.getGewichtung());
            kb.setBeurteilungsart("Summe");
            alleBeurteilungen.getStudentsHash().values().forEach(s -> {
                BeurteilungDTO b = new BeurteilungDTO();
                b.setProzent(Double.valueOf(((ErgebnisseNachLehrer)s.getErgebnisseNachLehrern().get(l.getIdLk())).getProzent() * 100.0));
                b.setIdUser(Integer.valueOf(s.getId()));
                b.setIdLk(Integer.valueOf(l.getIdLk()));
                b.setNote(dec.format(b.getProzent()) + "%");
                b.setId(1);
                b.setDateOK(true);
                b.setFehlendeUnterbeurteilung(false);
                kb.getBeurteilungen().add(b);
                b.setKlassenbeurteilung(kb);
                b.setIdKlassenbeurteilung(kb.getId());
                s.getKlassenBeurteilungen().put(kb.getId(), b);
            });
            kbList.add(kb);
        });
        alleBeurteilungen.setKbList(kbList);
        alleBeurteilungen.setSummeGlobal(true);
    }

    public static BeurteilungDTO createKlassenbeurteilung(KlassenBeurteilungDTO kb, int idUser, BeurteilungDTO b, BeurteilungsconfigDTO schema) {
        BeurteilungsartDTO ba = schema.getBeurteilungsart(kb);
        if (b == null) {
            b = new BeurteilungDTO();
        }
        b.setIdKlassenbeurteilung(kb.getId());
        b.setIdLk(Integer.valueOf(kb.getIdLk()));
        b.setIdUser(Integer.valueOf(idUser));
        b.setDatum(new Date());
        b.setBeurteilungsart(ba);
        int anzSub = 0;
        if (!ba.getSubBeurteilungen().isEmpty()) {
            int i = 0;
            String subText = ba.getSubBeurteilungen().replaceAll(";", ",").trim();
            String[] det = subText.split(",");
            anzSub = det.length;
            for (String sub : det) {
                BeurteilungDTO subBeurt;
                SubBeurteilung s = new SubBeurteilung(sub);
                if (b.getSubBeurteilungen().size() > i) {
                    subBeurt = (BeurteilungDTO)b.getSubBeurteilungen().get(i);
                } else {
                    subBeurt = new BeurteilungDTO();
                    subBeurt.setIdKlassenbeurteilung(0);
                    subBeurt.setParent(b);
                    b.getSubBeurteilungen().add(subBeurt);
                }
                subBeurt.setBeurteilungsart(ba);
                subBeurt.setFragetext(String.format("%s (%2.1f)", s.getName(), s.getFaktor()));
                subBeurt.setGewicht(s.getFaktor());
                try {
                    subBeurt.setIdActivity(((KlassenBeurteilungDTO)kb.getSubKlassenbeurteilungen().get(i)).getIdActivity());
                    subBeurt.setActivityName(((KlassenBeurteilungDTO)kb.getSubKlassenbeurteilungen().get(i)).getActivityName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        Iterator iter = b.getSubBeurteilungen().iterator();
        int i = 0;
        while (iter.hasNext()) {
            BeurteilungDTO s = (BeurteilungDTO)iter.next();
            if (i >= anzSub && (s.getNote() == null || s.getNote().isEmpty())) {
                iter.remove();
            }
            ++i;
        }
        b.getKompetenzen().clear();
        if (kb.getIdKompetenz() > 0) {
            KompetenzBeurteilungsDTO link = new KompetenzBeurteilungsDTO(b.getId(), kb.getIdKompetenz(), kb.getKompetenzen(), kb.getLevel());
            b.getKompetenzen().add(link);
        }
        return b;
    }

    public int findIdLk(int idKlassenbeurteilung, LettoToken token) {
        KlassenBeurteilungDTO kb = (KlassenBeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadParentKlassenbeurteilung(idKlassenbeurteilung));
        return kb.getIdLk();
    }

    public int findIdLkForBeurt(int idBeurteilung, LettoToken token) {
        Integer ret = (Integer)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadIdLkBeurteilung(idBeurteilung));
        return ret != null ? ret : 0;
    }

    public String saveInKlassenBeurteilung(String note, double proz, int idUser, int idKlassenbeurteilung, int idSchema, LettoToken token) {
        BeurteilungDTO change;
        BeurteilungDTO b;
        KlassenBeurteilungDTO parent = (KlassenBeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadParentKlassenbeurteilung(idKlassenbeurteilung));
        if (parent == null) {
            throw new MsgException("Zugeh\u00f6rige Klassenbeurteilung wurde nicht gefunden");
        }
        int pos = -1;
        if (parent.getId() != idKlassenbeurteilung) {
            int i = 0;
            for (KlassenBeurteilungDTO sub : parent.getSubKlassenbeurteilungen()) {
                if (sub.getId() == idKlassenbeurteilung) {
                    pos = i;
                    break;
                }
                ++i;
            }
        }
        if ((b = (BeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadBeurteilungFromKlassenbeurteilungAndUser(parent.getId(), idUser))) != null && b.getParent() != null) {
            b = b.getParent();
        }
        b = BeurteilungService.createKlassenbeurteilung((KlassenBeurteilungDTO)parent, (int)idUser, (BeurteilungDTO)b, (BeurteilungsconfigDTO)this.getSchema(idSchema, token));
        BeurteilungDTO beurteilungDTO = change = pos >= 0 ? (BeurteilungDTO)b.getSubBeurteilungen().get(pos) : b;
        if (change != null) {
            change.setInput("---");
            change.setNote(note);
            change.setProzent(Double.valueOf(proz * 100.0));
        }
        BeurteilungsconfigDTO schema = (BeurteilungsconfigDTO)this.beurtConfigCache.loadData(idSchema, token);
        b = this.recalc(b, schema);
        this.save(b, schema.getId(), token);
        return "";
    }

    public String saveInBeurteilung(String note, double proz, int idUser, int idBeurteilung, int idSchema, LettoToken token) {
        BeurteilungDTO b = (BeurteilungDTO)DtoAndMsg.get((DtoAndMsg)this.data((LettoToken)token).beurteilung.loadBeurteilung(idBeurteilung));
        if (b == null) {
            throw new MsgException("Zugeh\u00f6rige Beurteilung wurde nicht gefunden");
        }
        if (b != null) {
            b.setInput("---");
            b.setNote(note);
            b.setProzent(Double.valueOf(proz * 100.0));
        }
        BeurteilungsconfigDTO schema = (BeurteilungsconfigDTO)this.beurtConfigCache.loadData(idSchema, token);
        b = this.recalc(b, schema);
        this.save(b, schema.getId(), token);
        return "";
    }

    public String updateConfig(String config, int idLk, LettoToken token) {
        DtoAndMsg.check((DtoAndMsg)this.data((LettoToken)token).beurteilung.changeConfig(config, idLk));
        return "";
    }
}

