/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service;

import at.letto.data.dto.category.rechte.RechteCategoryDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.data.restclient.data.RestCategory;
import at.letto.globalinterfaces.IdEntity;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.security.LettoToken;
import at.letto.tools.ChangeLists;
import at.letto.tools.Listen;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RechteService {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    private ModelMapper modelMapper = new ModelMapper();
    private Map<String, Map<Integer, List<RechteCategoryDto>>> rechteMaps = new ConcurrentHashMap();

    private Map<Integer, List<RechteCategoryDto>> loadRechte(String school) {
        if (!this.rechteMaps.containsKey(school)) {
            Map map = ((List)this.microServiceConfiguration.getDataService((String)school).category.loadAllRechte().getData()).stream().collect(Collectors.groupingBy(r -> r.getIdCategory(), Collectors.toList()));
            this.rechteMaps.put(school, new ConcurrentHashMap(map));
        }
        return (Map)this.rechteMaps.get(school);
    }

    public String rechteChange(RechteCategoryDto r, LettoToken token) {
        Map rechteMap = this.loadRechte(token.getSchool());
        this.ds((LettoToken)token).category.changeRechte(r);
        if (!rechteMap.containsKey(r.getId())) {
            rechteMap.put(r.getId(), new Vector());
        }
        ((List)rechteMap.get(r.getId())).add(r);
        return "";
    }

    private RestLettoDataService ds(LettoToken token) {
        return this.microServiceConfiguration.getDataService(token);
    }

    public int rechteAdd(RechteCategoryDto r, LettoToken token) {
        Map rechteMap = this.loadRechte(token.getSchool());
        int id = (Integer)this.ds((LettoToken)token).category.addRechte(r).getData();
        if (!rechteMap.containsKey(r.getId())) {
            rechteMap.put(r.getId(), new Vector());
        }
        List list = (List)rechteMap.get(r.getIdCategory());
        r.setId(id);
        int ind = list.indexOf(r);
        if (ind > 0) {
            list.set(ind, r);
        } else {
            list.add(r);
        }
        return id;
    }

    public String rechteRemove(RechteCategoryDto r, LettoToken token) {
        Map rechteMap = this.loadRechte(token.getSchool());
        this.ds((LettoToken)token).category.deleteRechte(r);
        rechteMap.remove(r.getId());
        return "";
    }

    public RechteCategoryDto findRecht(int idCat, LettoToken token) {
        int idUser = token.getIdUser();
        Map rechteMap = this.loadRechte(token.getSchool());
        try {
            RechteCategoryDto r = (RechteCategoryDto)Listen.get((List)((List)rechteMap.get(idCat)), (int)idUser, RechteCategoryDto::getIdUser);
            return new RechteCategoryDto(r.getId(), Integer.valueOf(r.getIdUser()), Integer.valueOf(r.getIdCategory()), Boolean.valueOf(r.isChange()), Boolean.valueOf(r.isDelete()), Boolean.valueOf(r.isInsert()), r.getUser());
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<RechteCategoryDto> findRechteForCategory(int idCategory, LettoToken token) {
        Map rechteMap = this.loadRechte(token.getSchool());
        if (!rechteMap.containsKey(idCategory)) {
            rechteMap.put(idCategory, new Vector());
        }
        return ((List)rechteMap.get(idCategory)).stream().map(r -> new RechteCategoryDto(r.getId(), Integer.valueOf(r.getIdUser()), Integer.valueOf(r.getIdCategory()), Boolean.valueOf(r.isChange()), Boolean.valueOf(r.isDelete()), Boolean.valueOf(r.isInsert()), r.getUser())).collect(Collectors.toList());
    }

    public List<RechteCategoryDto> findRechteForCategoryFromDatabase(int idCategory, LettoToken token) {
        return (List)this.ds((LettoToken)token).category.loadRechteForCategory(idCategory).getData();
    }

    public String changeRechteForCategory(int idCateg, List<RechteCategoryDto> rechte, LettoToken token) {
        Map rechteMap = this.loadRechte(token.getSchool());
        Listen.removeNotContaing(rechte, (int)idCateg, RechteCategoryDto::getIdCategory);
        rechte = Listen.removeElementsNonUnique(rechte, (boolean)false);
        List dbRechte = this.findRechteForCategory(idCateg, token);
        ChangeLists ret = Listen.detectChanges((List)rechte, (List)dbRechte, RechteCategoryDto::changed);
        Vector liste = (Vector)rechteMap.get(idCateg);
        if (liste == null) {
            liste = new Vector();
        }
        Listen.change(liste, (List)ret.getChange());
        Listen.remove(liste, (List)ret.getDel());
        liste.addAll(ret.getAdd());
        RestCategory data = this.ds((LettoToken)token).category;
        ret.getChange().forEach(r -> data.changeRechte(r));
        ret.getAdd().forEach(r -> r.setId(((Integer)data.addRechte(r).getData()).intValue()));
        ret.getDel().forEach(r -> data.deleteRechte(r));
        this.loadRechte(token.getSchool()).put(idCateg, this.findRechteForCategoryFromDatabase(idCateg, token));
        return "";
    }

    private void addToHash(int idCategory, RechteCategoryDto recht, LettoToken token) {
        if (recht.getId() <= 0) {
            return;
        }
        List r = this.findRechteForCategory(idCategory, token);
        Listen.add((List)r, (IdEntity)recht);
    }

    private void removeFromHash(int idCategory, RechteCategoryDto recht, LettoToken token) {
        if (recht.getId() <= 0) {
            return;
        }
        List r = this.findRechteForCategory(idCategory, token);
        Listen.add((List)r, (IdEntity)recht);
    }
}

