/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.config.GlobalConfigDto;
import at.letto.data.dto.config.UserConfigDto;
import at.letto.data.dto.enums.RECHT;
import at.letto.data.dto.question.AnswerDTO;
import at.letto.data.dto.question.KompetenzSubquestionDTO;
import at.letto.data.dto.question.MoodleTextDTO;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.question.QuestionTextHistoryDTO;
import at.letto.data.dto.question.SubQuestionDTO;
import at.letto.data.dto.question.list.SaveQuestionDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.CategoryService;
import at.letto.lettoedit.service.QuestionService;
import at.letto.lettoedit.service.RechteService;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.security.LettoToken;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.LicenseKey;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.enums.SQMODE;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionService {
    @Autowired
    private ConfigService configService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private RechteService rechteService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    private static final String encryptSecret = "encryptedQuestion";

    public void encryt(QuestionDTO q, String name, String key) {
        q.setMaxima(ENCRYPT.enc((String)(encryptSecret + q.getMaxima()), (String)key));
        String txt = ENCRYPT.enc((String)(encryptSecret + q.getQuestionText().getText()), (String)key);
        String md5 = encryptSecret + ENCRYPT.md5falsch((String)txt);
        q.getQuestionText().setText(txt);
        q.setLicenceKey(name + ";" + md5);
    }

    private boolean decryptQuestion(QuestionDTO q, String key) {
        boolean decryptError = false;
        if (q.getLicenceKey() == null || q.getLicenceKey().isEmpty()) {
            return false;
        }
        if (key == null) {
            key = "";
        }
        String md5 = "";
        MoodleTextDTO text = (MoodleTextDTO)q.getMoodleTexte().get(0);
        String txt = text.getText();
        try {
            md5 = q.getLicenceKey().split(";")[1];
            txt = ENCRYPT.decrypt((String)txt, (char[])key.toCharArray());
            if (txt.startsWith(encryptSecret)) {
                txt = txt.replaceFirst(encryptSecret, "");
            } else {
                decryptError = true;
            }
            q.setMaxima(ENCRYPT.decrypt((String)q.getMaxima(), (char[])key.toCharArray()));
            if (q.getMaxima().startsWith(encryptSecret)) {
                q.setMaxima(q.getMaxima().replaceFirst(encryptSecret, ""));
            } else {
                decryptError = true;
            }
            text.setText(txt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        q.resetChanged();
        return decryptError;
    }

    public QuestionDTO loadQuestion(int idQuestion, LettoToken token) {
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        QuestionDTO q = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)data.question.loadQuestion(idQuestion));
        if (q != null && !Cmd.isEmpty((String)q.getLicenceKey())) {
            GlobalConfigDto l = (GlobalConfigDto)DtoAndMsg.get((DtoAndMsg)data.config.getGlobalConf("lizenz"));
            String param = q.getLicenceKey().split(";")[0];
            LicenseKey license = new LicenseKey(l.getText());
            String key = license.getKeyForBeispielsammlung(param);
            if (Cmd.isEmpty((String)key)) {
                param = ((UserConfigDto)DtoAndMsg.get((DtoAndMsg)data.config.get("lizenz", token.getIdUser().intValue()))).getText();
                license = new LicenseKey(l.getText());
                key = license.getKeyForBeispielsammlung(param);
            }
            if (Cmd.isEmpty((String)key)) {
                throw new MsgException("question.decryptError");
            }
            if (!this.decryptQuestion(q, key)) {
                throw new MsgException("question.decryptError");
            }
        }
        return q;
    }

    public QuestionDTO saveQuestion(SaveQuestionDto saveQuestionDto, LettoToken token) {
        boolean changeAllowed;
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        QuestionDTO q = saveQuestionDto.getQuestionDto();
        boolean bl = changeAllowed = q.getIdCategory() > 0 ? this.categoryService.checkRecht(q.getIdCategory(), RECHT.AENDERN, "", token) : false;
        if (!changeAllowed && saveQuestionDto.getIdTestfrage() <= 0) {
            throw new MsgException("err.question.noChangeRights");
        }
        if (q.getLicenceKey() != null && !q.getLicenceKey().isEmpty()) {
            try {
                GlobalConfigDto l = (GlobalConfigDto)DtoAndMsg.get((DtoAndMsg)data.config.getGlobalConf("lizenz"));
                String param = q.getLicenceKey().split(";")[0];
                LicenseKey license = new LicenseKey(l.getText());
                String key = q.getLicenceKey().split(";")[0];
                String licInfo = license.getKeyForBeispielsammlung(key);
                if (licInfo == null) {
                    key = "";
                }
                String[] x = licInfo.split(":");
                String pwd = x[0];
                boolean allow = false;
                if (x.length > 1) {
                    String[] users = x[1].split("\\|");
                    allow = Arrays.stream(users).anyMatch(s -> s.equals(token.getUsername()));
                }
                if (!allow) {
                    throw new MsgException("question.encryptError");
                }
                this.encryt(q, key, pwd);
            }
            catch (Exception e) {
                throw new MsgException("question.encryptError");
            }
        }
        this.setKompetenzenToCategory(q, false, token);
        saveQuestionDto.setQuestionDto(q);
        saveQuestionDto.setIdUser(token.getIdUser().intValue());
        saveQuestionDto.setChangeAllowed(changeAllowed);
        QuestionTextHistoryDTO h = new QuestionTextHistoryDTO(0, q.getId(), q.getQuestionText().getText(), new Date(), token.getVorname() + " " + token.getNachname() + "<br/>" + token.getSchool());
        data.question.saveHistory(h);
        q = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)data.question.saveQuestion(saveQuestionDto));
        return q;
    }

    public void changeQuestionType(QuestionDTO q, QuestionType questionType) {
        if (q.getQuestionType() == questionType) {
            return;
        }
        if (questionType != null) {
            while (q.getMoodleTexte().size() <= 5) {
                q.getMoodleTexte().add(new MoodleTextDTO(q));
            }
        }
        block0 : switch (1.$SwitchMap$at$letto$tools$enums$QuestionType[questionType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                if (q.getSubQuestions().size() < 1) {
                    q.getSubQuestions().add(new SubQuestionDTO(q));
                }
                ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.CALCULATED);
                if (((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().size() >= 1) break;
                AnswerDTO a = new AnswerDTO((SubQuestionDTO)q.getSubQuestions().get(0));
                a.setFraction(100.0);
                ((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().add(a);
                break;
            }
            case 22: 
            case 23: {
                if (q.getQuestionType() == null) break;
                switch (1.$SwitchMap$at$letto$tools$enums$QuestionType[q.getQuestionType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        q.getQuestionText().setText(q.getQuestionText().getText() + "\n[Q0]");
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setName("Q0");
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setGrade((double)((int)q.getPunkte()));
                        break block0;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.MULTICHOICE);
                        q.getQuestionText().setText(q.getQuestionText().getText() + "\n[Q0]");
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setGrade((double)((int)q.getPunkte()));
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setName("Q0");
                        break block0;
                    }
                    case 10: {
                        q.getQuestionText().setText(q.getQuestionText().getText() + "\n[Q0]");
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setName("Q0");
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.CALCULATED);
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setGrade((double)((int)q.getPunkte()));
                        break block0;
                    }
                    case 11: {
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.TEXT);
                        q.getQuestionText().setText(q.getQuestionText().getText() + "\n[Q0]");
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setGrade((double)((int)q.getPunkte()));
                        ((SubQuestionDTO)q.getSubQuestions().get(0)).setName("Q0");
                        break block0;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                q.getSubQuestions().clear();
                q.getSubQuestions().add(new SubQuestionDTO(q));
                ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.TEXT);
                if (((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().size() < 1) {
                    AnswerDTO a = new AnswerDTO((SubQuestionDTO)q.getSubQuestions().get(0));
                    a.setFraction(100.0);
                    ((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().add(a);
                }
                SubQuestionDTO sqImg = new SubQuestionDTO(q, new AnswerDTO[]{new AnswerDTO()});
                sqImg.setMode(SQMODE.IMAGE);
                sqImg.setName("Qimg");
                sqImg.setGrade(0.0);
                q.getSubQuestions().add(sqImg);
                break;
            }
            case 7: {
                if (q.getSubQuestions().size() == 0) {
                    q.getSubQuestions().add(new SubQuestionDTO());
                }
                q.getFirstSubquestion().setMode(SQMODE.ZUORDNUNG);
                for (SubQuestionDTO sq : q.getSubQuestions()) {
                    sq.setMode(SQMODE.ZUORDNUNG);
                }
                break;
            }
            case 9: {
                if (q.getSubQuestions().size() == 0) {
                    q.getSubQuestions().add(new SubQuestionDTO());
                }
                q.getFirstSubquestion().setMode(SQMODE.MULTICHOICE);
                for (SubQuestionDTO sq : q.getSubQuestions()) {
                    sq.setMode(SQMODE.MULTICHOICE);
                }
                break;
            }
            case 10: {
                if (q.getSubQuestions().size() < 1) {
                    q.getSubQuestions().add(new SubQuestionDTO(q));
                }
                ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.CALCULATED);
                if (((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().size() >= 1) break;
                AnswerDTO a = new AnswerDTO((SubQuestionDTO)q.getSubQuestions().get(0));
                a.setFraction(100.0);
                ((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().add(a);
                break;
            }
            case 6: {
                break;
            }
            case 11: {
                if (q.getSubQuestions().size() < 1) {
                    q.getSubQuestions().add(new SubQuestionDTO(q));
                }
                ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.TEXT);
                if (((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().size() >= 1) break;
                AnswerDTO a = new AnswerDTO((SubQuestionDTO)q.getSubQuestions().get(0));
                a.setFraction(100.0);
                ((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().add(a);
                break;
            }
            case 8: {
                if (q.getSubQuestions().size() < 1) {
                    q.getSubQuestions().add(new SubQuestionDTO(q));
                }
                ((SubQuestionDTO)q.getSubQuestions().get(0)).setMode(SQMODE.MULTICHOICE);
                ((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().removeAll(((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers());
                AnswerDTO yes = new AnswerDTO((SubQuestionDTO)q.getSubQuestions().get(0));
                AnswerDTO no = new AnswerDTO((SubQuestionDTO)q.getSubQuestions().get(0));
                yes.setFraction(100.0);
                yes.setText("true");
                no.setText("false");
                no.setFraction(0.0);
                ((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().add(yes);
                ((SubQuestionDTO)q.getSubQuestions().get(0)).getAnswers().add(no);
                break;
            }
        }
        q.setQuestionType(questionType);
    }

    public void setKompetenzenToCategory(QuestionDTO q, boolean deleteExisting, LettoToken token) {
        if (q.getIdCategory() <= 0) {
            return;
        }
        CategoryDTO cat = this.categoryService.loadCat(token, q.getIdCategory());
        if (cat == null) {
            return;
        }
        if (cat.getIdKompetenz() != null && cat.getIdKompetenz() > 0) {
            for (SubQuestionDTO sq : q.getSubQuestions()) {
                if (deleteExisting) {
                    sq.getKompetenzen().clear();
                } else {
                    Iterator iter = sq.getKompetenzen().iterator();
                    while (iter.hasNext()) {
                        KompetenzSubquestionDTO l = (KompetenzSubquestionDTO)iter.next();
                        if (cat.getIdKompetenz().intValue() != l.getIdKompetenz()) continue;
                        iter.remove();
                    }
                }
                KompetenzSubquestionDTO kl = new KompetenzSubquestionDTO(0, sq, cat.getIdKompetenz().intValue(), cat.getLevel(), "");
                sq.getKompetenzen().add(kl);
            }
        }
    }

    public QuestionDTO insertQuestion(QuestionDTO qu, int pos, int idLinkQuestion, LettoToken token) {
        int idCat = qu.getIdCategory();
        long qAnz = 0L;
        try {
            if (idCat > 0) {
                qAnz = this.categoryService.loadCat(token, idCat).getQuestionsInCategory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setKompetenzenToCategory(qu, true, token);
        qu.setUnitPenalty(((Double)this.configService.loadConf("EH_Fehler", Double.class, token)).doubleValue());
        String tol = (String)this.configService.loadConf("Toleranz", String.class, token);
        qu.getSubQuestions().forEach(sq -> sq.getAnswers().forEach(a -> {
            a.setFraction(100.0);
            a.setTolerance(tol);
        }));
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        QuestionDTO q = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)data.question.insertQuestion(new SaveQuestionDto(qu, pos)));
        if (q != null && idCat > 0) {
            try {
                this.categoryService.loadCat(token, idCat).setQuestionsInCategory(qAnz + 1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return q;
    }

    public QuestionDTO deleteQuestion(int idQuestion, int idCat, LettoToken token) {
        long qAnz = this.categoryService.loadCat(token, idCat).getQuestionsInCategory();
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        QuestionDTO qDel = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)data.question.deleteQuestion(idQuestion));
        if (qDel != null) {
            try {
                this.categoryService.loadCat(token, idCat).setQuestionsInCategory(qAnz - 1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return qDel;
    }

    public QuestionDTO cloneQuestion(int idQuestion, int idCat, int pos, LettoToken token) {
        long qAnz = 0L;
        try {
            if (idCat > 0) {
                qAnz = this.categoryService.loadCat(token, idCat).getQuestionsInCategory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        QuestionDTO q = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)data.question.cloneQuestion(idQuestion, idCat, pos));
        if (q != null) {
            try {
                this.categoryService.loadCat(token, idCat).setQuestionsInCategory(qAnz + 1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return q;
    }

    public QuestionDTO moveQuestion(int idQuestion, int idCat, int pos, LettoToken token) {
        long qAnz = 0L;
        try {
            if (idCat > 0) {
                qAnz = this.categoryService.loadCat(token, idCat).getQuestionsInCategory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RestLettoDataService data = this.microServiceConfiguration.getDataService(token);
        QuestionDTO q = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)data.question.loadQuestion(idQuestion));
        q.setIdCategory(idCat);
        SaveQuestionDto s = new SaveQuestionDto(q, pos);
        q = (QuestionDTO)DtoAndMsg.get((DtoAndMsg)data.question.saveQuestion(s));
        if (q != null) {
            try {
                this.categoryService.loadCat(token, idCat).setQuestionsInCategory(qAnz + 1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return q;
    }
}

