/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.service;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.category.CategoryTreeDto;
import at.letto.data.dto.category.kompetenzen.CategoryKompetenzDto;
import at.letto.data.dto.category.kompetenzen.SaveKompetenzenDto;
import at.letto.data.dto.category.kompetenzen.SaveSingleKompetenzenDto;
import at.letto.data.dto.category.rechte.RechteCategoryDto;
import at.letto.data.dto.enums.RECHT;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.dto.print.PrintConfDto;
import at.letto.edit.dto.conf.AbosDto;
import at.letto.lehrplan.dto.kompetenz.KompetenzSchulstufeDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.LehrerKlasseService;
import at.letto.lettoedit.service.RechteService;
import at.letto.lettoedit.service.config.ConfigService;
import at.letto.security.LettoToken;
import at.letto.tools.JSON;
import at.letto.tools.Listen;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.MsgException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    private ConfigService configService;
    private RechteService rechteService;
    private LehrerKlasseService lehrerKlasseService;
    private MicroServiceConfiguration microServiceConfiguration;
    private ModelMapper modelMapper = new ModelMapper();
    private ConcurrentMap<String, CategoryDTO> rootMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ConcurrentMap<Integer, CategoryDTO>> idsCategoriesPerSchool = new ConcurrentHashMap();
    private ConcurrentMap<Integer, KompetenzSchulstufeDto> themenMap = new ConcurrentHashMap();

    public CategoryService(@Lazy ConfigService configService, @Lazy RechteService rechteService, @Lazy LehrerKlasseService lehrerKlasseService, @Lazy MicroServiceConfiguration microServiceConfiguration) {
        this.configService = configService;
        this.rechteService = rechteService;
        this.microServiceConfiguration = microServiceConfiguration;
        this.lehrerKlasseService = lehrerKlasseService;
    }

    private void addSchool(LettoToken token) {
        RestLettoDataService dataservice = this.microServiceConfiguration.getDataService(token);
        CategoryDTO root = new CategoryDTO();
        DtoAndMsg ret = dataservice.category.loadAllCategories();
        List cats = (List)ret.getData();
        cats.stream().filter(c -> c.getIdParent() == null).collect(Collectors.toList()).forEach(c -> c.setIdParent(Integer.valueOf(-1)));
        List idsThemen = cats.stream().filter(c -> c.getIdKompetenz() != null && c.getIdKompetenz() > 0).map(c -> c.getIdKompetenz()).distinct().collect(Collectors.toList());
        ConcurrentHashMap themen = new ConcurrentHashMap();
        this.themenMap.putAll(themen);
        Map map = cats.stream().collect(Collectors.groupingBy(CategoryDTO::getIdParent, LinkedHashMap::new, Collectors.toList()));
        HashMap emptyChildren = new HashMap();
        HashMap<Integer, CategoryDTO> emptyParents = new HashMap<Integer, CategoryDTO>();
        for (Integer idPar : map.keySet()) {
            if (idPar == null) continue;
            CategoryDTO p = null;
            if (emptyChildren.containsKey(idPar)) {
                p = (CategoryDTO)emptyChildren.get(idPar);
                emptyChildren.remove(idPar);
            } else {
                p = new CategoryDTO();
                p.setId(idPar.intValue());
                p.setCategories(new ArrayList());
                if (idPar == -1) {
                    System.out.println(idPar);
                }
                emptyParents.put(idPar, p);
            }
            CategoryDTO p1 = p;
            ((List)map.get(idPar)).forEach(c -> {
                p1.getCategories().add(c);
                c.setParent(p1);
                if (emptyParents.containsKey(c.getId())) {
                    c.setCategories(((CategoryDTO)emptyParents.get(c.getId())).getCategories());
                    c.getCategories().forEach(ch -> ch.setParent(c));
                    emptyParents.remove(c.getId());
                } else {
                    emptyChildren.put(c.getId(), c);
                }
            });
        }
        root = (CategoryDTO)((CategoryDTO)emptyParents.get(-1)).getCategories().get(0);
        ConcurrentMap<Integer, CategoryDTO> idsCategories = cats.stream().collect(Collectors.toConcurrentMap(CategoryDTO::getId, c -> c, (c1, c2) -> c1));
        this.idsCategoriesPerSchool.put(token.getSchool(), idsCategories);
        this.rootMap.put(token.getSchool(), root);
    }

    public CategoryDTO loadRoot(LettoToken token) {
        if (!this.rootMap.containsKey(token.getSchool())) {
            this.addSchool(token);
        }
        if (!this.rootMap.containsKey(token.getSchool())) {
            throw new MsgException("schoolNotLoaded");
        }
        return (CategoryDTO)this.rootMap.get(token.getSchool());
    }

    public List<String> loadUsers(LettoToken token) {
        CategoryDTO root = this.loadRoot(token);
        Vector ret = new Vector();
        return root.getCategories().stream().map(c -> c.getCategories()).flatMap(Collection::stream).filter(cat -> !cat.isGlobalCategory()).map(c -> c.getName()).collect(Collectors.toSet()).stream().sorted().collect(Collectors.toList());
    }

    public List<String> loadMainCategs(LettoToken token) {
        CategoryDTO root = this.loadRoot(token);
        return root.getCategories().stream().map(c -> c.getName()).collect(Collectors.toList());
    }

    public CategoryTreeDto loadTreeFromCat(LettoToken token) {
        int idUser = token.getIdUser();
        String username = token.getUsername();
        CategoryDTO root = this.loadRoot(token);
        AbosDto abo = null;
        try {
            String aboUser = this.configService.loadString("abos", token);
            abo = (AbosDto)JSON.jsonToObj((String)aboUser, AbosDto.class);
        }
        catch (Exception aboUser) {
            // empty catch block
        }
        List<Object> aboUsers = new Vector();
        List<Object> aboCategs = new Vector();
        boolean showSchuljahre = true;
        if (abo != null) {
            if (abo.isUseAbosUsers()) {
                aboUsers = Arrays.stream(abo.getAboUsers().split(",")).collect(Collectors.toList());
            }
            if (abo.isUseAbosCategory()) {
                aboCategs = Arrays.stream(abo.getAboCategories().split(",")).collect(Collectors.toList());
            }
            showSchuljahre = !abo.isUseCurrentYear();
        }
        CategoryTreeDto main = new CategoryTreeDto();
        this.modelMapper.map((Object)root, (Object)main);
        this.iterateCategs(main, 0, aboCategs, aboUsers, token);
        return main;
    }

    public CategoryTreeDto loadTreeFromCat(int idCat, LettoToken token) {
        int idUser = token.getIdUser();
        String username = token.getUsername();
        CategoryDTO root = this.loadCat(token, idCat);
        Vector aboUsers = new Vector();
        Vector aboCategs = new Vector();
        CategoryTreeDto main = new CategoryTreeDto();
        this.modelMapper.map((Object)root, (Object)main);
        this.iterateCategs(main, -1, aboCategs, aboUsers, token);
        return main;
    }

    private int iterateCategs(CategoryTreeDto ziel, int level, List<String> themen, List<String> users, LettoToken token) {
        if (ziel.getIdKompetenz() != null && ziel.getIdKompetenz() > 0) {
            String komp = this.themenMap.get(ziel.getIdKompetenz()) != null ? ((KompetenzSchulstufeDto)this.themenMap.get(ziel.getIdKompetenz())).getKompetenz() : "";
            ziel.setKompetenz(komp);
        }
        String username = token.getUsername();
        int sumQuestions = 0;
        Iterator iter = ziel.getCategories().iterator();
        while (iter.hasNext()) {
            CategoryTreeDto child = (CategoryTreeDto)iter.next();
            switch (level) {
                case -1: {
                    break;
                }
                case 0: {
                    if (themen == null || themen.size() <= 0 || themen.contains(child.getName())) break;
                    iter.remove();
                    break;
                }
                case 1: {
                    if (users == null || users.size() == 0 || users.contains(child.getName()) || username.equals(child.getName())) {
                        boolean isUser = username.toLowerCase().equals(child.getName().toLowerCase());
                        RechteCategoryDto r = this.rechteService.findRecht(child.getId(), token);
                        if (r == null) {
                            r = new RechteCategoryDto();
                        }
                        child.setChange(isUser || r.isChange() || ziel.isChange());
                        child.setDelete(isUser || r.isDelete() || ziel.isDelete());
                        child.setInsert(isUser || r.isInsert() || ziel.isChange());
                        break;
                    }
                    iter.remove();
                    break;
                }
                default: {
                    RechteCategoryDto r = this.rechteService.findRecht(child.getId(), token);
                    if (r == null) {
                        r = new RechteCategoryDto();
                    }
                    child.setChange(r.isChange() || ziel.isChange());
                    child.setDelete(r.isDelete() || ziel.isDelete());
                    child.setInsert(r.isInsert() || ziel.isInsert());
                }
            }
            sumQuestions += this.iterateCategs(child, level >= 0 ? level + 1 : level, themen, users, token);
        }
        if (level < 2 && level >= 0) {
            ziel.getCategories().sort(new /* Unavailable Anonymous Inner Class!! */);
        }
        sumQuestions = (int)((long)sumQuestions + ziel.getQuestionsInCategory());
        ziel.setSumQuestions(sumQuestions);
        return sumQuestions;
    }

    public CategoryTreeDto insertCategory(int idParent, String name, int pos, LettoToken token) {
        int idUser = token.getIdUser();
        String username = token.getUsername();
        if (!this.checkRecht(idParent, RECHT.EINFUEGEN, name, token)) {
            throw new MsgException("cat.noInsertRight");
        }
        CategoryDTO parent = this.loadCat(token, idParent);
        if (parent == null) {
            throw new MsgException("cat.notFound");
        }
        DtoAndMsg res = this.microServiceConfiguration.getDataService((LettoToken)token).category.insertCategory(idParent, name, pos);
        CategoryDTO c = (CategoryDTO)DtoAndMsg.get((DtoAndMsg)res);
        if (c == null) {
            return null;
        }
        c.setParent(parent);
        ((ConcurrentMap)this.idsCategoriesPerSchool.get(token.getSchool())).put(c.getId(), c);
        CategoryTreeDto cat = new CategoryTreeDto();
        this.modelMapper.map((Object)c, (Object)cat);
        if (pos < 0 || pos >= parent.getCategories().size()) {
            parent.getCategories().add(c);
        } else {
            parent.getCategories().add(pos, c);
        }
        cat.setInsert(this.checkRecht(idParent, RECHT.EINFUEGEN, name, token));
        cat.setChange(this.checkRecht(idParent, RECHT.AENDERN, name, token));
        cat.setDelete(this.checkRecht(idParent, RECHT.LOESCHEN, name, token));
        return cat;
    }

    public String renameCategory(int id, String name, LettoToken token) {
        if (!this.checkRecht(id, RECHT.AENDERN, "", token)) {
            throw new MsgException("cat.noChangeRight");
        }
        CategoryDTO cat = this.loadCat(token, id);
        if (cat == null) {
            throw new MsgException("cat.notFound");
        }
        if (this.countParents(cat) == 1 && !cat.isGlobalCategory()) {
            throw new MsgException("cat.noChangeRight");
        }
        DtoAndMsg res = this.microServiceConfiguration.getDataService((LettoToken)token).category.renameCategory(id, name);
        DtoAndMsg.check((DtoAndMsg)res);
        cat.setName(name);
        return "";
    }

    public String updateCategoryEinheit(int id, String ehKorrText, boolean eh, LettoToken token) {
        if (!this.checkRecht(id, RECHT.AENDERN, "", token)) {
            throw new MsgException("cat.noChangeRight");
        }
        CategoryDTO cat = this.loadCat(token, id);
        if (cat == null) {
            throw new MsgException("cat.notFound");
        }
        if (this.countParents(cat) == 1 && !cat.isGlobalCategory()) {
            throw new MsgException("cat.noChangeRight");
        }
        DtoAndMsg res = this.microServiceConfiguration.getDataService((LettoToken)token).category.updateCategoryEinheit(id, ehKorrText, eh);
        DtoAndMsg.check((DtoAndMsg)res);
        cat.setEinheitenKorrText(ehKorrText);
        cat.setEinheitenKorr(Boolean.valueOf(eh));
        return "";
    }

    public String deleteCategory(int id, boolean force, LettoToken token) {
        String username = token.getUsername();
        if (!this.checkRecht(id, RECHT.LOESCHEN, "", token)) {
            throw new MsgException("cat.noDelteRight");
        }
        CategoryDTO cat = this.loadCat(token, id);
        if (cat == null) {
            throw new MsgException("cat.notFound");
        }
        DtoAndMsg res = this.microServiceConfiguration.getDataService((LettoToken)token).category.deleteCategory(id, force);
        DtoAndMsg.check((DtoAndMsg)res);
        cat.getParent().getCategories().remove(cat);
        ((ConcurrentMap)this.idsCategoriesPerSchool.get(token.getSchool())).remove(cat.getId());
        this.removeChildIDs(cat.getCategories(), token.getSchool());
        return "";
    }

    private void removeChildIDs(List<CategoryDTO> childs, String school) {
        ConcurrentMap hash = (ConcurrentMap)this.idsCategoriesPerSchool.get(school);
        childs.forEach(c -> {
            if (hash.containsKey(c.getId())) {
                hash.remove(c.getId());
            }
            this.removeChildIDs(c.getCategories(), school);
        });
    }

    public String sortCategory(int id, LettoToken token) {
        String username = token.getUsername();
        if (!this.checkRecht(id, RECHT.AENDERN, "", token)) {
            throw new MsgException("cat.noChangeRight");
        }
        CategoryDTO cat = this.loadCat(token, id);
        if (cat == null) {
            throw new MsgException("cat.notFound");
        }
        cat.getCategories().sort(Comparator.comparing(CategoryDTO::getName));
        List ids = cat.getCategories().stream().map(c -> c.getId()).collect(Collectors.toList());
        DtoAndMsg res = this.microServiceConfiguration.getDataService((LettoToken)token).category.setCategoriesOrder(ids);
        DtoAndMsg.check((DtoAndMsg)res);
        return "";
    }

    public String printCategory(PrintConfDto conf, LettoToken token) {
        return "";
    }

    public String exportCategory(Integer idCategory, LettoToken token) {
        return "";
    }

    public List<CategoryKompetenzDto> loadKompetenzenForCategory(int idCategory, LettoToken token) {
        DtoAndMsg ret = this.microServiceConfiguration.getDataService((LettoToken)token).category.loadKompetenzenForCategory(idCategory);
        DtoAndMsg.check((DtoAndMsg)ret);
        return (List)ret.getData();
    }

    public String saveKompetenzenForCategory(SaveKompetenzenDto komp, LettoToken token) {
        DtoAndMsg ret = this.microServiceConfiguration.getDataService((String)token.getSchool()).category.saveKompetenzenForCategory(komp);
        DtoAndMsg.check((DtoAndMsg)ret);
        return "";
    }

    public String saveSingleKompetenzenForCategory(SaveSingleKompetenzenDto komp, LettoToken token) {
        if (!this.themenMap.containsKey(komp.getIdThema())) {
            Vector<Integer> ids = new Vector<Integer>();
            ids.add(komp.getIdThema());
            this.themenMap.putAll(this.microServiceConfiguration.getLehrplanService().loadKompetenzen(ids).getThemen().stream().collect(Collectors.toMap(k -> k.getId(), k -> k, (k1, k2) -> k1)));
        }
        DtoAndMsg ret = this.microServiceConfiguration.getDataService((LettoToken)token).category.saveSingleKompetenz(komp);
        DtoAndMsg.check((DtoAndMsg)ret);
        ((CategoryDTO)((ConcurrentMap)this.idsCategoriesPerSchool.get(token.getSchool())).get(komp.getIdCategory())).setIdKompetenz(Integer.valueOf(komp.getIdThema()));
        return "";
    }

    public String moveCateg(int idCat, int idZiel, int pos, LettoToken token) {
        int idUser = token.getIdUser();
        String idSchule = token.getSchool();
        String username = token.getUsername();
        CategoryDTO cat = this.loadCat(token, idCat);
        CategoryDTO ziel = this.loadCat(token, idZiel);
        CategoryDTO parent = this.loadCat(token, cat.getIdParent().intValue());
        if (!this.checkRecht(ziel, RECHT.EINFUEGEN, "", token)) {
            throw new MsgException("noInsRights");
        }
        if (!this.checkRecht(parent, RECHT.LOESCHEN, "", token)) {
            throw new MsgException("noDelRights");
        }
        CategoryDTO c = ziel;
        while (c.getIdParent() != null && c.getIdParent() > 0 && (c = this.loadCat(token, c.getIdParent().intValue())) != null) {
            if (c.getId() != cat.getId()) continue;
            throw new MsgException("zirkelbezug");
        }
        parent.getCategories().remove(cat);
        int anz = ziel.getCategories().size();
        if (pos < anz && pos >= 0) {
            ziel.getCategories().add(pos, cat);
        } else {
            ziel.getCategories().add(cat);
        }
        Listen.sortColumn((List)ziel.getCategories(), CategoryDTO::setOrderCol);
        DtoAndMsg.check((DtoAndMsg)this.microServiceConfiguration.getDataService((LettoToken)token).category.moveCateg(cat.getId(), ziel.getId(), ziel.getCategories().stream().map(cx -> cx.getId()).collect(Collectors.toList())));
        return "";
    }

    private boolean checkRecht(CategoryDTO c, RECHT recht, String name, LettoToken token) {
        String username = token.getUsername().toLowerCase();
        if (c == null) {
            return false;
        }
        if (token.isAdmin() && this.countParents(c) == 2) {
            return true;
        }
        if (username.equals(name) && this.countParents(c) == 3) {
            return true;
        }
        while (c.getParent() != null) {
            if (this.checkRechtDetail(c, recht, token)) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    private int countParents(CategoryDTO c) {
        CategoryDTO cat = c;
        int anz = 0;
        while (cat.getParent() != null) {
            cat = cat.getParent();
            ++anz;
        }
        return anz;
    }

    public boolean checkRecht(int idCat, RECHT recht, String name, LettoToken token) {
        int idUser = token.getIdUser();
        String idSchule = token.getSchool();
        return this.checkRecht(this.loadCat(token, idCat), recht, name, token);
    }

    public boolean checkRechtDetail(CategoryDTO c, RECHT recht, LettoToken token) {
        String username = token.getUsername().toLowerCase();
        if (c.getName().equals(username)) {
            return true;
        }
        RechteCategoryDto r = this.rechteService.findRecht(c.getId(), token);
        if (r == null) {
            r = new RechteCategoryDto();
        }
        if (recht == RECHT.AENDERN) {
            return r.isChange();
        }
        if (recht == RECHT.LOESCHEN) {
            return r.isDelete();
        }
        if (recht == RECHT.EINFUEGEN) {
            return r.isInsert();
        }
        return false;
    }

    public CategoryDTO loadCat(LettoToken token, int idCategory) {
        try {
            return (CategoryDTO)((ConcurrentMap)this.idsCategoriesPerSchool.get(token.getSchool())).get(idCategory);
        }
        catch (Exception e) {
            this.addSchool(token);
            try {
                return (CategoryDTO)((ConcurrentMap)this.idsCategoriesPerSchool.get(token.getSchool())).get(idCategory);
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    public String clearCaches(LettoToken token) {
        if (this.rootMap.containsKey(token.getSchool())) {
            this.rootMap.remove(token.getSchool());
        }
        if (this.idsCategoriesPerSchool.containsKey(token.getSchool())) {
            this.idsCategoriesPerSchool.remove(token.getSchool());
        }
        if (this.themenMap.containsKey(token.getSchool())) {
            this.themenMap.remove(token.getSchool());
        }
        this.lehrerKlasseService.clearCache(token);
        return "";
    }
}

