/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.data.dto.question.ChangePenaltyDto;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.question.QuestionTextHistoryDTO;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.dto.question.list.QuestionUsedInTestsDTO;
import at.letto.data.dto.question.list.SaveQuestionDto;
import at.letto.data.dto.question.search.QuestionSearchDto;
import at.letto.data.restclient.RestLettoDataService;
import at.letto.data.restclient.data.RestQuestion;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.QuestionListService;
import at.letto.lettoedit.service.QuestionService;
import at.letto.security.LettoToken;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class QuestionController {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    QuestionService questionService;
    @Autowired
    QuestionListService questionListService;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "QuestionController");

    private RestLettoDataService data() {
        return this.microServiceConfiguration.getDataService(this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/question/insert_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> insertQuestion(@RequestBody Map<String, String> vals) {
        QuestionType typ = QuestionType.getType((String)vals.get("typ"));
        int idCat = Integer.parseInt(vals.get("idCat"));
        String name = vals.get("name");
        int pos = Integer.parseInt(vals.get("pos"));
        int idLinkQuestion = Integer.parseInt(vals.get("idLinkQuestion"));
        QuestionDTO qu = new QuestionDTO();
        this.questionService.changeQuestionType(qu, typ);
        if (typ == QuestionType.LinkedQuestion) {
            qu.setIdUser((long)idLinkQuestion);
        } else {
            qu.setIdUser((long)this.loadToken().getIdUser().intValue());
        }
        qu.setName(name);
        qu.setIdCategory(idCat);
        return this.r.getResponse(QuestionService::insertQuestion, (Object)this.questionService, (Object)qu, (Object)pos, (Object)idLinkQuestion, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/question/sort_question_list"})
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> sortQuestions(@RequestBody Map<String, String> vals) {
        int idCat = Integer.parseInt(vals.get("idCat"));
        int idTest = Integer.parseInt(vals.get("idTest"));
        return this.r.getRespData(RestQuestion::sortQuestions, (Object)this.data().question, (Object)idCat, (Object)idTest);
    }

    @PostMapping(value={"/edit/api/teacher/question/sort_questions_in_database"})
    public ResponseEntity<DtoAndMsg<String>> sortInDatabase(@RequestBody List<QuestionListDTO> list) {
        return this.r.getRespErrData(RestQuestion::sortInDatabase, (Object)this.data().question, list);
    }

    @PostMapping(value={"/edit/api/teacher/question/delete_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> deleteQuestion(@RequestBody Map<String, String> vals) {
        int idCat = Integer.parseInt(vals.get("idCategory"));
        int idQuest = Integer.parseInt(vals.get("idQuestion"));
        return this.r.getResponse(QuestionService::deleteQuestion, (Object)this.questionService, (Object)idQuest, (Object)idCat, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/question/load_used_tests"})
    public ResponseEntity<DtoAndMsg<List<QuestionUsedInTestsDTO>>> loadUsedTestsForQuestion(@RequestBody Integer id) {
        return this.r.getRespData(RestQuestion::loadUsedTestsForQuestion, (Object)this.data().question, (Object)id);
    }

    @PostMapping(value={"/edit/api/teacher/question/clone_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> cloneQuestion(@RequestBody Map<String, String> vals) {
        int idQuestion = Integer.parseInt(vals.get("idQuestion"));
        int idCategory = Integer.parseInt(vals.get("idCategory"));
        int pos = Integer.parseInt(vals.get("pos"));
        return this.r.getResponse(QuestionService::cloneQuestion, (Object)this.questionService, (Object)idQuestion, (Object)idCategory, (Object)pos, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/question/move_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> moveQuestion(@RequestBody Map<String, String> vals) {
        int idQuestion = Integer.parseInt(vals.get("idQuestion"));
        int idCategory = Integer.parseInt(vals.get("idCategory"));
        int pos = Integer.parseInt(vals.get("pos"));
        return this.r.getResponse(QuestionService::moveQuestion, (Object)this.questionService, (Object)idQuestion, (Object)idCategory, (Object)pos, (Object)this.loadToken());
    }

    @CrossOrigin
    @PostMapping(value={"/edit/api/teacher/question/load_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> loadQuestion(@RequestBody Integer id) {
        return this.r.getResponse(QuestionService::loadQuestion, (Object)this.questionService, (Object)id, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/question/save_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> saveQuestion(@RequestBody SaveQuestionDto dto) {
        return this.r.getResponse(QuestionService::saveQuestion, (Object)this.questionService, (Object)dto, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/question/load_in_category"})
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> loadQuestionsInCategory(@RequestBody Map<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idCateg = Integer.parseInt(vals.get("idCateg"));
        return this.r.getResponse(QuestionListService::loadQuestionsInCategory, (Object)this.questionListService, (Object)idCateg, (Object)idTest, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/question/load_texthistory"})
    public ResponseEntity<DtoAndMsg<List<QuestionTextHistoryDTO>>> loadHistory(@RequestBody Integer id) {
        return this.r.getRespData(RestQuestion::loadHistory, (Object)this.data().question, (Object)id);
    }

    @PostMapping(value={"/edit/api/teacher/question/save_texthistory"})
    public ResponseEntity<DtoAndMsg<String>> saveHistory(@RequestBody QuestionTextHistoryDTO questionTextHistoryDTO) {
        return this.r.getRespErrData(RestQuestion::saveHistory, (Object)this.data().question, (Object)questionTextHistoryDTO);
    }

    @PostMapping(value={"/edit/api/teacher/question/search_question"})
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> searchQuestion(@RequestBody QuestionSearchDto search) {
        return this.r.getRespData(RestQuestion::searchQuestion, (Object)this.data().question, (Object)search);
    }

    @PostMapping(value={"/edit/api/teacher/question/change_penalty"})
    public ResponseEntity<DtoAndMsg<String>> changePenalty(@RequestBody ChangePenaltyDto dto) {
        return this.r.getRespErrData(RestQuestion::changePenalty, (Object)this.data().question, (Object)dto);
    }

    private LettoToken loadToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (LettoToken)authentication.getDetails();
    }
}

