/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.lettoedit.config.TomcatConfiguration;
import at.letto.tools.rest.ResponseToolsObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MainHttpController {
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    ApplicationContext applicationContext;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "MainHttpController");

    @GetMapping(value={""})
    public String indexForm(Model model) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String username = "World";
        try {
            username = ((User)auth.getPrincipal()).getUsername();
        }
        catch (Exception exception) {
            // empty catch block
        }
        model.addAttribute("message", (Object)"Hallo Welt!");
        model.addAttribute("user", (Object)username);
        model.addAttribute("tasks", (Object)this);
        return "indexmodel";
    }

    @RequestMapping(value={"/edit/auth/login"})
    public String login(Model model) {
        return "login";
    }

    @RequestMapping(value={"/edit/open/home"})
    public String home(Model model) {
        return "home";
    }

    @RequestMapping(value={"/edit/open/hello"})
    public String hello(Model model) {
        return "hello";
    }

    @RequestMapping(value={"/edit/api/admin/dashboard"})
    public String dashboard(Model model) {
        model.addAttribute("username", (Object)this.getusername());
        model.addAttribute("tasks", (Object)this);
        return "dashboard";
    }

    private String getusername() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        try {
            return ((User)auth.getPrincipal()).getUsername();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean hasRole(String role) {
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            for (GrantedAuthority a : auth.getAuthorities()) {
                if (!a.toString().equals("ROLE_" + role.toUpperCase())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isUser() {
        return this.hasRole("user");
    }

    public boolean isGast() {
        return this.hasRole("gast");
    }

    public boolean isAdmin() {
        return this.hasRole("admin");
    }

    public boolean isLetto() {
        return this.hasRole("letto");
    }

    public TomcatConfiguration getTomcatConfiguration() {
        return this.tomcatConfiguration;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ResponseToolsObject getR() {
        return this.r;
    }

    public void setTomcatConfiguration(TomcatConfiguration tomcatConfiguration) {
        this.tomcatConfiguration = tomcatConfiguration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setR(ResponseToolsObject r) {
        this.r = r;
    }
}

