/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lettoedit.controller;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.category.CategoryTreeDto;
import at.letto.data.dto.category.kompetenzen.CategoryKompetenzDto;
import at.letto.data.dto.category.kompetenzen.SaveKompetenzenDto;
import at.letto.data.dto.category.kompetenzen.SaveSingleKompetenzenDto;
import at.letto.data.dto.category.rechte.RechteCategoryDto;
import at.letto.data.dto.category.rechte.SaveRechteDto;
import at.letto.dto.print.PrintConfDto;
import at.letto.lettoedit.config.MicroServiceConfiguration;
import at.letto.lettoedit.service.CategoryService;
import at.letto.lettoedit.service.RechteService;
import at.letto.security.LettoToken;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class CategoryController {
    @Autowired
    CategoryService treeService;
    @Autowired
    RechteService rechteService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    private ResponseToolsObject r = new ResponseToolsObject("Letto-(Edit)-Service", "CategoryController");

    @PostMapping(value={"/edit/api/teacher/category_edit/load_users"})
    public ResponseEntity<DtoAndMsg<List<String>>> loadUsers() {
        return this.r.getResponse(CategoryService::loadUsers, (Object)this.treeService, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/load_main_categs"})
    public ResponseEntity<DtoAndMsg<List<String>>> loadMainCategs() {
        return this.r.getResponse(CategoryService::loadMainCategs, (Object)this.treeService, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/load_categ"})
    public ResponseEntity<DtoAndMsg<CategoryDTO>> loadCategory(@RequestBody Integer id) {
        return this.r.getResponse(CategoryService::loadCat, (Object)this.treeService, (Object)this.loadToken(), (Object)id);
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/load_tree"})
    public ResponseEntity<DtoAndMsg<CategoryTreeDto>> loadTree() {
        return this.r.getResponse(CategoryService::loadTreeFromCat, (Object)this.treeService, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/load_tree_from_cat"})
    public ResponseEntity<DtoAndMsg<CategoryTreeDto>> loadTreeFromCat(@RequestBody Integer idCat) {
        return this.r.getResponse(CategoryService::loadTreeFromCat, (Object)this.treeService, (Object)idCat, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/insert_category"})
    public ResponseEntity<DtoAndMsg<CategoryTreeDto>> insertCategory(@RequestBody Map<String, String> vals) {
        int idParent = Integer.parseInt(vals.get("idParent"));
        String name = vals.get("name");
        int pos = Integer.parseInt(vals.get("idParent"));
        return this.r.getResponse(CategoryService::insertCategory, (Object)this.treeService, (Object)idParent, (Object)name, (Object)pos, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/cat_einheit"})
    public ResponseEntity<DtoAndMsg<String>> updateCategoryEinheit(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        String ehKorr = vals.get("ehKorr");
        boolean eh = vals.get("eh").equals("true");
        return this.r.getErrResponse(CategoryService::updateCategoryEinheit, (Object)this.treeService, (Object)id, (Object)ehKorr, (Object)eh, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/rename_category"})
    public ResponseEntity<DtoAndMsg<String>> renameCategory(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        String name = vals.get("name");
        return this.r.getErrResponse(CategoryService::renameCategory, (Object)this.treeService, (Object)id, (Object)name, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/delete_category"})
    public ResponseEntity<DtoAndMsg<String>> deleteCategory(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        boolean force = vals.get("force").equals("true");
        return this.r.getErrResponse(CategoryService::deleteCategory, (Object)this.treeService, (Object)id, (Object)force, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/sort_category_force"})
    public ResponseEntity<DtoAndMsg<String>> sorCategory(@RequestBody Integer id) {
        return this.r.getErrResponse(CategoryService::sortCategory, (Object)this.treeService, (Object)id, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/move_category"})
    public ResponseEntity<DtoAndMsg<String>> moveCategory(@RequestBody Map<String, String> vals) {
        int idCat = Integer.parseInt(vals.get("idCat"));
        int idZiel = Integer.parseInt(vals.get("idZiel"));
        int pos = Integer.parseInt(vals.get("pos"));
        return this.r.getErrResponse(CategoryService::moveCateg, (Object)this.treeService, (Object)idCat, (Object)idZiel, (Object)pos, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/print_category"})
    public ResponseEntity<DtoAndMsg<String>> printCategory(@RequestBody PrintConfDto conf) {
        return this.r.getResponse(CategoryService::printCategory, (Object)this.treeService, (Object)conf, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/export_category"})
    public ResponseEntity<DtoAndMsg<String>> exportCategory(@RequestBody Integer id) {
        return this.r.getErrResponse(CategoryService::exportCategory, (Object)this.treeService, (Object)id, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/load_rechte_category"})
    public ResponseEntity<DtoAndMsg<List<RechteCategoryDto>>> loadRechteForCategory(@RequestBody Integer id) {
        return this.r.getResponse(RechteService::findRechteForCategory, (Object)this.rechteService, (Object)id, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/save_rechte_category"})
    public ResponseEntity<DtoAndMsg<String>> saveRechteForCategory(@RequestBody SaveRechteDto rechte) {
        return this.r.getErrResponse(RechteService::changeRechteForCategory, (Object)this.rechteService, (Object)rechte.getIdCategory(), (Object)rechte.getRechte(), (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/load_kompetenzen_category"})
    public ResponseEntity<DtoAndMsg<List<CategoryKompetenzDto>>> loadKompetenzenForCategory(@RequestBody Integer id) {
        return this.r.getResponse(CategoryService::loadKompetenzenForCategory, (Object)this.treeService, (Object)id, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/save_kompetenz_category"})
    public ResponseEntity<DtoAndMsg<String>> saveKompetenzenForCategory(@RequestBody SaveKompetenzenDto komp) {
        return this.r.getErrResponse(CategoryService::saveKompetenzenForCategory, (Object)this.treeService, (Object)komp, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/category_edit/single_kompetenz_category"})
    public ResponseEntity<DtoAndMsg<String>> saveSingleKompetenzenForCategory(@RequestBody SaveSingleKompetenzenDto komp) {
        return this.r.getErrResponse(CategoryService::saveSingleKompetenzenForCategory, (Object)this.treeService, (Object)komp, (Object)this.loadToken());
    }

    @PostMapping(value={"/edit/api/teacher/clear_caches"})
    public ResponseEntity<DtoAndMsg<String>> clearCaches() {
        return this.r.getErrResponse(CategoryService::clearCaches, (Object)this.treeService, (Object)this.loadToken());
    }

    private LettoToken loadToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (LettoToken)authentication.getDetails();
    }
}

