/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.tests;

import at.letto.data.dto.activity.ActivityBaseDto;
import at.letto.data.dto.activity.ActivityChangeDto;
import at.letto.data.dto.activity.ActivityDto;
import at.letto.data.dto.beurteilung.TestDTO;
import at.letto.data.dto.enums.GroupModes;
import at.letto.data.dto.gruppierung.GruppierungsDto;
import at.letto.data.dto.gruppierung.InitTestInfoDto;
import at.letto.data.dto.testVersuch.MarkVersuchDto;
import at.letto.data.dto.tests.FragenGruppierung;
import at.letto.data.dto.tests.SelectEmptyTestsDTO;
import at.letto.data.dto.tests.TestBereichDetailsDto;
import at.letto.data.dto.tests.TestBereichDto;
import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.TestEigenschaftsDto;
import at.letto.data.dto.tests.TestFrageDto;
import at.letto.data.dto.tests.TestGruppeDto;
import at.letto.data.dto.tests.TestInhaltDto;
import at.letto.data.dto.tests.TestVersuchDto;
import at.letto.data.dto.tests.TestsBaseDto;
import at.letto.data.dto.tests.score.TestDetailAndAnswer;
import at.letto.data.dto.tests.score.TestScoreDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.ActivitytypeEntity;
import at.letto.data.entity.BeurteilungsartGlobalEntity;
import at.letto.data.entity.FragengruppeEntity;
import at.letto.data.entity.InetlinksEntity;
import at.letto.data.entity.KlasseEntity;
import at.letto.data.entity.LehrerKlasseEntity;
import at.letto.data.entity.QuestionEntity;
import at.letto.data.entity.TestAntwortEntity;
import at.letto.data.entity.TestDetailsEntity;
import at.letto.data.entity.TestFrageEntity;
import at.letto.data.entity.TestGruppeEntity;
import at.letto.data.entity.TestVersuchEntity;
import at.letto.data.entity.TestsEntity;
import at.letto.data.entity.UserEntity;
import at.letto.data.repository.ActivityEntityRepository;
import at.letto.data.repository.TestsEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.beurteilung.BeurteilungConfigService;
import at.letto.data.service.question.QuestionService;
import at.letto.data.service.tests.AdaptHelper;
import at.letto.data.service.tests.Reihenfolge;
import at.letto.data.service.tests.TestDetailServiceDatabase;
import at.letto.data.service.tests.TestsServiceDatabase;
import at.letto.globalinterfaces.IdEntity;
import at.letto.tools.ChangeLists;
import at.letto.tools.Cmd;
import at.letto.tools.JSON;
import at.letto.tools.LicenseKey;
import at.letto.tools.Listen;
import at.letto.tools.VectorTools;
import at.letto.tools.enums.QuestionType;
import at.letto.tools.rest.MsgException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestsServiceDatabase {
    @Autowired
    TestsEntityRepository testsRepository;
    @Autowired
    AllRepositories allRepositories;
    @Autowired
    QuestionService questionService;
    @Autowired
    BeurteilungConfigService beurtConfService;
    @Autowired
    TestDetailServiceDatabase tdService;
    @Inject
    private EntityManager em;
    private ModelMapper modelMapper = new ModelMapper();
    private List<ActivitytypeEntity> activityTypes;
    public static final String prepareProtokols = "/opt/letto/preparetest/";

    @PostConstruct
    public void init() {
        this.activityTypes = this.allRepositories.activitytypeEntityRepository.findAll();
    }

    public List<SelectEmptyTestsDTO> selectTestsForCreateVersuche(int idLk, Date date, List<Integer> beurteilungsartGlobals) {
        return this.testsRepository.findTestsForCreateVersuch(date, idLk, beurteilungsartGlobals);
    }

    public List<SelectEmptyTestsDTO> findOpenVersuche(int idLk, Date date, List<Integer> beurteilungsartGlobals) {
        return this.testsRepository.findOpenVersuche(date, idLk, beurteilungsartGlobals);
    }

    public Optional<TestDTO> changeGewichtungTest(TestDTO testDTO) {
        AtomicReference tRet = new AtomicReference();
        this.testsRepository.findById((Object)testDTO.getIdTest()).ifPresent(t -> {
            t.setGewichtung(testDTO.getGewicht());
            TestsEntity ret = (TestsEntity)this.testsRepository.save(t);
            tRet.set(ret);
        });
        return Optional.of(testDTO);
    }

    public TestGruppeEntity getBereich(TestFrageEntity f) {
        if (f.getTestGruppe() == null) {
            return null;
        }
        if (f.getTestGruppe().getParent() != null) {
            return f.getTestGruppe();
        }
        return null;
    }

    public double calcTestSum(TestGruppeEntity g) {
        double sum = 0.0;
        Vector<FragengruppeEntity> groups = new Vector<FragengruppeEntity>();
        Iterator iter = g.getTestFragen().iterator();
        while (iter.hasNext()) {
            TestFrageEntity tf = (TestFrageEntity)iter.next();
            if (tf == null) {
                iter.remove();
                continue;
            }
            if (tf.getGruppeVonFragen() == null) {
                sum += tf.getPoints();
                continue;
            }
            if (groups.contains(tf.getGruppeVonFragen())) continue;
            groups.add(tf.getGruppeVonFragen());
            sum += tf.getPoints() * (double)tf.getGruppeVonFragen().getAnzahl().intValue();
        }
        return sum;
    }

    public double getPoints(TestDetailsEntity td) {
        double pts = td.getFrage().getPoints();
        try {
            TestGruppeEntity bereich = this.getBereich(td.getFrage());
            if (bereich != null) {
                pts *= bereich.getProzentBereich() / this.calcTestSum(bereich);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pts;
    }

    public TestAntwortEntity getLastAnswer(TestDetailsEntity td) {
        return td.getTestAntworten().size() > 0 ? (TestAntwortEntity)td.getTestAntworten().get(0) : null;
    }

    private TestVersuchEntity rescoreAndDelTestanswer(TestVersuchEntity v) {
        boolean closeVersuch = true;
        boolean rescoreTestFragen = false;
        double punkteIst = 0.0;
        double punkteMax = 0.0;
        String fehler = "";
        for (TestDetailsEntity td : v.getTestDetails()) {
            TestAntwortEntity a = this.getLastAnswer(td);
            td.getTestAntworten().clear();
            double soll = this.getPoints(td);
            double ist = a != null ? a.getPoints() : 0.0;
            punkteMax += soll;
            punkteIst += ist <= soll ? ist : soll;
        }
        v.setPunkteIst(Double.valueOf(punkteIst));
        if (punkteMax > 0.0) {
            v.setPunkteSoll(Double.valueOf(punkteMax));
        } else {
            v.setPunkteSoll(Double.valueOf(this.calcTestSum(v.getGruppe())));
        }
        if (closeVersuch) {
            v.setFinished(Boolean.valueOf(true));
        }
        return v;
    }

    public List<Integer> findTestVersucheInTimePeriod(Date searchStart, Date searchEnd, int idLk) {
        return this.testsRepository.findTestVersucheInTimePeriod(searchStart, searchEnd, idLk);
    }

    public void markTestVersuchInDb(int idVersuch, boolean used) {
        this.testsRepository.markTestVersuchInDb(idVersuch, used ? 1 : 0);
    }

    public void markTestVersucheInDb(List<Integer> idVersuche, boolean used) {
        this.testsRepository.markTestVersuchInDb(idVersuche, used ? 1 : 0);
    }

    public void markTestVersuch(int idTest, int idUser, boolean anonym) {
        List versuche = this.allRepositories.testVersuchEntityRepository.loadMarkVers(idTest, idUser);
        GroupModes mode = this.testsRepository.loadGruppenModus(idTest);
        if (versuche.size() == 1 && !anonym) {
            if (((MarkVersuchDto)versuche.get(0)).isUsedForKatalog()) {
                return;
            }
            this.markTestVersuchInDb(((MarkVersuchDto)versuche.get(0)).getIdTestVersuch(), true);
            return;
        }
        List ids = versuche.stream().map(v -> v.getIdTestVersuch()).collect(Collectors.toList());
        this.markTestVersucheInDb(versuche.stream().map(v -> v.getIdTestVersuch()).collect(Collectors.toList()), false);
        if (anonym) {
            return;
        }
        MarkVersuchDto mark = null;
        try {
            switch (1.$SwitchMap$at$letto$data$dto$enums$GroupModes[mode.ordinal()]) {
                case 1: {
                    mark = versuche.stream().filter(v -> v.getDatum() != null).max(Comparator.comparing(MarkVersuchDto::calcProzent)).get();
                    break;
                }
                case 2: {
                    mark = versuche.stream().filter(v -> v.getDatum() != null).min(Comparator.comparing(MarkVersuchDto::getDatum)).get();
                    break;
                }
                case 3: {
                    mark = versuche.stream().filter(v -> v.getDatum() != null).max(Comparator.comparing(MarkVersuchDto::getDatum)).get();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mark != null) {
            this.markTestVersuchInDb(mark.getIdTestVersuch(), true);
        }
    }

    public String getNameDate(ActivityEntity a) {
        try {
            return a.getName() + " (" + LicenseKey.df.format(a.getTest().getTestDatum()) + ")";
        }
        catch (Exception e) {
            return a.getName();
        }
    }

    private String getNamePath(ActivityEntity a, boolean nameWithDate) {
        Object path = nameWithDate ? this.getNameDate(a) : a.getName();
        for (int max = 0; a.getParentFolder() != null && max < 5; ++max) {
            a = a.getParentFolder();
            path = a.getName() + "/" + (String)path;
        }
        return path;
    }

    public String getFilePath(int idActivity) {
        return this.allRepositories.activityEntityRepository.findById((Object)idActivity).map(a -> {
            LehrerKlasseEntity lk = a.getLehrerKlasse();
            if (lk == null) {
                return "";
            }
            KlasseEntity k = lk.getKlasse();
            if (k == null) {
                return "";
            }
            Object path = k.getSchuljahr().getName().replaceAll("\\/", "-") + "/" + k.getName() + "/" + lk.getGegenstand().getName() + "/" + this.getNamePath(a, false);
            path = Cmd.renamePath((String)path);
            return path;
        }).orElse("");
    }

    public String getTestPrepareFile(int idActivity) {
        return prepareProtokols + this.getFilePath(idActivity) + "/prepareQuestions.html";
    }

    public String saveTestVersuchStartPos(int idVersuch, String pos) {
        this.testsRepository.updateTestVersuchStartPos(idVersuch, pos);
        return "";
    }

    public String saveTestDetail(int id, String json, String fb) {
        this.testsRepository.updateTestDetail(id, json, fb);
        return "";
    }

    public String updateTestVersuchProtokoll(int idVersuch, String protokoll) {
        this.testsRepository.updateTestVersuchProtokoll(idVersuch, protokoll);
        return "";
    }

    private TestVersuchEntity mapToEntity(TestVersuchDto testVersuchDto) {
        TestVersuchEntity v = testVersuchDto.getId() > 0 ? this.allRepositories.testVersuchEntityRepository.findTestVersuchById(testVersuchDto.getId()).orElse(new TestVersuchEntity()) : new TestVersuchEntity();
        TestsEntity t = this.allRepositories.testVersuchEntityRepository.findTestById(testVersuchDto.getIdTest()).orElse(null);
        if (t == null) {
            throw new RuntimeException("Zugeh\u00f6render Test wurde in DB nicht gefunden!");
        }
        v.setTest(t);
        if (testVersuchDto.getIdUser() != 0) {
            UserEntity u = this.allRepositories.userEntityRepository.findById((Object)testVersuchDto.getIdUser()).orElse(null);
            if (u == null) {
                throw new RuntimeException("Zugeh\u00f6render Benutzer wurde in DB nicht gefunden!");
            }
            v.setUser(u);
        } else {
            v.setUser(null);
        }
        TestGruppeEntity tg = this.allRepositories.testVersuchEntityRepository.findTestGruppeById(testVersuchDto.getIdTestGruppe()).orElse((TestGruppeEntity)t.getTestGruppe().get(0));
        if (tg == null) {
            throw new RuntimeException("Zugeh\u00f6rende Testgruppe wurde in DB nicht gefunden!");
        }
        v.setGruppe(tg);
        v.setFinished(Boolean.valueOf(testVersuchDto.isFinished()));
        v.setPunkteIst(testVersuchDto.getPunkteIst());
        v.setPunkteSoll(testVersuchDto.getPunkteSoll());
        v.setStartdatum(testVersuchDto.getStartDatum());
        v.setStopdatum(testVersuchDto.getStopDatum());
        v.setFocusLost(Boolean.valueOf(testVersuchDto.isFocusLost()));
        v.setFocusLostCleared(Boolean.valueOf(testVersuchDto.isFocusLostCleared()));
        v.setFocusLostProtokoll(testVersuchDto.getFocusLostProtokoll());
        v.setIndexStartQuestion(testVersuchDto.getIndexStartQuestion());
        v.setOpenTestTime(Integer.valueOf(testVersuchDto.getOpenTestTime()));
        v.setUsedForKatalog(Boolean.valueOf(testVersuchDto.isUsedForKatalog()));
        v.setPunkteSoll(Double.valueOf(this.calcTestSum(tg)));
        v.setReihenfolge(testVersuchDto.getReihenfolge());
        return v;
    }

    public TestVersuchDto saveTestVersuch(TestVersuchDto testVersuchDto, boolean anonym) {
        TestVersuchEntity v = this.mapToEntity(testVersuchDto);
        this.allRepositories.testVersuchEntityRepository.save((Object)v);
        this.markTestVersuch(testVersuchDto.getIdTest(), testVersuchDto.getIdUser(), anonym);
        return testVersuchDto;
    }

    public String saveTestVersuchProperties(TestVersuchDto testVersuchDto) {
        this.allRepositories.testVersuchEntityRepository.updateTestVersuch(testVersuchDto);
        return "";
    }

    public TestEigenschaftsDto loadTestEigenschaften(int idTest) {
        TestEigenschaftsDto t = (TestEigenschaftsDto)this.testsRepository.findTestEigenschaftenById(idTest).get();
        if (t == null) {
            return null;
        }
        this.testsRepository.findLicenseForTest(t.getIdLk()).ifPresent(l -> t.setLicenseKey(new LicenseKey(l)));
        if (t.getIdLk() <= 0) {
            if (t.getIdKlassenbeurteilung() > 0) {
                t.setIdLk(this.findIdLkBeurteilung(t.getIdKlassenbeurteilung()).intValue());
            }
            if (t.getIdBeurteilung() > 0) {
                t.setIdLk(this.findIdLkBeurteilung(t.getIdBeurteilung()).intValue());
            }
        }
        return t;
    }

    public ActivityDto saveTest(ActivityChangeDto change) {
        ActivityEntity a = this.saveTestTransaction(change);
        ActivityBaseDto act = this.allRepositories.activityEntityRepository.loadById(a.getId());
        ActivityDto actDto = new ActivityDto();
        this.modelMapper.map((Object)act, (Object)actDto);
        return actDto;
    }

    public ActivityEntity prepareActivityEntity(int idActivity, int idLk, int idParentFolder, ActivityChangeDto.CHANGE_MODE mode) {
        if (idActivity > 0) {
            Optional ax = this.allRepositories.activityEntityRepository.findById((Object)idActivity);
            if (!ax.isPresent()) {
                throw new MsgException("act.err.activity_not_found");
            }
            return (ActivityEntity)ax.get();
        }
        ActivitytypeEntity actTyp = this.findType(mode.toString());
        ActivityEntity a = new ActivityEntity();
        a.setActivityType(actTyp);
        if (idParentFolder > 0) {
            ActivityEntity parent = (ActivityEntity)this.allRepositories.activityEntityRepository.findById((Object)idParentFolder).get();
            if (parent == null) {
                throw new MsgException("errNoParentActivity");
            }
            a.setParentFolder(parent);
            a.getActivities().add(a);
            a.setFolderOrder(Integer.valueOf(parent.getActivities().size()));
        } else {
            LehrerKlasseEntity lk = (LehrerKlasseEntity)this.allRepositories.lehrerKlasseEntityRepository.findById((Object)idLk).get();
            if (lk == null) {
                throw new MsgException("errLkNotFound");
            }
            a.setLehrerKlasse(lk);
            a.setLkOrder(Integer.valueOf(lk.getActivities().size()));
        }
        a.setIdLk(Integer.valueOf(idLk));
        return a;
    }

    @Transactional
    public ActivityEntity saveTestTransaction(ActivityChangeDto change) {
        TestInhaltDto testInhalt = change.getTestInhalt();
        TestEigenschaftsDto test = testInhalt.getTestEigenschaften();
        ActivityEntity a = this.prepareActivityEntity(change.getIdAct(), change.getIdLk(), change.getIdParentFolder(), change.getMode());
        TestsEntity t = test.getIdAcitiviy() > 0 ? a.getTest() : new TestsEntity();
        t.setActivity(a);
        a.setTest(t);
        this.adaptTestGruppen(t, testInhalt);
        a.setName(test.getName());
        a.setVisible(Boolean.valueOf(test.isVisible()));
        this.modelMapper.map((Object)test, (Object)t);
        BeurteilungsartGlobalEntity ba = this.allRepositories.beurteilungsartGlobalEntityRepository.loadBeurteilungsartOnline(test.getMode());
        t.setMode(ba);
        if (t.getId() == 0) {
            t.setId(null);
        }
        int pos = a.getParentFolder() != null ? a.getFolderOrder() : a.getLkOrder();
        if ((a = (ActivityEntity)this.allRepositories.activityEntityRepository.save((Object)a)).getParentFolder() != null) {
            this.allRepositories.activityEntityRepository.setFolderPos(a.getId(), pos);
        } else {
            this.allRepositories.activityEntityRepository.setLkPos(a.getId(), pos);
        }
        if (test.getIdBeurteilung() > 0) {
            ActivityEntity finalA = a;
            this.allRepositories.beurteilungEntityRepository.findById((Object)test.getIdBeurteilung()).ifPresent(b -> {
                b.setActivity(finalA);
                this.allRepositories.beurteilungEntityRepository.save(b);
            });
        }
        if (test.getIdKlassenbeurteilung() > 0) {
            ActivityEntity finalA1 = a;
            this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)test.getIdBeurteilung()).ifPresent(kb -> {
                kb.setActivity(finalA1);
                this.allRepositories.klassenbeurteilungEntityRepository.save(kb);
            });
        }
        return a;
    }

    public static List<TestFrageDto> loadTestfragen(TestBereichDto b) {
        return b.getGruppierungen().stream().map(gr -> gr.getTestFragen()).flatMap(Collection::stream).sorted(Comparator.comparing(TestFrageDto::getPosInGruppe)).collect(Collectors.toList());
    }

    private void adaptBereich(TestGruppeEntity gr, TestBereichDto b) {
        gr.getBereiche().clear();
        gr.setGruppenName(b.getName());
        gr.setProzentBereich(Double.valueOf(b.getProzentBereich()));
        gr.setProzentForPositiv(Double.valueOf(b.getProzentForPositiv()));
        Set idsGruppierungen = b.getGruppierungen().stream().map(gru -> gru.getIdGruppierung()).filter(id -> id > 0).collect(Collectors.toSet());
        List gruppierungen = this.allRepositories.fragengruppeEntityRepository.findAllById(idsGruppierungen);
        List ent = gr.getTestFragen();
        Map<Integer, TestFrageEntity> tfMap = gr.getTestFragen().stream().collect(Collectors.toMap(tf -> tf.getId(), tf -> tf));
        ent.clear();
        for (FragenGruppierung g : b.getGruppierungen()) {
            FragengruppeEntity gruppierung = (FragengruppeEntity)Listen.get((List)gruppierungen, (int)g.getIdGruppierung());
            if (gruppierung == null && g.getIdGruppierung() != 0) {
                gruppierung = new FragengruppeEntity();
            }
            if (gruppierung != null) {
                if (g.getIdGruppierung() < 0) {
                    gruppierung.setId(null);
                }
                gruppierung.setAnzahl(Integer.valueOf(g.getAnz()));
                gruppierung.getTestFragen().clear();
            }
            for (TestFrageDto tf2 : g.getTestFragen()) {
                TestFrageEntity tAdd = tfMap.containsKey(tf2.getId()) ? tfMap.get(tf2.getId()) : new TestFrageEntity();
                ent.add(tAdd);
                tAdd.setTestGruppe(gr);
                tAdd.setPoints(tf2.getPoints());
                tAdd.setOrderColumn(tf2.getPosInGruppe());
                tAdd.setGruppeVonFragen(gruppierung);
                if (gruppierung != null) {
                    gruppierung.getTestFragen().add(tAdd);
                }
                if (tAdd.getQuestion() != null && tAdd.getQuestion().getId().intValue() == tf2.getIdQuestion()) continue;
                this.allRepositories.questionEntityRepository.findById((Object)tf2.getIdQuestion()).ifPresent(q -> tAdd.setQuestion(q));
            }
        }
        ent.sort(Comparator.comparing(TestFrageEntity::getOrderColumn));
    }

    private void adaptTestGruppe(TestGruppeEntity g, TestGruppeDto dto) {
        g.setGruppenName(dto.getGruppenName());
        if (dto.getBereiche().size() == 1) {
            this.adaptBereich(g, (TestBereichDto)dto.getBereiche().get(0));
        } else {
            List ent = g.getBereiche();
            Map<Integer, TestGruppeEntity> gMap = g.getBereiche().stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
            ent.clear();
            for (TestBereichDto b : dto.getBereiche()) {
                TestGruppeEntity bereich = gMap.containsKey(b.getId()) ? gMap.get(b.getId()) : new TestGruppeEntity();
                bereich.setParent(g);
                ent.add(bereich);
                this.adaptBereich(bereich, b);
            }
        }
    }

    private void adaptTestGruppen(TestsEntity t, TestInhaltDto test) {
        int anz = test.getTestGruppen().size();
        ChangeLists ret = Listen.detectChanges((List)test.getTestGruppen(), (List)t.getTestGruppe());
        ret.getDel().forEach(d -> Listen.remove((List)t.getTestGruppe(), (IdEntity)d));
        ret.getAdd().forEach(a -> {
            TestGruppeEntity g = new TestGruppeEntity();
            g.setTest(t);
            g.setGruppenName(a.getGruppenName());
            t.getTestGruppe().add(g);
            this.adaptTestGruppe(g, a);
        });
        for (TestGruppeDto g : test.getTestGruppen()) {
            if (g.getId() <= 0) continue;
            TestGruppeEntity grEnt = (TestGruppeEntity)Listen.get((List)t.getTestGruppe(), (int)g.getId());
            this.adaptTestGruppe(grEnt, g);
        }
    }

    private void adaptGruppenToBereich(TestsEntity t, String testBereich) {
        if (testBereich == null) {
            testBereich = "";
        }
        String[] bereicheArray = testBereich.split(",");
        int len = testBereich.isEmpty() ? 0 : bereicheArray.length;
        for (TestGruppeEntity g : t.getTestGruppe()) {
            if (g.getTestFragen().size() > 0) {
                throw new MsgException("In einer Testgruppe sind Fragen definiert! Bereiche k\u00f6nnen nur dann angelegt werden, wenn alle Testgruppen keine Fragen enthalten!");
            }
            if (g.getBereiche().size() <= len) continue;
            boolean empty = true;
            for (int i = len; i < g.getBereiche().size(); ++i) {
                if (((TestGruppeEntity)g.getBereiche().get(0)).getTestFragen().size() <= 0) continue;
                empty = false;
            }
            if (!empty) {
                throw new MsgException("Es sind zu viele Bereiche f\u00fcr diese Definition in der aktuellen Testgruppe definiert! Bitte korrigieren Sie zuerst die Bereiche in den Testgruppen!");
            }
            while (len < g.getBereiche().size()) {
                g.getBereiche().remove(len);
            }
        }
        int i = 0;
        if (len == 0) {
            return;
        }
        for (String ber : bereicheArray) {
            String[] x = ber.split("-");
            String bereich = x[0];
            double proz = 0.0;
            double minProz = 0.0;
            try {
                proz = Double.parseDouble(x[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                minProz = Double.parseDouble(x[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (TestGruppeEntity g : t.getTestGruppe()) {
                TestGruppeEntity b;
                if (g.getBereiche().size() >= i + 1) {
                    b = (TestGruppeEntity)g.getBereiche().get(i);
                } else {
                    b = new TestGruppeEntity();
                    b.setParent(g);
                    b.setGruppenName(g.getGruppenName());
                    g.getBereiche().add(b);
                }
                b.setGruppenName(bereich);
                b.setProzentBereich(Double.valueOf(proz));
                b.setProzentForPositiv(Double.valueOf(minProz));
            }
            ++i;
        }
    }

    public ActivityChangeDto saveActivity(ActivityChangeDto act) {
        ActivityEntity a = null;
        ActivityEntityRepository actRepo = this.allRepositories.activityEntityRepository;
        int id = act.getIdAct();
        if (id > 0) {
            try {
                a = (ActivityEntity)actRepo.findById((Object)id).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (a == null) {
                throw new MsgException("act.err.activity_not_found");
            }
        } else {
            Optional par;
            a = new ActivityEntity();
            if (act.getIdParentFolder() > 0 && (par = actRepo.findById((Object)act.getIdParentFolder())).isPresent()) {
                ActivityEntity parent = (ActivityEntity)par.get();
                a.setParentFolder(parent);
                Long maxOrder = this.allRepositories.activityEntityRepository.loadMaxActivitiesOrder(parent.getId());
                long max = maxOrder == null ? -1L : maxOrder;
                a.setFolderOrder(Integer.valueOf((int)max + 1));
            }
            if (a.getParentFolder() == null) {
                LehrerKlasseEntity lk = (LehrerKlasseEntity)this.allRepositories.lehrerKlasseEntityRepository.findById((Object)act.getIdLk()).get();
                if (lk == null) {
                    throw new MsgException("act_err_LK_not_found");
                }
                a.setLehrerKlasse(lk);
                Long maxOrder = this.allRepositories.lehrerKlasseEntityRepository.loadMaxActivitiesOrder(lk.getId().intValue());
                long max = maxOrder == null ? -1L : maxOrder;
                a.setLkOrder(Integer.valueOf((int)max + 1));
            }
        }
        a.setName(act.getName());
        a.setVisible(Boolean.valueOf(act.isVisible()));
        a.setIdLk(Integer.valueOf(act.getIdLk()));
        switch (1.$SwitchMap$at$letto$data$dto$activity$ActivityChangeDto$CHANGE_MODE[act.getMode().ordinal()]) {
            case 1: {
                InetlinksEntity l;
                if (a.getInetLink() == null) {
                    l = new InetlinksEntity();
                    l.setActivity(a);
                    a.setInetLink(l);
                } else {
                    l = a.getInetLink();
                }
                l.setLinkAdress(act.getLink());
                a.setActivityType(this.findType("InetLink"));
                break;
            }
            case 2: {
                QuestionEntity q = act.getIdQuestion() > 0 ? (QuestionEntity)this.allRepositories.questionEntityRepository.findById((Object)act.getIdQuestion()).get() : null;
                a.setQuestion(q);
                a.setActivityType(this.findType("HtmlQuestion"));
                break;
            }
            case 3: {
                a.setActivityType(this.findType("Folder"));
            }
        }
        a = (ActivityEntity)this.allRepositories.activityEntityRepository.save((Object)a);
        act.setRetVal(this.toActivityDto(a));
        return act;
    }

    private ActivityDto toActivityDto(ActivityEntity a) {
        ActivityDto ret = new ActivityDto();
        ret.setId(Integer.valueOf(a.getId()));
        ret.setName(a.getName());
        ret.setIDLK(a.getIdLk());
        ret.setIdLehrerKlasse(Integer.valueOf(a.getLehrerKlasse() != null ? a.getLehrerKlasse().getId() : 0));
        ret.setIdParentFolder(Integer.valueOf(a.getParentFolder() != null ? a.getParentFolder().getId() : 0));
        ret.setIdLink(Integer.valueOf(a.getInetLink() != null ? a.getInetLink().getId() : 0));
        ret.setIdTest(Integer.valueOf(a.getTest() != null ? a.getTest().getId() : 0));
        ret.setIdDokument(Integer.valueOf(a.getDokument() != null ? a.getDokument().getId() : 0));
        ret.setIdBeurteilung(Integer.valueOf(a.getBeurteilung() != null ? a.getBeurteilung().getId() : 0));
        ret.setIdKlassenbeurteilung(Integer.valueOf(a.getKlassenBeurteilung() != null ? a.getKlassenBeurteilung().getId() : 0));
        ret.setIdProject(Integer.valueOf(a.getProject() != null ? a.getProject().getId() : 0));
        ret.setIdQuestion(Integer.valueOf(a.getQuestion() != null ? a.getQuestion().getId() : 0));
        ret.setVisible(Boolean.valueOf(a.getVisible() != null ? a.getVisible() : false));
        ret.setTyp(a.getActivityType().getDescription());
        ret.setPos(a.getParentFolder() != null ? a.getFolderOrder() : a.getLkOrder());
        ret.setIdActivityTyp(a.getActivityType().getId());
        ret.setErstellerId(a.getErstellerId());
        ret.setImg(a.getActivityType().getImageName());
        return ret;
    }

    private ActivitytypeEntity findType(String typ) {
        return this.activityTypes.stream().filter(t -> t.getDescription().toLowerCase().equals(typ.toLowerCase())).findFirst().get();
    }

    public TestInhaltDto loadTestInhaltFromDatabase(int idTest) {
        List gruppen = this.testsRepository.findTestGruppen(idTest);
        List bereiche = this.testsRepository.findTestBereiche(idTest);
        Map<Integer, List<TestBereichDto>> bereichsHash = bereiche.stream().collect(Collectors.groupingBy(b -> b.getIdGruppe()));
        gruppen.forEach(g -> {
            if (bereichsHash.containsKey(g.getId())) {
                g.getBereiche().addAll((Collection)bereichsHash.get(g.getId()));
            } else {
                TestBereichDto b = new TestBereichDto();
                b.setId(g.getId());
                g.getBereiche().add(b);
                b.setName(g.getGruppenName());
                bereiche.add(b);
            }
        });
        Map<Integer, TestBereichDto> bereichsMap = bereiche.stream().collect(Collectors.toMap(b -> b.getId(), b -> b, (b1, b2) -> b1));
        List testfragen = this.testsRepository.findTestFragen(bereichsMap.keySet());
        Map<Integer, List<TestFrageDto>> gr = testfragen.stream().collect(Collectors.groupingBy(TestFrageDto::getGruppierung));
        int i = 0;
        for (TestFrageDto f : testfragen) {
            f.setPosInGruppe(Integer.valueOf(i++));
        }
        testfragen.stream().collect(Collectors.groupingBy(TestFrageDto::getIdTestGruppe)).values().forEach(g -> g.stream().collect(Collectors.groupingBy(TestFrageDto::getGruppierung)).values().stream().map(b -> b.stream().findFirst().map(tf -> {
            FragenGruppierung gruppe = new FragenGruppierung();
            gruppe.setIdGruppe(tf.getIdTestGruppe());
            gruppe.setIdGruppierung(tf.getGruppierung());
            gruppe.setAnz(tf.getAnzahlInGruppe());
            gruppe.setPoints(tf.getAnzahlInGruppe() > 0 ? tf.getPoints() : 0.0);
            gruppe.setTestFragen(b);
            return gruppe;
        }).orElse(null)).filter(x -> x != null).forEach(x -> {
            if (bereichsMap.containsKey(x.getIdGruppe())) {
                ((TestBereichDto)bereichsMap.get(x.getIdGruppe())).getGruppierungen().add(x);
            }
        }));
        TestEigenschaftsDto eigenschaften = this.loadTestEigenschaften(idTest);
        if (eigenschaften == null) {
            throw new MsgException("Test konnte nicht gefunden werden! id: " + idTest);
        }
        eigenschaften.setPathToDocuments(this.getFilePath(eigenschaften.getIdAcitiviy()));
        return new TestInhaltDto(idTest, gruppen, eigenschaften);
    }

    public String stopTest(int idTest, Date stopdate, boolean stop) {
        this.testsRepository.changeStop(idTest, stopdate, stop);
        return "";
    }

    public TestVersuchDto loadTestVersuchComplete(int idVersuch, TestInhaltDto t) {
        TestVersuchDto v = this.loadTestVersuchSimple(idVersuch);
        this.loadDetailsInTestVersuch(v, t);
        this.adaptTestVersuch(v, t);
        return v;
    }

    public TestVersuchDto loadTestVersuchSimple(int idTestversuch) {
        return this.testsRepository.findTestVersuchDto(idTestversuch).orElse(null);
    }

    public List<TestVersuchDto> loadTestVersucheSimple(int idTest) {
        return this.testsRepository.findTestVersucheByTestId(idTest);
    }

    public TestVersuchDto adaptTestVersuch(TestVersuchDto v, TestInhaltDto t) {
        int idGruppe = v.getIdTestGruppe();
        TestGruppeDto gruppe = t.getTestGruppen().stream().filter(g -> g.getId() == idGruppe).findFirst().orElse(t.getTestGruppen().stream().findFirst().orElse(null));
        if (gruppe == null) {
            throw new RuntimeException("Testgruppe wurde nicht gefunden");
        }
        if (v.getBereiche().size() != gruppe.getBereiche().size()) {
            v.setBereiche(gruppe.getBereiche().stream().map(b -> new TestBereichDetailsDto(b.getName(), b.getProzentBereich(), b.getProzentForPositiv())).collect(Collectors.toList()));
        }
        List del = AdaptHelper.findQuestonsToRemove((TestVersuchDto)v, (TestGruppeDto)gruppe);
        List add = AdaptHelper.findQuestonsToAdd((TestVersuchDto)v, (TestGruppeDto)gruppe);
        if (del.size() == 0 && add.size() == 0) {
            return null;
        }
        TestVersuchEntity vEnt = this.mapToEntity(v);
        vEnt.getTestDetails().removeAll(vEnt.getTestDetails().stream().filter(t_d -> del.contains(t_d.getFrage().getId())).collect(Collectors.toList()));
        StringBuilder errMsg = new StringBuilder();
        add.forEach(idTf -> {
            TestFrageEntity f = this.allRepositories.testVersuchEntityRepository.findTestFrageEntity(idTf.intValue()).orElse(null);
            if (f == null) {
                errMsg.append("Testfrage-ID:" + idTf + " wurde nicht gefunden!\n");
            } else {
                TestDetailsEntity td = new TestDetailsEntity();
                td.setFrage(f);
                td.setTestVersuch(vEnt);
                int x = f.getQuestion().getRandomDataset() != false ? -1 : VectorTools.random((int)0, (int)40);
                QuestionEntity q = f.getQuestion();
                td.setSelektor(Integer.valueOf(x));
                vEnt.getTestDetails().add(td);
            }
        });
        List idsFragen = vEnt.getTestDetails().stream().map(td -> td.getFrage().getId()).collect(Collectors.toList());
        v.setReihenfolge(Reihenfolge.getReihenfolge((TestGruppeDto)gruppe, (TestInhaltDto)t, idsFragen));
        vEnt.setReihenfolge(v.getReihenfolge());
        TestVersuchEntity vsave = (TestVersuchEntity)this.allRepositories.testVersuchEntityRepository.save((Object)vEnt);
        v.setId(vsave.getId().intValue());
        this.loadDetailsInTestVersuch(v, t);
        return v;
    }

    public TestVersuchDto loadDetailsInTestVersuch(TestVersuchDto v, TestInhaltDto test) {
        List details = this.allRepositories.testDetailsEntityRepository.findTestDetailsByTestVersuchsId(v.getId());
        details.forEach(td -> {
            try {
                td.setTestAntwort((TestAntwortDto)JSON.jsonToObj((String)td.getTestAntwortJson(), TestAntwortDto.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return this.loadDetailsInTestVersuch(v, test, details, true);
    }

    public TestVersuchDto loadDetailsInTestVersuch(TestVersuchDto v, TestInhaltDto test, List<TestDetailDto> details, boolean sort) {
        if (details == null) {
            return v;
        }
        TestGruppeDto gr = test.getTestGruppen().stream().filter(g -> g.getId() == v.getIdTestGruppe()).findFirst().orElse((TestGruppeDto)test.getTestGruppen().get(0));
        if (gr == null) {
            throw new RuntimeException("Testgruppe konnte nicht gefunden werden!");
        }
        Map<Integer, TestDetailDto> tdMap = details.stream().collect(Collectors.toMap(td -> td.getIdTestFrage(), td -> td, (td1, td2) -> td1));
        List bereiche = gr.getBereiche().stream().map(b -> {
            TestBereichDetailsDto ber = new TestBereichDetailsDto(b.getName(), b.getProzentBereich(), b.getProzentForPositiv());
            List idsTestfragenInBereich = b.getGruppierungen().stream().map(x -> x.getTestFragen()).flatMap(Collection::stream).map(tf -> tf.getId()).collect(Collectors.toList());
            ber.setTestDetails(details.stream().filter(td -> idsTestfragenInBereich.contains(td.getIdTestFrage())).collect(Collectors.toList()));
            return ber;
        }).collect(Collectors.toList());
        try {
            int i = 0;
            for (String r : v.getReihenfolge().split(";")) {
                if (bereiche.size() <= i) continue;
                Reihenfolge.sortTestBereich((TestBereichDetailsDto)((TestBereichDetailsDto)bereiche.get(i++)), (String)r);
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        v.setBereiche(bereiche);
        int idNext = 0;
        for (int i = v.getBereiche().size() - 1; i >= 0; --i) {
            TestBereichDetailsDto b2 = (TestBereichDetailsDto)v.getBereiche().get(i);
            for (int j = b2.getTestDetails().size() - 1; j >= 0; --j) {
                TestDetailDto td3 = (TestDetailDto)b2.getTestDetails().get(j);
                td3.setNextDetailId(idNext);
                idNext = td3.getId();
            }
        }
        return v;
    }

    @Transactional
    protected Integer findIdLkBeurteilung(int id) {
        return this.allRepositories.beurteilungEntityRepository.findParentBeurteilung(id).map(b -> b.getLehrerKlasse().getId()).orElse(0);
    }

    public String changeGewichtungTest(int idTest, double gewicht) {
        this.testsRepository.changeGewichtung(idTest, gewicht);
        return "";
    }

    public int getAnzahlFragenInTestversuch(int idTestversuch) {
        int s1 = (int)this.testsRepository.getAnzahlFragenOhneGruppen(idTestversuch);
        int x = this.testsRepository.getAnzahlFragenInGruppen(idTestversuch).stream().collect(Collectors.summingInt(Integer::intValue));
        return s1 + x;
    }

    public String delTestVersuch(int idVersuch) {
        TestVersuchEntity v = (TestVersuchEntity)this.allRepositories.testVersuchEntityRepository.findById((Object)idVersuch).get();
        if (v == null) {
            throw new MsgException("Testversuch wurde in DB nicht gefunden");
        }
        this.allRepositories.testVersuchEntityRepository.delete((Object)v);
        return "";
    }

    public String delTestFrage(int idTestfrage) {
        this.allRepositories.testFrageEntityRepository.deleteById((Object)idTestfrage);
        return "";
    }

    public String updateTestFragePoints(int idTestfrage, double points) {
        this.allRepositories.testFrageEntityRepository.updateTestFragePoints(idTestfrage, points);
        return "";
    }

    public String updateTestFragePointsInGruppe(int idGruppierung, double points) {
        this.allRepositories.testFrageEntityRepository.updateGruppierungPoints(idGruppierung, points);
        return "";
    }

    @Transactional
    public String sortTestfragenInDatabase(List<TestFrageDto> tfs) {
        String upd = Listen.sqlUpdateSort(tfs, TestFrageDto::getPosInGruppe);
        String sql = "INSERT into testFrage (id, testFragen_ORDER) VALUES " + upd + " ON DUPLICATE KEY UPDATE testFragen_ORDER = VALUES(testFragen_ORDER);";
        this.em.createNativeQuery(sql).executeUpdate();
        return "";
    }

    public String isolateTestFrage(List<TestFrageDto> testfragen) {
        for (TestFrageDto tf : testfragen) {
            if (tf.getIdCategory() <= 0) continue;
            int idneu = this.questionService.cloneQuestion(tf.getIdQuestion());
            Vector<Integer> ids = new Vector<Integer>();
            ids.add(tf.getId());
            this.allRepositories.testFrageEntityRepository.changeQuestionInTestfrage(ids, idneu);
        }
        return "";
    }

    @Transactional
    public Integer groupingTestFragen(List<Integer> idsTestfragen, int anzahl, int nr) {
        List tfs = this.allRepositories.testFrageEntityRepository.findAllById(idsTestfragen);
        FragengruppeEntity gruppierung = new FragengruppeEntity();
        gruppierung.setAnzahl(Integer.valueOf(anzahl));
        gruppierung.setNr(Integer.valueOf(nr));
        gruppierung.setTestFragen(tfs);
        FragengruppeEntity finalGruppierung = gruppierung = (FragengruppeEntity)this.allRepositories.fragengruppeEntityRepository.save((Object)gruppierung);
        tfs.forEach(tf -> {
            tf.setGruppeVonFragen(finalGruppierung);
            tf.setPoints(((TestFrageEntity)tfs.get(0)).getPoints());
        });
        return gruppierung.getId();
    }

    public String updateGruppierungPoints(int idGruppierung, int anzahl) {
        this.allRepositories.fragengruppeEntityRepository.updateGruppierungPoints(idGruppierung, anzahl);
        return "";
    }

    public String removeTestfageFromGruppierung(int idTestfrage) {
        this.allRepositories.testFrageEntityRepository.removeTestfageFromGruppierung(idTestfrage);
        return "";
    }

    public String removeGruppierung(int idGruppierung) {
        this.allRepositories.testFrageEntityRepository.removeAllTestfagenFromGruppierung(idGruppierung);
        this.allRepositories.fragengruppeEntityRepository.deleteById((Object)idGruppierung);
        return "";
    }

    public InitTestInfoDto loadInitTestInfo(int idTest, int idParentFolder, int idLk) {
        TestsEntityRepository testRepo = this.allRepositories.testsEntityRepository;
        InitTestInfoDto testInfoDto = new InitTestInfoDto();
        ActivityBaseDto a = null;
        try {
            a = this.allRepositories.activityEntityRepository.loadByTestId(idTest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (a != null) {
            idLk = a.getIDLK();
            idParentFolder = a.getIdParentFolder();
        }
        List inFolder = idParentFolder > 0 ? testRepo.loadTestInFolder(idParentFolder) : testRepo.loadTestsInLk(idLk);
        testInfoDto.setTestsInFolder(inFolder);
        Vector<GruppierungsDto> gruppierungen = new Vector<GruppierungsDto>();
        for (TestsBaseDto t : inFolder) {
            boolean found = false;
            for (GruppierungsDto gr : gruppierungen) {
                if (t.getIdGruppierung() == null || gr.getId() != t.getIdGruppierung().intValue()) continue;
                gr.getTests().add(t);
                found = true;
                break;
            }
            if (found) continue;
            GruppierungsDto gr = new GruppierungsDto();
            gr.setId(0);
            gr.getTests().add(t);
            gruppierungen.add(gr);
        }
        testInfoDto.setGruppierungen(gruppierungen);
        List testTypes = testRepo.loadTestTypes(idLk);
        testInfoDto.setTestTypes(testTypes);
        testInfoDto.setOnlineTests(this.allRepositories.beurteilungsartGlobalEntityRepository.loadOnlineTests());
        return testInfoDto;
    }

    @Transactional
    public String insertTestQuestion(int idGruppe, List<Integer> idQuestions) {
        TestGruppeEntity g = (TestGruppeEntity)this.allRepositories.testGruppeEntityRepository.findById((Object)idGruppe).get();
        List qs = this.allRepositories.questionEntityRepository.findAllById(idQuestions);
        if (g == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Integer idQestion : idQuestions) {
            Long idQuest;
            int id;
            Optional qOpt;
            QuestionEntity q = QuestionService.search((List)qs, (int)idQestion);
            if (q.getQuestionType() == QuestionType.LinkedQuestion && (qOpt = this.allRepositories.questionEntityRepository.findById((Object)(id = (idQuest = q.getIdUser()) != null ? (int)idQuest.longValue() : 0))).isPresent()) {
                q = (QuestionEntity)qOpt.get();
            }
            TestFrageEntity tf = new TestFrageEntity();
            tf.setQuestion(q);
            tf.setTestGruppe(g);
            tf.setPoints(q.getPunkte().doubleValue());
            g.getTestFragen().add(tf);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(q.getName());
        }
        this.allRepositories.testGruppeEntityRepository.save((Object)g);
        return sb.toString();
    }

    public List<TestDetailAndAnswer> loadTestAnswersJsonFromVersuch(int idVersuch) {
        List answers = this.allRepositories.testDetailsEntityRepository.findTestAnswersByTestVersuchsId(idVersuch);
        return answers;
    }

    @Transactional
    public String scoreTestVersuch(TestScoreDto scoreVersuch) {
        String sql = "INSERT INTO testDetails     (id, TESTANTWORTJSON)    VALUES " + scoreVersuch.getAnswer().stream().map(a -> "(" + a.getIdDetail() + ",'" + JSON.objToJson((Object)a) + "')").collect(Collectors.joining(",")) + "    ON DUPLICATE KEY UPDATE         TESTANTWORTJSON = VALUES(TESTANTWORTJSON);";
        this.em.createNativeQuery(sql).executeUpdate();
        scoreVersuch.getAnswer().stream().forEach(a -> this.tdService.saveStudentAnswerToDB(a));
        TestVersuchDto v = scoreVersuch.getTestVersuch();
        this.allRepositories.testVersuchEntityRepository.updateTestVersuch(v);
        return "";
    }

    public String storeProzentTestVersuch(Map<String, String> vals) {
        int idTestVersuch = Integer.parseInt(vals.get("idVersuch"));
        double proz = Double.parseDouble(vals.get("proz"));
        double ist = Double.parseDouble(vals.get("ist"));
        double soll = Double.parseDouble(vals.get("soll"));
        this.allRepositories.testVersuchEntityRepository.updateTestVersuchProzent(idTestVersuch, soll, ist);
        return "";
    }
}

