/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.tests;

import at.letto.ServerConfiguration;
import at.letto.data.dto.enums.FeedbackMode;
import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.TestEigenschaftsDto;
import at.letto.data.dto.tests.testAnswer.TestAnswerDetailDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortSqDto;
import at.letto.data.entity.DokumenteEntity;
import at.letto.data.entity.TestAnswerSubQuestionEntity;
import at.letto.data.entity.TestAntwortEntity;
import at.letto.data.entity.TestDetailsEntity;
import at.letto.data.repository.QuestionEntityRepository;
import at.letto.data.repository.TestDetailsEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.tests.TestDetailServiceDatabase;
import at.letto.globalinterfaces.ImageService;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.JSON;
import at.letto.tools.enums.Score;
import at.letto.tools.rest.MsgException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TestDetailServiceDatabase {
    @Autowired
    TestDetailsEntityRepository testDetailRepository;
    @Autowired
    QuestionEntityRepository questionRepository;
    @Autowired
    AllRepositories allRepos;
    public static final String splitCloze = "<c>";
    public static final String splitAnswer = "<n>";

    private TestEigenschaftsDto getTestBpSammlung() {
        TestEigenschaftsDto t = new TestEigenschaftsDto();
        t.setAntwortMischen(true);
        t.setFeedback(FeedbackMode.FeedbackQuestion);
        return t;
    }

    private TestAntwortDto mapToDto(TestAntwortEntity ta) {
        TestAntwortDto a = new TestAntwortDto();
        a.setId(ta.getId().intValue());
        a.setPoints(ta.getPoints() != null ? ta.getPoints() : 0.0);
        int m = ta.getManellScored();
        a.setManuellScored(m != 0);
        a.setUserReScore(ta.getUserReScore().intValue());
        a.setBewertung(ta.getBewertung());
        a.setTimestamp(ta.getTimestamp());
        a.setIdDetail(ta.getTestDetail().getId().intValue());
        String answerText = ta.getEingabe();
        if (answerText == null) {
            answerText = "";
        }
        boolean newInput = answerText.startsWith("inp:");
        answerText = answerText.replaceAll("^inp:", "");
        answerText = answerText.replaceAll("^answered", "");
        String[] ansTexte = answerText.split("<c>");
        int i = 0;
        for (TestAnswerSubQuestionEntity sub : ta.getAntwortenSubquestions()) {
            TestAntwortSqDto sqAnswer = new TestAntwortSqDto(sub.getSubQuest(), a);
            a.getSqAntworten().add(sqAnswer);
            Score sc = sub.getScored();
            if (sub.getLehrerScored().booleanValue()) {
                switch (1.$SwitchMap$at$letto$tools$enums$Score[sc.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        double soll = sub.getSoll();
                        double ist = sub.getIst();
                        if (ist > soll * 0.98) {
                            sc = Score.MEHRFACHANTWORT_OK_LEHRER;
                            break;
                        }
                        if (ist < 0.02) {
                            sc = Score.FALSCH_Lehrer;
                            break;
                        }
                        sc = Score.MEHRFACHANTWORT_TW_RICHTIG_LEHRER;
                        break;
                    }
                }
            }
            try {
                sqAnswer.setScored(sc);
                sqAnswer.setScoreText(sub.getScoreText());
                sqAnswer.setScoreInfo(sub.getScoreInfo());
                sqAnswer.setInput(sub.getAnswer());
                sqAnswer.setIst(sub.getIst());
                sqAnswer.setSoll(sub.getSoll());
                int pos = 0;
                String antwort = sub.getAnswer();
                if (Cmd.isEmpty((String)antwort) && ansTexte.length > i) {
                    antwort = ansTexte[i];
                }
                if ((pos = antwort.indexOf(":Rf")) >= 0) {
                    antwort = antwort.substring(0, pos);
                }
                ++i;
                sqAnswer.setAntworten(Arrays.stream(antwort.split("<n>", -1)).map(ax -> new TestAnswerDetailDto(ax)).collect(Collectors.toList()));
            }
            catch (Exception e) {
                newInput = false;
                break;
            }
        }
        return a;
    }

    public List<TestAntwortDto> loadLastTestAnswers(Set<Integer> ids) {
        return this.testDetailRepository.findLastTestAntworten(ids).stream().map(ta -> this.mapToDto(ta)).collect(Collectors.toList());
    }

    public List<TestAntwortDto> loadTestAntwortenForDetail(int idDetail) {
        return this.testDetailRepository.findTestAntworten(idDetail).stream().map(ta -> this.mapToDto(ta)).collect(Collectors.toList());
    }

    public Optional<TestAntwortDto> loadLastTestAntwort(int idTestDetail) {
        return this.testDetailRepository.findLastTestAntwort(idTestDetail).map(ta -> this.mapToDto(ta));
    }

    public TestAntwortDto loadLastTestAnswer(int idTestDetail) {
        return (TestAntwortDto)this.loadLastTestAntwort(idTestDetail).get();
    }

    public String saveStudentAnswerToDB(TestAntwortDto a) {
        if (a.getIdDetail() == 0) {
            throw new MsgException("ID TestDetail = 0, das darf nicht sein!");
        }
        TestDetailsEntity d = (TestDetailsEntity)this.testDetailRepository.findTestDetailEntity(a.getIdDetail()).get();
        if (d == null) {
            throw new MsgException("Testdetail wurde nicht gefunden");
        }
        TestAntwortEntity ta = this.testDetailRepository.findTestAntwort(a.getId()).orElse(new TestAntwortEntity());
        TestDetailServiceDatabase.loadTestAntwort((TestAntwortDto)a, (TestAntwortEntity)ta, (TestDetailsEntity)d);
        ta = (TestAntwortEntity)this.allRepos.testAntwortEntityRepository.save((Object)ta);
        a.setId(ta.getId().intValue());
        d.setTestAntwortJson(JSON.objToJson((Object)a));
        d = (TestDetailsEntity)this.testDetailRepository.save((Object)d);
        return "";
    }

    public static void loadTestAntwort(TestAntwortDto a, TestAntwortEntity ta, TestDetailsEntity d) {
        ta.setBewertung(a.getBewertung());
        ta.setTestDetail(d);
        ta.setPoints(Double.valueOf(a.getPoints()));
        ta.setManellScored(Integer.valueOf(a.isManuellScored() ? 1 : 0));
        ta.setTimestamp(a.getTimestamp());
        ta.setUserReScore(Integer.valueOf(a.getUserReScore()));
        ta.getAntwortenSubquestions().clear();
        ta.getAntwortenSubquestions().addAll(a.getSqAntworten().stream().map(aSq -> {
            TestAnswerSubQuestionEntity tas = new TestAnswerSubQuestionEntity();
            tas.setParent(ta);
            tas.setAnswer(TestDetailServiceDatabase.getAnswerTextSubQuest((TestAntwortSqDto)aSq));
            tas.setIst(Double.valueOf(aSq.getIst() != null ? aSq.getIst() : -1.0));
            tas.setLehrerScored(Boolean.valueOf(aSq.isLehrerScored()));
            tas.setOrigIst(aSq.getOrigIst());
            tas.setScoreAnzahl(Integer.valueOf(aSq.getScoreAnzahl()));
            tas.setScored(aSq.getScored());
            tas.setScoreInfo(aSq.getScoreInfo());
            tas.setScoreText(aSq.getScoreText());
            tas.setSoll(aSq.getSoll());
            tas.setSubQuest(aSq.getSq());
            return tas;
        }).collect(Collectors.toList()));
    }

    public static String getAnswerTextSubQuest(TestAntwortSqDto sq) {
        TestAntwortDto parent = sq.getParent();
        StringBuilder sb = new StringBuilder();
        boolean allEmpty = true;
        int i = 0;
        for (TestAnswerDetailDto a : sq.getAntworten()) {
            if (i++ > 0) {
                sb.append("<n>");
            }
            if (!Cmd.isEmpty((String)a.getInput()) && !a.getInput().equals("0")) {
                allEmpty = false;
            }
            sb.append(a.getInput());
        }
        return allEmpty ? "" : sb.toString();
    }

    public String saveTestDetailFilePath(TestDetailDto td) {
        String files = TestDetailDto.getAsString((List)td.getFiles());
        this.testDetailRepository.updateTestDetailFilePath(td.getId(), files);
        return "";
    }

    public String saveTestDetailDataset(int id, String dataset) {
        this.testDetailRepository.updateTestDetailDataset(id, dataset);
        return "";
    }

    public String saveTestDetailAnswer(int id, String json) {
        String jsonAnswer = json.replaceAll("'", "\\'").replaceAll("\\\\", "\\\\\\\\");
        this.testDetailRepository.updateTestDetailAnswer(id, jsonAnswer);
        return "";
    }

    public String saveTestDetailFeedback(int id, String feedback) {
        feedback = feedback.replaceAll("'", "\\'");
        this.testDetailRepository.updateTestDetailFeedback(id, feedback);
        return "";
    }

    public String delTestAntwort(int idTestAntwort, int idDetail) {
        long anz = this.testDetailRepository.countTestAntworten(idDetail);
        if (anz < 2L) {
            throw new RuntimeException("Es muss mehr als eine Antwort vorhanden sein. Die letze Antwort kann nicht gel\u00f6scht werden");
        }
        this.allRepos.testAntwortEntityRepository.deleteById((Object)idTestAntwort);
        this.loadLastTestAntwort(idDetail).ifPresent(a -> {
            String jsonAnswer = JSON.objToJson((Object)a);
            this.testDetailRepository.updateTestDetailAnswer(idDetail, jsonAnswer);
        });
        return "";
    }

    public String saveFeedbackFileToTestDetail(int idTestDetail, byte[] fileContent, String filename) {
        return this.testDetailRepository.findTestDetailEntity(idTestDetail).map(td -> {
            DokumenteEntity d = this.saveFileToDocument(fileContent, filename);
            td.setFeedbackDocument(d);
            String webpath = "";
            d.getFilename();
            this.testDetailRepository.save(td);
            ImageService imgService = ServerConfiguration.service.getImageService();
            return imgService.getURL(d.getMd5() + "." + d.getTyp());
        }).orElse("");
    }

    public DokumenteEntity saveFileToDocument(byte[] fileContent, String filename) {
        DokumenteEntity d = new DokumenteEntity();
        String msg = "";
        ImageService imgService = ServerConfiguration.service.getImageService();
        String ext = "";
        Matcher m = Pattern.compile(".*\\.([^\\.]+)$").matcher(filename);
        if (m.find()) {
            ext = m.toMatchResult().group(1).toLowerCase();
        }
        d.setTyp(ext);
        d.setFilesize(Long.valueOf(fileContent.length));
        d.setFilename(filename);
        if (!imgService.checkFilesystem().isEmpty()) {
            msg = "Bild konnte nicht am Filesystem abgelegt werden!";
            d.setContent(fileContent);
            d.setMd5(ENCRYPT.md5((byte[])fileContent));
        } else {
            String md5 = imgService.saveByteArrayImage(fileContent, ext);
            md5 = md5.replaceAll("\\." + ext, "");
            d.setMd5(md5);
        }
        return this.allRepos.dokumenteEntityRepository.findByMd5(d.getMd5());
    }

    public String removeFeedbackFileFromTestDetail(int idTestDetail) {
        this.testDetailRepository.findTestDetailEntity(idTestDetail).ifPresent(td -> {
            td.setFeedbackDocument(null);
            this.testDetailRepository.save(td);
        });
        return "";
    }

    public TestDetailDto loadTestDetailById(int id) {
        Optional optTd = this.testDetailRepository.findTestDetail(id);
        if (optTd.isPresent()) {
            return (TestDetailDto)optTd.get();
        }
        return null;
    }
}

