/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.question;

import at.letto.data.dto.enums.SAVEMODE;
import at.letto.data.dto.question.MoodleFileDTO;
import at.letto.data.dto.question.MoodleTextDTO;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.question.QuestionTextHistoryDTO;
import at.letto.data.dto.question.list.SaveQuestionDto;
import at.letto.data.entity.CategoryEntity;
import at.letto.data.entity.ImagesEntity;
import at.letto.data.entity.MoodleFileEntity;
import at.letto.data.entity.MoodleTextEntity;
import at.letto.data.entity.QuestionEntity;
import at.letto.data.entity.QuestiontexthistoryEntity;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.data.repository.ImagesEntityRepository;
import at.letto.data.repository.QuestionEntityRepository;
import at.letto.data.repository.QuestiontexthistoryEntityRepository;
import at.letto.data.repository.TestFrageEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.question.QuestionMapper;
import at.letto.tools.Cmd;
import at.letto.tools.rest.MsgException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionService {
    @Autowired
    private QuestiontexthistoryEntityRepository questionhistoryRepository;
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private TestFrageEntityRepository testfrageRepository;
    @Autowired
    private QuestionEntityRepository questionRepository;
    @Inject
    private EntityManager em;
    private ModelMapper modelMapper = new ModelMapper();

    public List<QuestionTextHistoryDTO> loadHistory(long idQuestion) {
        return this.questionhistoryRepository.findTextHistory((int)idQuestion);
    }

    public String saveHistory(QuestionTextHistoryDTO questionTextHistoryDTO) {
        String txt;
        int idQ = questionTextHistoryDTO.getIdQuestion();
        if (this.questionhistoryRepository.containsText(idQ, txt = questionTextHistoryDTO.getText()) > 0L) {
            return "";
        }
        QuestiontexthistoryEntity obj = questionTextHistoryDTO.getId() > 0 ? this.questionhistoryRepository.findById(questionTextHistoryDTO.getId()).orElse(new QuestiontexthistoryEntity()) : new QuestiontexthistoryEntity();
        this.modelMapper.map((Object)questionTextHistoryDTO, (Object)obj);
        this.questionhistoryRepository.save((Object)obj);
        return "";
    }

    public QuestionDTO saveQuestion(SaveQuestionDto saveQuestionDto) {
        List closedFragen;
        QuestionDTO q = saveQuestionDto.getQuestionDto();
        int idTest = saveQuestionDto.getIdTest();
        int idTestfrage = saveQuestionDto.getIdTestfrage();
        Vector<Integer> idsTestfragen = new Vector<Integer>();
        List list = closedFragen = idTest > 0 ? this.testfrageRepository.searchClosedTestQuestions(q.getId(), idTest) : this.testfrageRepository.searchClosedTestQuestions(q.getId());
        if (idTestfrage > 0 && q.getIdCategory() > 0 && !saveQuestionDto.isChangeAllowed()) {
            q.setIdCategory(0);
            q = this.saveQuestionToDatabase(q, true);
            idsTestfragen.add(idTestfrage);
            this.testfrageRepository.changeQuestionInTestfrage(idsTestfragen, q.getId());
            return q;
        }
        if (closedFragen.size() > 0) {
            if (saveQuestionDto.getSavemode().equals((Object)SAVEMODE.DIALOG)) {
                throw new MsgException("dialogSave");
            }
            if (saveQuestionDto.getSavemode().equals((Object)SAVEMODE.SPLIT)) {
                int idClone = this.cloneQuestion(q.getId());
                this.testfrageRepository.changeQuestionInTestfrage(closedFragen, idClone);
            }
        }
        return this.saveQuestionToDatabase(q, false);
    }

    public QuestionDTO saveQuestionToDatabase(QuestionDTO questionDto, boolean asNewQuestion) {
        ImagesEntityRepository imageRepository = this.allRepositories.imagesEntityRepository;
        QuestionEntity q = QuestionMapper.service.map(questionDto, new CycleAvoidingMappingContext());
        int i = 0;
        for (MoodleTextDTO t2 : questionDto.getMoodleTexte()) {
            int j = 0;
            for (MoodleFileDTO file : t2.getFiles()) {
                if (!Cmd.isEmpty((String)file.getMd5())) {
                    try {
                        MoodleFileEntity f = (MoodleFileEntity)((MoodleTextEntity)q.getMoodleTexte().get(i)).getFiles().get(j);
                        if (f.getImage() == null) {
                            ImagesEntity im = new ImagesEntity();
                            im.getMoodleFiles().add(f);
                            f.setImage(im);
                        }
                        f.getImage().setMd5(file.getMd5());
                        f.getImage().setExtension(file.getExtension());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        q.getMoodleTexte().forEach(t -> t.getFiles().forEach(f -> {
            if (f.getImage() != null && imageRepository.findImage(f.getImage().getMd5()) == null) {
                imageRepository.save((Object)f.getImage());
            }
        }));
        if (questionDto.getIdCategory() > 0) {
            CategoryEntity c = new CategoryEntity();
            c.setId(Integer.valueOf(questionDto.getIdCategory()));
            q.setCategory(c);
        } else {
            q.setCategory(null);
        }
        if (asNewQuestion) {
            this.setAsNewQuestion(q);
        }
        if (q.getQuestionComment() != null) {
            q.getQuestionComment().setQuestion(q);
        }
        q = (QuestionEntity)this.questionRepository.save((Object)q);
        return QuestionMapper.service.mapDto(q, new CycleAvoidingMappingContext());
    }

    @Transactional
    public int cloneQuestion(int idQuestion) {
        QuestionEntity q = this.cloneQuestionEntity(idQuestion, -1);
        q.setCategory(null);
        q = (QuestionEntity)this.questionRepository.save((Object)q);
        return q.getId();
    }

    public QuestionEntity cloneQuestionEntity(int idQuestion, int idCat) {
        boolean changeName;
        QuestionDTO qu = this.loadQuestion(idQuestion);
        if (idCat < 0) {
            idCat = qu.getIdCategory();
        }
        QuestionEntity q = QuestionMapper.service.map(qu, new CycleAvoidingMappingContext());
        boolean bl = changeName = qu.getIdCategory() == idCat;
        if (changeName) {
            Object name = "";
            try {
                name = qu.getName() + " Kopie";
            }
            catch (Exception e) {
                name = "Kopie";
            }
            q.setName((String)name);
        }
        this.setAsNewQuestion(q);
        return q;
    }

    private void setAsNewQuestion(QuestionEntity q) {
        q.setId(null);
        if (q.getQuestionComment() != null) {
            q.getQuestionComment().setId(null);
        }
        q.getSubQuestions().forEach(sq -> {
            sq.setId(null);
            sq.getAnswers().forEach(a -> a.setId(null));
            sq.getKompetenzen().forEach(k -> k.setId(null));
        });
        Iterator i = q.getMoodleTexte().iterator();
        while (i.hasNext()) {
            MoodleTextEntity t = (MoodleTextEntity)i.next();
            if (t == null) {
                i.remove();
                continue;
            }
            t.setId(null);
            t.getFiles().forEach(f -> f.setId(null));
        }
        q.getDatasetDefinitions().forEach(ds -> ds.setId(null));
        if (q.getQuestionComment() != null) {
            q.getQuestionComment().setId(null);
            q.getQuestionComment().setQuestion(q);
        }
    }

    @Transactional
    public QuestionDTO loadQuestion(int id) {
        Optional q = this.questionRepository.findById((Object)id);
        if (q.isPresent()) {
            return QuestionMapper.service.mapDto((QuestionEntity)q.get(), new CycleAvoidingMappingContext());
        }
        return null;
    }

    public boolean existsQuestion(int id) {
        Long anz = this.questionRepository.checkIfPresent(id);
        if (anz == null) {
            return false;
        }
        return anz > 0L;
    }

    public String changePenalty(List<Integer> ids, double penalty) {
        try {
            ids.forEach(id -> this.questionRepository.changePenalty(id.intValue(), "" + penalty));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return "";
    }

    public static QuestionEntity search(List<QuestionEntity> list, int id) {
        QuestionEntity el;
        Iterator<QuestionEntity> var2 = list.iterator();
        do {
            if (var2.hasNext()) continue;
            return null;
        } while ((el = var2.next()).getId() != id);
        return el;
    }
}

