/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.question;

import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.dto.question.search.Logik;
import at.letto.data.dto.question.search.QuestionSearchDto;
import at.letto.data.repository.QuestionEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.question.QuestionSearchService;
import at.letto.lehrplan.restclient.RestLehrplanService;
import at.letto.tools.Cmd;
import at.letto.tools.enums.IconType;
import at.letto.tools.rest.MsgException;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionSearchService {
    @Inject
    EntityManager em;
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private QuestionEntityRepository questionRepository;
    RestLehrplanService lehrplanService = new RestLehrplanService("https://localhost:9700");

    public List<QuestionListDTO> searchQuestion(QuestionSearchDto search) {
        Object sql_ = "";
        String verkn = this.getLogikSql(search.getLogik());
        if (search.getKompetenz().isEmpty() && search.getText().isEmpty() && search.getTitle().isEmpty() && search.getMarkierung().equals("Keine Einschr\u00e4nkung")) {
            if (search.getUser() != null && !search.getUser().isEmpty()) {
                throw new MsgException("searchNotDefinedUser");
            }
            throw new MsgException("searchNotDefined");
        }
        List themenIDs = null;
        if (!Cmd.isEmpty((String)search.getKompetenz()) && (themenIDs = this.lehrplanService.loadThemenIDs(search.getKompetenz())).size() == 0) {
            return new Vector<QuestionListDTO>();
        }
        sql_ = "select distinct new at.letto.data.dto.question.list.QuestionListDTO(q.id, q.name, q.licenceKey, q.hidden, q.questionType, q.idUser, c.id) from QuestionEntity q left join q.subQuestions sq left join q.moodleTexte t left join q.category c left join sq.kompetenzen kl ";
        String mark = search.getMarkierung();
        if (mark.equals("Ohne Markierung")) {
            sql_ = (String)sql_ + "left join q.questionComment qc ";
        } else if (!mark.isEmpty() && !search.getMarkierung().equals("Keine Einschr\u00e4nkung")) {
            sql_ = (String)sql_ + "join q.questionComment qc ";
        }
        Object sql = "";
        sql = this.addSql((String)sql, verkn, "q.name", search.getTitle(), search.getTextLogik());
        sql = this.addSql((String)sql, verkn, "t.text", search.getText(), search.getTextLogik());
        sql = this.addSql((String)sql, verkn, "c.name", search.getCategory(), search.getLogik());
        if (themenIDs != null) {
            sql = (String)sql + " " + verkn + " kl.kompetenzID in :kompIds ";
        }
        if (search.getSelTypen().size() > 0) {
            sql = (String)sql + " and q.questionType in :qTyp ";
        }
        IconType icon = null;
        if (search.getMarkierung().equals("Ohne Markierung")) {
            sql = (String)sql + " and qc is null ";
        } else if (!mark.isEmpty() && !search.getMarkierung().equals("Keine Einschr\u00e4nkung")) {
            sql = (String)sql + " and qc.icon = :icon ";
            switch (search.getMarkierung()) {
                case "Fehlerhafte Fragen": {
                    icon = IconType.WARNING;
                    break;
                }
                case "Fragen in Entwicklung": {
                    icon = IconType.PROCESSING;
                    break;
                }
                case "Kontrollierte Fragen": {
                    icon = IconType.REVIEWED;
                }
            }
        }
        sql = ((String)sql).trim();
        if (((String)sql).startsWith("and")) {
            sql = ((String)sql).replaceFirst("and", "");
        }
        if (((String)sql).startsWith("or")) {
            sql = ((String)sql).replaceFirst("or", "");
        }
        sql = (String)sql_ + " where " + (String)sql;
        TypedQuery query = this.em.createQuery((String)sql, QuestionListDTO.class);
        if (search.getSelTypen().size() > 0) {
            query.setParameter("qTyp", (Object)search.getSelTypen());
        }
        if (icon != null) {
            query.setParameter("icon", (Object)icon);
        }
        if (themenIDs != null) {
            query.setParameter("kompIds", (Object)themenIDs);
        }
        return query.getResultList();
    }

    private String getLogikSql(Logik logik) {
        String verkn = "";
        switch (1.$SwitchMap$at$letto$data$dto$question$search$Logik[logik.ordinal()]) {
            case 1: {
                verkn = " or ";
                break;
            }
            case 2: {
                verkn = " and ";
            }
        }
        return verkn;
    }

    private String addSql(String sql, String verkn, String feld, String param, Logik verknuepfungIntern) {
        String[] t;
        if (param.isEmpty()) {
            return sql;
        }
        sql = (String)sql + verkn;
        boolean firstText = true;
        sql = (String)sql + "(";
        for (String x : t = param.replaceAll(",", " ").split(" ")) {
            if ((x = x.trim()).isEmpty()) continue;
            sql = (String)sql + (firstText ? "" : this.getLogikSql(verknuepfungIntern));
            sql = (String)sql + feld + " like '%" + x + "%' ";
            firstText = false;
        }
        sql = (String)sql + ") ";
        return sql;
    }
}

