/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.question;

import at.letto.data.dto.PairIntInt;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.dto.question.list.QuestionUsedInTestsDTO;
import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.CategoryEntity;
import at.letto.data.entity.QuestionEntity;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.data.repository.QuestionEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.question.QuestionMapper;
import at.letto.data.service.question.QuestionService;
import at.letto.tools.Datum;
import at.letto.tools.Listen;
import at.letto.tools.enums.QuestionType;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionListService {
    @Inject
    EntityManager em;
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private QuestionEntityRepository questionRepository;
    @Autowired
    private QuestionService questionService;

    @Transactional
    public QuestionDTO insertQuestion(QuestionDTO qu, int pos) {
        QuestionEntity q = QuestionMapper.service.map(qu, new CycleAvoidingMappingContext());
        return this.insQuestionInPos(q, qu.getIdCategory(), pos);
    }

    public QuestionDTO insertQuestion(QuestionType typ, int idCategory, String name, int pos) {
        QuestionDTO qu = new QuestionDTO();
        qu.setQuestionType(typ);
        qu.setName(name);
        qu.setIdCategory(idCategory);
        return this.insertQuestion(qu, pos);
    }

    @Transactional
    public List<QuestionListDTO> sortQuestions(int idCategory, int idTest) {
        List list = this.loadQuestionsInCategory(idCategory, idTest);
        list.sort(Comparator.comparing(QuestionListDTO::getName));
        this.sortInDatabase(list);
        return list;
    }

    @Transactional
    public String sortInDatabase(List<QuestionListDTO> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setOrderCol(i);
        }
        String upd = Listen.sqlUpdateSort(list, QuestionListDTO::getOrderCol);
        String sql = "INSERT into question (id, questionList_ORDER) VALUES " + upd + " ON DUPLICATE KEY UPDATE questionList_ORDER = VALUES(questionList_ORDER);";
        this.em.createNativeQuery(sql).executeUpdate();
        return "";
    }

    @Transactional
    public String execNativeQuery(String sql) {
        this.em.createNativeQuery(sql).executeUpdate();
        return "";
    }

    @Transactional
    public String sortActivitiesFolder(List<ActivityEntity> childs) {
        for (int i = 0; i < childs.size(); ++i) {
            childs.get(i).setFolderOrder(Integer.valueOf(i));
        }
        String upd = Listen.sqlUpdateSort(childs, ActivityEntity::getFolderOrder);
        String sql = "INSERT into activity (id, folder_ORDER) VALUES " + upd + " ON DUPLICATE KEY UPDATE folder_ORDER = VALUES(folder_ORDER);";
        this.em.createNativeQuery(sql).executeUpdate();
        return "";
    }

    @Transactional
    public String sortActivitiesLk(List<ActivityEntity> childs) {
        for (int i = 0; i < childs.size(); ++i) {
            childs.get(i).setFolderOrder(Integer.valueOf(i));
        }
        String upd = Listen.sqlUpdateSort(childs, ActivityEntity::getFolderOrder);
        String sql = "INSERT into activity (id, activities_ORDER) VALUES " + upd + " ON DUPLICATE KEY UPDATE activities_ORDER = VALUES(activities_ORDER);";
        this.em.createNativeQuery(sql).executeUpdate();
        return "";
    }

    public QuestionDTO deleteQuestion(int idQuestion) {
        QuestionDTO q = this.questionService.loadQuestion(idQuestion);
        if (this.questionRepository.loadUsedTestsForQuestion(idQuestion).size() > 0) {
            this.questionRepository.changeCategory(idQuestion, null);
        } else {
            this.questionRepository.deleteById((Object)idQuestion);
        }
        q.setId(0);
        return q;
    }

    public List<QuestionUsedInTestsDTO> loadUsedTestsForQuestion(int idQuestion) {
        return this.questionRepository.loadUsedTestsForQuestion(idQuestion);
    }

    private QuestionDTO insQuestionInPos(QuestionEntity q, int idCategory, int pos) {
        List ids = this.questionRepository.loadQuestionIDs(idCategory);
        CategoryEntity c = new CategoryEntity();
        c.setId(Integer.valueOf(idCategory));
        q.setCategory(c);
        q = (QuestionEntity)this.questionRepository.save((Object)q);
        int id = q.getId();
        if (pos < 0 || pos >= ids.size()) {
            ids.add(id);
        } else {
            ids.add(pos, id);
        }
        Vector<PairIntInt> idsSorted = new Vector<PairIntInt>();
        for (int i = 0; i < ids.size(); ++i) {
            idsSorted.add(new PairIntInt(((Integer)ids.get(i)).intValue(), i));
        }
        String upd = Listen.sqlUpdateSort(idsSorted, PairIntInt::getVal2);
        String sql = "INSERT into question (id, questionList_ORDER) VALUES " + upd + " ON DUPLICATE KEY UPDATE questionList_ORDER = VALUES(questionList_ORDER);";
        try {
            this.em.createNativeQuery(sql).executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.em.getEntityManagerFactory().getCache().evict(QuestionEntity.class);
        return QuestionMapper.service.mapDto(q, new CycleAvoidingMappingContext());
    }

    @Transactional
    public QuestionDTO cloneQuestion(int idQuestion, int idCategory, int pos) {
        QuestionEntity q = this.questionService.cloneQuestionEntity(idQuestion, idCategory);
        return this.insQuestionInPos(q, idCategory, pos);
    }

    public List<QuestionListDTO> loadQuestionsInCategory(int idCateg, int idTest) {
        Map qMap = this.questionRepository.loadQuestionList(idCateg).stream().collect(LinkedHashMap::new, (map, item) -> map.put(item.getId(), item), Map::putAll);
        this.questionRepository.loadQuestionComments(qMap.keySet()).forEach(c -> {
            try {
                ((QuestionListDTO)qMap.get(c.getIdQuestion())).setQuestionComment(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.questionRepository.loadQuestionKompetenzen(qMap.keySet()).forEach(k -> {
            try {
                List kl = ((QuestionListDTO)qMap.get(k.getIdQuestion())).getKompetenzen();
                if (!kl.contains(k)) {
                    kl.add(k);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (idTest > 0) {
            this.questionRepository.loadUsedTestsInGegenstand(qMap.keySet(), idTest).forEach(k -> {
                try {
                    ((QuestionListDTO)qMap.get(k.getIdQuestion())).getUsedInTests().add(k.getTest() + " (" + Datum.formatSimple((Date)k.getDatum()) + ")");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        Vector<QuestionListDTO> ret = new Vector<QuestionListDTO>(qMap.values());
        for (int i = 0; i < ret.size(); ++i) {
            ret.get(i).setOrderCol(i);
        }
        return ret;
    }

    public Map<Integer, List<QuestionListDTO>> loadAllQuestions() {
        Map qMap = this.questionRepository.loadQuestionListAll().stream().collect(LinkedHashMap::new, (map, item) -> map.put(item.getId(), item), Map::putAll);
        this.questionRepository.loadAllQuestionComments().forEach(c -> {
            try {
                if (qMap.containsKey(c.getIdQuestion())) {
                    ((QuestionListDTO)qMap.get(c.getIdQuestion())).setQuestionComment(c);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.questionRepository.loadQuestionKompetenzenAll().forEach(k -> {
            try {
                List kl;
                if (qMap.containsKey(k.getIdQuestion()) && !(kl = ((QuestionListDTO)qMap.get(k.getIdQuestion())).getKompetenzen()).contains(k)) {
                    kl.add(k);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Vector ret = new Vector(qMap.values());
        for (int i = 0; i < ret.size(); ++i) {
            ((QuestionListDTO)ret.get(i)).setOrderCol(i);
        }
        return ret.stream().collect(Collectors.groupingBy(QuestionListDTO::getIdCategory));
    }
}

