/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.export;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.category.CategorySortDTO;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.category.CategoryServiceDatabase;
import at.letto.data.service.export.ExportMapService;
import at.letto.data.service.question.QuestionService;
import at.letto.export.dto.api.DataSaveCategoryRequestDto;
import at.letto.export.dto.api.DataSaveQuestionRequestDto;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.export.dto.questions.ExportQuestionV1;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportExportService {
    @Autowired
    ExportMapService mapping;
    @Autowired
    AllRepositories allRepositories;
    @Autowired
    QuestionService questionService;
    @Autowired
    CategoryServiceDatabase categoryServiceDatabase;
    @Autowired
    private CategoryServiceDatabase cat;

    @PostConstruct
    public void init() {
    }

    public ExportCategoryV1 loadCategory_v1(int id, List<String> importClasses) {
        CategoryDTO c = this.cat.findCategory(id);
        List childs = this.allRepositories.categoryEntityRepository.findChildCategories(c.getIdParent().intValue()).stream().sorted(Comparator.comparing(CategorySortDTO::getOrderCol)).map(ch -> new ExportCategoryV1(ch.getName(), ch.getId())).collect(Collectors.toList());
        ExportCategoryV1 ret = this.mapping.map_cat_v1(c, true);
        ret.setCategories(childs);
        if (ret != null) {
            ret.downgrade(importClasses);
        }
        return ret;
    }

    public ExportQuestionV1 loadQuestion_v1(int id, List<String> importClasses) {
        QuestionDTO q = this.questionService.loadQuestion(id);
        ExportQuestionV1 ret = this.mapping.map_v1(q);
        if (ret != null) {
            ret.downgrade(importClasses);
        }
        return ret;
    }

    public int saveQuestion_v1(DataSaveQuestionRequestDto saveInfo) {
        QuestionDTO qDto = this.mapping.map_to_questionDto(saveInfo.getQuestion());
        boolean asNewQuestion = true;
        switch (saveInfo.getImportQuestion()) {
            case "override": {
                asNewQuestion = false;
                break;
            }
            case "add": 
            case "none": {
                if (this.questionService.existsQuestion(qDto.getId()) && saveInfo.getImportQuestion().equals("none")) {
                    return -1;
                }
                qDto.setName(qDto.getName() + "_exp_1");
            }
        }
        qDto = this.questionService.saveQuestionToDatabase(qDto, asNewQuestion);
        return qDto == null ? 0 : qDto.getId();
    }

    public int saveCategory_v1(DataSaveCategoryRequestDto saveInfo) {
        CategoryDTO c = this.categoryServiceDatabase.insertCategory(saveInfo.getIdCategory(), saveInfo.getPos(), saveInfo.getCategory());
        saveInfo.getCategory().getQuestions().forEach(q -> {
            DataSaveQuestionRequestDto save = new DataSaveQuestionRequestDto(c.getId(), saveInfo.getImportQuestion(), q, saveInfo.getPos());
            this.saveQuestion_v1(save);
            saveInfo.setPos(saveInfo.getPos() + 1);
        });
        return c.getId();
    }
}

