/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.config;

import at.letto.data.dto.config.ConfigInterface;
import at.letto.data.dto.config.GlobalConfigDto;
import at.letto.data.dto.config.UserConfigDto;
import at.letto.data.dto.enums.ConfigTyp;
import at.letto.data.entity.ConfiguserEntity;
import at.letto.data.entity.GlobalconfigEntity;
import at.letto.data.entity.SchuleEntity;
import at.letto.data.entity.UserEntity;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.config.ConfigService;
import at.letto.tools.rest.MsgException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigService {
    @Autowired
    private AllRepositories allRepos;

    public String setGlobal(GlobalConfigDto c) {
        if (c == null) {
            throw new MsgException("noGlobalConfigDefined");
        }
        if (c.getId() == 0) {
            c.setId(this.insertToDB(c));
        } else {
            this.allRepos.globalconfigEntityRepository.globalConfigChange(c);
        }
        return "";
    }

    public String delete(GlobalConfigDto c) {
        this.allRepos.globalconfigEntityRepository.globalConfigDelete(c.getId());
        return "";
    }

    public String deleteGlobalConf(String key) {
        this.allRepos.globalconfigEntityRepository.globalConfigDelete(key);
        return "";
    }

    public GlobalConfigDto getGlobalConf(String key) {
        return this.allRepos.globalconfigEntityRepository.findGlobalByKey(key).stream().findFirst().orElse(null);
    }

    public UserConfigDto get(String key, int idUser) {
        return this.allRepos.configuserEntityRepository.findUserConfigByKey(idUser, key).stream().findFirst().orElse(null);
    }

    public int set(UserConfigDto c) {
        if (c.getId() == 0) {
            c.setId(this.insertToDB(c));
        } else {
            this.allRepos.configuserEntityRepository.userConfigChange(c);
        }
        return c.getId();
    }

    public String delete(UserConfigDto c) {
        this.allRepos.configuserEntityRepository.userConfigDelete(c.getId());
        return "";
    }

    public String deleteUserConf(String key, int idUser) {
        this.allRepos.configuserEntityRepository.userConfigDelete(key, idUser);
        return "";
    }

    private void setConfDto(Object obj, ConfigInterface c) {
        if (obj != null) {
            switch (obj.getClass().getSimpleName()) {
                case "Double": {
                    c.setTyp(ConfigTyp.DOUBLE);
                    c.setText(Double.toString((Double)obj));
                    break;
                }
                case "Integer": {
                    c.setTyp(ConfigTyp.INT);
                    c.setText(Integer.toString((Integer)obj));
                    break;
                }
                case "String": {
                    c.setTyp(ConfigTyp.TEXT);
                    c.setText((String)obj);
                    break;
                }
                case "Boolean": {
                    c.setTyp(ConfigTyp.BOOLEAN);
                    c.setText((Boolean)obj != false ? "1" : "0");
                }
            }
        }
    }

    public static Object loadVal(ConfigTyp typ, String txt) {
        if (typ == null) {
            typ = ConfigTyp.TEXT;
        }
        if (txt == null) {
            txt = "";
        }
        switch (1.$SwitchMap$at$letto$data$dto$enums$ConfigTyp[typ.ordinal()]) {
            case 1: {
                try {
                    return Double.parseDouble(txt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 2: {
                try {
                    return Integer.parseInt(txt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 3: {
                return !txt.equals("0") && !txt.isEmpty();
            }
        }
        return txt;
    }

    public int insertToDB(GlobalConfigDto c) {
        List existing = this.allRepos.globalconfigEntityRepository.findGlobalId(c.getName());
        if (existing.size() > 1) {
            for (int i = 1; i < existing.size(); ++i) {
                this.allRepos.globalconfigEntityRepository.deleteById((Object)((Integer)existing.get(i)));
            }
        }
        if (existing.size() > 0) {
            c.setId(((Integer)existing.get(0)).intValue());
            this.allRepos.globalconfigEntityRepository.globalConfigChange(c);
            return c.getId();
        }
        GlobalconfigEntity e = new GlobalconfigEntity();
        e.setText(c.getText());
        e.setEditable(c.getEditable());
        e.setHelp(c.getHelp());
        e.setName(c.getName());
        e.setDisableSchoolEdit(c.getDisableSchoolEdit());
        e.setTyp(c.getTyp());
        e.setVisible(c.getVisible());
        if (c.getIdSchule() != null && c.getIdSchule() > 0) {
            SchuleEntity s = new SchuleEntity();
            s.setId(c.getIdSchule());
            e.setSchule(s);
        }
        e = (GlobalconfigEntity)this.allRepos.globalconfigEntityRepository.save((Object)e);
        return e.getId();
    }

    public int insertToDB(UserConfigDto c) {
        List existing = this.allRepos.configuserEntityRepository.findConfigId(c.getName(), c.getIdUser());
        if (existing.size() > 1) {
            for (int i = 1; i < existing.size(); ++i) {
                this.allRepos.configuserEntityRepository.deleteById((Object)((Integer)existing.get(i)));
            }
        }
        if (existing.size() > 0) {
            c.setId(((Integer)existing.get(0)).intValue());
            this.allRepos.configuserEntityRepository.userConfigChange(c);
            return c.getId();
        }
        ConfiguserEntity e = new ConfiguserEntity();
        e.setText(c.getText());
        e.setName(c.getName());
        e.setTyp(c.getTyp());
        UserEntity u = new UserEntity();
        u.setId(Integer.valueOf(c.getIdUser()));
        e.setUser(u);
        e = (ConfiguserEntity)this.allRepos.configuserEntityRepository.save((Object)e);
        return e.getId();
    }
}

