/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.category;

import at.letto.data.dto.category.kompetenzen.CategoryKompetenzDto;
import at.letto.data.dto.category.kompetenzen.SaveKompetenzenDto;
import at.letto.data.dto.category.kompetenzen.SaveSingleKompetenzenDto;
import at.letto.data.repository.CategoryEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.category.CategoryServiceDatabase;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KompetenzCategoryService {
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private CategoryServiceDatabase treeService;
    @Inject
    EntityManager em;

    public List<CategoryKompetenzDto> loadKompetenzenForCategory(int idCategory) {
        return this.allRepositories.categoryEntityRepository.findKompetenzenInCategory(idCategory);
    }

    @Transactional
    public String saveSingleKompetenz(SaveSingleKompetenzenDto komp) {
        List ids = this.allRepositories.questionEntityRepository.loadSubQuestionIDs(komp.getIdCategory());
        if (komp.isClear()) {
            this.allRepositories.questionEntityRepository.deleteKompetenzen(ids.stream().map(id -> (long)id).collect(Collectors.toList()));
        }
        if (ids.size() > 0) {
            Object sql = "INSERT INTO kompetenz_subquestion (`level`, `kompetenzID`, `subQuestionsID`) VALUES ";
            sql = (String)sql + ids.stream().map(id -> String.format("('%d', '%d', '%d')", komp.getLevel().ordinal(), komp.getIdThema(), id)).collect(Collectors.joining(",")) + ";";
            this.em.createNativeQuery((String)sql).executeUpdate();
        }
        this.allRepositories.categoryEntityRepository.updateCategoryKompetenz(komp.getIdCategory(), komp.getIdThema());
        return "";
    }

    public String saveKompetenzenForCategory(SaveKompetenzenDto komp) {
        CategoryEntityRepository repo = this.allRepositories.categoryEntityRepository;
        List k = this.loadKompetenzenForCategory(komp.getIdCategory());
        List<CategoryKompetenzDto> add = komp.getKompetenzen().stream().filter(r1 -> k.stream().noneMatch(kx -> kx.getIdCategory() == r1.getIdCategory() && kx.getIdThema() == r1.getIdThema())).collect(Collectors.toList());
        List<CategoryKompetenzDto> del = k.stream().filter(r1 -> komp.getKompetenzen().stream().noneMatch(kx -> kx.getIdCategory() == r1.getIdCategory() && kx.getIdThema() == r1.getIdThema())).collect(Collectors.toList());
        del.removeAll(add);
        add.forEach(r -> repo.kompetenzInsert(r.getIdThema(), r.getIdCategory()));
        del.forEach(r -> repo.kompetenzDelete(r.getIdThema(), r.getIdCategory()));
        return "";
    }
}

