/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.beurteilung;

import at.letto.data.dto.PairIntString;
import at.letto.data.dto.beurteilung.BeurteilungDTO;
import at.letto.data.dto.beurteilung.FremdLehrerDTO;
import at.letto.data.dto.beurteilung.KlassenBeurteilungDTO;
import at.letto.data.dto.beurteilung.KlassenInfoDTO;
import at.letto.data.dto.beurteilung.KompetenzBeurteilungsDTO;
import at.letto.data.dto.beurteilung.LehrerInfoDTO;
import at.letto.data.dto.beurteilung.NoteDTO;
import at.letto.data.dto.beurteilung.StudentDto;
import at.letto.data.dto.beurteilung.StudentGroupDto;
import at.letto.data.dto.beurteilung.TestDTO;
import at.letto.data.dto.beurteilung.TestPunkteDTO;
import at.letto.data.dto.beurteilung.TestversuchDTO;
import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.BeurteilungEntity;
import at.letto.data.entity.BeurteilungKompetenzEntity;
import at.letto.data.entity.BeurteilungsartEntity;
import at.letto.data.entity.GegenstandEntity;
import at.letto.data.entity.KlassenbeurteilungEntity;
import at.letto.data.entity.LehrerKlasseEntity;
import at.letto.data.entity.NotenEntity;
import at.letto.data.entity.SchuelerKlasseEntity;
import at.letto.data.entity.SchuelergruppeEntity;
import at.letto.data.entity.UserEntity;
import at.letto.data.repository.BeurteilungEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.beurteilung.BeurteilungConfigService;
import at.letto.tools.rest.MsgException;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class BeurteilungDataService {
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private BeurteilungConfigService beurteilungConfigService;
    @Autowired
    private BeurteilungEntityRepository beurteilungsRepository;

    @Transactional
    public BeurteilungDTO saveBeurteilung(BeurteilungDTO b) {
        BeurteilungEntity beurteilung = this.createBeurteilung(b, true);
        BeurteilungEntity bRet = (BeurteilungEntity)this.allRepositories.beurteilungEntityRepository.save((Object)beurteilung);
        return bRet != null ? this.toDto(bRet) : null;
    }

    @Transactional
    public KlassenBeurteilungDTO saveKlassenBeurteilung(KlassenBeurteilungDTO kbDto) {
        KlassenbeurteilungEntity kb = this.createKlassenBeurteilung(kbDto, true);
        KlassenbeurteilungEntity kbErg = (KlassenbeurteilungEntity)this.allRepositories.klassenbeurteilungEntityRepository.save((Object)kb);
        if (kbErg == null) {
            return null;
        }
        return this.toDto(kbErg);
    }

    public void saveBeurt() {
        BeurteilungEntity b = new BeurteilungEntity();
        b.setNote("Sehr Gut");
        b.setDatum(new Date());
        UserEntity u = this.allRepositories.userEntityRepository.findById((Object)7).orElse(null);
        b.setUser(u);
        BeurteilungEntity bRet = (BeurteilungEntity)this.allRepositories.beurteilungEntityRepository.save((Object)b);
    }

    public NoteDTO saveNote(NoteDTO n) {
        LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)n.getIdLk()).orElse(null);
        if (lk == null) {
            throw new MsgException("noKlasseGegenstand");
        }
        NotenEntity note = this.allRepositories.notenEntityRepository.findById((Object)n.getId()).orElse(new NotenEntity());
        if (n.getId() == 0) {
            note.setLehrerKlasse(lk);
            note.setSemester(n.getSemestrierung());
            this.allRepositories.userEntityRepository.findById((Object)n.getIdUser()).ifPresent(u -> note.setUser(u));
        }
        note.setMahnung(Boolean.valueOf(n.isMahnung()));
        note.setNote(n.getNote());
        note.getIdsNegativeDeskriptoren().clear();
        note.getIdsNegativeLehrinhalte().clear();
        if (note.getNote().equals("5")) {
            int id2;
            List ids = n.getNegativeDeskriptoren().keySet().stream().filter(id -> (Boolean)n.getNegativeDeskriptoren().get(id)).collect(Collectors.toList());
            note.getIdsNegativeDeskriptoren().clear();
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                id2 = (Integer)iterator.next();
                note.getIdsNegativeDeskriptoren().add(id2);
            }
            ids = n.getNegativeLehrinhalte().keySet().stream().filter(id -> (Boolean)n.getNegativeLehrinhalte().get(id)).collect(Collectors.toList());
            iterator = ids.iterator();
            while (iterator.hasNext()) {
                id2 = (Integer)iterator.next();
                note.getIdsNegativeLehrinhalte().add(id2);
            }
        }
        NotenEntity noteSaved = (NotenEntity)this.allRepositories.notenEntityRepository.save((Object)note);
        return this.toDTO(noteSaved);
    }

    public BeurteilungDTO loadBeurteilung(int id) {
        return this.beurteilungsRepository.findBeurteilungDto(id).map(b -> {
            b.setSubBeurteilungen(this.beurteilungsRepository.findSubBeurteilungen((Set)Stream.of(Integer.valueOf(id)).collect(Collectors.toCollection(HashSet::new))));
            return b;
        }).orElse(null);
    }

    @Transactional
    public KlassenBeurteilungDTO loadKlassenbeurteilung(int id) {
        AtomicReference kbDto = new AtomicReference();
        this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)id).ifPresent(kb -> kbDto.set(this.toDto(kb)));
        return (KlassenBeurteilungDTO)kbDto.get();
    }

    @Transactional
    public KlassenBeurteilungDTO loadParentKlassenbeurteilung(int id) {
        return this.allRepositories.beurteilungEntityRepository.findParentKlassenbeurteilung(id).map(kb -> this.toDto(kb)).get();
    }

    @Transactional
    public Integer loadIdLkBeurteilung(int id) {
        AtomicReference idLkAtomic = new AtomicReference();
        this.beurteilungsRepository.findParentBeurteilung(id).ifPresent(b -> idLkAtomic.set(b.getLehrerKlasse().getId()));
        if (idLkAtomic.get() == null) {
            this.allRepositories.beurteilungEntityRepository.findById((Object)id).ifPresent(b -> idLkAtomic.set(b.getLehrerKlasse().getId()));
        }
        return (Integer)idLkAtomic.get();
    }

    private BeurteilungEntity createBeurteilung(BeurteilungDTO b, boolean runtimeException) {
        BeurteilungEntity beurteilung = b.getId() > 0 ? this.allRepositories.beurteilungEntityRepository.findById((Object)b.getId()).orElse(new BeurteilungEntity()) : new BeurteilungEntity();
        beurteilung.setDatum(b.getDatum());
        beurteilung.setFragetext(b.getFragetext());
        beurteilung.setGewicht(Double.valueOf(b.getGewicht()));
        beurteilung.setNote(b.getNote());
        beurteilung.setProzent(b.getProzent());
        beurteilung.setInput(b.getInput());
        BeurteilungsartEntity ba = this.allRepositories.beurteilungsartEntityRepository.findById((Object)b.getIdBeurteilungsart()).orElse(null);
        if (ba == null && runtimeException) {
            throw new MsgException("noBeurteilungsart");
        }
        beurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        beurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        this.allRepositories.userEntityRepository.findById((Object)b.getIdFremdLehrer()).ifPresent(fl -> beurteilung.setFremdLehrer(fl));
        this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)b.getIdKlassenbeurteilung()).ifPresent(kb -> beurteilung.setKlassenBeurteilung(kb));
        if (b.getIdLk() != null) {
            LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)b.getIdLk()).orElse(null);
            if (lk == null && runtimeException) {
                throw new MsgException("noKlasseGegenstand");
            }
            beurteilung.setLehrerKlasse(lk);
        }
        if (b.getIdUser() != null) {
            UserEntity u = this.allRepositories.userEntityRepository.findById((Object)b.getIdUser()).orElse(null);
            if (u == null && runtimeException) {
                throw new MsgException("noUser");
            }
            beurteilung.setUser(u);
        }
        beurteilung.getKompetenzenLink().clear();
        beurteilung.setKompetenzenLink(b.getKompetenzen().stream().map(k -> new BeurteilungKompetenzEntity(null, beurteilung, Integer.valueOf(k.getIdKompetenz()), k.getLevel())).collect(Collectors.toList()));
        beurteilung.getSubBeurteilungen().clear();
        b.getSubBeurteilungen().forEach(s -> {
            BeurteilungEntity sub = this.createBeurteilung(s, false);
            sub.setParent(beurteilung);
            beurteilung.getSubBeurteilungen().add(sub);
        });
        return beurteilung;
    }

    private KlassenbeurteilungEntity createKlassenBeurteilung(KlassenBeurteilungDTO kbDto, boolean runtimeException) {
        KlassenbeurteilungEntity klassenBeurteilung = kbDto.getId() > 0 ? this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)kbDto.getId()).orElse(new KlassenbeurteilungEntity()) : new KlassenbeurteilungEntity();
        klassenBeurteilung.setAufgabenstellung(kbDto.getAufgabenstellung());
        klassenBeurteilung.setName(kbDto.getName());
        klassenBeurteilung.setShowDateBeurteilung(Boolean.valueOf(kbDto.isShowDateBeurteilung()));
        klassenBeurteilung.setTestAllowed(Boolean.valueOf(kbDto.isTestAllowed()));
        klassenBeurteilung.setDatum(kbDto.getDatum());
        klassenBeurteilung.setGewicht(Double.valueOf(kbDto.getGewichtung()));
        BeurteilungsartEntity ba = this.allRepositories.beurteilungsartEntityRepository.findById((Object)kbDto.getIdBeurteilungsart()).orElse(null);
        if (ba == null && runtimeException) {
            throw new MsgException("noBeurteilungsart");
        }
        klassenBeurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        klassenBeurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        klassenBeurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        klassenBeurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        klassenBeurteilung.setSubKlassenBeurteilungen(klassenBeurteilung.getSubKlassenBeurteilungen().stream().filter(s -> kbDto.getSubKlassenbeurteilungen().stream().anyMatch(x -> x.getId() == s.getId().intValue())).collect(Collectors.toList()));
        kbDto.getSubKlassenbeurteilungen().forEach(kbSub -> {
            Optional<KlassenbeurteilungEntity> optSub = klassenBeurteilung.getSubKlassenBeurteilungen().stream().filter(s -> s.getId().intValue() == kbSub.getId() && s.getId() > 0).findFirst();
            KlassenbeurteilungEntity sub = optSub.isPresent() ? optSub.get() : new KlassenbeurteilungEntity();
            sub.setParent(klassenBeurteilung);
            klassenBeurteilung.getSubKlassenBeurteilungen().add(sub);
            sub.setName(kbSub.getName());
            sub.setGewicht(Double.valueOf(kbSub.getGewichtung()));
            if (kbSub.getIdActivity() > 0) {
                this.allRepositories.activityEntityRepository.findById((Object)kbSub.getIdActivity()).ifPresent(a -> sub.setActivity(a));
            } else if (sub.getActivity() != null) {
                ActivityEntity a2 = sub.getActivity();
                a2.setKlassenBeurteilung(null);
                sub.setActivity(null);
            }
        });
        if (kbDto.getIdLk() != 0) {
            LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)kbDto.getIdLk()).orElse(null);
            if (lk == null && runtimeException) {
                throw new MsgException("noKlasseGegenstand");
            }
            klassenBeurteilung.setLehrerKlasse(lk);
        }
        klassenBeurteilung.setSelKompetenz(Integer.valueOf(kbDto.getIdKompetenz()));
        klassenBeurteilung.setSelectedLevel(kbDto.getLevel());
        if (kbDto.getIdFremdlehrer() > 0) {
            this.allRepositories.userEntityRepository.findById((Object)kbDto.getIdFremdlehrer()).ifPresent(fl -> klassenBeurteilung.setFremdLehrer(fl));
        }
        return klassenBeurteilung;
    }

    public String updateKlassenbeurteilungsGewicht(int idKb, double gewicht) {
        this.allRepositories.klassenbeurteilungEntityRepository.updateGewicht(idKb, gewicht);
        return "";
    }

    public String loadLehrerKlasseConfig(int idLk) {
        return this.allRepositories.lehrerKlasseEntityRepository.loadLehrerKlassConfig(idLk);
    }

    public List<TestversuchDTO> loadTestVersuche(Set<Integer> idTests) {
        return this.beurteilungsRepository.findTestVersuche(idTests);
    }

    public String delBeurteilung(int id) {
        Vector<CallSite> info = new Vector<CallSite>();
        info.add((CallSite)((Object)("" + id)));
        try {
            this.allRepositories.beurteilungEntityRepository.deleteById((Object)id);
        }
        catch (EmptyResultDataAccessException e) {
            throw new MsgException("beurt.notExisting", info);
        }
        catch (Exception e1) {
            throw new MsgException("beurt.errDelBeurteilung", info);
        }
        return "";
    }

    public String delKlassenBeurteilung(int id) {
        Vector<CallSite> info = new Vector<CallSite>();
        info.add((CallSite)((Object)("" + id)));
        try {
            this.allRepositories.klassenbeurteilungEntityRepository.deleteById((Object)id);
        }
        catch (EmptyResultDataAccessException e) {
            throw new MsgException("beurt.notExistingKb", info);
        }
        catch (Exception e1) {
            throw new MsgException("beurt.errDelKb", info);
        }
        return "";
    }

    public String delBeurteilungenTestversuch(int idTestversuch) {
        Vector<CallSite> info = new Vector<CallSite>();
        info.add((CallSite)((Object)("" + idTestversuch)));
        try {
            this.allRepositories.beurteilungEntityRepository.delBeurteilungenTestversuch(idTestversuch);
        }
        catch (EmptyResultDataAccessException e) {
            throw new MsgException("beurt.notExistingTestversuch", info);
        }
        catch (Exception e1) {
            throw new MsgException("beurt.errDelTestversuch", info);
        }
        return "";
    }

    public BeurteilungDTO delOnlineTest(BeurteilungDTO b) {
        if (b.getIdActivity() == 0) {
            throw new MsgException("beurt.idActivityNull");
        }
        int idAct = b.getIdActivity();
        this.allRepositories.activityEntityRepository.findById((Object)idAct).ifPresent(act -> {
            try {
                this.allRepositories.activityEntityRepository.deleteById((Object)idAct);
                this.allRepositories.beurteilungEntityRepository.findById((Object)b.getId()).ifPresent(beurt -> {
                    beurt.setActivity(null);
                    this.allRepositories.beurteilungEntityRepository.save(beurt);
                    b.setIdActivity(0);
                    b.setActivityName("");
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return b;
    }

    public KlassenBeurteilungDTO delOnlineTest(KlassenBeurteilungDTO b) {
        if (b.getIdActivity() == 0) {
            throw new MsgException("beurt.idActiviyNotDefined");
        }
        this.allRepositories.klassenbeurteilungEntityRepository.removeActivity(b.getIdActivity());
        b.setIdActivity(0);
        b.setActivityName("");
        return b;
    }

    @Transactional
    public BeurteilungDTO loadBeurteilungFromKlassenbeurteilungAndUser(int idKb, int idUser) {
        return this.allRepositories.beurteilungEntityRepository.findBeurteilungFromKlassenbeurteilungAndUser(idKb, idUser).map(b -> this.toDto(b)).get();
    }

    @Transactional
    public NoteDTO loadNote(int idNote) {
        return this.allRepositories.notenEntityRepository.findById((Object)idNote).map(n -> this.toDto(n)).get();
    }

    public int loadLehrerID(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findLehrerID(idLk);
    }

    public List<BeurteilungDTO> loadByLK(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findByLK(idLk);
    }

    public List<BeurteilungDTO> loadGlobalByLK(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findGlobalByLK(idLk);
    }

    public List<BeurteilungDTO> loadSubBeurteilungen(Set<Integer> ids) {
        return this.allRepositories.beurteilungEntityRepository.findSubBeurteilungen(ids);
    }

    public List<FremdLehrerDTO> loadFremdLehrer(Set<Integer> ids) {
        return this.allRepositories.beurteilungEntityRepository.findFremdLehrer(ids);
    }

    public List<KompetenzBeurteilungsDTO> loadKompetenzen(Set<Integer> ids) {
        return this.allRepositories.beurteilungEntityRepository.findKompetenzen(ids);
    }

    public List<KlassenBeurteilungDTO> loadKlassenBeurteilungen(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findKlassenBeurteilungDto(idLk);
    }

    public List<KlassenBeurteilungDTO> loadSubKlassenBeurteilung(Set<Integer> idsParent) {
        return this.allRepositories.beurteilungEntityRepository.findSubKlassenBeurteilungDto(idsParent);
    }

    public List<KlassenBeurteilungDTO> loadGlobalKlassenBeurteilung(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findGlobalKlassenBeurteilungDto(idLk);
    }

    public List<BeurteilungDTO> loadByKlasse(int idKlasse) {
        return this.allRepositories.beurteilungEntityRepository.findByKlasse(idKlasse);
    }

    public List<PairIntString> loadTestsWithFullPath(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findTestsWithFullPath(idLk);
    }

    public List<PairIntString> loadTestsGlobalWithFullPath(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findTestsGlobalWithFullPath(idLk);
    }

    public List<PairIntString> loadTestsFullPathWinterSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsFullPathWinterSemester(idLk, semester);
    }

    public List<PairIntString> loadTestsGlobalFullPathWinterSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsGlobalFullPathWinterSemester(idLk, semester);
    }

    public List<PairIntString> loadTestsFullPathSommerSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsFullPathSommerSemester(idLk, semester);
    }

    public List<PairIntString> loadTestsGlobalFullPathSommerSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsGlobalFullPathSommerSemester(idLk, semester);
    }

    public List<TestDTO> loadTestsByAct(Set<Integer> idAct) {
        return this.allRepositories.beurteilungEntityRepository.findTests(idAct);
    }

    public Map<Integer, List<Integer>> loadTestGroups(Set<Integer> idAct) {
        return this.allRepositories.beurteilungEntityRepository.findTestGroups(idAct);
    }

    public List<TestPunkteDTO> loadTestPoints(Set<Integer> idAct) {
        List res = this.allRepositories.entityManager.createQuery("select distinct t.id, gF.id, 1, sum(tf.points), tf.points from TestsEntity t join t.testGruppe g join g.testFragen tf left join tf.gruppeVonFragen gF where t.id in :idAct group by g, gF").setParameter("idAct", idAct).getResultList();
        Vector<TestPunkteDTO> punkte = new Vector<TestPunkteDTO>();
        for (Object re : res) {
            Object[] line = (Object[])re;
            Integer idTest = (Integer)line[0];
            Integer idGruppe = (Integer)line[1];
            Integer anzInGruppe = (Integer)line[2];
            Double sumPoints = (Double)line[3];
            Double points = (Double)line[4];
            TestPunkteDTO tp = new TestPunkteDTO(idTest, idGruppe, anzInGruppe, sumPoints, points);
            punkte.add(tp);
        }
        return punkte;
    }

    public List<NoteDTO> loadNoten(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findNoten(idLk);
    }

    public List<StudentDto> loadStudents(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findStudents(idLk);
    }

    public List<StudentGroupDto> loadStudentGroups(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findStudentGroups(idLk);
    }

    public KlassenInfoDTO loadKlassenInfo(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findKlassenInfo(idLk);
    }

    public List<LehrerInfoDTO> loadLehrerInKlasse(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findLehrerInKlasse(idLk);
    }

    public List<Integer> loadBeurteilungenSchuljahr(int idSchuljahr) {
        return this.allRepositories.beurteilungEntityRepository.findBeurteilungenSchuljahr(idSchuljahr);
    }

    public List<String> loadActivitiesInKlasse(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findActivitiesInKlasse(idLk);
    }

    public List<LehrerInfoDTO> loadFremdLehrerInKlasse(int idLk) {
        return this.beurteilungsRepository.findFremdLehrerInKlasse(idLk);
    }

    private NoteDTO toDto(NotenEntity nEnt) {
        NoteDTO n = new NoteDTO();
        n.setId(nEnt.getId().intValue());
        n.setIdLk(nEnt.getLehrerKlasse().getId());
        n.setIdUser(nEnt.getUser().getId());
        n.setNote(nEnt.getNote());
        n.setMahnung(nEnt.getMahnung().booleanValue());
        n.setSemestrierung(nEnt.getSemester());
        return n;
    }

    private KlassenBeurteilungDTO toDto(KlassenbeurteilungEntity kb) {
        KlassenBeurteilungDTO kbDto = new KlassenBeurteilungDTO();
        kbDto.setId(kb.getId().intValue());
        kbDto.setIdLk(kb.getLehrerKlasse().getId().intValue());
        kbDto.setName(kb.getName());
        kbDto.setAufgabenstellung(kb.getAufgabenstellung());
        if (kb.getBeurteilungsartGlobal() != null) {
            kbDto.setBeurteilungsart(kb.getBeurteilungsartGlobal().getName());
        }
        kbDto.setBezeichnerBeurteilungsart(kb.getBezeichnerBeurteilungsart());
        kbDto.setGewichtung(kb.getGewicht().doubleValue());
        kbDto.setDatum(kb.getDatum());
        if (kb.getActivity() != null) {
            kbDto.setIdActivity(kb.getActivity().getId());
            kbDto.setActivityName(kb.getActivity().getName());
        }
        if (kb.getSelKompetenz() > 0) {
            kbDto.setIdKompetenz(kb.getSelKompetenz().intValue());
        }
        kbDto.setLevel(kb.getSelectedLevel());
        kb.getSubKlassenBeurteilungen().forEach(sub -> {
            KlassenBeurteilungDTO subDto = this.toDto(sub);
            subDto.setParent(kbDto);
            kbDto.getSubKlassenbeurteilungen().add(subDto);
        });
        return kbDto;
    }

    private NoteDTO toDTO(NotenEntity note) {
        NoteDTO n = new NoteDTO();
        n.setId(note.getId().intValue());
        n.setIdLk(note.getLehrerKlasse().getId());
        n.setIdUser(note.getUser().getId());
        n.setNote(note.getNote());
        n.setMahnung(note.getMahnung().booleanValue());
        n.setSemestrierung(note.getSemester());
        return n;
    }

    public String setUserGruppe(StudentDto student, int idLk, String gruppe) {
        SchuelergruppeEntity x;
        SchuelergruppeEntity schuelergruppeEntity = x = student.getGruppenId() != null ? this.beurteilungsRepository.findUserGruppe(student.getGruppenId().intValue()) : this.beurteilungsRepository.findUserGruppe(idLk, student.getId());
        if (x == null) {
            x = new SchuelergruppeEntity();
            GegenstandEntity g = this.beurteilungsRepository.findGegenstand(idLk);
            SchuelerKlasseEntity sk = this.beurteilungsRepository.findSchuelerKlasse(idLk, student.getId());
            if (g == null || sk == null) {
                throw new MsgException("Zuordnung nicht speicherbar!");
            }
            x.setGegenstand(g);
            x.setSchuelerKlasse(sk);
        }
        x.setGruppenName(gruppe);
        this.allRepositories.schuelergruppeEntityRepository.save((Object)x);
        return "";
    }

    public String changeLehrerKlasseGewicht(int idLk, double gewicht) {
        this.allRepositories.beurteilungEntityRepository.changeLehrerKlasseGewicht(idLk, gewicht);
        return "";
    }

    public String changeKlassenbeurteilungsGewicht(int id, double gewicht) {
        this.allRepositories.klassenbeurteilungEntityRepository.updateGewicht(id, gewicht);
        return "";
    }

    public String changeConfig(String config, int idLk) {
        this.allRepositories.lehrerKlasseEntityRepository.updateConfig(idLk, config);
        return "";
    }

    private BeurteilungDTO toDto(BeurteilungEntity bEnt) {
        BeurteilungDTO b = this.toDtoIntern(bEnt);
        List kompetenzen = bEnt.getKompetenzenLink().stream().map(kl -> new KompetenzBeurteilungsDTO(b.getId(), kl.getKompetenzID().intValue(), "", kl.getLevel())).collect(Collectors.toList());
        b.setKompetenzen(kompetenzen);
        UserEntity fl = bEnt.getFremdLehrer();
        if (fl != null) {
            String name = fl.getNachname() + " " + fl.getVorname();
            b.setFremdLehrer(name);
            b.setIdFremdLehrer(bEnt.getFremdLehrer().getId().intValue());
        }
        bEnt.getSubBeurteilungen().forEach(sub -> {
            BeurteilungDTO subDto = this.toDtoIntern(sub);
            subDto.setParent(b);
            b.getSubBeurteilungen().add(subDto);
        });
        if (bEnt.getActivity() != null) {
            b.setIdActivity(bEnt.getActivity().getId());
            b.setActivityName(bEnt.getActivity().getName());
        }
        b.setDateOK(true);
        return b;
    }

    private BeurteilungDTO toDtoIntern(BeurteilungEntity be) {
        BeurteilungDTO b = new BeurteilungDTO();
        b.setId(be.getId().intValue());
        b.setIdLk(be.getLehrerKlasse() != null ? be.getLehrerKlasse().getId() : null);
        b.setIdUser(be.getUser() != null ? be.getUser().getId() : null);
        b.setIdKlassenbeurteilung(be.getKlassenBeurteilung() != null ? be.getKlassenBeurteilung().getId() : 0);
        b.setBeurteilungsart(be.getBeurteilungsartGlobal().getName());
        b.setBezeichnerBeurteilungsart(be.getBezeichnerBeurteilungsart());
        b.setDatum(be.getDatum());
        b.setNote(be.getNote());
        b.setProzent(be.getProzent());
        b.setGewicht(be.getGewicht().doubleValue());
        b.setFragetext(be.getFragetext());
        b.setInput(be.getInput());
        return b;
    }
}

