/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.activity;

import at.letto.data.DatabaseUtil;
import at.letto.data.dto.Id;
import at.letto.data.dto.activity.ActivityBaseDto;
import at.letto.data.dto.activity.ActivityDto;
import at.letto.data.dto.activity.RetHtmlActivity;
import at.letto.data.dto.dokumente.DokumenteBaseDto;
import at.letto.data.dto.inetlinks.InetlinksBaseDto;
import at.letto.data.dto.projekte.ProjekteBaseDto;
import at.letto.data.dto.tests.TestsBaseDto;
import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.ActivitytypeEntity;
import at.letto.data.entity.BeurteilungsartGlobalEntity;
import at.letto.data.entity.DokumenteEntity;
import at.letto.data.entity.FragengruppeEntity;
import at.letto.data.entity.GruppierungEntity;
import at.letto.data.entity.InetlinksEntity;
import at.letto.data.entity.LehrerKlasseEntity;
import at.letto.data.entity.ProjekteEntity;
import at.letto.data.entity.QuestionEntity;
import at.letto.data.entity.TestFrageEntity;
import at.letto.data.entity.TestGruppeEntity;
import at.letto.data.entity.TestsEntity;
import at.letto.data.repository.ActivityEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.question.QuestionListService;
import at.letto.data.service.question.QuestionService;
import at.letto.tools.rest.MsgException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityService {
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private ActivityEntityRepository activityEntityRepository;
    @Autowired
    QuestionListService qService;
    private ModelMapper mapper = new ModelMapper();
    Converter<QuestionEntity, QuestionEntity> loadQuestionEntity = new /* Unavailable Anonymous Inner Class!! */;
    Converter<LehrerKlasseEntity, LehrerKlasseEntity> loadLkEntity = new /* Unavailable Anonymous Inner Class!! */;
    @Inject
    EntityManager em;

    public String updateVisibility(Map<String, String> map) {
        int idActivity = Integer.parseInt(map.get("idActivity"));
        boolean visible = map.get("visible").equals("true");
        this.activityEntityRepository.updateVisibility(idActivity, visible);
        return "";
    }

    public String updateName(Map<String, String> map) {
        int idActivity = Integer.parseInt(map.get("idActivity"));
        String name = map.get("name");
        this.activityEntityRepository.updateName(idActivity, name);
        return "";
    }

    public String changeTest(ActivityDto act) {
        TestsBaseDto te = act.getTest();
        Optional test = this.allRepositories.testsEntityRepository.findById((Object)te.getId());
        if (!test.isPresent()) {
            return "testNotAvailable";
        }
        TestsEntity t = (TestsEntity)test.get();
        this.mapper.map((Object)te, (Object)t);
        this.allRepositories.testsEntityRepository.save((Object)t);
        this.allRepositories.activityEntityRepository.update(act.getId().intValue(), act.getName(), act.getVisible().booleanValue());
        return "";
    }

    @Transactional
    public String deleteActivity(int id) {
        this.activityEntityRepository.deleteById((Object)id);
        return "";
    }

    @Transactional
    protected int loadIdLehererKlasse(int idAct) {
        Optional actOpt = this.allRepositories.activityEntityRepository.findById((Object)idAct);
        if (!actOpt.isPresent()) {
            return 0;
        }
        ActivityEntity a = (ActivityEntity)actOpt.get();
        int max = 100;
        while (a.getLehrerKlasse() == null && max-- > 0) {
            a = a.getParentFolder();
        }
        return a.getLehrerKlasse() != null ? a.getLehrerKlasse().getId() : 0;
    }

    @Transactional
    public Integer insertActivity(ActivityDto act, int pos) {
        ProjekteEntity p;
        act.setId(Integer.valueOf(0));
        ActivityEntity a = new ActivityEntity();
        this.mapper.map((Object)act, (Object)a);
        ActivitytypeEntity actTyp = new ActivitytypeEntity();
        actTyp.setId(act.getIdActivityTyp());
        a.setActivityType(actTyp);
        if (act.getIDLK() == null || act.getIDLK() < 1) {
            if (act.getIdLehrerKlasse() != null && act.getIdLehrerKlasse() > 0) {
                act.setIDLK(act.getIdLehrerKlasse());
            } else {
                act.setIDLK(Integer.valueOf(this.loadIdLehererKlasse(act.getIdParentFolder().intValue())));
            }
        }
        if (act.getTest() != null) {
            TestsEntity t = new TestsEntity();
            TestsBaseDto te = act.getTest();
            this.mapper.map((Object)te, (Object)t);
            t.setId(Integer.valueOf(0));
            BeurteilungsartGlobalEntity mode = new BeurteilungsartGlobalEntity();
            mode.setId(te.getIdMode());
            t.setMode(mode);
            t.setActivity(a);
            if (te.getIdGruppierung() != null) {
                GruppierungEntity g = new GruppierungEntity();
                g.setId(te.getIdGruppierung());
                t.setGruppierung(g);
            }
            if (t.getTestGruppe() == null) {
                t.setTestGruppe(new Vector());
            }
            for (int i = 1; i <= te.getAnzahlGruppen(); ++i) {
                TestGruppeEntity gr = new TestGruppeEntity();
                gr.setGruppenName("Gruppe " + i);
                gr.setTest(t);
                t.getTestGruppe().add(gr);
            }
            t = (TestsEntity)this.allRepositories.testsEntityRepository.save((Object)t);
            a.setTest(t);
        }
        if (act.getDokument() != null) {
            DokumenteBaseDto doc = act.getDokument();
            DokumenteEntity d = new DokumenteEntity();
            this.mapper.map((Object)doc, (Object)d);
            d.setId(Integer.valueOf(0));
            d = (DokumenteEntity)this.allRepositories.dokumenteEntityRepository.save((Object)d);
            a.setDokument(d);
        }
        if (act.getLink() != null) {
            InetlinksBaseDto link = act.getLink();
            InetlinksEntity l = new InetlinksEntity();
            this.mapper.map((Object)link, (Object)l);
            l.setId(Integer.valueOf(0));
            l = (InetlinksEntity)this.allRepositories.inetlinksEntityRepository.save((Object)l);
            a.setInetLink(l);
        }
        if (act.getProjekt() != null) {
            ProjekteBaseDto pr = act.getProjekt();
            p = new ProjekteEntity();
            this.mapper.map((Object)pr, (Object)p);
            p.setId(Integer.valueOf(0));
            p = (ProjekteEntity)this.allRepositories.projekteEntityRepository.save((Object)p);
            a.setProject(p);
        }
        if (act.getIdLehrerKlasse() != null) {
            a.setIdLk(act.getIdLehrerKlasse());
            LehrerKlasseEntity lk = new LehrerKlasseEntity();
            lk.setId(act.getIdLehrerKlasse());
            a.setLehrerKlasse(lk);
        } else if (act.getIdParentFolder() != null) {
            Optional parent = this.activityEntityRepository.findById((Object)act.getIdParentFolder());
            if (!parent.isPresent()) {
                throw new MsgException("noParentFolderExisting");
            }
            p = (ActivityEntity)parent.get();
            if (p.getIdLk() <= 0) {
                throw new MsgException("noLkInParent");
            }
            a.setIdLk(p.getIdLk());
            a.setParentFolder((ActivityEntity)p);
        } else {
            throw new MsgException("noParentFolderDefined");
        }
        List ids = Id.check((Integer)act.getIdLehrerKlasse()) ? this.allRepositories.activityEntityRepository.activityIdsInGegenstand(act.getIdLehrerKlasse().intValue()) : this.allRepositories.activityEntityRepository.activityIdsInFolder(act.getIdParentFolder().intValue());
        a = (ActivityEntity)this.allRepositories.activityEntityRepository.save((Object)a);
        if (Id.check((Integer)act.getIdLehrerKlasse())) {
            DatabaseUtil.sortEntities((List)ids, (int)a.getId(), (int)pos, (String)"activity", (String)"activities_ORDER", (EntityManager)this.em);
        } else {
            DatabaseUtil.sortEntities((List)ids, (int)a.getId(), (int)pos, (String)"activity", (String)"folder_ORDER", (EntityManager)this.em);
        }
        return a.getId();
    }

    @Transactional
    public List<RetHtmlActivity> insHtmlQuestion(List<Integer> idQuestions, int idLk, int idParent, int idUser) {
        ActivitytypeEntity type = this.allRepositories.activitytypeEntityRepository.findByDescription("HtmlQuestion");
        List qs = this.allRepositories.questionEntityRepository.findAllById(idQuestions);
        LehrerKlasseEntity lk = (LehrerKlasseEntity)this.allRepositories.lehrerKlasseEntityRepository.findById((Object)idLk).get();
        ActivityEntity par = null;
        int pos = lk.getActivities().size();
        if (idParent > 0) {
            par = (ActivityEntity)this.allRepositories.activityEntityRepository.findById((Object)idParent).get();
            if (par == null) {
                throw new MsgException("errFolderNotFound");
            }
            pos = par.getActivities().size();
        }
        Vector<RetHtmlActivity> inserted = new Vector<RetHtmlActivity>();
        for (Integer idQestion : idQuestions) {
            QuestionEntity q = QuestionService.search((List)qs, (int)idQestion);
            ActivityEntity a = new ActivityEntity();
            a.setActivityType(type);
            a.setName(q.getName());
            a.setVisible(Boolean.valueOf(true));
            a.setErstellerId(idUser > 0 ? Integer.valueOf(idUser) : null);
            a.setIdLk(Integer.valueOf(idLk));
            if (par != null) {
                a.setParentFolder(par);
            } else {
                a.setLehrerKlasse(lk);
            }
            a.setQuestion(q);
            a.setFolderOrder(Integer.valueOf(pos));
            a.setLkOrder(Integer.valueOf(pos));
            ++pos;
            this.allRepositories.activityEntityRepository.save((Object)a);
            inserted.add(new RetHtmlActivity(a.getId(), q.getId().intValue(), type.getId().intValue(), a.getName()));
        }
        return inserted;
    }

    public ActivityBaseDto cutCopyActivity(HashMap<String, String> vals) {
        int idActivity = Integer.parseInt(vals.get("idActivity"));
        int idLk = Integer.parseInt(vals.get("idLk"));
        int idFolder = Integer.parseInt(vals.get("idFolder"));
        int pos = Integer.parseInt(vals.get("pos"));
        boolean copy = Boolean.parseBoolean(vals.get("copy"));
        ActivityEntity a = this.cloneActivityTransaction(idActivity, idLk, idFolder, pos, copy);
        return this.activityEntityRepository.loadById(a.getId());
    }

    public int checkPos(int pos, int max) {
        if (pos < 0) {
            return max;
        }
        if (pos > max) {
            return max;
        }
        return pos;
    }

    public ActivityEntity cloneActivityTransaction(int idActivity, int idLk, int idFolder, int pos, boolean copy) {
        Optional oa = this.activityEntityRepository.findById((Object)idActivity);
        if (!oa.isPresent()) {
            throw new MsgException("err.clone.no.activity");
        }
        AtomicReference<ActivityEntity> a = new AtomicReference<ActivityEntity>((ActivityEntity)oa.get());
        if (!copy) {
            if (idFolder > 0) {
                this.activityEntityRepository.findById((Object)idFolder).ifPresent(f -> {
                    ActivityEntity c = (ActivityEntity)oa.get();
                    f.getActivities().removeIf(Objects::isNull);
                    if (c.getParentFolder() != null && c.getParentFolder().getId() == idFolder) {
                        f.getActivities().remove(c);
                    } else {
                        c.setParentFolder(f);
                        c.setLehrerKlasse(null);
                        c.setIdLk(f.getIdLk());
                        this.activityEntityRepository.save((Object)c);
                    }
                    f.getActivities().add(this.checkPos(pos, f.getActivities().size()), c);
                    this.sortActivities(f.getActivities());
                });
            } else {
                this.allRepositories.lehrerKlasseEntityRepository.findById((Object)idLk).ifPresent(lk -> {
                    ActivityEntity c = (ActivityEntity)oa.get();
                    lk.getActivities().removeIf(Objects::isNull);
                    if (c.getLehrerKlasse() != null && c.getLehrerKlasse().getId() == lk.getId()) {
                        lk.getActivities().remove(c);
                    } else {
                        c.setParentFolder(null);
                        c.setLehrerKlasse(lk);
                        c.setIdLk(lk.getId());
                        this.activityEntityRepository.save((Object)c);
                    }
                    lk.getActivities().add(this.checkPos(pos, lk.getActivities().size()), c);
                    this.sortActivities(lk.getActivities());
                });
            }
            return a.get();
        }
        ActivityEntity c = new ActivityEntity();
        ModelMapper mapper = new ModelMapper();
        mapper.addConverter(this.loadQuestionEntity);
        mapper.addConverter(this.loadLkEntity);
        mapper.typeMap(ActivityEntity.class, ActivityEntity.class).addMappings(mp -> mp.skip(ActivityEntity::setId));
        mapper.typeMap(ActivityEntity.class, ActivityEntity.class).addMappings(mp -> mp.skip(ActivityEntity::setLehrerKlasse));
        mapper.typeMap(ActivityEntity.class, ActivityEntity.class).addMappings(mp -> mp.skip(ActivityEntity::setParentFolder));
        mapper.typeMap(InetlinksEntity.class, InetlinksEntity.class).addMappings(mp -> mp.skip(InetlinksEntity::setId));
        mapper.typeMap(InetlinksEntity.class, InetlinksEntity.class).addMappings(mp -> mp.skip(InetlinksEntity::setActivity));
        mapper.typeMap(DokumenteEntity.class, DokumenteEntity.class).addMappings(mp -> mp.skip(DokumenteEntity::setId));
        mapper.typeMap(DokumenteEntity.class, DokumenteEntity.class).addMappings(mp -> mp.skip(DokumenteEntity::setActivities));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setId));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setTestVersuche));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setGruppierung));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setBeurteilungsart));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setActivity));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setStart));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setStop));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setTestStart));
        mapper.typeMap(TestsEntity.class, TestsEntity.class).addMappings(mp -> mp.skip(TestsEntity::setTestStop));
        mapper.typeMap(TestGruppeEntity.class, TestGruppeEntity.class).addMappings(mp -> mp.skip(TestGruppeEntity::setId));
        mapper.typeMap(TestGruppeEntity.class, TestGruppeEntity.class).addMappings(mp -> mp.skip(TestGruppeEntity::setTestVersuche));
        mapper.typeMap(TestFrageEntity.class, TestFrageEntity.class).addMappings(mp -> mp.skip(TestFrageEntity::setId));
        mapper.typeMap(TestFrageEntity.class, TestFrageEntity.class).addMappings(mp -> mp.skip(TestFrageEntity::setTestDetails));
        mapper.typeMap(FragengruppeEntity.class, FragengruppeEntity.class).addMappings(mp -> mp.skip(FragengruppeEntity::setId));
        mapper.map(oa.get(), (Object)c);
        c.setIdLk(Integer.valueOf(idLk));
        if (c.getInetLink() != null) {
            c.getInetLink().setActivity(null);
        }
        if (c.getTest() != null) {
            c.getTest().setActivity(null);
            c.getTest().setTestDatum(new Date());
            c.getTest().getTestGruppe().forEach(g -> g.setTest(c.getTest()));
        }
        if (idFolder > 0) {
            this.activityEntityRepository.findById((Object)idFolder).ifPresent(f -> {
                int i;
                f.getActivities().removeIf(Objects::isNull);
                int n = i = pos < 0 ? f.getActivities().size() : pos;
                if (i > f.getActivities().size()) {
                    i = f.getActivities().size();
                }
                f.getActivities().add(i, c);
                c.setParentFolder(f);
                f = (ActivityEntity)this.activityEntityRepository.save(f);
                a.set((ActivityEntity)f.getActivities().get(i));
            });
        } else {
            this.allRepositories.lehrerKlasseEntityRepository.findById((Object)idLk).ifPresent(lk -> {
                int i;
                lk.getActivities().removeIf(Objects::isNull);
                int n = i = pos < 0 ? lk.getActivities().size() : pos;
                if (i > lk.getActivities().size()) {
                    i = lk.getActivities().size();
                }
                c.setLehrerKlasse(lk);
                lk.getActivities().add(i, c);
                lk = (LehrerKlasseEntity)this.allRepositories.lehrerKlasseEntityRepository.save(lk);
                a.set((ActivityEntity)lk.getActivities().get(i));
            });
        }
        return a.get();
    }

    private void sortActivities(List<ActivityEntity> activities) {
        this.qService.sortActivitiesFolder(activities);
        this.qService.sortActivitiesLk(activities);
    }

    static /* synthetic */ AllRepositories access$000(ActivityService x0) {
        return x0.allRepositories;
    }
}

