/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service;

import at.letto.data.dto.config.UserConfigDto;
import at.letto.data.dto.user.UserDto;
import at.letto.data.dto.user.UserKeyDto;
import at.letto.data.entity.UserEntity;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.config.ConfigService;
import at.letto.service.interfaces.CheckPasswortResponseDto;
import at.letto.service.interfaces.RequestResult;
import at.letto.service.interfaces.UserDataService;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import java.util.List;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService
implements UserDataService {
    @Autowired
    @Lazy
    private ModelMapper modelMapper;
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private ConfigService configService;

    @Bean
    @Lazy
    public ModelMapper modelMapper() {
        return new ModelMapper();
    }

    public UserKeyDto getUserByName(String username) {
        List users;
        if ((username != null || username.length() > 0) && (users = this.allRepositories.userEntityRepository.findAllByName(username)).size() == 1) {
            return this.UserEntityToKeyDto((UserEntity)users.get(0));
        }
        return null;
    }

    public UserKeyDto getUserById(Integer id) {
        List users;
        if ((id != null || id > 0) && (users = this.allRepositories.userEntityRepository.findAllById(id.intValue())).size() == 1) {
            return this.UserEntityToKeyDto((UserEntity)users.get(0));
        }
        return null;
    }

    public CheckPasswortResponseDto checkCredentials(String username, String password) {
        if (username != null || username.length() > 0) {
            boolean found = false;
            for (UserEntity user : this.allRepositories.userEntityRepository.findAllByName(username)) {
                found = true;
                if (!ENCRYPT.md5falsch((String)password).equals(user.getPasswort()) && !new BCryptPasswordEncoder().matches((CharSequence)password, user.getPassword())) continue;
                return new CheckPasswortResponseDto(this.UserEntityToKeyDto(user), RequestResult.OK, "");
            }
            if (found) {
                return new CheckPasswortResponseDto(null, RequestResult.ERROR, "");
            }
        }
        return new CheckPasswortResponseDto(null, RequestResult.NOTFOUND, "");
    }

    private UserKeyDto UserEntityToKeyDto(UserEntity u) {
        String s;
        UserKeyDto userKeyDto = (UserKeyDto)this.modelMapper.map((Object)u, UserKeyDto.class);
        String sprache = "de";
        UserConfigDto userConfigDto = this.configService.get("sprache", u.getId().intValue());
        if (userConfigDto != null && !Cmd.isEmpty((String)(s = userConfigDto.getText()))) {
            sprache = s;
        }
        userKeyDto.setSprache(sprache);
        return userKeyDto;
    }

    public int loadUserAnzahl(boolean globalAdmin) {
        return globalAdmin ? this.allRepositories.userEntityRepository.loadAdminAnzahl().intValue() : this.allRepositories.userEntityRepository.loadUserAnzahl().intValue();
    }

    public String changePassword(int idUser, String pwd, boolean temp) {
        if (temp) {
            pwd = new BCryptPasswordEncoder().encode((CharSequence)pwd);
            this.allRepositories.userEntityRepository.changeTempPwd(idUser, pwd);
        } else {
            pwd = new BCryptPasswordEncoder().encode((CharSequence)pwd);
            this.allRepositories.userEntityRepository.changePwd(idUser, pwd);
        }
        return "";
    }

    public String changePassword(List<Integer> idUsers, String pwd, boolean temp) {
        if (temp) {
            pwd = new BCryptPasswordEncoder().encode((CharSequence)pwd);
            this.allRepositories.userEntityRepository.changeTempPwd(idUsers, pwd);
        } else {
            pwd = new BCryptPasswordEncoder().encode((CharSequence)pwd);
            this.allRepositories.userEntityRepository.changePwd(idUsers, pwd);
        }
        return "";
    }

    public String changeUser(UserDto u) {
        this.allRepositories.userEntityRepository.changeUser(u);
        return "";
    }

    public String resetSchuelerLizenzen() {
        this.allRepositories.userEntityRepository.resetSchuelerLizenzen();
        return "";
    }
}

