/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.dto.beurteilung.LehrerInfoDTO;
import at.letto.data.dto.lehrerKlasse.LehrerKlasseBaseDto;
import at.letto.data.entity.LehrerKlasseEntity;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface LehrerKlasseEntityRepository
extends JpaRepository<LehrerKlasseEntity, Integer>,
JpaSpecificationExecutor<LehrerKlasseEntity> {
    public static final String lkBase = "new at.letto.data.dto.lehrerKlasse.LehrerKlasseBaseDto(lk.id, lk.gegenstand.id, lk.klasse.id, lk.user.id, lk.beurteilungsConfig.id,lk.bezeichnung, lk.disableKatalog, lk.fremdZugriff, lk.gewichtung,lk.kosten, lk.userAdded)";

    @Modifying
    @Query(value="update LehrerKlasseEntity lk SET lk.config = :conf  WHERE lk.id=:id")
    public void updateConfig(@Param(value="id") int var1, @Param(value="conf") String var2);

    @Query(value="select lk.config from LehrerKlasseEntity lk  WHERE lk.id=:id")
    public String loadLehrerKlassConfig(@Param(value="id") int var1);

    @Query(value="SELECT lk FROM LehrerKlasseEntity lk join lk.klasse k join k.schuljahr sj where sj.id  = :idSj and lk.user.id = :idUser order by lk.gegenstand.kuerzel")
    public List<LehrerKlasseEntity> lehrerKlasseInSchuljahr(@Param(value="idSj") int var1, @Param(value="idUser") int var2);

    @Query(value="SELECT lk FROM LehrerKlasseEntity lk join lk.klasse k join k.schuljahr sj where lk.user.id = :idUser order by sj.name, k.name, lk.gegenstand.kuerzel")
    public List<LehrerKlasseEntity> lehrerKlasseAll(@Param(value="idUser") int var1);

    @Query(value="select new at.letto.data.dto.lehrerKlasse.LehrerKlasseBaseDto(lk.id, lk.gegenstand.id, lk.klasse.id, lk.user.id, lk.beurteilungsConfig.id,lk.bezeichnung, lk.disableKatalog, lk.fremdZugriff, lk.gewichtung,lk.kosten, lk.userAdded) from LehrerKlasseEntity lk")
    public List<LehrerKlasseBaseDto> loadAll();

    @Query(value="select new at.letto.data.dto.lehrerKlasse.LehrerKlasseBaseDto(lk.id, lk.gegenstand.id, lk.klasse.id, lk.user.id, lk.beurteilungsConfig.id,lk.bezeichnung, lk.disableKatalog, lk.fremdZugriff, lk.gewichtung,lk.kosten, lk.userAdded) from LehrerKlasseEntity lk join lk.klasse k join k.schuljahr sj where lk.user.id = :idLehrer order by sj.name, k.name, lk.gegenstand.kuerzel")
    public List<LehrerKlasseBaseDto> loadAllForTeacher(@Param(value="idLehrer") int var1);

    @Query(value="SELECT new at.letto.data.dto.lehrerKlasse.LehrerKlasseBaseDto(lk.id, lk.gegenstand.id, lk.klasse.id, lk.user.id, lk.beurteilungsConfig.id,lk.bezeichnung, lk.disableKatalog, lk.fremdZugriff, lk.gewichtung,lk.kosten, lk.userAdded) FROM LehrerKlasseEntity lk join lk.klasse k join k.schuljahr sj where sj.id  = :idSj and lk.user.id = :idUser order by lk.gegenstand.kuerzel")
    public List<LehrerKlasseBaseDto> loadTeacherInSchuljahr(@Param(value="idSj") int var1, @Param(value="idUser") int var2);

    @Query(value="SELECT new at.letto.data.dto.beurteilung.LehrerInfoDTO(u.id, lk.id, u.nachname, u.vorname, 1.0, lk.bezeichnung) FROM LehrerKlasseEntity lk join lk.fremdLehrer fl join fl.user u")
    public List<LehrerInfoDTO> findFremdLehrer();

    @Query(value="select lk from LehrerKlasseEntity  lk join lk.user u where u.schule.id not in :id")
    public List<LehrerKlasseEntity> loadLehrerNotInSchool(@Param(value="id") int var1);

    @Query(value="select max(a.lkOrder) from ActivityEntity a join a.lehrerKlasse lk where lk.id = :id")
    public Long loadMaxActivitiesOrder(@Param(value="id") int var1);
}

