/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.category.CategorySortDTO;
import at.letto.data.dto.category.kompetenzen.CategoryKompetenzDto;
import at.letto.data.entity.CategoryEntity;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface CategoryEntityRepository
extends JpaRepository<CategoryEntity, Integer>,
JpaSpecificationExecutor<CategoryEntity> {
    @Query(nativeQuery=true)
    public List<CategoryDTO> findAllCategories();

    @Query(nativeQuery=true)
    public CategoryDTO findCatById(@Param(value="id") int var1);

    @Query(nativeQuery=true)
    public List<CategorySortDTO> findChildCategories(@Param(value="idParent") int var1);

    @Query(nativeQuery=true)
    public List<CategorySortDTO> findRoot();

    @Modifying
    @Transactional
    @Query(value="update CategoryEntity set name = :name WHERE id=:id")
    public void updateCategoryName(@Param(value="id") int var1, @Param(value="name") String var2);

    @Modifying
    @Transactional
    @Query(value="update CategoryEntity set einheitenKorrText = :einheit, einheitenKorr =:eh WHERE id=:id")
    public void updateCategoryEinheit(@Param(value="id") int var1, @Param(value="einheit") String var2, @Param(value="eh") boolean var3);

    @Modifying
    @Transactional
    @Query(value="update CategoryEntity set privateCategory = :priv WHERE id=:id")
    public void updatePrivate(@Param(value="id") int var1, @Param(value="priv") boolean var2);

    @Modifying
    @Transactional
    @Query(value="update CategoryEntity set globalCategory = :glob WHERE id=:id")
    public void updateGlobal(@Param(value="id") int var1, @Param(value="glob") boolean var2);

    @Modifying
    @Transactional
    @Query(value="update category set idParent=:idParent WHERE id=:id", nativeQuery=true)
    public void updateParent(@Param(value="id") int var1, @Param(value="idParent") int var2);

    @Modifying
    @Transactional
    @Query(value="update category set KOMP_ID=:idKomp WHERE id=:id", nativeQuery=true)
    public void updateCategoryKompetenz(@Param(value="id") int var1, @Param(value="idKomp") int var2);

    @Query(value="select new at.letto.data.dto.category.kompetenzen.CategoryKompetenzDto(c.category.id, c.kompetenzID, '') from CategoryKompetenzEntity c where c.category.id =:idCat")
    public List<CategoryKompetenzDto> findKompetenzenInCategory(@Param(value="idCat") int var1);

    @Modifying
    @Transactional
    @Query(value="delete from CategoryKompetenzEntity c WHERE c.kompetenzID = :idKomp and c.category.id = :idCat")
    public void kompetenzDelete(@Param(value="idKomp") int var1, @Param(value="idCat") int var2);

    @Modifying(clearAutomatically=true)
    @Transactional
    @Query(value="insert into category_kompetenz (kompetenzCategories_ID, kompetenzen_ID) VALUES (:idCat,:idKomp)", nativeQuery=true)
    public void kompetenzInsert(@Param(value="idKomp") int var1, @Param(value="idCat") int var2);

    @Query(value="select c from CategoryEntity c join c.parent p where p.parent.id = 2651 and c.name in :names")
    public List<CategoryEntity> loadUserCategs(@Param(value="names") List<String> var1);
}

