/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.tests.TestDetailDto;
import at.letto.data.dto.tests.testAnswer.TestAntwortDto;
import at.letto.data.repository.TestDetailsEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.tests.TestDetailServiceDatabase;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class TestDetailController {
    @Autowired
    TestDetailServiceDatabase tdService;
    @Autowired
    AllRepositories repos;

    @PostMapping(value={"/data/auth/user/test/td_last_answers"})
    public ResponseEntity<DtoAndMsg<List<TestAntwortDto>>> loadLastTestAnswers(@RequestBody Set<Integer> ids) {
        return ResponseTools.getResponse(TestDetailServiceDatabase::loadLastTestAnswers, (Object)this.tdService, ids);
    }

    @PostMapping(value={"/data/auth/user/test/td_last_answer"})
    public ResponseEntity<DtoAndMsg<TestAntwortDto>> loadLastTestAntwort(@RequestBody Integer id) {
        return ResponseTools.getResponse(TestDetailServiceDatabase::loadLastTestAnswer, (Object)this.tdService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/td_answers"})
    public ResponseEntity<DtoAndMsg<List<TestAntwortDto>>> loadTestAntwortenForDetail(@RequestBody Integer id) {
        return ResponseTools.getResponse(TestDetailServiceDatabase::loadTestAntwortenForDetail, (Object)this.tdService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/td_save"})
    public ResponseEntity<DtoAndMsg<String>> saveStudentAnswerToDB(@RequestBody TestAntwortDto a) {
        return ResponseTools.getErrResponse(TestDetailServiceDatabase::saveStudentAnswerToDB, (Object)this.tdService, (Object)a);
    }

    @PostMapping(value={"/data/auth/user/test/td_save_docs"})
    public ResponseEntity<DtoAndMsg<String>> saveTestDetailFilePath(@RequestBody TestDetailDto td) {
        return ResponseTools.getErrResponse(TestDetailServiceDatabase::saveTestDetailFilePath, (Object)this.tdService, (Object)td);
    }

    @PostMapping(value={"/data/auth/user/test/td_save_angabe"})
    public ResponseEntity<DtoAndMsg<String>> saveTestDetailDataset(@RequestBody HashMap<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        String dataset = vals.get("dataset");
        return ResponseTools.getErrResponse(TestDetailServiceDatabase::saveTestDetailDataset, (Object)this.tdService, (Object)id, (Object)dataset);
    }

    @PostMapping(value={"/data/auth/user/test/td_save_answer_json"})
    public ResponseEntity<DtoAndMsg<String>> saveTestDetailAnswer(@RequestBody HashMap<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        String json = vals.get("json");
        return ResponseTools.getErrResponse(TestDetailServiceDatabase::saveTestDetailAnswer, (Object)this.tdService, (Object)id, (Object)json);
    }

    @PostMapping(value={"/data/auth/user/test/td_save_fb"})
    public ResponseEntity<DtoAndMsg<String>> saveTestDetailFeedback(@RequestBody HashMap<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        String feedback = vals.get("feedback");
        return ResponseTools.getErrResponse(TestDetailServiceDatabase::saveTestDetailFeedback, (Object)this.tdService, (Object)id, (Object)feedback);
    }

    @PostMapping(value={"/data/auth/user/test/td_del_answer"})
    public ResponseEntity<DtoAndMsg<String>> delTestAntwort(@RequestBody HashMap<String, String> vals) {
        int idTestAntwort = Integer.parseInt(vals.get("idTestAntwort"));
        int idDetail = Integer.parseInt(vals.get("idDetail"));
        return ResponseTools.getErrResponse(TestDetailServiceDatabase::delTestAntwort, (Object)this.tdService, (Object)idTestAntwort, (Object)idDetail);
    }

    @PostMapping(value={"/data/auth/user/test/td_del_fb"})
    public ResponseEntity<DtoAndMsg<String>> removeFeedbackFileFromTestDetail(@RequestBody Integer id) {
        return ResponseTools.getErrResponse(TestDetailServiceDatabase::removeFeedbackFileFromTestDetail, (Object)this.tdService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/td_loadall_test"})
    public ResponseEntity<DtoAndMsg<List<TestDetailDto>>> loadTestDetailsByTestId(@RequestBody Integer id) {
        return ResponseTools.getResponse(TestDetailsEntityRepository::findTestDetailsByTestId, (Object)this.repos.testDetailsEntityRepository, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/td_load"})
    public ResponseEntity<DtoAndMsg<TestDetailDto>> loadTestDetailById(@RequestBody Integer id) {
        return ResponseTools.getResponse(TestDetailServiceDatabase::loadTestDetailById, (Object)this.tdService, (Object)id);
    }
}

