/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.question.ChangePenaltyDto;
import at.letto.data.dto.question.QuestionDTO;
import at.letto.data.dto.question.QuestionTextHistoryDTO;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.dto.question.list.QuestionUsedInTestsDTO;
import at.letto.data.dto.question.list.SaveQuestionDto;
import at.letto.data.dto.question.search.QuestionSearchDto;
import at.letto.data.repository.QuestionEntityRepository;
import at.letto.data.service.question.QuestionListService;
import at.letto.data.service.question.QuestionSearchService;
import at.letto.data.service.question.QuestionService;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class QuestionController {
    @Autowired
    QuestionService questionService;
    @Autowired
    QuestionListService questionListService;
    @Autowired
    QuestionSearchService searchService;
    @Autowired
    QuestionEntityRepository questionRepo;

    @PostMapping(value={"/data/auth/user/question/insert_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> insertQuestion(@RequestBody SaveQuestionDto dto) {
        return ResponseTools.getResponse(QuestionListService::insertQuestion, (Object)this.questionListService, (Object)dto.getQuestionDto(), (Object)dto.getPos());
    }

    @PostMapping(value={"/data/auth/user/question/sort_question_list"})
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> sortQuestions(@RequestBody Map<String, String> vals) {
        int idCat = Integer.parseInt(vals.get("idCat"));
        int idTest = Integer.parseInt(vals.get("idTest"));
        return ResponseTools.getResponse(QuestionListService::sortQuestions, (Object)this.questionListService, (Object)idCat, (Object)idTest);
    }

    @PostMapping(value={"/data/auth/user/question/sort_questions_in_database"})
    public ResponseEntity<DtoAndMsg<String>> sortInDatabase(@RequestBody List<QuestionListDTO> list) {
        return ResponseTools.getErrResponse(QuestionListService::sortInDatabase, (Object)this.questionListService, list);
    }

    @PostMapping(value={"/data/auth/user/question/delete_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> deleteQuestion(@RequestBody Integer id) {
        return ResponseTools.getResponse(QuestionListService::deleteQuestion, (Object)this.questionListService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/question/load_used_tests"})
    public ResponseEntity<DtoAndMsg<List<QuestionUsedInTestsDTO>>> loadUsedTestsForQuestion(@RequestBody Integer id) {
        return ResponseTools.getResponse(QuestionListService::loadUsedTestsForQuestion, (Object)this.questionListService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/question/clone_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> cloneQuestion(@RequestBody Map<String, String> vals) {
        int idQuestion = Integer.parseInt(vals.get("idQuestion"));
        int idCategory = Integer.parseInt(vals.get("idCategory"));
        int pos = Integer.parseInt(vals.get("pos"));
        return ResponseTools.getResponse(QuestionListService::cloneQuestion, (Object)this.questionListService, (Object)idQuestion, (Object)idCategory, (Object)pos);
    }

    @PostMapping(value={"/data/auth/user/question/load_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> loadQuestion(@RequestBody Integer id) {
        return ResponseTools.getResponse(QuestionService::loadQuestion, (Object)this.questionService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/question/save_question"})
    public ResponseEntity<DtoAndMsg<QuestionDTO>> saveQuestion(@RequestBody SaveQuestionDto dto) {
        return ResponseTools.getResponse(QuestionService::saveQuestion, (Object)this.questionService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/question/load_in_category"})
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> loadQuestionsInCategory(@RequestBody Map<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idCateg = Integer.parseInt(vals.get("idCateg"));
        return ResponseTools.getResponse(QuestionListService::loadQuestionsInCategory, (Object)this.questionListService, (Object)idCateg, (Object)idTest);
    }

    @PostMapping(value={"/data/auth/user/question/load_all"})
    public ResponseEntity<DtoAndMsg<Map<Integer, List<QuestionListDTO>>>> loadAllQuestions() {
        return ResponseTools.getResponse(QuestionListService::loadAllQuestions, (Object)this.questionListService);
    }

    @PostMapping(value={"/data/auth/user/question/load_texthistory"})
    public ResponseEntity<DtoAndMsg<List<QuestionTextHistoryDTO>>> loadHistory(@RequestBody Integer id) {
        return ResponseTools.getResponse(QuestionService::loadHistory, (Object)this.questionService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/question/save_texthistory"})
    public ResponseEntity<DtoAndMsg<String>> saveHistory(@RequestBody QuestionTextHistoryDTO questionTextHistoryDTO) {
        return ResponseTools.getErrResponse(QuestionService::saveHistory, (Object)this.questionService, (Object)questionTextHistoryDTO);
    }

    @PostMapping(value={"/data/auth/user/question/search_question"})
    public ResponseEntity<DtoAndMsg<List<QuestionListDTO>>> searchQuestion(@RequestBody QuestionSearchDto search) {
        return ResponseTools.getResponse(QuestionSearchService::searchQuestion, (Object)this.searchService, (Object)search);
    }

    @PostMapping(value={"/data/auth/user/question/change_penalty"})
    public ResponseEntity<DtoAndMsg<String>> changePenalty(@RequestBody ChangePenaltyDto penalty) {
        return ResponseTools.getErrResponse(QuestionService::changePenalty, (Object)this.questionService, (Object)penalty.getIds(), (Object)penalty.getPenalty());
    }
}

