/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.export.DtoExpImp;
import at.letto.data.repository.CategoryEntityRepository;
import at.letto.data.service.category.CategoryServiceDatabase;
import at.letto.data.service.category.KompetenzCategoryService;
import at.letto.data.service.category.RechteCategoryService;
import at.letto.data.service.export.ImportExportService;
import at.letto.export.dto.ImportExportDto;
import at.letto.export.dto.api.DataLoadCategoryQuestionsRequestDto;
import at.letto.export.dto.api.DataLoadQuestionsRequestDto;
import at.letto.export.dto.api.DataSaveCategoryRequestDto;
import at.letto.export.dto.api.DataSaveQuestionRequestDto;
import at.letto.export.dto.api.InfoResultDto;
import at.letto.export.restclient.RestExportService;
import at.letto.tools.JSON;
import at.letto.tools.ServerStatus;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.FunctionInterfaces;
import at.letto.tools.rest.MsgException;
import at.letto.tools.rest.ResponseTools;
import at.letto.tools.rest.RestException;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping
public class ExportController {
    @Autowired
    CategoryServiceDatabase categoryService;
    @Autowired
    RechteCategoryService rechteService;
    @Autowired
    CategoryEntityRepository categoryRepository;
    @Autowired
    KompetenzCategoryService kompetenzCategoryService;
    @Autowired
    ImportExportService importExportService;

    @GetMapping(value={"/export/auth/user/info"})
    public ResponseEntity<InfoResultDto> infoData() {
        HashMap info = new HashMap();
        ArrayList<String> exportClasses = new ArrayList<String>();
        ArrayList<String> importClasses = new ArrayList<String>();
        for (Class c : RestExportService.classes) {
            exportClasses.add(c.getName());
            importClasses.add(c.getName());
        }
        InfoResultDto infoResultDto = new InfoResultDto(ServerStatus.getRevision(), "1.0", exportClasses, importClasses, info);
        return ResponseEntity.ok((Object)infoResultDto);
    }

    public static <T, S, D1, D2, D3> ResponseEntity<DtoExpImp> getImpExpResponse(FunctionInterfaces.ThreeParameterFunction<S, D1, D2, ImportExportDto> function, S service, D1 dto1, D2 dto2) {
        try {
            ImportExportDto erg = (ImportExportDto)function.apply(service, dto1, dto2);
            DtoExpImp dto = new DtoExpImp(erg);
            String x = JSON.objToJson((Object)dto);
            return ResponseEntity.ok((Object)dto);
        }
        catch (MsgException m) {
            return ResponseEntity.ok((Object)new DtoExpImp(m.getMessage()));
        }
        catch (RestException r) {
            return ResponseEntity.ok((Object)new DtoExpImp(r.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)new DtoExpImp(e));
        }
    }

    @PostMapping(value={"/data/auth/user/export/export_load_category_question"})
    public ResponseEntity<DtoExpImp> loadCategoryQuestion(@RequestBody DataLoadCategoryQuestionsRequestDto dto) {
        return ExportController.getImpExpResponse(ImportExportService::loadCategory_v1, (Object)this.importExportService, (Object)dto.getIdCategory(), (Object)dto.getImportClasses());
    }

    @PostMapping(value={"/data/auth/user/export/export_load_question"})
    public ResponseEntity<DtoExpImp> loadQuestion(@RequestBody DataLoadQuestionsRequestDto dto) {
        return ExportController.getImpExpResponse(ImportExportService::loadQuestion_v1, (Object)this.importExportService, (Object)dto.getIdQuestion(), (Object)dto.getImportClasses());
    }

    @PostMapping(value={"/data/auth/user/export/export_save_category"})
    public ResponseEntity<DtoAndMsg<Integer>> saveCategory(@RequestBody DataSaveCategoryRequestDto dto) {
        return ResponseTools.getErrResponse(ImportExportService::saveCategory_v1, (Object)this.importExportService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/export/export_save_question"})
    public ResponseEntity<DtoAndMsg<Integer>> saveQuestion(@RequestBody DataSaveQuestionRequestDto dto) {
        return ResponseTools.getErrResponse(ImportExportService::saveQuestion_v1, (Object)this.importExportService, (Object)dto);
    }
}

