/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.category.CategorySortDTO;
import at.letto.data.dto.category.MoveCategoryDto;
import at.letto.data.dto.category.kompetenzen.CategoryKompetenzDto;
import at.letto.data.dto.category.kompetenzen.SaveKompetenzenDto;
import at.letto.data.dto.category.kompetenzen.SaveSingleKompetenzenDto;
import at.letto.data.dto.category.rechte.RechteCategoryDto;
import at.letto.data.repository.CategoryEntityRepository;
import at.letto.data.service.category.CategoryServiceDatabase;
import at.letto.data.service.category.KompetenzCategoryService;
import at.letto.data.service.category.RechteCategoryService;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class CategoryController {
    @Autowired
    CategoryServiceDatabase categoryService;
    @Autowired
    RechteCategoryService rechteService;
    @Autowired
    CategoryEntityRepository categoryRepository;
    @Autowired
    KompetenzCategoryService kompetenzCategoryService;

    @PostMapping(value={"/data/auth/user/category/cat_load_by_id"})
    public ResponseEntity<DtoAndMsg<CategoryDTO>> loadCategoryById(@RequestBody Integer id) {
        return ResponseTools.getErrResponse(CategoryServiceDatabase::findCategory, (Object)this.categoryService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/category/cat_load_by_path"})
    public ResponseEntity<DtoAndMsg<CategorySortDTO>> loadCategoryByPath(@RequestBody String path) {
        return ResponseTools.getErrResponse(CategoryServiceDatabase::findCategoryByPath, (Object)this.categoryService, (Object)path);
    }

    @PostMapping(value={"/data/auth/user/category/cat_load_all"})
    public ResponseEntity<DtoAndMsg<List<CategoryDTO>>> findAllCategories() {
        return ResponseTools.getResponse(CategoryServiceDatabase::findAllCategories, (Object)this.categoryService);
    }

    @PostMapping(value={"/data/auth/user/category/insert_category"})
    public ResponseEntity<DtoAndMsg<CategoryDTO>> insertCategory(@RequestBody Map<String, String> vals) {
        int idParent = Integer.parseInt(vals.get("idParent"));
        String name = vals.get("name");
        int pos = Integer.parseInt(vals.get("pos"));
        return ResponseTools.getResponse(CategoryServiceDatabase::insertCategory, (Object)this.categoryService, (Object)idParent, (Object)name, (Object)pos);
    }

    @PostMapping(value={"/data/auth/user/category/move_category"})
    public ResponseEntity<DtoAndMsg<String>> moveCategory(@RequestBody MoveCategoryDto move) {
        return ResponseTools.getErrResponse(CategoryServiceDatabase::moveCateg, (Object)this.categoryService, (Object)move.getIdCat(), (Object)move.getIdZiel(), (Object)move.getOrder());
    }

    @PostMapping(value={"/data/auth/user/category/rename_category"})
    public ResponseEntity<DtoAndMsg<String>> renameCategory(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        String name = vals.get("name");
        return ResponseTools.getErrResponse(CategoryServiceDatabase::renameCateg, (Object)this.categoryService, (Object)id, (Object)name);
    }

    @PostMapping(value={"/data/auth/user/category/einheit"})
    public ResponseEntity<DtoAndMsg<String>> updateCategoryEinheit(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        String ehKorr = vals.get("ehKorr");
        boolean eh = vals.get("eh").equals("true");
        return ResponseTools.getErrResponse(CategoryServiceDatabase::updateCategoryEinheit, (Object)this.categoryService, (Object)id, (Object)ehKorr, (Object)eh);
    }

    @PostMapping(value={"/data/auth/user/category/delete_category"})
    public ResponseEntity<DtoAndMsg<String>> deleteCategory(@RequestBody Map<String, String> vals) {
        int id = Integer.parseInt(vals.get("id"));
        boolean force = vals.get("force").equals("true");
        return ResponseTools.getErrResponse(CategoryServiceDatabase::deleteCateg, (Object)this.categoryService, (Object)id, (Object)force);
    }

    @PostMapping(value={"/data/auth/user/category/sort_order_category"})
    public ResponseEntity<DtoAndMsg<String>> setCategoriesOrder(@RequestBody List<Integer> ids) {
        return ResponseTools.getErrResponse(CategoryServiceDatabase::setCategoriesOrder, (Object)this.categoryService, ids);
    }

    @PostMapping(value={"/data/auth/user/category/load_rechte_all"})
    public ResponseEntity<DtoAndMsg<List<RechteCategoryDto>>> findAllRechte() {
        return ResponseTools.getResponse(RechteCategoryService::findAllRechte, (Object)this.rechteService);
    }

    @PostMapping(value={"/data/auth/user/category/load_recht"})
    public ResponseEntity<DtoAndMsg<RechteCategoryDto>> findRecht(@RequestBody Integer id) {
        return ResponseTools.getResponse(RechteCategoryService::findRecht, (Object)this.rechteService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/category/load_rechte_category"})
    public ResponseEntity<DtoAndMsg<List<RechteCategoryDto>>> findRechteForCategory(@RequestBody Integer id) {
        return ResponseTools.getErrResponse(RechteCategoryService::findRechteForCategory, (Object)this.rechteService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/category/change_rechte"})
    public ResponseEntity<DtoAndMsg<String>> rechteChange(@RequestBody RechteCategoryDto dto) {
        return ResponseTools.getErrResponse(RechteCategoryService::rechteChange, (Object)this.rechteService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/category/add_rechte"})
    public ResponseEntity<DtoAndMsg<Integer>> rechteAdd(@RequestBody RechteCategoryDto dto) {
        return ResponseTools.getResponse(RechteCategoryService::rechteAdd, (Object)this.rechteService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/category/del_recht"})
    public ResponseEntity<DtoAndMsg<String>> rechteRemove(@RequestBody RechteCategoryDto dto) {
        return ResponseTools.getErrResponse(RechteCategoryService::rechteRemove, (Object)this.rechteService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/category/set_single_kompetenz"})
    public ResponseEntity<DtoAndMsg<String>> saveSingleKompetenz(@RequestBody SaveSingleKompetenzenDto dto) {
        return ResponseTools.getErrResponse(KompetenzCategoryService::saveSingleKompetenz, (Object)this.kompetenzCategoryService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/category/load_kompetenzen"})
    public ResponseEntity<DtoAndMsg<List<CategoryKompetenzDto>>> loadKompetenzenForCategory(@RequestBody Integer idCategory) {
        return ResponseTools.getErrResponse(KompetenzCategoryService::loadKompetenzenForCategory, (Object)this.kompetenzCategoryService, (Object)idCategory);
    }

    @PostMapping(value={"/data/auth/user/category/save_kompetenzen"})
    public ResponseEntity<DtoAndMsg<String>> saveKompetenzenForCategory(@RequestBody SaveKompetenzenDto dto) {
        return ResponseTools.getErrResponse(KompetenzCategoryService::saveKompetenzenForCategory, (Object)this.kompetenzCategoryService, (Object)dto);
    }
}

