/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.config.MicroServiceConfiguration;
import at.letto.data.dto.PairIntString;
import at.letto.data.dto.beurteilung.BeurteilungDTO;
import at.letto.data.dto.beurteilung.ChangeGewichtDto;
import at.letto.data.dto.beurteilung.DefineStudentGroup;
import at.letto.data.dto.beurteilung.FremdLehrerDTO;
import at.letto.data.dto.beurteilung.KlassenBeurteilungDTO;
import at.letto.data.dto.beurteilung.KlassenInfoDTO;
import at.letto.data.dto.beurteilung.KompetenzBeurteilungsDTO;
import at.letto.data.dto.beurteilung.LehrerInfoDTO;
import at.letto.data.dto.beurteilung.LoadTestsSemesterDto;
import at.letto.data.dto.beurteilung.NoteDTO;
import at.letto.data.dto.beurteilung.StudentDto;
import at.letto.data.dto.beurteilung.StudentGroupDto;
import at.letto.data.dto.beurteilung.TestDTO;
import at.letto.data.dto.beurteilung.TestPunkteDTO;
import at.letto.data.dto.beurteilung.TestversuchDTO;
import at.letto.data.service.beurteilung.BeurteilungDataService;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import at.letto.tools.rest.ResponseToolsObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class BeurteilungsController {
    @Autowired
    private BeurteilungDataService beurteilungService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    private ResponseToolsObject r = new ResponseToolsObject("Dataservice", "Beurteilungscontroller");

    @PostMapping(value={"/data/auth/user/beurt/save"})
    public ResponseEntity<DtoAndMsg<BeurteilungDTO>> save(@RequestBody BeurteilungDTO b) {
        return this.r.getResponse(BeurteilungDataService::saveBeurteilung, (Object)this.beurteilungService, (Object)b);
    }

    @PostMapping(value={"/data/auth/user/beurt/save_kb"})
    public ResponseEntity<DtoAndMsg<KlassenBeurteilungDTO>> save(@RequestBody KlassenBeurteilungDTO kb) {
        return this.r.getResponse(BeurteilungDataService::saveKlassenBeurteilung, (Object)this.beurteilungService, (Object)kb);
    }

    @PostMapping(value={"/data/auth/user/beurt/save_note"})
    public ResponseEntity<DtoAndMsg<NoteDTO>> saveNote(@RequestBody NoteDTO n) {
        return this.r.getResponse(BeurteilungDataService::saveNote, (Object)this.beurteilungService, (Object)n);
    }

    @PostMapping(value={"/data/auth/user/beurt/load"})
    public ResponseEntity<DtoAndMsg<BeurteilungDTO>> loadBeurteilung(@RequestBody int id) {
        return this.r.getResponse(BeurteilungDataService::loadBeurteilung, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_kb"})
    public ResponseEntity<DtoAndMsg<KlassenBeurteilungDTO>> loadKlassenbeurteilung(@RequestBody int id) {
        return this.r.getResponse(BeurteilungDataService::loadKlassenbeurteilung, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_lk_conf"})
    public ResponseEntity<DtoAndMsg<String>> loadLehrerKlasseConfig(@RequestBody Integer id) {
        return this.r.getResponse(BeurteilungDataService::loadLehrerKlasseConfig, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_lk_idLehrer"})
    public ResponseEntity<DtoAndMsg<Integer>> loadLehrerID(@RequestBody Integer id) {
        return this.r.getResponse(BeurteilungDataService::loadLehrerID, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_tests_byAct"})
    public ResponseEntity<DtoAndMsg<List<TestDTO>>> loadTestsByAct(@RequestBody Set<Integer> idAct) {
        return this.r.getResponse(BeurteilungDataService::loadTestsByAct, (Object)this.beurteilungService, idAct);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_testpoints_group"})
    public ResponseEntity<DtoAndMsg<List<TestPunkteDTO>>> loadTestPoints(@RequestBody Set<Integer> idAct) {
        return this.r.getResponse(BeurteilungDataService::loadTestPoints, (Object)this.beurteilungService, idAct);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_versuche_by_testids"})
    public ResponseEntity<DtoAndMsg<List<TestversuchDTO>>> loadTestVersuche(@RequestBody Set<Integer> idTests) {
        return this.r.getResponse(BeurteilungDataService::loadTestVersuche, (Object)this.beurteilungService, idTests);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_students"})
    public ResponseEntity<DtoAndMsg<List<StudentDto>>> loadStudents(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadStudents, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_student_groups"})
    public ResponseEntity<DtoAndMsg<List<StudentGroupDto>>> loadStudentGroups(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadStudentGroups, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_activity_path"})
    public ResponseEntity<DtoAndMsg<List<String>>> loadActivitiesInKlasse(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadActivitiesInKlasse, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_by_lk"})
    public ResponseEntity<DtoAndMsg<List<BeurteilungDTO>>> loadByLK(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadByLK, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_global_by_lk"})
    public ResponseEntity<DtoAndMsg<List<BeurteilungDTO>>> loadGlobalByLK(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadGlobalByLK, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_sub_beurt"})
    public ResponseEntity<DtoAndMsg<List<BeurteilungDTO>>> loadSubBeurteilungen(@RequestBody Set<Integer> ids) {
        return this.r.getResponse(BeurteilungDataService::loadSubBeurteilungen, (Object)this.beurteilungService, ids);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_fremdlehrer"})
    public ResponseEntity<DtoAndMsg<List<FremdLehrerDTO>>> loadFremdLehrer(@RequestBody Set<Integer> ids) {
        return this.r.getResponse(BeurteilungDataService::loadFremdLehrer, (Object)this.beurteilungService, ids);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_kompetenzen"})
    public ResponseEntity<DtoAndMsg<List<KompetenzBeurteilungsDTO>>> loadKompetenzen(@RequestBody Set<Integer> ids) {
        return this.r.getResponse(BeurteilungDataService::loadKompetenzen, (Object)this.beurteilungService, ids);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_kb_by_lk"})
    public ResponseEntity<DtoAndMsg<List<KlassenBeurteilungDTO>>> loadKlassenBeurteilungen(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadKlassenBeurteilungen, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_parent_kb"})
    public ResponseEntity<DtoAndMsg<KlassenBeurteilungDTO>> loadParentKlassenbeurteilung(@RequestBody int id) {
        return this.r.getResponse(BeurteilungDataService::loadParentKlassenbeurteilung, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_kb_sub_beurt"})
    public ResponseEntity<DtoAndMsg<List<KlassenBeurteilungDTO>>> loadSubKlassenBeurteilungDto(@RequestBody Set<Integer> idsParent) {
        return this.r.getResponse(BeurteilungDataService::loadSubKlassenBeurteilung, (Object)this.beurteilungService, idsParent);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_kb_global_by_lk"})
    public ResponseEntity<DtoAndMsg<List<KlassenBeurteilungDTO>>> loadGlobalKlassenBeurteilungDto(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadGlobalKlassenBeurteilung, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_noten"})
    public ResponseEntity<DtoAndMsg<List<NoteDTO>>> loadNoten(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadNoten, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/set_user_group"})
    public ResponseEntity<DtoAndMsg<String>> setUserGruppe(@RequestBody DefineStudentGroup g) {
        return this.r.getResponse(BeurteilungDataService::setUserGruppe, (Object)this.beurteilungService, (Object)g.getStudentDto(), (Object)g.getIdLk(), (Object)g.getGruppe());
    }

    @PostMapping(value={"/data/auth/user/beurt/change_gewicht_lk"})
    public ResponseEntity<DtoAndMsg<String>> changeLehrerKlasseGewicht(@RequestBody ChangeGewichtDto g) {
        return ResponseTools.getErrResponse(BeurteilungDataService::changeLehrerKlasseGewicht, (Object)this.beurteilungService, (Object)g.getId(), (Object)g.getGewicht());
    }

    @PostMapping(value={"/data/auth/user/beurt/change_gewicht_kb"})
    public ResponseEntity<DtoAndMsg<String>> changeKlassenbeurteilungsGewicht(@RequestBody ChangeGewichtDto g) {
        return ResponseTools.getErrResponse(BeurteilungDataService::changeKlassenbeurteilungsGewicht, (Object)this.beurteilungService, (Object)g.getId(), (Object)g.getGewicht());
    }

    @PostMapping(value={"/data/auth/user/beurt/load_klassen_info"})
    public ResponseEntity<DtoAndMsg<KlassenInfoDTO>> loadKlassenInfo(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadKlassenInfo, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_lehrer_in_klasse"})
    public ResponseEntity<DtoAndMsg<List<LehrerInfoDTO>>> loadLehrerInKlasse(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadLehrerInKlasse, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_beurt_sj"})
    public ResponseEntity<DtoAndMsg<List<Integer>>> loadBeurteilungenSchuljahr(@RequestBody int idSchuljahr) {
        return this.r.getResponse(BeurteilungDataService::loadBeurteilungenSchuljahr, (Object)this.beurteilungService, (Object)idSchuljahr);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_by_klasse"})
    public ResponseEntity<DtoAndMsg<List<BeurteilungDTO>>> loadByKlasse(@RequestBody int idKlasse) {
        return this.r.getResponse(BeurteilungDataService::loadByKlasse, (Object)this.beurteilungService, (Object)idKlasse);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_test_full_path"})
    public ResponseEntity<DtoAndMsg<List<PairIntString>>> loadTestsWithFullPath(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadTestsWithFullPath, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_test_global_path"})
    public ResponseEntity<DtoAndMsg<List<PairIntString>>> loadTestsGlobalWithFullPath(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadTestsGlobalWithFullPath, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_test_full_path_ws"})
    public ResponseEntity<DtoAndMsg<List<PairIntString>>> loadTestsFullPathWinterSemester(@RequestBody LoadTestsSemesterDto x) {
        return this.r.getResponse(BeurteilungDataService::loadTestsFullPathWinterSemester, (Object)this.beurteilungService, (Object)x.getIdLk(), (Object)x.getSemester());
    }

    @PostMapping(value={"/data/auth/user/beurt/load_test_global_path_ws"})
    public ResponseEntity<DtoAndMsg<List<PairIntString>>> loadTestsGlobalFullPathWinterSemester(@RequestBody LoadTestsSemesterDto x) {
        return this.r.getResponse(BeurteilungDataService::loadTestsGlobalFullPathWinterSemester, (Object)this.beurteilungService, (Object)x.getIdLk(), (Object)x.getSemester());
    }

    @PostMapping(value={"/data/auth/user/beurt/load_test_full_path_ss"})
    public ResponseEntity<DtoAndMsg<List<PairIntString>>> loadTestsFullPathSommerSemester(@RequestBody LoadTestsSemesterDto x) {
        return this.r.getResponse(BeurteilungDataService::loadTestsFullPathSommerSemester, (Object)this.beurteilungService, (Object)x.getIdLk(), (Object)x.getSemester());
    }

    @PostMapping(value={"/data/auth/user/beurt/load_test_global_path_ss"})
    public ResponseEntity<DtoAndMsg<List<PairIntString>>> loadTestsGlobalFullPathSommerSemester(@RequestBody LoadTestsSemesterDto x) {
        return this.r.getResponse(BeurteilungDataService::loadTestsGlobalFullPathSommerSemester, (Object)this.beurteilungService, (Object)x.getIdLk(), (Object)x.getSemester());
    }

    @PostMapping(value={"/data/auth/user/beurt/load_beurt_kb_user"})
    public ResponseEntity<DtoAndMsg<BeurteilungDTO>> loadBeurteilungFromKlassenbeurteilungAndUser(@RequestBody HashMap<String, String> vals) {
        int idKb = Integer.parseInt(vals.get("idKb"));
        int idUser = Integer.parseInt(vals.get("idUser"));
        return this.r.getResponse(BeurteilungDataService::loadBeurteilungFromKlassenbeurteilungAndUser, (Object)this.beurteilungService, (Object)idKb, (Object)idUser);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_note"})
    public ResponseEntity<DtoAndMsg<NoteDTO>> loadNote(@RequestBody int idNote) {
        return this.r.getResponse(BeurteilungDataService::loadNote, (Object)this.beurteilungService, (Object)idNote);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_test_groups"})
    public ResponseEntity<DtoAndMsg<Map<Integer, List<Integer>>>> loadTestGroups(@RequestBody Set<Integer> idAct) {
        return this.r.getResponse(BeurteilungDataService::loadTestGroups, (Object)this.beurteilungService, idAct);
    }

    @PostMapping(value={"/data/auth/user/beurt/change_config_lk"})
    public ResponseEntity<DtoAndMsg<String>> changeConfig(@RequestBody HashMap<String, String> vals) {
        int idLk = Integer.parseInt(vals.get("idLk"));
        String config = vals.get("config");
        return this.r.getResponse(BeurteilungDataService::changeConfig, (Object)this.beurteilungService, (Object)config, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_fremdlehrer_kl"})
    public ResponseEntity<DtoAndMsg<List<LehrerInfoDTO>>> loadFremdLehrerInKlasse(@RequestBody int idLk) {
        return this.r.getResponse(BeurteilungDataService::loadFremdLehrerInKlasse, (Object)this.beurteilungService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurt/load_idlk_from_beurt"})
    public ResponseEntity<DtoAndMsg<Integer>> loadIdLkBeurteilung(@RequestBody int id) {
        return this.r.getResponse(BeurteilungDataService::loadIdLkBeurteilung, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/del"})
    public ResponseEntity<DtoAndMsg<String>> delBeurteilung(@RequestBody int id) {
        return this.r.getResponse(BeurteilungDataService::delBeurteilung, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/del_kb"})
    public ResponseEntity<DtoAndMsg<String>> delKlassenBeurteilung(@RequestBody int id) {
        return this.r.getResponse(BeurteilungDataService::delKlassenBeurteilung, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/del_test_vers"})
    public ResponseEntity<DtoAndMsg<String>> delBeurteilungenTestversuch(@RequestBody int id) {
        return this.r.getResponse(BeurteilungDataService::delBeurteilungenTestversuch, (Object)this.beurteilungService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurt/del_test"})
    public ResponseEntity<DtoAndMsg<BeurteilungDTO>> delOnlineTest(@RequestBody BeurteilungDTO b) {
        return this.r.getResponse(BeurteilungDataService::delOnlineTest, (Object)this.beurteilungService, (Object)b);
    }

    @PostMapping(value={"/data/auth/user/beurt/del_test_kb"})
    public ResponseEntity<DtoAndMsg<KlassenBeurteilungDTO>> delOnlineTest(@RequestBody KlassenBeurteilungDTO b) {
        return this.r.getResponse(BeurteilungDataService::delOnlineTest, (Object)this.beurteilungService, (Object)b);
    }
}

