/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.beuteilungsschema.BeurteilungsartDTO;
import at.letto.data.dto.beuteilungsschema.BeurteilungsartGlobalDTO;
import at.letto.data.dto.beuteilungsschema.BeurteilungsconfigDTO;
import at.letto.data.repository.BeurteilungsartGlobalEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.beurteilung.BeurteilungConfigService;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class BeurteilungsConfigController {
    @Autowired
    BeurteilungConfigService beurteilungConfigService;
    @Autowired
    AllRepositories repos;

    @PostMapping(value={"/data/auth/user/beurtconf/findSchemaBA"})
    public ResponseEntity<DtoAndMsg<BeurteilungsconfigDTO>> findSchemaForBeurteilungsart(@RequestBody String beurteilungsart) {
        return ResponseTools.getResponse(BeurteilungConfigService::findSchemaForBeurteilungsart, (Object)this.beurteilungConfigService, (Object)beurteilungsart);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/loadSchema"})
    public ResponseEntity<DtoAndMsg<BeurteilungsconfigDTO>> loadSchema(@RequestBody int id) {
        return ResponseTools.getResponse(BeurteilungConfigService::loadSchema, (Object)this.beurteilungConfigService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/loadDefSchema"})
    public ResponseEntity<DtoAndMsg<BeurteilungsconfigDTO>> loadDefaultSchema() {
        return ResponseTools.getResponse(BeurteilungConfigService::loadDefaultSchema, (Object)this.beurteilungConfigService);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/loadUserDefault"})
    public ResponseEntity<DtoAndMsg<BeurteilungsconfigDTO>> loadUserDefault(@RequestBody int idUser) {
        return ResponseTools.getResponse(BeurteilungConfigService::loadUserDefault, (Object)this.beurteilungConfigService, (Object)idUser);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/loadByLehrerKlasse"})
    public ResponseEntity<DtoAndMsg<BeurteilungsconfigDTO>> loadSchemaByLehrerKlasse(@RequestBody int idLk) {
        return ResponseTools.getResponse(BeurteilungConfigService::loadSchemaByLehrerKlasse, (Object)this.beurteilungConfigService, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/loadGlobalBeurteilungsart"})
    public ResponseEntity<DtoAndMsg<BeurteilungsartDTO>> loadGlobalBeurteilungsart(@RequestBody String name) {
        return ResponseTools.getResponse(BeurteilungConfigService::loadGlobalBeurteilungsart, (Object)this.beurteilungConfigService, (Object)name);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/loadBeurteilungsartByBezeichner"})
    public ResponseEntity<DtoAndMsg<BeurteilungsartDTO>> loadBeurteilungsartByBezeichner(@RequestBody String name) {
        return ResponseTools.getResponse(BeurteilungConfigService::loadBeurteilungsartByBezeichner, (Object)this.beurteilungConfigService, (Object)name);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/save"})
    public ResponseEntity<DtoAndMsg<String>> save(@RequestBody BeurteilungsconfigDTO schema) {
        return ResponseTools.getErrResponse(BeurteilungConfigService::save, (Object)this.beurteilungConfigService, (Object)schema);
    }

    @PostMapping(value={"/data/auth/user/beurtconf/load_online_tests"})
    public ResponseEntity<DtoAndMsg<List<BeurteilungsartGlobalDTO>>> loadOnlineTests() {
        return ResponseTools.getResponse(BeurteilungsartGlobalEntityRepository::loadOnlineTests, (Object)this.repos.beurteilungsartGlobalEntityRepository);
    }
}

