/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.activity.ActivityBaseDto;
import at.letto.data.dto.activity.ActivityDto;
import at.letto.data.dto.activity.InsertHtmlActivities;
import at.letto.data.dto.activity.RetHtmlActivity;
import at.letto.data.dto.activitytype.ActivitytypeBaseDto;
import at.letto.data.dto.beurteilung.LehrerInfoDTO;
import at.letto.data.dto.gegenstand.GegenstandBaseDto;
import at.letto.data.dto.inetlinks.InetlinksBaseDto;
import at.letto.data.dto.klasse.KlasseBaseDto;
import at.letto.data.dto.lehrerKlasse.LehrerKlasseBaseDto;
import at.letto.data.dto.schuelerKlasse.SchuelerKlasseBaseDto;
import at.letto.data.dto.schuljahr.SchuljahrBaseDto;
import at.letto.data.dto.tests.TestsBaseDto;
import at.letto.data.dto.user.UserDto;
import at.letto.data.dto.user.UserSimpleDto;
import at.letto.data.repository.ActivityEntityRepository;
import at.letto.data.repository.ActivitytypeEntityRepository;
import at.letto.data.repository.GegenstandEntityRepository;
import at.letto.data.repository.InetlinksEntityRepository;
import at.letto.data.repository.KlasseEntityRepository;
import at.letto.data.repository.LehrerKlasseEntityRepository;
import at.letto.data.repository.SchuelerKlasseEntityRepository;
import at.letto.data.repository.SchuljahrEntityRepository;
import at.letto.data.repository.TestsEntityRepository;
import at.letto.data.repository.UserEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.activity.ActivityService;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class BaseEntitiesController {
    @Autowired
    AllRepositories repos;
    @Autowired
    ActivityService activityService;

    @PostMapping(value={"/data/auth/user/base/loadschuljahre"})
    public ResponseEntity<DtoAndMsg<List<SchuljahrBaseDto>>> loadSchuljahre() {
        return ResponseTools.getResponse(SchuljahrEntityRepository::loadSchuljahre, (Object)this.repos.schuljahrEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/loadschuljahr_by_id"})
    public ResponseEntity<DtoAndMsg<SchuljahrBaseDto>> loadSchuljahrById(@RequestBody Integer id) {
        return ResponseTools.getResponse(SchuljahrEntityRepository::loadById, (Object)this.repos.schuljahrEntityRepository, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/base/loadschuljahre_schueler"})
    public ResponseEntity<DtoAndMsg<List<SchuljahrBaseDto>>> loadSchuljahrSchueler(@RequestBody Integer idUser) {
        return ResponseTools.getResponse(SchuljahrEntityRepository::loadSchuljahreSchueler, (Object)this.repos.schuljahrEntityRepository, (Object)idUser);
    }

    @PostMapping(value={"/data/auth/user/base/load_klassen"})
    public ResponseEntity<DtoAndMsg<List<KlasseBaseDto>>> loadKlassen() {
        return ResponseTools.getResponse(KlasseEntityRepository::loadKlassen, (Object)this.repos.klasseEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_klassen_schuljahr"})
    public ResponseEntity<DtoAndMsg<List<KlasseBaseDto>>> loadKlasseBySchuljahr(@RequestBody Integer idSchuljahr) {
        return ResponseTools.getResponse(KlasseEntityRepository::loadKlassenBySchuljahr, (Object)this.repos.klasseEntityRepository, (Object)idSchuljahr);
    }

    @PostMapping(value={"/data/auth/user/base/load_lehrer_klassen"})
    public ResponseEntity<DtoAndMsg<List<LehrerKlasseBaseDto>>> loadLehrerKlassen() {
        return ResponseTools.getResponse(LehrerKlasseEntityRepository::loadAll, (Object)this.repos.lehrerKlasseEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_gegenstaende"})
    public ResponseEntity<DtoAndMsg<List<GegenstandBaseDto>>> loadGegenstaende() {
        return ResponseTools.getResponse(GegenstandEntityRepository::loadGegenstaende, (Object)this.repos.gegenstandEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_lehrer_simple"})
    public ResponseEntity<DtoAndMsg<List<UserSimpleDto>>> loadLehrerSimple() {
        return ResponseTools.getResponse(UserEntityRepository::loadLehrerSimple, (Object)this.repos.userEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_lehrer"})
    public ResponseEntity<DtoAndMsg<List<UserDto>>> loadLehrer() {
        return ResponseTools.getResponse(UserEntityRepository::loadLehrer, (Object)this.repos.userEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_user_by_id"})
    public ResponseEntity<DtoAndMsg<UserDto>> loadUser(@RequestBody Integer idUser) {
        return ResponseTools.getResponse(UserEntityRepository::loadUserById, (Object)this.repos.userEntityRepository, (Object)idUser);
    }

    @PostMapping(value={"/data/auth/user/base/load_user_by_name"})
    public ResponseEntity<DtoAndMsg<UserDto>> loadUserByName(@RequestBody String name) {
        return ResponseTools.getResponse(UserEntityRepository::loadUserByName, (Object)this.repos.userEntityRepository, (Object)name);
    }

    @PostMapping(value={"/data/auth/user/base/load_schueler_by_klasse"})
    public ResponseEntity<DtoAndMsg<List<UserDto>>> loadSchuelerByKlasse(@RequestBody Integer idKlasse) {
        return ResponseTools.getResponse(UserEntityRepository::loadSchuelerByKlasse, (Object)this.repos.userEntityRepository, (Object)idKlasse);
    }

    @PostMapping(value={"/data/auth/user/base/load_schueler_all"})
    public ResponseEntity<DtoAndMsg<List<SchuelerKlasseBaseDto>>> loadSchuelerAll() {
        return ResponseTools.getResponse(SchuelerKlasseEntityRepository::loadSchuelerKlasseAll, (Object)this.repos.schuelerKlasseEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/change_activity_visible"})
    public ResponseEntity<DtoAndMsg<String>> changeActivityVisibility(@RequestBody Map<String, String> map) {
        return ResponseTools.getResponse(ActivityService::updateVisibility, (Object)this.activityService, map);
    }

    @PostMapping(value={"/data/auth/user/base/change_activity_name"})
    public ResponseEntity<DtoAndMsg<String>> changeActivityName(@RequestBody Map<String, String> map) {
        return ResponseTools.getResponse(ActivityService::updateName, (Object)this.activityService, map);
    }

    @PostMapping(value={"/data/auth/user/base/change_test"})
    public ResponseEntity<DtoAndMsg<String>> changeTest(@RequestBody ActivityDto act) {
        return ResponseTools.getResponse(ActivityService::changeTest, (Object)this.activityService, (Object)act);
    }

    @PostMapping(value={"/data/auth/user/base/delete_activity"})
    public ResponseEntity<DtoAndMsg<String>> deleteActivity(@RequestBody Integer idAct) {
        return ResponseTools.getResponse(ActivityService::deleteActivity, (Object)this.activityService, (Object)idAct);
    }

    @PostMapping(value={"/data/auth/user/base/insert_activity"})
    public ResponseEntity<DtoAndMsg<Integer>> insertActivity(@RequestBody ActivityDto act) {
        return ResponseTools.getResponse(ActivityService::insertActivity, (Object)this.activityService, (Object)act, (Object)act.getPos());
    }

    @PostMapping(value={"/data/auth/user/base/insert_html_activity"})
    public ResponseEntity<DtoAndMsg<List<RetHtmlActivity>>> insertActivity(@RequestBody InsertHtmlActivities act) {
        return ResponseTools.getResponse(ActivityService::insHtmlQuestion, (Object)this.activityService, (Object)act.getIdQestions(), (Object)act.getIdLk(), (Object)act.getIdParent(), (Object)act.getIdUser());
    }

    @PostMapping(value={"/data/auth/user/base/load_activity_types"})
    public ResponseEntity<DtoAndMsg<List<ActivitytypeBaseDto>>> loadActivityTypes() {
        return ResponseTools.getResponse(ActivitytypeEntityRepository::loadAll, (Object)this.repos.activitytypeEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_activities"})
    public ResponseEntity<DtoAndMsg<List<ActivityBaseDto>>> loadActivities() {
        return ResponseTools.getResponse(ActivityEntityRepository::loadAll, (Object)this.repos.activityEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_activity_by_id"})
    public ResponseEntity<DtoAndMsg<ActivityBaseDto>> loadActivityById(@RequestBody Integer id) {
        return ResponseTools.getResponse(ActivityEntityRepository::loadById, (Object)this.repos.activityEntityRepository, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/base/load_test_by_id"})
    public ResponseEntity<DtoAndMsg<TestsBaseDto>> loadTestById(@RequestBody Integer id) {
        return ResponseTools.getResponse(TestsEntityRepository::loadById, (Object)this.repos.testsEntityRepository, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/base/load_fremdlehrer"})
    public ResponseEntity<DtoAndMsg<List<LehrerInfoDTO>>> loadFremdlehrerAll() {
        return ResponseTools.getResponse(LehrerKlasseEntityRepository::findFremdLehrer, (Object)this.repos.lehrerKlasseEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/base/load_inetlink"})
    public ResponseEntity<DtoAndMsg<InetlinksBaseDto>> loadInetLink(@RequestBody Integer id) {
        return ResponseTools.getResponse(InetlinksEntityRepository::loadInetLink, (Object)this.repos.inetlinksEntityRepository, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/base/activity_clone"})
    public ResponseEntity<DtoAndMsg<ActivityBaseDto>> cutCopyActivity(@RequestBody HashMap<String, String> vals) {
        return ResponseTools.getResponse(ActivityService::cutCopyActivity, (Object)this.activityService, vals);
    }
}

