/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.dto.DockerContainerStatusDto;
import at.letto.setupservice.dto.SystemStatusDto;
import at.letto.setupservice.dto.Trend.DockerStatusTrendDto;
import at.letto.setupservice.dto.Trend.SystemStatusTrendDto;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LogFileService;
import at.letto.tools.Datum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemStatusTrendService {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private LogFileService logFileService;

    public SystemStatusTrendDto loadLogfileTrend() {
        SystemStatusTrendDto systemStatusTrendDto = new SystemStatusTrendDto();
        File logfile = this.logFileService.getLogfileSystemStatus();
        try {
            String line;
            BufferedReader bfr = new BufferedReader(new FileReader(logfile));
            ArrayList<Long> time = new ArrayList<Long>();
            while ((line = bfr.readLine()) != null) {
                try {
                    SystemStatusDto dto = SystemStatusDto.parse((String)line);
                    long t = dto.getTime();
                    if (t <= 0L) continue;
                    time.add(t);
                    int size = time.size();
                    systemStatusTrendDto.getCpuLoad().add((double)((int)(dto.getCpuLoad() * 10000.0)) / 100.0 + "");
                    systemStatusTrendDto.getMemoryTotalMB().add(dto.getMemoryTotalMB() + "");
                    systemStatusTrendDto.getMemoryFreeMB().add(dto.getMemoryFreeMB() + "");
                    systemStatusTrendDto.getMemoryUsedMB().add(dto.getMemoryUsedMB() + "");
                    systemStatusTrendDto.getMemorySwapTotalMB().add(dto.getMemorySwapTotalMB() + "");
                    systemStatusTrendDto.getMemorySwapFreeMB().add(dto.getMemorySwapFreeMB() + "");
                    systemStatusTrendDto.getMemorySwapUsedMB().add(dto.getMemorySwapUsedMB() + "");
                    systemStatusTrendDto.getMemoryBufferMB().add(dto.getMemoryBufferMB() + "");
                    systemStatusTrendDto.getMemoryAvailableMB().add(dto.getMemoryAvailableMB() + "");
                    systemStatusTrendDto.getMemoryJavaUsedMB().add(dto.getMemoryJavaUsedMB() + "");
                    systemStatusTrendDto.getMemoryJavaMaxMB().add(dto.getMemoryJavaMaxMB() + "");
                    systemStatusTrendDto.getTotalDiskSpaceMB().add(dto.getTotalDiskSpaceMB() + "");
                    systemStatusTrendDto.getFreeDiskSpaceMB().add(dto.getFreeDiskSpaceMB() + "");
                    systemStatusTrendDto.getUseableDiskSpaceMB().add(dto.getUseableDiskSpaceMB() + "");
                    for (DockerContainerStatusDto dc : dto.getDockerContainers()) {
                        String dcname = dc.getName();
                        DockerStatusTrendDto dockerStatusTrendDto = null;
                        if (!systemStatusTrendDto.getDockerContainer().containsKey(dcname)) {
                            dockerStatusTrendDto = new DockerStatusTrendDto();
                            dockerStatusTrendDto.setName(dcname);
                            systemStatusTrendDto.getDockerContainer().put(dcname, dockerStatusTrendDto);
                        } else {
                            dockerStatusTrendDto = (DockerStatusTrendDto)systemStatusTrendDto.getDockerContainer().get(dcname);
                        }
                        while (dockerStatusTrendDto.getCpuProzent().size() < size) {
                            dockerStatusTrendDto.getCpuProzent().add("0");
                        }
                        while (dockerStatusTrendDto.getHealthy().size() < size) {
                            dockerStatusTrendDto.getHealthy().add("0");
                        }
                        while (dockerStatusTrendDto.getMemoryProzent().size() < size) {
                            dockerStatusTrendDto.getMemoryProzent().add("0");
                        }
                        while (dockerStatusTrendDto.getRunning().size() < size) {
                            dockerStatusTrendDto.getRunning().add("0");
                        }
                        dockerStatusTrendDto.getRunning().set(size - 1, dc.isRunning() ? "1" : "0");
                        dockerStatusTrendDto.getHealthy().set(size - 1, dc.isHealthy() ? "1" : "0");
                        dockerStatusTrendDto.getMemoryProzent().set(size - 1, dc.getMemoryProzent() + "");
                        dockerStatusTrendDto.getCpuProzent().set(size - 1, dc.getCpuProzent() + "");
                    }
                }
                catch (Exception dto) {
                }
            }
            bfr.close();
            long lasttime = (Long)time.get(time.size() - 1);
            Iterator iterator = time.iterator();
            while (iterator.hasNext()) {
                long t = (Long)iterator.next();
                Date date = new Date(t);
                String timeString = Datum.simpleTimeFormat.format(date);
                systemStatusTrendDto.getTimeSeconds().add((t - lasttime) / 60000L + "");
                systemStatusTrendDto.getTimeFormat().add(timeString);
            }
            return systemStatusTrendDto;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String canvasTrend(String title, int id, String width, String height, List<String> legend, SystemStatusTrendDto.Trendline ... trendlines) {
        StringBuilder sb = new StringBuilder();
        sb.append("      <h4>" + title + "</h4>        <div> <canvas id=\"systemstatustrend" + id + "\" style=\"max-width:" + width + "; max-height: " + height + "\"  ></canvas> </div>\n        <script>\n          const chartSystemStatusTrend" + id + " = new Chart(\n            document.getElementById('systemstatustrend" + id + "').getContext('2d'),\n            {\n                type: 'line',\n                data: {\n                     labels: [");
        boolean first = true;
        for (String t : legend) {
            sb.append((first ? "'" : ",'") + t + "'");
            first = false;
        }
        sb.append("],\n");
        sb.append("                     datasets:[\n                       ");
        first = true;
        for (int i = 0; i < trendlines.length; ++i) {
            if (!first) {
                sb.append(",\n                       ");
            }
            trendlines[i].canvasTrendline(sb, i);
            first = false;
        }
        sb.append("]");
        sb.append("                },options: {}\n");
        sb.append("            });\n");
        return sb.toString();
    }
}

