/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.model.docker;

import at.letto.setupservice.model.docker.DockerComposeNetworkDto;
import at.letto.setupservice.model.docker.DockerComposeServiceDto;
import at.letto.setupservice.model.docker.DockerComposeVolumeDto;
import java.util.ArrayList;
import java.util.List;

public class DockerComposeDto {
    private String version = "";
    private List<DockerComposeServiceDto> services = new ArrayList();
    private List<DockerComposeVolumeDto> volumes = new ArrayList();
    private List<DockerComposeNetworkDto> networks = new ArrayList();

    public DockerComposeServiceDto serviceFromName(String name) {
        for (DockerComposeServiceDto dto : this.services) {
            if (!dto.getName().trim().equals(name.trim())) continue;
            return dto;
        }
        return null;
    }

    public DockerComposeServiceDto serviceFromContainername(String containername) {
        for (DockerComposeServiceDto dto : this.services) {
            if (!dto.getContainername().trim().equals(containername.trim())) continue;
            return dto;
        }
        return null;
    }

    public DockerComposeServiceDto serviceFromImage(String imagename) {
        String n = imagename.trim();
        for (DockerComposeServiceDto dto : this.services) {
            String im = dto.getImage().trim();
            if (im.equals(n)) {
                return dto;
            }
            if (im.equals("lettohub/" + n)) {
                return dto;
            }
            if (im.startsWith(n + ":")) {
                return dto;
            }
            if (!im.startsWith("lettohub/" + n + ":")) continue;
            return dto;
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public List<DockerComposeServiceDto> getServices() {
        return this.services;
    }

    public List<DockerComposeVolumeDto> getVolumes() {
        return this.volumes;
    }

    public List<DockerComposeNetworkDto> getNetworks() {
        return this.networks;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setServices(List<DockerComposeServiceDto> services) {
        this.services = services;
    }

    public void setVolumes(List<DockerComposeVolumeDto> volumes) {
        this.volumes = volumes;
    }

    public void setNetworks(List<DockerComposeNetworkDto> networks) {
        this.networks = networks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerComposeDto)) {
            return false;
        }
        DockerComposeDto other = (DockerComposeDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List this$services = this.getServices();
        List other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        List this$volumes = this.getVolumes();
        List other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        List this$networks = this.getNetworks();
        List other$networks = other.getNetworks();
        return !(this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerComposeDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        List $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        List $networks = this.getNetworks();
        result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
        return result;
    }

    public String toString() {
        return "DockerComposeDto(version=" + this.getVersion() + ", services=" + this.getServices() + ", volumes=" + this.getVolumes() + ", networks=" + this.getNetworks() + ")";
    }
}

