/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.dto;

import at.letto.setupservice.model.docker.DockerContainerDto;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerContainerStatusDto {
    private String name = "";
    private boolean running = false;
    private boolean healthy = false;
    private int cpuProzent = 0;
    private int memoryProzent = 0;
    private String memoryLimit = "";

    public DockerContainerStatusDto(DockerContainerDto dockerContainerDto) {
        this.name = dockerContainerDto.getName();
        this.running = dockerContainerDto.running();
        this.healthy = dockerContainerDto.healthy();
        this.cpuProzent = dockerContainerDto.getCpuProzent();
        this.memoryProzent = dockerContainerDto.getMemProzent();
        this.memoryLimit = dockerContainerDto.getMemoryLimit();
    }

    public String toString() {
        String ret = "docker(" + this.name.replaceAll(";", "") + ";" + this.running + ";" + this.healthy + ";" + this.cpuProzent + ";" + this.memoryProzent + ";" + this.memoryLimit + ")";
        return ret;
    }

    public static DockerContainerStatusDto parse(String s) {
        DockerContainerStatusDto dto = new DockerContainerStatusDto();
        Pattern p = Pattern.compile("^\\s*docker\\(([^;]+);([^;]*);([^;]*);([^;]*);([^;]*);([^;]*)\\)\\s*$");
        Matcher m = p.matcher(s);
        if (m.find()) {
            try {
                dto.name = m.group(1).trim();
                dto.running = Boolean.parseBoolean(m.group(2).trim());
                dto.healthy = Boolean.parseBoolean(m.group(3).trim());
                dto.cpuProzent = Integer.parseInt(m.group(4).trim());
                dto.memoryProzent = Integer.parseInt(m.group(5).trim());
                dto.memoryLimit = m.group(6).trim();
                return dto;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public int getCpuProzent() {
        return this.cpuProzent;
    }

    public int getMemoryProzent() {
        return this.memoryProzent;
    }

    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public void setCpuProzent(int cpuProzent) {
        this.cpuProzent = cpuProzent;
    }

    public void setMemoryProzent(int memoryProzent) {
        this.memoryProzent = memoryProzent;
    }

    public void setMemoryLimit(String memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerContainerStatusDto)) {
            return false;
        }
        DockerContainerStatusDto other = (DockerContainerStatusDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isRunning() != other.isRunning()) {
            return false;
        }
        if (this.isHealthy() != other.isHealthy()) {
            return false;
        }
        if (this.getCpuProzent() != other.getCpuProzent()) {
            return false;
        }
        if (this.getMemoryProzent() != other.getMemoryProzent()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$memoryLimit = this.getMemoryLimit();
        String other$memoryLimit = other.getMemoryLimit();
        return !(this$memoryLimit == null ? other$memoryLimit != null : !this$memoryLimit.equals(other$memoryLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerContainerStatusDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRunning() ? 79 : 97);
        result = result * 59 + (this.isHealthy() ? 79 : 97);
        result = result * 59 + this.getCpuProzent();
        result = result * 59 + this.getMemoryProzent();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $memoryLimit = this.getMemoryLimit();
        result = result * 59 + ($memoryLimit == null ? 43 : $memoryLimit.hashCode());
        return result;
    }

    public DockerContainerStatusDto() {
    }

    public DockerContainerStatusDto(String name, boolean running, boolean healthy, int cpuProzent, int memoryProzent, String memoryLimit) {
        this.name = name;
        this.running = running;
        this.healthy = healthy;
        this.cpuProzent = cpuProzent;
        this.memoryProzent = memoryProzent;
        this.memoryLimit = memoryLimit;
    }
}

