/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerMapping;

@Controller
public class StaticHttpController {
    @RequestMapping(method={RequestMethod.GET}, value={"/setup/open/css/{itemId}"})
    public ResponseEntity<InputStreamResource> getItemCss(@PathVariable String itemId) {
        try {
            InputStream data = this.getClass().getResourceAsStream("/static/config/open/css/" + itemId);
            return ResponseEntity.ok().body((Object)new InputStreamResource(data));
        }
        catch (Exception ex) {
            return ResponseEntity.notFound().build();
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/setup/open/fontawesome/**"})
    public ResponseEntity<InputStreamResource> getItemFontawesome(HttpServletRequest request) {
        try {
            String patternAttribute = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
            String mappingAttribute = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
            patternAttribute = patternAttribute.substring("/setup/open/fontawesome".length());
            mappingAttribute = mappingAttribute.substring("/setup/open/fontawesome".length());
            InputStream data = null;
            String name = "";
            try {
                data = this.getClass().getResourceAsStream("/static/config/open/fontawesome" + mappingAttribute);
                name = mappingAttribute;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (data == null) {
                try {
                    data = this.getClass().getResourceAsStream("/static/config/open/fontawesome" + patternAttribute);
                    name = patternAttribute;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (data == null) {
                return ResponseEntity.notFound().build();
            }
            MediaType contentType = null;
            if (name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg")) {
                contentType = MediaType.IMAGE_JPEG;
            }
            if (name.toLowerCase().endsWith(".png")) {
                contentType = MediaType.IMAGE_PNG;
            }
            if (name.toLowerCase().endsWith(".gif")) {
                contentType = MediaType.IMAGE_GIF;
            }
            if (contentType != null) {
                return ResponseEntity.ok().contentType(contentType).body((Object)new InputStreamResource(data));
            }
            return ResponseEntity.ok().body((Object)new InputStreamResource(data));
        }
        catch (Exception ex) {
            return ResponseEntity.notFound().build();
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/setup/open/fonts/{itemId}"})
    public ResponseEntity<InputStreamResource> getItemFonts(@PathVariable String itemId) {
        try {
            InputStream data = this.getClass().getResourceAsStream("/static/config/open/fonts/" + itemId);
            return ResponseEntity.ok().body((Object)new InputStreamResource(data));
        }
        catch (Exception ex) {
            return ResponseEntity.notFound().build();
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/setup/open/images/{itemId}"})
    public ResponseEntity<InputStreamResource> getItemImages(@PathVariable String itemId) {
        try {
            InputStream data = this.getClass().getResourceAsStream("/static/config/open/images/" + itemId);
            MediaType contentType = null;
            if (itemId.toLowerCase().endsWith(".jpg") || itemId.toLowerCase().endsWith(".jpeg")) {
                contentType = MediaType.IMAGE_JPEG;
            }
            if (itemId.toLowerCase().endsWith(".png")) {
                contentType = MediaType.IMAGE_PNG;
            }
            if (itemId.toLowerCase().endsWith(".gif")) {
                contentType = MediaType.IMAGE_GIF;
            }
            if (contentType != null) {
                return ResponseEntity.ok().contentType(contentType).body((Object)new InputStreamResource(data));
            }
            return ResponseEntity.ok().body((Object)new InputStreamResource(data));
        }
        catch (Exception ex) {
            return ResponseEntity.notFound().build();
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/setup/open/js/{itemId}"})
    public ResponseEntity<InputStreamResource> getItemJs(@PathVariable String itemId) {
        try {
            InputStream data = this.getClass().getResourceAsStream("/static/config/open/js/" + itemId);
            return ResponseEntity.ok().contentType(MediaType.asMediaType((MimeType)MimeType.valueOf((String)"application/javascript;charset=UTF-8"))).body((Object)new InputStreamResource(data));
        }
        catch (Exception ex) {
            return ResponseEntity.notFound().build();
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/setup/open/head_include.html"})
    public ResponseEntity<InputStreamResource> getItemHeadInclude() {
        try {
            InputStream data = this.getClass().getResourceAsStream("/static/config/open/head_include.html");
            return ResponseEntity.ok().body((Object)new InputStreamResource(data));
        }
        catch (Exception ex) {
            return ResponseEntity.notFound().build();
        }
    }
}

