/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setup.dto.ManipulateSetupServiceDto;
import at.letto.setup.dto.SchoolLicenseDto;
import at.letto.setup.dto.ServiceSchuleDto;
import at.letto.setup.dto.ServiceSchulenListDto;
import at.letto.setup.dto.ServiceStatusDto;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.ImpSetupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class SetupRestController {
    @Autowired
    DockerService dockerService;
    @Autowired
    ImpSetupService impSetupService;

    @GetMapping(value={"/config/auth/user/getschulen"})
    public ResponseEntity<ServiceSchulenListDto> getSchulen() {
        ServiceSchulenListDto schulenListDto = new ServiceSchulenListDto();
        schulenListDto.setSchulen(this.dockerService.getSchulen());
        return ResponseEntity.ok((Object)schulenListDto);
    }

    @PostMapping(value={"/config/auth/user/postschule"})
    public ResponseEntity<ServiceSchuleDto> getSchule(@RequestBody String schule) {
        ServiceSchuleDto schuleDto = this.dockerService.getSchule(schule);
        return ResponseEntity.ok((Object)schuleDto);
    }

    @GetMapping(value={"/config/auth/user/getrestkey"})
    public ResponseEntity<String> getRestKey() {
        String restKey = this.dockerService.getRestKey();
        return ResponseEntity.ok((Object)restKey);
    }

    @PostMapping(value={"/config/auth/user/setschoollicense"})
    public ResponseEntity<String> setSchoolLicense(@RequestBody SchoolLicenseDto dto) {
        return ResponseEntity.ok((Object)this.dockerService.setSchoolLicense(dto));
    }

    @PostMapping(value={"/config/auth/admin/manipulatesetupservice"})
    public ResponseEntity<String> manipulateSetupService(@RequestBody ManipulateSetupServiceDto dto) {
        String result = this.impSetupService.manipulateSetupService(dto.getCommand(), dto.isDocker(), dto.getComposeDirectory());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/config/auth/admin/checkservicestatus"})
    public ResponseEntity<ServiceStatusDto> checkServiceStatus() {
        return ResponseEntity.ok((Object)this.impSetupService.checkServiceStatus());
    }

    @GetMapping(value={"/config/auth/admin/deactivatemain"})
    public ResponseEntity<String> deactivateMain() {
        String result = this.dockerService.deactivateMain();
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/setup/auth/admin/checkservicestatus"})
    public ResponseEntity<ServiceStatusDto> checkServiceStatusLocal() {
        return ResponseEntity.ok((Object)this.impSetupService.checkServiceStatusLocal());
    }
}

