/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.security.JwtAuthentication;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.service.DockerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MainHttpController {
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private DockerService dockerService;

    @RequestMapping(value={"/"})
    public String root() {
        return "redirect:" + (this.microServiceConfiguration.isSetupDocker() ? "/config/open/login" : "/setup/open/login");
    }

    @RequestMapping(value={"/config"})
    public String service() {
        return "redirect:/config/session/welcome";
    }

    @RequestMapping(value={"/config/"})
    public String serviceBS() {
        return "redirect:/config/session/welcome";
    }

    @RequestMapping(value={"/setup"})
    public String servicelocal() {
        return "redirect:/setup/session/welcome";
    }

    @RequestMapping(value={"/setup/"})
    public String servicelocalBS() {
        return "redirect:/setup/session/welcome";
    }

    @RequestMapping(value={"/config/api/teacher/lehrer"})
    public String lehrer(Model model) {
        try {
            JwtAuthentication auth = (JwtAuthentication)SecurityContextHolder.getContext().getAuthentication();
            model.addAttribute("username", (Object)auth.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "lehrer";
    }

    @RequestMapping(value={"/config/api/student/schueler"})
    public String schueler(Model model) {
        model.addAttribute("dockerService", (Object)this.dockerService);
        try {
            JwtAuthentication auth = (JwtAuthentication)SecurityContextHolder.getContext().getAuthentication();
            model.addAttribute("username", (Object)auth.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "schueler";
    }
}

