/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setupservice.beans.FileEditBean;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.controller.Msg;
import at.letto.setupservice.controller.MsgType;
import at.letto.setupservice.model.DownloadFile;
import at.letto.setupservice.model.FileEditDialogDto;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DownloadService;
import java.io.File;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FileViewController {
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private DockerService dockerService;
    @Resource(name="fileEditBean")
    FileEditBean fileEditBean;

    @RequestMapping(value={"/config/session/fileview"})
    public String fileViewDocker(@ModelAttribute FileEditDialogDto fileEditDialogDto, Model model) {
        return this.fileViewLocal(fileEditDialogDto, model);
    }

    @RequestMapping(value={"/setup/session/fileview"})
    public String fileViewLocal(@ModelAttribute FileEditDialogDto fileEditDialogDto, Model model) {
        model.addAttribute("action", (Object)this.dockerService.fileviewEP());
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = fileEditDialogDto.getUserAction();
        if (button != null) {
            switch (button) {
                case "reload": {
                    this.fileEditBean.reloadFile();
                    break;
                }
                case "save": {
                    break;
                }
                case "reset": {
                    this.fileEditBean.reloadFile();
                    break;
                }
                case "cancel": {
                    return "redirect:" + this.fileEditBean.getBacklink();
                }
                case "enter": 
                case "gotoLine": {
                    try {
                        int line = Integer.parseInt(fileEditDialogDto.getGotoLine());
                        this.fileEditBean.toLine(line);
                    }
                    catch (Exception line) {}
                    break;
                }
                case "first": {
                    this.fileEditBean.setPart(0);
                    break;
                }
                case "previous": {
                    this.fileEditBean.setPart(this.fileEditBean.getPart() > 0 ? this.fileEditBean.getPart() - 1 : 0);
                    break;
                }
                case "next": {
                    this.fileEditBean.setPart(this.fileEditBean.getPart() < this.fileEditBean.getParts() - 1 ? this.fileEditBean.getPart() + 1 : this.fileEditBean.getParts() - 1);
                    break;
                }
                case "last": {
                    this.fileEditBean.setPart(this.fileEditBean.getParts() - 1);
                    break;
                }
                case "part30": {
                    this.fileEditBean.setPartLines(30);
                    this.fileEditBean.splitTextIntoParts();
                    break;
                }
                case "part50": {
                    this.fileEditBean.setPartLines(50);
                    this.fileEditBean.splitTextIntoParts();
                    break;
                }
                case "part200": {
                    this.fileEditBean.setPartLines(200);
                    this.fileEditBean.splitTextIntoParts();
                    break;
                }
                case "part1000": {
                    this.fileEditBean.setPartLines(1000);
                    this.fileEditBean.splitTextIntoParts();
                    break;
                }
                case "part10k": {
                    this.fileEditBean.setPartLines(10000);
                    this.fileEditBean.splitTextIntoParts();
                    break;
                }
                case "ok": {
                    return "redirect:" + this.fileEditBean.getOklink();
                }
                case "downloadFile": {
                    DownloadFile df = this.downloadService.newDownloadGlobal(this.fileEditBean.getFile());
                    return "redirect:" + (this.microServiceConfiguration.isSetupDocker() ? "/config/session/global/download" : "/setup/session/global/download") + "/" + df.getId();
                }
            }
        }
        model.addAttribute("fileEditBean", (Object)this.fileEditBean);
        return "fileview";
    }

    public String viewFile(File f, Model model, String endpoint) {
        model.addAttribute("action", (Object)this.dockerService.fileviewEP());
        model.addAttribute("dockerService", (Object)this.dockerService);
        if (f != null) {
            this.fileEditBean.loadFile(f);
            this.fileEditBean.setBacklink(endpoint);
            this.fileEditBean.setOklink(endpoint);
            this.fileEditBean.setHelplink("https://letto.at");
            this.fileEditBean.setInfo("Information<span style=\"color:red;\"> Info </span>");
            model.addAttribute("fileEditBean", (Object)this.fileEditBean);
            return "fileview";
        }
        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)endpoint, (String)"Datei konnte nicht gefunden werden!", (String)"");
    }

    public String viewFileWelcome(File f, Model model) {
        if (this.microServiceConfiguration.isSetupDocker()) {
            model.addAttribute("action", (Object)"/config/session/fileedit");
        } else {
            model.addAttribute("action", (Object)"/setup/session/fileedit");
        }
        model.addAttribute("dockerService", (Object)this.dockerService);
        if (f != null) {
            this.fileEditBean.loadFile(f);
            this.fileEditBean.setBacklink(this.microServiceConfiguration.isSetupDocker() ? "/config/session/welcome" : "/setup/session/welcome");
            this.fileEditBean.setOklink(this.microServiceConfiguration.isSetupDocker() ? "/config/session/welcome" : "/setup/session/welcome");
            this.fileEditBean.setHelplink("https://letto.at");
            this.fileEditBean.setInfo("Information<span style=\"color:red;\"> Info </span>");
            model.addAttribute("fileEditBean", (Object)this.fileEditBean);
            return "fileview";
        }
        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)(this.microServiceConfiguration.isSetupDocker() ? "/config/session/welcome" : "/setup/session/welcome"), (String)"Datei konnte nicht gefunden werden!", (String)"");
    }
}

