/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.basespringboot.config.BaseMicroServiceConfiguration;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MicroServiceConfiguration
extends BaseMicroServiceConfiguration {
    @Value(value="${letto_setup_host_path:${letto.path.setup:/opt/letto/setup}}")
    private String lettoSetupHostPath;
    @Value(value="${letto_setup_host_docker:${letto.path.docker:/opt/letto/docker}}")
    private String lettoSetupHostDocker;
    @Value(value="${setup_docker:false}")
    private boolean setupDocker;
    @Value(value="${setup_debug:false}")
    private boolean setupDebug;
    @Value(value="${setup_stable:false}")
    private boolean setupStable;
    @Value(value="${setup_agent:false}")
    private boolean setupAgent;

    public File getComposeDir() {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/compose");
        }
        return new File(this.lettoSetupHostDocker + "/compose");
    }

    public String getComposeDirName() {
        if (this.setupDocker) {
            return "/opt/letto/docker/compose";
        }
        return this.lettoSetupHostDocker + "/compose";
    }

    public File getLogDir() {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/storage/log");
        }
        return new File(this.lettoSetupHostDocker + "/storage/log");
    }

    public File getSetupEnvFile() {
        if (this.setupDocker) {
            return new File("/host/.env");
        }
        return new File(this.lettoSetupHostDocker + "/compose/setup/.env");
    }

    public File getLettoEnvFile() {
        if (this.setupDocker) {
            return new File("/letto_compose/.env");
        }
        return new File(this.lettoSetupHostDocker + "/compose/letto/.env");
    }

    public File getMysqlEnvFile() {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/compose/mysql/.env");
        }
        return new File(this.lettoSetupHostDocker + "/compose/mysql/.env");
    }

    public File getSetupYmlFile() {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/compose/setup/docker-compose.yml");
        }
        return new File(this.lettoSetupHostDocker + "/compose/setup/docker-compose.yml");
    }

    public File getLettoYmlFile() {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/compose/letto/docker-compose.yml");
        }
        return new File(this.lettoSetupHostDocker + "/compose/letto/docker-compose.yml");
    }

    public File getSchoolYmlFile(String school) {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/compose/letto/docker-compose-" + school + ".yml");
        }
        return new File(this.lettoSetupHostDocker + "/compose/letto/docker-compose-" + school + ".yml");
    }

    public File getMysqlYmlFile() {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/compose/mysql/docker-compose.yml");
        }
        return new File(this.lettoSetupHostDocker + "/compose/mysql/docker-compose.yml");
    }

    public File getServiceYmlFile(String ymlFileName) {
        if (this.setupDocker) {
            return new File("/opt/letto/docker/compose/letto/" + ymlFileName);
        }
        return new File(this.lettoSetupHostDocker + "/compose/letto/" + ymlFileName);
    }

    public String getLettoSetupHostPath() {
        return this.lettoSetupHostPath;
    }

    public String getLettoSetupHostDocker() {
        return this.lettoSetupHostDocker;
    }

    public boolean isSetupDocker() {
        return this.setupDocker;
    }

    public boolean isSetupDebug() {
        return this.setupDebug;
    }

    public boolean isSetupStable() {
        return this.setupStable;
    }

    public boolean isSetupAgent() {
        return this.setupAgent;
    }
}

